/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractCharCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.CharCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortCharAssociativeContainer;
import com.carrotsearch.hppc.ShortCharMap;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.CharCursor;
import com.carrotsearch.hppc.cursors.ShortCharCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.CharPredicate;
import com.carrotsearch.hppc.predicates.ShortCharPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.CharProcedure;
import com.carrotsearch.hppc.procedures.ShortCharProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortCharHashMap
implements ShortCharMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public char[] values;

    public ShortCharHashMap() {
        this(4);
    }

    public ShortCharHashMap(int n) {
        this(n, 0.75);
    }

    public ShortCharHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortCharHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortCharHashMap(ShortCharAssociativeContainer shortCharAssociativeContainer) {
        this(shortCharAssociativeContainer.size());
        this.putAll(shortCharAssociativeContainer);
    }

    public static ShortCharHashMap from(short[] sArray, char[] cArray) {
        if (sArray.length == cArray.length) {
            ShortCharHashMap shortCharHashMap = new ShortCharHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortCharHashMap.put(sArray[i], cArray[i]);
            }
            return shortCharHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public char addTo(short s, char c) {
        return this.putOrAdd(s, c, c);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        char[] cArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new char[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = cArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, char c) {
        short[] sArray = this.keys;
        char[] cArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        cArray[n] = c;
        this.rehash(sArray, cArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortCharHashMap clone() {
        try {
            ShortCharHashMap shortCharHashMap = (ShortCharHashMap)super.clone();
            shortCharHashMap.keys = (short[])this.keys.clone();
            shortCharHashMap.values = (char[])this.values.clone();
            shortCharHashMap.hasEmptyKey = shortCharHashMap.hasEmptyKey;
            shortCharHashMap.orderMixer = this.orderMixer.clone();
            return shortCharHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            char[] cArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, cArray);
            }
        }
    }

    protected boolean equalElements(ShortCharHashMap object) {
        if (((ShortCharHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ShortCharHashMap)object).iterator();
        while (object.hasNext()) {
            ShortCharCursor shortCharCursor = (ShortCharCursor)object.next();
            short s = shortCharCursor.key;
            if (this.containsKey(s) && this.get(s) == shortCharCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortCharHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortCharPredicate> T forEach(T t) {
        short[] sArray = this.keys;
        char[] cArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, cArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], cArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortCharProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        char[] cArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, cArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], cArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public char get(short s) {
        int n;
        int n2 = 0;
        if (s == 0) {
            int n3 = n2;
            if (this.hasEmptyKey) {
                n3 = n2 = this.values[this.mask + 1];
            }
            return (char)n3;
        }
        short[] sArray = this.keys;
        int n4 = this.mask;
        n2 = this.hashKey(s);
        while ((n2 = sArray[n = n2 & n4]) != 0) {
            if (n2 == s) {
                return this.values[n];
            }
            n2 = n + 1;
        }
        return '\u0000';
    }

    @Override
    public char getOrDefault(short s, char c) {
        short s2;
        if (s == 0) {
            if (this.hasEmptyKey) {
                char c2;
                c = c2 = this.values[this.mask + 1];
            }
            return c;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return c;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortCharCursor shortCharCursor : this) {
            n += BitMixer.mix(shortCharCursor.key) + BitMixer.mix(shortCharCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public char indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, char c) {
        if (s == 0) {
            this.values[n] = c;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, c);
            } else {
                this.keys[n] = s;
                this.values[n] = c;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public char indexReplace(int n, char c) {
        char[] cArray = this.values;
        char c2 = cArray[n];
        cArray[n] = c;
        return c2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortCharCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public char put(short s, char c) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            char[] cArray = this.values;
            int n2 = n + 1;
            char c2 = cArray[n2];
            cArray[n2] = c;
            return c2;
        }
        Object[] objectArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = objectArray[n3 &= n]) != 0) {
            if (s2 == s) {
                objectArray = this.values;
                char c3 = objectArray[n3];
                objectArray[n3] = (short)c;
                return c3;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, s, c);
        } else {
            objectArray[n3] = s;
            this.values[n3] = c;
        }
        ++this.assigned;
        return '\u0000';
    }

    @Override
    public int putAll(ShortCharAssociativeContainer object) {
        int n = this.size();
        Iterator<ShortCharCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ShortCharCursor)object).key, ((ShortCharCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortCharCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortCharCursor shortCharCursor = (ShortCharCursor)object.next();
            this.put(shortCharCursor.key, shortCharCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, char c) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, c);
            return true;
        }
        return false;
    }

    @Override
    public char putOrAdd(short s, char c, char c2) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            c = (char)(this.values[n] + c2);
            this.indexReplace(n, c);
        } else {
            this.indexInsert(n, s, c);
        }
        return c;
    }

    protected void rehash(short[] sArray, char[] cArray) {
        int n;
        short[] sArray2 = this.keys;
        char[] cArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        cArray2[cArray2.length - 1] = cArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            cArray2[n3] = cArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public char remove(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            char[] cArray = this.values;
            int n3 = n2 + 1;
            char c = cArray[n3];
            cArray[n3] = (char)0;
            return c;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                char c = this.values[n];
                this.shiftConflictingKeys(n);
                return c;
            }
            n4 = n + 1;
        }
        return '\u0000';
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (char)0;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortCharPredicate shortCharPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortCharPredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (char)0;
        }
        objectArray = this.keys;
        char[] cArray = this.values;
        while (n4 <= n3) {
            char c = objectArray[n4];
            if (c != '\u0000' && shortCharPredicate.apply((short)c, cArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (char)0;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        char[] cArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    cArray[n] = (char)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            cArray[n] = cArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortCharCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortCharCursor shortCharCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortCharCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortCharCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public CharCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortCharCursor> {
        private final ShortCharCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCharCursor();
        }

        @Override
        protected ShortCharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortCharHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (short)n;
                        this.cursor.value = ShortCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCharCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortCharHashMap owner;

        public KeysContainer() {
            this.owner = ShortCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortCharPredicate(){

                @Override
                public boolean apply(short s, char c) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortCharProcedure(){

                @Override
                public void apply(short s, char c) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortCharHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = (short)n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractCharCollection {
        private final ShortCharHashMap owner;

        private ValuesContainer() {
            this.owner = ShortCharHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(char c) {
            Iterator<ShortCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != c) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends CharPredicate> T forEach(T t) {
            Iterator<ShortCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends CharProcedure> T forEach(T t) {
            Iterator<ShortCharCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<CharCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final char c) {
            return this.owner.removeAll(new ShortCharPredicate(){

                @Override
                public boolean apply(short s, char c2) {
                    boolean bl = c2 == c;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final CharPredicate charPredicate) {
            return this.owner.removeAll(new ShortCharPredicate(){

                @Override
                public boolean apply(short s, char c) {
                    return charPredicate.apply(c);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<CharCursor> {
        private final CharCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortCharHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new CharCursor();
        }

        @Override
        protected CharCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortCharHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortCharHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortCharHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortCharHashMap.this.values[this.max];
                return this.cursor;
            }
            return (CharCursor)this.done();
        }
    }
}

