/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortCharHashMap;

public class ShortCharScatterMap
extends ShortCharHashMap {
    public ShortCharScatterMap() {
        this(4);
    }

    public ShortCharScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortCharScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortCharScatterMap from(short[] sArray, char[] cArray) {
        if (sArray.length == cArray.length) {
            ShortCharScatterMap shortCharScatterMap = new ShortCharScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortCharScatterMap.put(sArray[i], cArray[i]);
            }
            return shortCharScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

