/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractDoubleCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.DoubleCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortDoubleAssociativeContainer;
import com.carrotsearch.hppc.ShortDoubleMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.DoubleCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortDoubleCursor;
import com.carrotsearch.hppc.predicates.DoublePredicate;
import com.carrotsearch.hppc.predicates.ShortDoublePredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.DoubleProcedure;
import com.carrotsearch.hppc.procedures.ShortDoubleProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortDoubleHashMap
implements ShortDoubleMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public double[] values;

    public ShortDoubleHashMap() {
        this(4);
    }

    public ShortDoubleHashMap(int n) {
        this(n, 0.75);
    }

    public ShortDoubleHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortDoubleHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortDoubleHashMap(ShortDoubleAssociativeContainer shortDoubleAssociativeContainer) {
        this(shortDoubleAssociativeContainer.size());
        this.putAll(shortDoubleAssociativeContainer);
    }

    public static ShortDoubleHashMap from(short[] sArray, double[] dArray) {
        if (sArray.length == dArray.length) {
            ShortDoubleHashMap shortDoubleHashMap = new ShortDoubleHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortDoubleHashMap.put(sArray[i], dArray[i]);
            }
            return shortDoubleHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public double addTo(short s, double d) {
        return this.putOrAdd(s, d, d);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        double[] dArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new double[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = dArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, double d) {
        short[] sArray = this.keys;
        double[] dArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        dArray[n] = d;
        this.rehash(sArray, dArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortDoubleHashMap clone() {
        try {
            ShortDoubleHashMap shortDoubleHashMap = (ShortDoubleHashMap)super.clone();
            shortDoubleHashMap.keys = (short[])this.keys.clone();
            shortDoubleHashMap.values = (double[])this.values.clone();
            shortDoubleHashMap.hasEmptyKey = shortDoubleHashMap.hasEmptyKey;
            shortDoubleHashMap.orderMixer = this.orderMixer.clone();
            return shortDoubleHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            double[] dArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, dArray);
            }
        }
    }

    protected boolean equalElements(ShortDoubleHashMap object) {
        if (((ShortDoubleHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ShortDoubleHashMap)object).iterator();
        while (object.hasNext()) {
            ShortDoubleCursor shortDoubleCursor = (ShortDoubleCursor)object.next();
            short s = shortDoubleCursor.key;
            if (this.containsKey(s) && Double.doubleToLongBits(this.get(s)) == Double.doubleToLongBits(shortDoubleCursor.value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortDoubleHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortDoublePredicate> T forEach(T t) {
        short[] sArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, dArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], dArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortDoubleProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        double[] dArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, dArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], dArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public double get(short s) {
        short s2;
        double d = 0.0;
        if (s == 0) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0;
    }

    @Override
    public double getOrDefault(short s, double d) {
        short s2;
        if (s == 0) {
            if (this.hasEmptyKey) {
                d = this.values[this.mask + 1];
            }
            return d;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return d;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortDoubleCursor shortDoubleCursor : this) {
            n += BitMixer.mix(shortDoubleCursor.key) + BitMixer.mix(shortDoubleCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public double indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, double d) {
        if (s == 0) {
            this.values[n] = d;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, d);
            } else {
                this.keys[n] = s;
                this.values[n] = d;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public double indexReplace(int n, double d) {
        double[] dArray = this.values;
        double d2 = dArray[n];
        dArray[n] = d;
        return d2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortDoubleCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public double put(short s, double d) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            double[] dArray = this.values;
            int n3 = n2 + 1;
            double d2 = dArray[n3];
            dArray[n3] = d;
            return d2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                objectArray = this.values;
                short s2 = objectArray[n];
                objectArray[n] = (short)d;
                return s2;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s, d);
        } else {
            objectArray[n] = s;
            this.values[n] = d;
        }
        ++this.assigned;
        return 0.0;
    }

    @Override
    public int putAll(ShortDoubleAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortDoubleCursor shortDoubleCursor = (ShortDoubleCursor)object.next();
            this.put(shortDoubleCursor.key, shortDoubleCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortDoubleCursor> object) {
        int n = this.size();
        Iterator<? extends ShortDoubleCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ShortDoubleCursor)object).key, ((ShortDoubleCursor)object).value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, double d) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, d);
            return true;
        }
        return false;
    }

    @Override
    public double putOrAdd(short s, double d, double d2) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            d = this.values[n] + d2;
            this.indexReplace(n, d);
        } else {
            this.indexInsert(n, s, d);
        }
        return d;
    }

    protected void rehash(short[] sArray, double[] dArray) {
        int n;
        short[] sArray2 = this.keys;
        double[] dArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        dArray2[dArray2.length - 1] = dArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            dArray2[n3] = dArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public double remove(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            double[] dArray = this.values;
            int n3 = n2 + 1;
            double d = dArray[n3];
            dArray[n3] = 0.0;
            return d;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                double d = this.values[n];
                this.shiftConflictingKeys(n);
                return d;
            }
            n4 = n + 1;
        }
        return 0.0;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortDoublePredicate shortDoublePredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortDoublePredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0;
        }
        objectArray = this.keys;
        double[] dArray = this.values;
        while (n4 <= n3) {
            double d = objectArray[n4];
            if (d != false && shortDoublePredicate.apply((short)d, dArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        double[] dArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    dArray[n] = 0.0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            dArray[n] = dArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortDoubleCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortDoubleCursor shortDoubleCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortDoubleCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortDoubleCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public DoubleCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortDoubleCursor> {
        private final ShortDoubleCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortDoubleCursor();
        }

        @Override
        protected ShortDoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortDoubleHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (short)n;
                        this.cursor.value = ShortDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortDoubleCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortDoubleHashMap owner;

        public KeysContainer() {
            this.owner = ShortDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortDoublePredicate(){

                @Override
                public boolean apply(short s, double d) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortDoubleProcedure(){

                @Override
                public void apply(short s, double d) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortDoubleHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.value = s;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractDoubleCollection {
        private final ShortDoubleHashMap owner;

        private ValuesContainer() {
            this.owner = ShortDoubleHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(double d) {
            Iterator<ShortDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Double.doubleToLongBits(iterator.next().value) != Double.doubleToLongBits(d)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends DoublePredicate> T forEach(T t) {
            Iterator<ShortDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends DoubleProcedure> T forEach(T t) {
            Iterator<ShortDoubleCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<DoubleCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final double d) {
            return this.owner.removeAll(new ShortDoublePredicate(){

                @Override
                public boolean apply(short s, double d2) {
                    boolean bl = Double.doubleToLongBits(d2) == Double.doubleToLongBits(d);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final DoublePredicate doublePredicate) {
            return this.owner.removeAll(new ShortDoublePredicate(){

                @Override
                public boolean apply(short s, double d) {
                    return doublePredicate.apply(d);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<DoubleCursor> {
        private final DoubleCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortDoubleHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new DoubleCursor();
        }

        @Override
        protected DoubleCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortDoubleHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortDoubleHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortDoubleHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortDoubleHashMap.this.values[this.max];
                return this.cursor;
            }
            return (DoubleCursor)this.done();
        }
    }
}

