/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortDoubleHashMap;

public class ShortDoubleScatterMap
extends ShortDoubleHashMap {
    public ShortDoubleScatterMap() {
        this(4);
    }

    public ShortDoubleScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortDoubleScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortDoubleScatterMap from(short[] sArray, double[] dArray) {
        if (sArray.length == dArray.length) {
            ShortDoubleScatterMap shortDoubleScatterMap = new ShortDoubleScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortDoubleScatterMap.put(sArray[i], dArray[i]);
            }
            return shortDoubleScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

