/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractFloatCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.FloatCollection;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortFloatAssociativeContainer;
import com.carrotsearch.hppc.ShortFloatMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.FloatCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortFloatCursor;
import com.carrotsearch.hppc.predicates.FloatPredicate;
import com.carrotsearch.hppc.predicates.ShortFloatPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.FloatProcedure;
import com.carrotsearch.hppc.procedures.ShortFloatProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortFloatHashMap
implements ShortFloatMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public float[] values;

    public ShortFloatHashMap() {
        this(4);
    }

    public ShortFloatHashMap(int n) {
        this(n, 0.75);
    }

    public ShortFloatHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortFloatHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortFloatHashMap(ShortFloatAssociativeContainer shortFloatAssociativeContainer) {
        this(shortFloatAssociativeContainer.size());
        this.putAll(shortFloatAssociativeContainer);
    }

    public static ShortFloatHashMap from(short[] sArray, float[] fArray) {
        if (sArray.length == fArray.length) {
            ShortFloatHashMap shortFloatHashMap = new ShortFloatHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortFloatHashMap.put(sArray[i], fArray[i]);
            }
            return shortFloatHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public float addTo(short s, float f) {
        return this.putOrAdd(s, f, f);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        float[] fArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new float[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = fArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, float f) {
        short[] sArray = this.keys;
        float[] fArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        fArray[n] = f;
        this.rehash(sArray, fArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortFloatHashMap clone() {
        try {
            ShortFloatHashMap shortFloatHashMap = (ShortFloatHashMap)super.clone();
            shortFloatHashMap.keys = (short[])this.keys.clone();
            shortFloatHashMap.values = (float[])this.values.clone();
            shortFloatHashMap.hasEmptyKey = shortFloatHashMap.hasEmptyKey;
            shortFloatHashMap.orderMixer = this.orderMixer.clone();
            return shortFloatHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            float[] fArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, fArray);
            }
        }
    }

    protected boolean equalElements(ShortFloatHashMap object) {
        if (((ShortFloatHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<ShortFloatCursor> iterator = ((ShortFloatHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            short s = ((ShortFloatCursor)object).key;
            if (this.containsKey(s) && Float.floatToIntBits(this.get(s)) == Float.floatToIntBits(((ShortFloatCursor)object).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortFloatHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortFloatPredicate> T forEach(T t) {
        short[] sArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, fArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], fArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortFloatProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        float[] fArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, fArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], fArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public float get(short s) {
        short s2;
        float f = 0.0f;
        if (s == 0) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0.0f;
    }

    @Override
    public float getOrDefault(short s, float f) {
        int n;
        if (s == 0) {
            if (this.hasEmptyKey) {
                f = this.values[this.mask + 1];
            }
            return f;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return f;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortFloatCursor shortFloatCursor : this) {
            n += BitMixer.mix(shortFloatCursor.key) + BitMixer.mix(shortFloatCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public float indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, float f) {
        if (s == 0) {
            this.values[n] = f;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, f);
            } else {
                this.keys[n] = s;
                this.values[n] = f;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public float indexReplace(int n, float f) {
        float[] fArray = this.values;
        float f2 = fArray[n];
        fArray[n] = f;
        return f2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortFloatCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public float put(short s, float f) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            float[] fArray = this.values;
            int n3 = n2 + 1;
            float f2 = fArray[n3];
            fArray[n3] = f;
            return f2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                objectArray = this.values;
                short s2 = objectArray[n];
                objectArray[n] = (short)f;
                return s2;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s, f);
        } else {
            objectArray[n] = s;
            this.values[n] = f;
        }
        ++this.assigned;
        return 0.0f;
    }

    @Override
    public int putAll(ShortFloatAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortFloatCursor shortFloatCursor = (ShortFloatCursor)object.next();
            this.put(shortFloatCursor.key, shortFloatCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortFloatCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortFloatCursor shortFloatCursor = (ShortFloatCursor)object.next();
            this.put(shortFloatCursor.key, shortFloatCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, float f) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, f);
            return true;
        }
        return false;
    }

    @Override
    public float putOrAdd(short s, float f, float f2) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            f = this.values[n] + f2;
            this.indexReplace(n, f);
        } else {
            this.indexInsert(n, s, f);
        }
        return f;
    }

    protected void rehash(short[] sArray, float[] fArray) {
        int n;
        short[] sArray2 = this.keys;
        float[] fArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        fArray2[fArray2.length - 1] = fArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            fArray2[n3] = fArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public float remove(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            float[] fArray = this.values;
            int n3 = n2 + 1;
            float f = fArray[n3];
            fArray[n3] = 0.0f;
            return f;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                float f = this.values[n];
                this.shiftConflictingKeys(n);
                return f;
            }
            n4 = n + 1;
        }
        return 0.0f;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0.0f;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortFloatPredicate shortFloatPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortFloatPredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0.0f;
        }
        objectArray = this.keys;
        float[] fArray = this.values;
        while (n4 <= n3) {
            float f = objectArray[n4];
            if (f != false && shortFloatPredicate.apply((short)f, fArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0.0f;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        float[] fArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    fArray[n] = 0.0f;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            fArray[n] = fArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortFloatCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortFloatCursor shortFloatCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortFloatCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortFloatCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public FloatCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortFloatCursor> {
        private final ShortFloatCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortFloatCursor();
        }

        @Override
        protected ShortFloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortFloatHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.key = s;
                        this.cursor.value = ShortFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortFloatCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortFloatHashMap owner;

        public KeysContainer() {
            this.owner = ShortFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortFloatPredicate(){

                @Override
                public boolean apply(short s, float f) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortFloatProcedure(){

                @Override
                public void apply(short s, float f) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortFloatHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = (short)n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractFloatCollection {
        private final ShortFloatHashMap owner;

        private ValuesContainer() {
            this.owner = ShortFloatHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(float f) {
            Iterator<ShortFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (Float.floatToIntBits(iterator.next().value) != Float.floatToIntBits(f)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends FloatPredicate> T forEach(T t) {
            Iterator<ShortFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends FloatProcedure> T forEach(T t) {
            Iterator<ShortFloatCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final float f) {
            return this.owner.removeAll(new ShortFloatPredicate(){

                @Override
                public boolean apply(short s, float f2) {
                    boolean bl = Float.floatToIntBits(f2) == Float.floatToIntBits(f);
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final FloatPredicate floatPredicate) {
            return this.owner.removeAll(new ShortFloatPredicate(){

                @Override
                public boolean apply(short s, float f) {
                    return floatPredicate.apply(f);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortFloatHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new FloatCursor();
        }

        @Override
        protected FloatCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortFloatHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortFloatHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortFloatHashMap.this.values[this.max];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }
}

