/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortFloatHashMap;

public class ShortFloatScatterMap
extends ShortFloatHashMap {
    public ShortFloatScatterMap() {
        this(4);
    }

    public ShortFloatScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortFloatScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortFloatScatterMap from(short[] sArray, float[] fArray) {
        if (sArray.length == fArray.length) {
            ShortFloatScatterMap shortFloatScatterMap = new ShortFloatScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortFloatScatterMap.put(sArray[i], fArray[i]);
            }
            return shortFloatScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

