/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortSet;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortHashSet
extends AbstractShortCollection
implements ShortLookupContainer,
ShortSet,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;

    public ShortHashSet() {
        this(4, 0.75);
    }

    public ShortHashSet(int n) {
        this(n, 0.75);
    }

    public ShortHashSet(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortHashSet(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortHashSet(ShortContainer shortContainer) {
        this(shortContainer.size());
        this.addAll(shortContainer);
    }

    public static ShortHashSet from(short ... sArray) {
        ShortHashSet shortHashSet = new ShortHashSet(sArray.length);
        shortHashSet.addAll(sArray);
        return shortHashSet;
    }

    private boolean sameKeys(ShortSet object) {
        if (object.size() != this.size()) {
            return false;
        }
        object = object.iterator();
        while (object.hasNext()) {
            if (this.contains(((ShortCursor)object.next()).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(short s) {
        int n;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = true;
            return bl ^ true;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return false;
            }
            n3 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s);
        } else {
            sArray[n] = s;
        }
        ++this.assigned;
        return true;
    }

    public int addAll(ShortContainer shortContainer) {
        this.ensureCapacity(shortContainer.size());
        return this.addAll((Iterable<? extends ShortCursor>)shortContainer);
    }

    public int addAll(Iterable<? extends ShortCursor> object) {
        object = object.iterator();
        int n = 0;
        while (object.hasNext()) {
            if (!this.add(((ShortCursor)object.next()).value)) continue;
            ++n;
        }
        return n;
    }

    public final int addAll(short ... sArray) {
        this.ensureCapacity(sArray.length);
        int n = sArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = n2;
            if (this.add(sArray[i])) {
                n3 = n2 + 1;
            }
            n2 = n3;
        }
        return n2;
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        try {
            this.keys = new short[n + 1];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            n2 = this.keys == null ? 0 : this.size();
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, n2, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s) {
        short[] sArray = this.keys;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        this.rehash(sArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortHashSet clone() {
        try {
            ShortHashSet shortHashSet = (ShortHashSet)super.clone();
            shortHashSet.keys = (short[])this.keys.clone();
            shortHashSet.hasEmptyKey = shortHashSet.hasEmptyKey;
            shortHashSet.orderMixer = this.orderMixer.clone();
            return shortHashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean contains(short s) {
        int n;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return true;
            }
            n3 = n + 1;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray);
            }
        }
    }

    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.sameKeys((ShortSet)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortPredicate> T forEach(T t) {
        short s;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0)) {
            return t;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        for (int i = 0; i <= n && ((s = sArray[i]) == 0 || t.apply(s)); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortProcedure> T forEach(T t) {
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0);
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        while (n <= n2) {
            short s = sArray[n];
            if (s != 0) {
                t.apply(s);
            }
            ++n;
        }
        return t;
    }

    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        short[] sArray = this.keys;
        for (int i = this.mask; i >= 0; --i) {
            short s = sArray[i];
            int n2 = n;
            if (s != 0) {
                n2 = n + BitMixer.mix(s);
            }
            n = n2;
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    public short indexGet(int n) {
        return this.keys[n];
    }

    public void indexInsert(int n, short s) {
        if (s == 0) {
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s);
            } else {
                this.keys[n] = s;
            }
            ++this.assigned;
        }
    }

    public int indexOf(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    public short indexReplace(int n, short s) {
        short[] sArray = this.keys;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortCursor> iterator() {
        return new EntryIterator();
    }

    protected void rehash(short[] sArray) {
        int n;
        short[] sArray2 = this.keys;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.ensureCapacity(4);
    }

    public boolean remove(short s) {
        int n;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            this.hasEmptyKey = false;
            return bl;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                this.shiftConflictingKeys(n);
                return true;
            }
            n3 = n + 1;
        }
        return false;
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(short s) {
        return this.remove(s) ? 1 : 0;
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    @Override
    public short[] toArray() {
        int n;
        short[] sArray = new short[this.size()];
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl) {
            sArray[0] = (short)0;
            n = 1;
        } else {
            n = 0;
        }
        short[] sArray2 = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray2[n2];
            int n4 = n;
            if (s != 0) {
                sArray[n] = s;
                n4 = n + 1;
            }
            ++n2;
            n = n4;
        }
        return sArray;
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    protected final class EntryIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortHashSet.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortHashSet.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.value = s;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortHashSet.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

