/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIntCollection;
import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortIntAssociativeContainer;
import com.carrotsearch.hppc.ShortIntMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortIntCursor;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.predicates.ShortIntPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.IntProcedure;
import com.carrotsearch.hppc.procedures.ShortIntProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortIntHashMap
implements ShortIntMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public int[] values;

    public ShortIntHashMap() {
        this(4);
    }

    public ShortIntHashMap(int n) {
        this(n, 0.75);
    }

    public ShortIntHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortIntHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortIntHashMap(ShortIntAssociativeContainer shortIntAssociativeContainer) {
        this(shortIntAssociativeContainer.size());
        this.putAll(shortIntAssociativeContainer);
    }

    public static ShortIntHashMap from(short[] sArray, int[] nArray) {
        if (sArray.length == nArray.length) {
            ShortIntHashMap shortIntHashMap = new ShortIntHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortIntHashMap.put(sArray[i], nArray[i]);
            }
            return shortIntHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public int addTo(short s, int n) {
        return this.putOrAdd(s, n, n);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        int[] nArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new int[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = nArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, int n2) {
        short[] sArray = this.keys;
        int[] nArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        nArray[n] = n2;
        this.rehash(sArray, nArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortIntHashMap clone() {
        try {
            ShortIntHashMap shortIntHashMap = (ShortIntHashMap)super.clone();
            shortIntHashMap.keys = (short[])this.keys.clone();
            shortIntHashMap.values = (int[])this.values.clone();
            shortIntHashMap.hasEmptyKey = shortIntHashMap.hasEmptyKey;
            shortIntHashMap.orderMixer = this.orderMixer.clone();
            return shortIntHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            int[] nArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, nArray);
            }
        }
    }

    protected boolean equalElements(ShortIntHashMap object) {
        if (((ShortIntHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ShortIntHashMap)object).iterator();
        while (object.hasNext()) {
            ShortIntCursor shortIntCursor = (ShortIntCursor)object.next();
            short s = shortIntCursor.key;
            if (this.containsKey(s) && this.get(s) == shortIntCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortIntHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortIntPredicate> T forEach(T t) {
        short[] sArray = this.keys;
        int[] nArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, nArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], nArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortIntProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        int[] nArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, nArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], nArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public int get(short s) {
        short s2;
        int n = 0;
        if (s == 0) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        n = this.hashKey(s);
        while ((s2 = sArray[n &= n2]) != 0) {
            if (s2 == s) {
                return this.values[n];
            }
            ++n;
        }
        return 0;
    }

    @Override
    public int getOrDefault(short s, int n) {
        short s2;
        if (s == 0) {
            if (this.hasEmptyKey) {
                n = this.values[this.mask + 1];
            }
            return n;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n2]) != 0) {
            if (s2 == s) {
                return this.values[n3];
            }
            ++n3;
        }
        return n;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortIntCursor shortIntCursor : this) {
            n += BitMixer.mix(shortIntCursor.key) + BitMixer.mix(shortIntCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public int indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, int n2) {
        if (s == 0) {
            this.values[n] = n2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, n2);
            } else {
                this.keys[n] = s;
                this.values[n] = n2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public int indexReplace(int n, int n2) {
        int[] nArray = this.values;
        int n3 = nArray[n];
        nArray[n] = n2;
        return n3;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortIntCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public int put(short s, int n) {
        short s2;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            int[] nArray = this.values;
            int n3 = nArray[++n2];
            nArray[n2] = n;
            return n3;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(s);
        while ((s2 = objectArray[n4 &= n2]) != 0) {
            if (s2 == s) {
                objectArray = this.values;
                n2 = objectArray[n4];
                objectArray[n4] = n;
                return n2;
            }
            ++n4;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n4, s, n);
        } else {
            objectArray[n4] = s;
            this.values[n4] = n;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ShortIntAssociativeContainer object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortIntCursor shortIntCursor = (ShortIntCursor)object.next();
            this.put(shortIntCursor.key, shortIntCursor.value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortIntCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortIntCursor shortIntCursor = (ShortIntCursor)object.next();
            this.put(shortIntCursor.key, shortIntCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, int n) {
        int n2 = this.indexOf(s);
        if (!this.indexExists(n2)) {
            this.indexInsert(n2, s, n);
            return true;
        }
        return false;
    }

    @Override
    public int putOrAdd(short s, int n, int n2) {
        int n3 = this.indexOf(s);
        if (this.indexExists(n3)) {
            n = this.values[n3] + n2;
            this.indexReplace(n3, n);
        } else {
            this.indexInsert(n3, s, n);
        }
        return n;
    }

    protected void rehash(short[] sArray, int[] nArray) {
        int n;
        short[] sArray2 = this.keys;
        int[] nArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        nArray2[nArray2.length - 1] = nArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            nArray2[n3] = nArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public int remove(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            int[] nArray = this.values;
            int n2 = n + 1;
            n = nArray[n2];
            nArray[n2] = 0;
            return n;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                n = this.values[n3];
                this.shiftConflictingKeys(n3);
                return n;
            }
            ++n3;
        }
        return 0;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortIntPredicate shortIntPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortIntPredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0;
        }
        objectArray = this.keys;
        int[] nArray = this.values;
        while (n4 <= n3) {
            short s = objectArray[n4];
            if (s != 0 && shortIntPredicate.apply(s, nArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        int[] nArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    nArray[n] = 0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            nArray[n] = nArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortIntCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortIntCursor shortIntCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortIntCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortIntCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public IntCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortIntCursor> {
        private final ShortIntCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortIntCursor();
        }

        @Override
        protected ShortIntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortIntHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (short)n;
                        this.cursor.value = ShortIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortIntCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortIntHashMap owner;

        public KeysContainer() {
            this.owner = ShortIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortIntPredicate(){

                @Override
                public boolean apply(short s, int n) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortIntProcedure(){

                @Override
                public void apply(short s, int n) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortIntHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.value = s;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractIntCollection {
        private final ShortIntHashMap owner;

        private ValuesContainer() {
            this.owner = ShortIntHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(int n) {
            Iterator<ShortIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != n) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends IntPredicate> T forEach(T t) {
            Iterator<ShortIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends IntProcedure> T forEach(T t) {
            Iterator<ShortIntCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<IntCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final int n) {
            return this.owner.removeAll(new ShortIntPredicate(){

                @Override
                public boolean apply(short s, int n2) {
                    boolean bl = n2 == n;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final IntPredicate intPredicate) {
            return this.owner.removeAll(new ShortIntPredicate(){

                @Override
                public boolean apply(short s, int n) {
                    return intPredicate.apply(n);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<IntCursor> {
        private final IntCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortIntHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new IntCursor();
        }

        @Override
        protected IntCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortIntHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortIntHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortIntHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortIntHashMap.this.values[this.max];
                return this.cursor;
            }
            return (IntCursor)this.done();
        }
    }
}

