/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortIntHashMap;

public class ShortIntScatterMap
extends ShortIntHashMap {
    public ShortIntScatterMap() {
        this(4);
    }

    public ShortIntScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortIntScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortIntScatterMap from(short[] sArray, int[] nArray) {
        if (sArray.length == nArray.length) {
            ShortIntScatterMap shortIntScatterMap = new ShortIntScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortIntScatterMap.put(sArray[i], nArray[i]);
            }
            return shortIntScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

