/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractLongCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.LongCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLongAssociativeContainer;
import com.carrotsearch.hppc.ShortLongMap;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.cursors.LongCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortLongCursor;
import com.carrotsearch.hppc.predicates.LongPredicate;
import com.carrotsearch.hppc.predicates.ShortLongPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.carrotsearch.hppc.procedures.ShortLongProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortLongHashMap
implements ShortLongMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public long[] values;

    public ShortLongHashMap() {
        this(4);
    }

    public ShortLongHashMap(int n) {
        this(n, 0.75);
    }

    public ShortLongHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortLongHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortLongHashMap(ShortLongAssociativeContainer shortLongAssociativeContainer) {
        this(shortLongAssociativeContainer.size());
        this.putAll(shortLongAssociativeContainer);
    }

    public static ShortLongHashMap from(short[] sArray, long[] lArray) {
        if (sArray.length == lArray.length) {
            ShortLongHashMap shortLongHashMap = new ShortLongHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortLongHashMap.put(sArray[i], lArray[i]);
            }
            return shortLongHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public long addTo(short s, long l) {
        return this.putOrAdd(s, l, l);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        long[] lArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new long[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = lArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, long l) {
        short[] sArray = this.keys;
        long[] lArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        lArray[n] = l;
        this.rehash(sArray, lArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortLongHashMap clone() {
        try {
            ShortLongHashMap shortLongHashMap = (ShortLongHashMap)super.clone();
            shortLongHashMap.keys = (short[])this.keys.clone();
            shortLongHashMap.values = (long[])this.values.clone();
            shortLongHashMap.hasEmptyKey = shortLongHashMap.hasEmptyKey;
            shortLongHashMap.orderMixer = this.orderMixer.clone();
            return shortLongHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            long[] lArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, lArray);
            }
        }
    }

    protected boolean equalElements(ShortLongHashMap object) {
        if (((ShortLongHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<ShortLongCursor> iterator = ((ShortLongHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            short s = ((ShortLongCursor)object).key;
            if (this.containsKey(s) && this.get(s) == ((ShortLongCursor)object).value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortLongHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortLongPredicate> T forEach(T t) {
        short[] sArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, lArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], lArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortLongProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        long[] lArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, lArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], lArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public long get(short s) {
        short s2;
        long l = 0L;
        if (s == 0) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return this.values[n2];
            }
            ++n2;
        }
        return 0L;
    }

    @Override
    public long getOrDefault(short s, long l) {
        int n;
        if (s == 0) {
            if (this.hasEmptyKey) {
                l = this.values[this.mask + 1];
            }
            return l;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return l;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortLongCursor shortLongCursor : this) {
            n += BitMixer.mix(shortLongCursor.key) + BitMixer.mix(shortLongCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public long indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, long l) {
        if (s == 0) {
            this.values[n] = l;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, l);
            } else {
                this.keys[n] = s;
                this.values[n] = l;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n3 = n2 + 1;
            if (!bl) {
                // empty if block
            }
            return n3;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                return n;
            }
            n4 = n + 1;
        }
        return n;
    }

    @Override
    public long indexReplace(int n, long l) {
        long[] lArray = this.values;
        long l2 = lArray[n];
        lArray[n] = l;
        return l2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortLongCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public long put(short s, long l) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            long[] lArray = this.values;
            int n3 = n2 + 1;
            long l2 = lArray[n3];
            lArray[n3] = l;
            return l2;
        }
        Object[] objectArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = objectArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                objectArray = this.values;
                short s2 = objectArray[n];
                objectArray[n] = (short)l;
                return s2;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s, l);
        } else {
            objectArray[n] = s;
            this.values[n] = l;
        }
        ++this.assigned;
        return 0L;
    }

    @Override
    public int putAll(ShortLongAssociativeContainer object) {
        int n = this.size();
        Iterator<ShortLongCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ShortLongCursor)object).key, ((ShortLongCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortLongCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortLongCursor shortLongCursor = (ShortLongCursor)object.next();
            this.put(shortLongCursor.key, shortLongCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, long l) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, l);
            return true;
        }
        return false;
    }

    @Override
    public long putOrAdd(short s, long l, long l2) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            l = this.values[n] + l2;
            this.indexReplace(n, l);
        } else {
            this.indexInsert(n, s, l);
        }
        return l;
    }

    protected void rehash(short[] sArray, long[] lArray) {
        int n;
        short[] sArray2 = this.keys;
        long[] lArray2 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        lArray2[lArray2.length - 1] = lArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            lArray2[n3] = lArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public long remove(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            long[] lArray = this.values;
            int n3 = n2 + 1;
            long l = lArray[n3];
            lArray[n3] = 0L;
            return l;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                long l = this.values[n];
                this.shiftConflictingKeys(n);
                return l;
            }
            n4 = n + 1;
        }
        return 0L;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = 0L;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortLongPredicate shortLongPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortLongPredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = 0L;
        }
        objectArray = this.keys;
        long[] lArray = this.values;
        while (n4 <= n3) {
            long l = objectArray[n4];
            if (l != false && shortLongPredicate.apply((short)l, lArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = 0L;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        long[] lArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    lArray[n] = 0L;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            lArray[n] = lArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortLongCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortLongCursor shortLongCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortLongCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortLongCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public LongCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortLongCursor> {
        private final ShortLongCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortLongCursor();
        }

        @Override
        protected ShortLongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortLongHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.key = (short)n;
                        this.cursor.value = ShortLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortLongCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortLongHashMap owner;

        public KeysContainer() {
            this.owner = ShortLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortLongPredicate(){

                @Override
                public boolean apply(short s, long l) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortLongProcedure(){

                @Override
                public void apply(short s, long l) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortLongHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.value = s;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractLongCollection {
        private final ShortLongHashMap owner;

        private ValuesContainer() {
            this.owner = ShortLongHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(long l) {
            Iterator<ShortLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != l) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends LongPredicate> T forEach(T t) {
            Iterator<ShortLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends LongProcedure> T forEach(T t) {
            Iterator<ShortLongCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<LongCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final long l) {
            return this.owner.removeAll(new ShortLongPredicate(){

                @Override
                public boolean apply(short s, long l2) {
                    boolean bl = l2 == l;
                    return bl;
                }
            });
        }

        @Override
        public int removeAll(final LongPredicate longPredicate) {
            return this.owner.removeAll(new ShortLongPredicate(){

                @Override
                public boolean apply(short s, long l) {
                    return longPredicate.apply(l);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortLongHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new LongCursor();
        }

        @Override
        protected LongCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortLongHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortLongHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortLongHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortLongHashMap.this.values[this.max];
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }
}

