/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.ShortLongHashMap;

public class ShortLongScatterMap
extends ShortLongHashMap {
    public ShortLongScatterMap() {
        this(4);
    }

    public ShortLongScatterMap(int n) {
        this(n, 0.75);
    }

    public ShortLongScatterMap(int n, double d) {
        super(n, d, HashOrderMixing.none());
    }

    public static ShortLongScatterMap from(short[] sArray, long[] lArray) {
        if (sArray.length == lArray.length) {
            ShortLongScatterMap shortLongScatterMap = new ShortLongScatterMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortLongScatterMap.put(sArray[i], lArray[i]);
            }
            return shortLongScatterMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    protected int hashKey(short s) {
        return BitMixer.mixPhi(s);
    }
}

