/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractObjectCollection;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.ObjectCollection;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortObjectAssociativeContainer;
import com.carrotsearch.hppc.ShortObjectMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortObjectCursor;
import com.carrotsearch.hppc.predicates.ObjectPredicate;
import com.carrotsearch.hppc.predicates.ShortObjectPredicate;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.procedures.ObjectProcedure;
import com.carrotsearch.hppc.procedures.ShortObjectProcedure;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;

public class ShortObjectHashMap<VType>
implements ShortObjectMap<VType>,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public Object[] values;

    public ShortObjectHashMap() {
        this(4);
    }

    public ShortObjectHashMap(int n) {
        this(n, 0.75);
    }

    public ShortObjectHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortObjectHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortObjectHashMap(ShortObjectAssociativeContainer<? extends VType> shortObjectAssociativeContainer) {
        this(shortObjectAssociativeContainer.size());
        this.putAll(shortObjectAssociativeContainer);
    }

    public static <VType> ShortObjectHashMap<VType> from(short[] sArray, VType[] VTypeArray) {
        if (sArray.length == VTypeArray.length) {
            ShortObjectHashMap<VType> shortObjectHashMap = new ShortObjectHashMap<VType>(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortObjectHashMap.put(sArray[i], VTypeArray[i]);
            }
            return shortObjectHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        Object[] objectArray = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new Object[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = objectArray;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, VType VType) {
        short[] sArray = this.keys;
        Object[] objectArray = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        objectArray[n] = VType;
        this.rehash(sArray, objectArray);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
        Arrays.fill(this.values, null);
    }

    public ShortObjectHashMap<VType> clone() {
        try {
            ShortObjectHashMap shortObjectHashMap = (ShortObjectHashMap)super.clone();
            shortObjectHashMap.keys = (short[])this.keys.clone();
            shortObjectHashMap.values = (Object[])this.values.clone();
            shortObjectHashMap.hasEmptyKey = shortObjectHashMap.hasEmptyKey;
            shortObjectHashMap.orderMixer = this.orderMixer.clone();
            return shortObjectHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            Object[] objectArray = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, objectArray);
            }
        }
    }

    protected boolean equalElements(ShortObjectHashMap<?> object) {
        if (((ShortObjectHashMap)object).size() != this.size()) {
            return false;
        }
        Iterator<ShortObjectCursor<?>> iterator = ((ShortObjectHashMap)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            short s = ((ShortObjectCursor)object).key;
            if (this.containsKey(s) && Objects.equals(this.get(s), ((ShortObjectCursor)object).value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortObjectHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortObjectPredicate<? super VType>> T forEach(T t) {
        short[] sArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, (Object)objectArray[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], (Object)objectArray[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortObjectProcedure<? super VType>> T forEach(T t) {
        short[] sArray = this.keys;
        Object[] objectArray = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, (Object)objectArray[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], (Object)objectArray[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public VType get(short s) {
        short s2;
        Object object = null;
        if (s == 0) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return (VType)object;
        }
        object = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = object[n2 &= n]) != 0) {
            if (s2 == s) {
                return (VType)this.values[n2];
            }
            ++n2;
        }
        return null;
    }

    @Override
    public VType getOrDefault(short s, VType object) {
        int n;
        if (s == 0) {
            if (this.hasEmptyKey) {
                object = this.values[this.mask + 1];
            }
            return object;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return (VType)this.values[n];
            }
            n3 = n + 1;
        }
        return object;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortObjectCursor<VType> shortObjectCursor : this) {
            n += BitMixer.mix(shortObjectCursor.key) + BitMixer.mix(shortObjectCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public VType indexGet(int n) {
        return (VType)this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, VType VType) {
        if (s == 0) {
            this.values[n] = VType;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, VType);
            } else {
                this.keys[n] = s;
                this.values[n] = VType;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public VType indexReplace(int n, VType VType) {
        Object[] objectArray = this.values;
        Object object = objectArray[n];
        objectArray[n] = VType;
        return (VType)object;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortObjectCursor<VType>> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public VType put(short s, VType VType) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            Object[] objectArray = this.values;
            int n3 = n2 + 1;
            Object object = objectArray[n3];
            objectArray[n3] = VType;
            return (VType)object;
        }
        Object object = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = object[n = n4 & n2]) != 0) {
            if (n4 == s) {
                Object[] objectArray = this.values;
                object = objectArray[n];
                objectArray[n] = VType;
                return (VType)object;
            }
            n4 = n + 1;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n, s, VType);
        } else {
            object[n] = s;
            this.values[n] = VType;
        }
        ++this.assigned;
        return null;
    }

    @Override
    public int putAll(ShortObjectAssociativeContainer<? extends VType> object) {
        int n = this.size();
        Iterator<ShortObjectCursor<VType>> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ShortObjectCursor)object).key, ((ShortObjectCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortObjectCursor<? extends VType>> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortObjectCursor shortObjectCursor = (ShortObjectCursor)object.next();
            this.put(shortObjectCursor.key, shortObjectCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, VType VType) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, VType);
            return true;
        }
        return false;
    }

    protected void rehash(short[] sArray, VType[] VTypeArray) {
        int n;
        short[] sArray2 = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray2[sArray2.length - 1] = sArray[n3];
        objectArray[objectArray.length - 1] = VTypeArray[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray2[n3 &= n2] != 0) {
                ++n3;
            }
            sArray2[n3] = s;
            objectArray[n3] = VTypeArray[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public VType remove(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            Object[] objectArray = this.values;
            int n2 = n + 1;
            Object object = objectArray[n2];
            objectArray[n2] = null;
            return (VType)object;
        }
        Object object = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = object[n3 &= n]) != 0) {
            if (s2 == s) {
                object = this.values[n3];
                this.shiftConflictingKeys(n3);
                return (VType)object;
            }
            ++n3;
        }
        return null;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = null;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortObjectPredicate<? super VType> shortObjectPredicate) {
        int n;
        Object[] objectArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortObjectPredicate.apply((short)0, (objectArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = null;
        }
        objectArray = this.keys;
        Object[] objectArray2 = this.values;
        while (n4 <= n3) {
            Object object = objectArray[n4];
            if (object != false && shortObjectPredicate.apply((short)object, objectArray2[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = null;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        Object[] objectArray = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    objectArray[n] = null;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            objectArray[n] = objectArray[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortObjectCursor<VType>> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortObjectCursor<VType> shortObjectCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortObjectCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortObjectCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ObjectCollection<VType> values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortObjectCursor<VType>> {
        private final ShortObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortObjectCursor();
        }

        @Override
        protected ShortObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortObjectHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.key = s;
                        this.cursor.value = ShortObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortObjectCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortObjectHashMap<VType> owner;

        public KeysContainer() {
            this.owner = ShortObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short s, VType VType) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortObjectProcedure<VType>(){

                @Override
                public void apply(short s, VType VType) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortObjectHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.value = s;
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractObjectCollection<VType> {
        private final ShortObjectHashMap<VType> owner;

        private ValuesContainer() {
            this.owner = ShortObjectHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(VType VType) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (!Objects.equals(iterator.next().value, VType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ObjectPredicate<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ObjectProcedure<? super VType>> T forEach(T t) {
            Iterator iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ObjectCursor<VType>> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ObjectPredicate<? super VType> objectPredicate) {
            return this.owner.removeAll(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short s, VType VType) {
                    return objectPredicate.apply(VType);
                }
            });
        }

        @Override
        public int removeAll(final VType VType) {
            return this.owner.removeAll(new ShortObjectPredicate<VType>(){

                @Override
                public boolean apply(short s, VType VType2) {
                    return Objects.equals(VType2, VType);
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ObjectCursor<VType>> {
        private final ObjectCursor<VType> cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortObjectHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ObjectCursor();
        }

        @Override
        protected ObjectCursor<VType> fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortObjectHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortObjectHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortObjectHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortObjectHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ObjectCursor)this.done();
        }
    }
}

