/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc;

import com.carrotsearch.hppc.AbstractIterator;
import com.carrotsearch.hppc.AbstractShortCollection;
import com.carrotsearch.hppc.BitMixer;
import com.carrotsearch.hppc.BufferAllocationException;
import com.carrotsearch.hppc.HashContainers;
import com.carrotsearch.hppc.HashOrderMixing;
import com.carrotsearch.hppc.HashOrderMixingStrategy;
import com.carrotsearch.hppc.Preallocable;
import com.carrotsearch.hppc.ShortBufferVisualizer;
import com.carrotsearch.hppc.ShortCollection;
import com.carrotsearch.hppc.ShortContainer;
import com.carrotsearch.hppc.ShortLookupContainer;
import com.carrotsearch.hppc.ShortShortAssociativeContainer;
import com.carrotsearch.hppc.ShortShortMap;
import com.carrotsearch.hppc.cursors.ShortCursor;
import com.carrotsearch.hppc.cursors.ShortShortCursor;
import com.carrotsearch.hppc.predicates.ShortPredicate;
import com.carrotsearch.hppc.predicates.ShortShortPredicate;
import com.carrotsearch.hppc.procedures.ShortProcedure;
import com.carrotsearch.hppc.procedures.ShortShortProcedure;
import java.util.Arrays;
import java.util.Iterator;

public class ShortShortHashMap
implements ShortShortMap,
Preallocable,
Cloneable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected int assigned;
    protected boolean hasEmptyKey;
    protected int keyMixer;
    public short[] keys;
    protected double loadFactor;
    protected int mask;
    protected HashOrderMixingStrategy orderMixer;
    protected int resizeAt;
    public short[] values;

    public ShortShortHashMap() {
        this(4);
    }

    public ShortShortHashMap(int n) {
        this(n, 0.75);
    }

    public ShortShortHashMap(int n, double d) {
        this(n, d, HashOrderMixing.defaultStrategy());
    }

    public ShortShortHashMap(int n, double d, HashOrderMixingStrategy hashOrderMixingStrategy) {
        this.orderMixer = hashOrderMixingStrategy;
        this.loadFactor = this.verifyLoadFactor(d);
        this.ensureCapacity(n);
    }

    public ShortShortHashMap(ShortShortAssociativeContainer shortShortAssociativeContainer) {
        this(shortShortAssociativeContainer.size());
        this.putAll(shortShortAssociativeContainer);
    }

    public static ShortShortHashMap from(short[] sArray, short[] sArray2) {
        if (sArray.length == sArray2.length) {
            ShortShortHashMap shortShortHashMap = new ShortShortHashMap(sArray.length);
            for (int i = 0; i < sArray.length; ++i) {
                shortShortHashMap.put(sArray[i], sArray2[i]);
            }
            return shortShortHashMap;
        }
        throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
    }

    @Override
    public short addTo(short s, short s2) {
        return this.putOrAdd(s, s2, s2);
    }

    protected void allocateBuffers(int n) {
        int n2 = this.orderMixer.newKeyMixer(n);
        short[] sArray = this.keys;
        short[] sArray2 = this.values;
        int n3 = n + 1;
        try {
            this.keys = new short[n3];
            this.values = new short[n3];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            this.keys = sArray;
            this.values = sArray2;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)outOfMemoryError, this.mask + 1, n);
        }
        this.resizeAt = HashContainers.expandAtCount(n, this.loadFactor);
        this.keyMixer = n2;
        this.mask = n - 1;
    }

    protected void allocateThenInsertThenRehash(int n, short s, short s2) {
        short[] sArray = this.keys;
        short[] sArray2 = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        sArray[n] = s;
        sArray2[n] = s2;
        this.rehash(sArray, sArray2);
    }

    @Override
    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, (short)0);
    }

    public ShortShortHashMap clone() {
        try {
            ShortShortHashMap shortShortHashMap = (ShortShortHashMap)super.clone();
            shortShortHashMap.keys = (short[])this.keys.clone();
            shortShortHashMap.values = (short[])this.values.clone();
            shortShortHashMap.hasEmptyKey = shortShortHashMap.hasEmptyKey;
            shortShortHashMap.orderMixer = this.orderMixer.clone();
            return shortShortHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    @Override
    public boolean containsKey(short s) {
        short s2;
        if (s == 0) {
            return this.hasEmptyKey;
        }
        short[] sArray = this.keys;
        int n = this.mask;
        int n2 = this.hashKey(s);
        while ((s2 = sArray[n2 &= n]) != 0) {
            if (s2 == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void ensureCapacity(int n) {
        if (n > this.resizeAt || this.keys == null) {
            short[] sArray = this.keys;
            short[] sArray2 = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(n, this.loadFactor));
            if (sArray != null && !this.isEmpty()) {
                this.rehash(sArray, sArray2);
            }
        }
    }

    protected boolean equalElements(ShortShortHashMap object) {
        if (((ShortShortHashMap)object).size() != this.size()) {
            return false;
        }
        object = ((ShortShortHashMap)object).iterator();
        while (object.hasNext()) {
            ShortShortCursor shortShortCursor = (ShortShortCursor)object.next();
            short s = shortShortCursor.key;
            if (this.containsKey(s) && this.get(s) == shortShortCursor.value) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = object != null && this.getClass() == object.getClass() && this.equalElements((ShortShortHashMap)this.getClass().cast(object));
        return bl;
    }

    @Override
    public <T extends ShortShortPredicate> T forEach(T t) {
        short[] sArray = this.keys;
        short[] sArray2 = this.values;
        boolean bl = this.hasEmptyKey;
        if (bl && !t.apply((short)0, sArray2[this.mask + 1])) {
            return t;
        }
        int n = this.mask;
        for (int i = 0; i <= n && (sArray[i] == 0 || t.apply(sArray[i], sArray2[i])); ++i) {
        }
        return t;
    }

    @Override
    public <T extends ShortShortProcedure> T forEach(T t) {
        short[] sArray = this.keys;
        short[] sArray2 = this.values;
        boolean bl = this.hasEmptyKey;
        int n = 0;
        if (bl) {
            t.apply((short)0, sArray2[this.mask + 1]);
        }
        int n2 = this.mask;
        while (n <= n2) {
            if (sArray[n] != 0) {
                t.apply(sArray[n], sArray2[n]);
            }
            ++n;
        }
        return t;
    }

    @Override
    public short get(short n) {
        int n2;
        int n3 = 0;
        if (n == 0) {
            n = n3;
            if (this.hasEmptyKey) {
                n = n3 = this.values[this.mask + 1];
            }
            return (short)n;
        }
        short[] sArray = this.keys;
        int n4 = this.mask;
        n3 = this.hashKey((short)n);
        while ((n3 = sArray[n2 = n3 & n4]) != 0) {
            if (n3 == n) {
                return this.values[n2];
            }
            n3 = n2 + 1;
        }
        return 0;
    }

    @Override
    public short getOrDefault(short s, short s2) {
        int n;
        if (s == 0) {
            if (this.hasEmptyKey) {
                short s3;
                s2 = s3 = this.values[this.mask + 1];
            }
            return s2;
        }
        short[] sArray = this.keys;
        int n2 = this.mask;
        int n3 = this.hashKey(s);
        while ((n3 = sArray[n = n3 & n2]) != 0) {
            if (n3 == s) {
                return this.values[n];
            }
            n3 = n + 1;
        }
        return s2;
    }

    @Override
    public int hashCode() {
        int n = this.hasEmptyKey ? -559038737 : 0;
        for (ShortShortCursor shortShortCursor : this) {
            n += BitMixer.mix(shortShortCursor.key) + BitMixer.mix(shortShortCursor.value);
        }
        return n;
    }

    protected int hashKey(short s) {
        return BitMixer.mix(s, this.keyMixer);
    }

    @Override
    public boolean indexExists(int n) {
        boolean bl = n >= 0;
        return bl;
    }

    @Override
    public short indexGet(int n) {
        return this.values[n];
    }

    @Override
    public void indexInsert(int n, short s, short s2) {
        if (s == 0) {
            this.values[n] = s2;
            this.hasEmptyKey = true;
        } else {
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(n, s, s2);
            } else {
                this.keys[n] = s;
                this.values[n] = s2;
            }
            ++this.assigned;
        }
    }

    @Override
    public int indexOf(short s) {
        short s2;
        int n = this.mask;
        if (s == 0) {
            boolean bl = this.hasEmptyKey;
            int n2 = n + 1;
            if (!bl) {
                // empty if block
            }
            return n2;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s2 = sArray[n3 &= n]) != 0) {
            if (s2 == s) {
                return n3;
            }
            ++n3;
        }
        return n3;
    }

    @Override
    public short indexReplace(int n, short s) {
        short[] sArray = this.values;
        short s2 = sArray[n];
        sArray[n] = s;
        return s2;
    }

    @Override
    public boolean isEmpty() {
        boolean bl = this.size() == 0;
        return bl;
    }

    @Override
    public Iterator<ShortShortCursor> iterator() {
        return new EntryIterator();
    }

    @Override
    public KeysContainer keys() {
        return new KeysContainer();
    }

    @Override
    public short put(short s, short s2) {
        short s3;
        int n = this.mask;
        if (s == 0) {
            this.hasEmptyKey = true;
            short[] sArray = this.values;
            int n2 = n + 1;
            s = sArray[n2];
            sArray[n2] = s2;
            return s;
        }
        short[] sArray = this.keys;
        int n3 = this.hashKey(s);
        while ((s3 = sArray[n3 &= n]) != 0) {
            if (s3 == s) {
                sArray = this.values;
                s = sArray[n3];
                sArray[n3] = s2;
                return s;
            }
            ++n3;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(n3, s, s2);
        } else {
            sArray[n3] = s;
            this.values[n3] = s2;
        }
        ++this.assigned;
        return 0;
    }

    @Override
    public int putAll(ShortShortAssociativeContainer object) {
        int n = this.size();
        Iterator<ShortShortCursor> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            this.put(((ShortShortCursor)object).key, ((ShortShortCursor)object).value);
        }
        return this.size() - n;
    }

    @Override
    public int putAll(Iterable<? extends ShortShortCursor> object) {
        int n = this.size();
        object = object.iterator();
        while (object.hasNext()) {
            ShortShortCursor shortShortCursor = (ShortShortCursor)object.next();
            this.put(shortShortCursor.key, shortShortCursor.value);
        }
        return this.size() - n;
    }

    public boolean putIfAbsent(short s, short s2) {
        int n = this.indexOf(s);
        if (!this.indexExists(n)) {
            this.indexInsert(n, s, s2);
            return true;
        }
        return false;
    }

    @Override
    public short putOrAdd(short s, short s2, short s3) {
        int n = this.indexOf(s);
        if (this.indexExists(n)) {
            s2 = (short)(this.values[n] + s3);
            this.indexReplace(n, s2);
        } else {
            this.indexInsert(n, s, s2);
        }
        return s2;
    }

    protected void rehash(short[] sArray, short[] sArray2) {
        int n;
        short[] sArray3 = this.keys;
        short[] sArray4 = this.values;
        int n2 = this.mask;
        int n3 = sArray.length - 1;
        sArray3[sArray3.length - 1] = sArray[n3];
        sArray4[sArray4.length - 1] = sArray2[n3];
        while ((n = n3 - 1) >= 0) {
            short s = sArray[n];
            n3 = n;
            if (s == 0) continue;
            n3 = this.hashKey(s);
            while (sArray3[n3 &= n2] != 0) {
                ++n3;
            }
            sArray3[n3] = s;
            sArray4[n3] = sArray2[n];
            n3 = n;
        }
    }

    @Override
    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    @Override
    public short remove(short s) {
        int n;
        int n2 = this.mask;
        if (s == 0) {
            this.hasEmptyKey = false;
            short[] sArray = this.values;
            int n3 = n2 + 1;
            s = sArray[n3];
            sArray[n3] = (short)0;
            return s;
        }
        short[] sArray = this.keys;
        int n4 = this.hashKey(s);
        while ((n4 = sArray[n = n4 & n2]) != 0) {
            if (n4 == s) {
                s = this.values[n];
                this.shiftConflictingKeys(n);
                return s;
            }
            n4 = n + 1;
        }
        return 0;
    }

    @Override
    public int removeAll(ShortContainer object) {
        int n = this.size();
        if (object.size() >= this.size() && object instanceof ShortLookupContainer) {
            boolean bl = this.hasEmptyKey;
            int n2 = 0;
            if (bl && object.contains((short)0)) {
                this.hasEmptyKey = false;
                this.values[this.mask + 1] = (short)0;
            }
            short[] sArray = this.keys;
            int n3 = this.mask;
            while (n2 <= n3) {
                short s = sArray[n2];
                if (s != 0 && object.contains(s)) {
                    this.shiftConflictingKeys(n2);
                    continue;
                }
                ++n2;
            }
        } else {
            object = object.iterator();
            while (object.hasNext()) {
                this.remove(((ShortCursor)object.next()).value);
            }
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortPredicate shortPredicate) {
        int n = this.size();
        boolean bl = this.hasEmptyKey;
        int n2 = 0;
        if (bl && shortPredicate.apply((short)0)) {
            this.hasEmptyKey = false;
            this.values[this.mask + 1] = (short)0;
        }
        short[] sArray = this.keys;
        int n3 = this.mask;
        while (n2 <= n3) {
            short s = sArray[n2];
            if (s != 0 && shortPredicate.apply(s)) {
                this.shiftConflictingKeys(n2);
                continue;
            }
            ++n2;
        }
        return n - this.size();
    }

    @Override
    public int removeAll(ShortShortPredicate shortShortPredicate) {
        int n;
        short[] sArray;
        int n2 = this.size();
        int n3 = this.mask;
        boolean bl = this.hasEmptyKey;
        int n4 = 0;
        if (bl && shortShortPredicate.apply((short)0, (sArray = this.values)[n = n3 + 1])) {
            this.hasEmptyKey = false;
            this.values[n] = (short)0;
        }
        short[] sArray2 = this.keys;
        sArray = this.values;
        while (n4 <= n3) {
            short s = sArray2[n4];
            if (s != 0 && shortShortPredicate.apply(s, sArray[n4])) {
                this.shiftConflictingKeys(n4);
                continue;
            }
            ++n4;
        }
        return n2 - this.size();
    }

    protected void shiftConflictingKeys(int n) {
        short[] sArray = this.keys;
        short[] sArray2 = this.values;
        int n2 = this.mask;
        while (true) {
            int n3;
            short s;
            int n4;
            int n5 = 0;
            do {
                if ((s = sArray[n4 = n + (n3 = n5 + 1) & n2]) == 0) {
                    sArray[n] = (short)0;
                    sArray2[n] = (short)0;
                    --this.assigned;
                    return;
                }
                n5 = n3;
            } while ((n4 - this.hashKey(s) & n2) < n3);
            sArray[n] = s;
            sArray2[n] = sArray2[n4];
            n = n4;
        }
    }

    @Override
    public int size() {
        return this.assigned + this.hasEmptyKey;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        Iterator<ShortShortCursor> iterator = this.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            ShortShortCursor shortShortCursor = iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(shortShortCursor.key);
            stringBuilder.append("=>");
            stringBuilder.append(shortShortCursor.value);
            bl = false;
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    @Override
    public ShortCollection values() {
        return new ValuesContainer();
    }

    protected double verifyLoadFactor(double d) {
        HashContainers.checkLoadFactor(d, 0.01f, 0.99f);
        return d;
    }

    @Override
    public String visualizeKeyDistribution(int n) {
        return ShortBufferVisualizer.visualizeKeyDistribution(this.keys, this.mask, n);
    }

    private final class EntryIterator
    extends AbstractIterator<ShortShortCursor> {
        private final ShortShortCursor cursor;
        private final int max;
        private int slot;

        public EntryIterator() {
            this.max = ShortShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortShortCursor();
        }

        @Override
        protected ShortShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortShortHashMap.this.keys;
                    n = this.slot;
                    short s = sArray[n];
                    if (s != 0) {
                        this.cursor.index = n;
                        this.cursor.key = s;
                        this.cursor.value = ShortShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.key = (short)0;
                this.cursor.value = ShortShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortShortCursor)this.done();
        }
    }

    public final class KeysContainer
    extends AbstractShortCollection
    implements ShortLookupContainer {
        private final ShortShortHashMap owner;

        public KeysContainer() {
            this.owner = ShortShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            return this.owner.containsKey(s);
        }

        @Override
        public <T extends ShortPredicate> T forEach(final T t) {
            this.owner.forEach(new ShortShortPredicate(){

                @Override
                public boolean apply(short s, short s2) {
                    return t.apply(s);
                }
            });
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(final T t) {
            this.owner.forEach(new ShortShortProcedure(){

                @Override
                public void apply(short s, short s2) {
                    t.apply(s);
                }
            });
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new KeysIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(ShortPredicate shortPredicate) {
            return this.owner.removeAll(shortPredicate);
        }

        @Override
        public int removeAll(short s) {
            if (this.owner.containsKey(s)) {
                this.owner.remove(s);
                return 1;
            }
            return 0;
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class KeysIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public KeysIterator() {
            this.max = ShortShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortShortHashMap.this.keys;
                    int n2 = this.slot;
                    n = sArray[n2];
                    if (n != 0) {
                        this.cursor.index = n2;
                        this.cursor.value = (short)n;
                        return this.cursor;
                    }
                    this.slot = n2 + 1;
                }
            }
            if (this.slot == this.max && ShortShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = (short)0;
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }

    private final class ValuesContainer
    extends AbstractShortCollection {
        private final ShortShortHashMap owner;

        private ValuesContainer() {
            this.owner = ShortShortHashMap.this;
        }

        @Override
        public void clear() {
            this.owner.clear();
        }

        @Override
        public boolean contains(short s) {
            Iterator<ShortShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().value != s) continue;
                return true;
            }
            return false;
        }

        @Override
        public <T extends ShortPredicate> T forEach(T t) {
            Iterator<ShortShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext() && t.apply(iterator.next().value)) {
            }
            return t;
        }

        @Override
        public <T extends ShortProcedure> T forEach(T t) {
            Iterator<ShortShortCursor> iterator = this.owner.iterator();
            while (iterator.hasNext()) {
                t.apply(iterator.next().value);
            }
            return t;
        }

        @Override
        public boolean isEmpty() {
            return this.owner.isEmpty();
        }

        @Override
        public Iterator<ShortCursor> iterator() {
            return new ValuesIterator();
        }

        @Override
        public void release() {
            this.owner.release();
        }

        @Override
        public int removeAll(final ShortPredicate shortPredicate) {
            return this.owner.removeAll(new ShortShortPredicate(){

                @Override
                public boolean apply(short s, short s2) {
                    return shortPredicate.apply(s2);
                }
            });
        }

        @Override
        public int removeAll(final short s) {
            return this.owner.removeAll(new ShortShortPredicate(){

                @Override
                public boolean apply(short s3, short s2) {
                    boolean bl = s2 == s;
                    return bl;
                }
            });
        }

        @Override
        public int size() {
            return this.owner.size();
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<ShortCursor> {
        private final ShortCursor cursor;
        private final int max;
        private int slot;

        public ValuesIterator() {
            this.max = ShortShortHashMap.this.mask + 1;
            this.slot = -1;
            this.cursor = new ShortCursor();
        }

        @Override
        protected ShortCursor fetch() {
            int n = this.slot;
            if (n < this.max) {
                this.slot = n + 1;
                while (this.slot < this.max) {
                    short[] sArray = ShortShortHashMap.this.keys;
                    n = this.slot;
                    if (sArray[n] != 0) {
                        this.cursor.index = n;
                        this.cursor.value = ShortShortHashMap.this.values[this.slot];
                        return this.cursor;
                    }
                    this.slot = n + 1;
                }
            }
            if (this.slot == this.max && ShortShortHashMap.this.hasEmptyKey) {
                this.cursor.index = this.slot++;
                this.cursor.value = ShortShortHashMap.this.values[this.max];
                return this.cursor;
            }
            return (ShortCursor)this.done();
        }
    }
}

