/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc.sorting;

import java.util.Comparator;

public interface IndirectComparator {
    public int compare(int var1, int var2);

    public static class AscendingDoubleComparator
    implements IndirectComparator {
        private final double[] array;

        public AscendingDoubleComparator(double[] dArray) {
            this.array = dArray;
        }

        @Override
        public int compare(int n, int n2) {
            double[] dArray = this.array;
            double d = dArray[n];
            double d2 = dArray[n2];
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }

    public static class AscendingFloatComparator
    implements IndirectComparator {
        private final float[] array;

        public AscendingFloatComparator(float[] fArray) {
            this.array = fArray;
        }

        @Override
        public int compare(int n, int n2) {
            float[] fArray = this.array;
            float f = fArray[n];
            float f2 = fArray[n2];
            if (f < f2) {
                return -1;
            }
            if (f > f2) {
                return 1;
            }
            return 0;
        }
    }

    public static class AscendingIntComparator
    implements IndirectComparator {
        private final int[] array;

        public AscendingIntComparator(int[] nArray) {
            this.array = nArray;
        }

        @Override
        public int compare(int n, int n2) {
            int[] nArray = this.array;
            if ((n = nArray[n]) < (n2 = nArray[n2])) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
    }

    public static class AscendingShortComparator
    implements IndirectComparator {
        private final short[] array;

        public AscendingShortComparator(short[] sArray) {
            this.array = sArray;
        }

        @Override
        public int compare(int n, int n2) {
            short[] sArray = this.array;
            if ((n = sArray[n]) < (n2 = sArray[n2])) {
                return -1;
            }
            if (n > n2) {
                return 1;
            }
            return 0;
        }
    }

    public static final class DelegatingComparator<T>
    implements IndirectComparator {
        private final T[] array;
        private final Comparator<? super T> delegate;

        public DelegatingComparator(T[] TArray, Comparator<? super T> comparator) {
            this.array = TArray;
            this.delegate = comparator;
        }

        @Override
        public final int compare(int n, int n2) {
            Comparator<T> comparator = this.delegate;
            T[] TArray = this.array;
            return comparator.compare(TArray[n], TArray[n2]);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.getClass().getSimpleName());
            stringBuilder.append(" -> ");
            stringBuilder.append(this.delegate);
            return stringBuilder.toString();
        }
    }

    public static class DescendingDoubleComparator
    extends AscendingDoubleComparator {
        public DescendingDoubleComparator(double[] dArray) {
            super(dArray);
        }

        @Override
        public final int compare(int n, int n2) {
            return -super.compare(n, n2);
        }
    }

    public static class DescendingFloatComparator
    extends AscendingFloatComparator {
        public DescendingFloatComparator(float[] fArray) {
            super(fArray);
        }

        @Override
        public final int compare(int n, int n2) {
            return -super.compare(n, n2);
        }
    }

    public static class DescendingIntComparator
    extends AscendingIntComparator {
        public DescendingIntComparator(int[] nArray) {
            super(nArray);
        }

        @Override
        public final int compare(int n, int n2) {
            return -super.compare(n, n2);
        }
    }

    public static class DescendingShortComparator
    extends AscendingShortComparator {
        public DescendingShortComparator(short[] sArray) {
            super(sArray);
        }

        @Override
        public final int compare(int n, int n2) {
            return -super.compare(n, n2);
        }
    }
}

