/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppc.sorting;

import com.carrotsearch.hppc.sorting.IndirectComparator;
import java.util.Comparator;

public final class IndirectSort {
    static int MIN_LENGTH_FOR_INSERTION_SORT = 30;

    private IndirectSort() {
    }

    private static int[] createOrderArray(int n, int n2) {
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n + i;
        }
        return nArray;
    }

    private static void insertionSort(int n, int n2, int[] nArray, IndirectComparator indirectComparator) {
        for (int i = n + 1; i < n + n2; ++i) {
            int n3;
            int n4 = nArray[i];
            for (int j = i; j > n && indirectComparator.compare(n3 = nArray[j - 1], n4) > 0; --j) {
                nArray[j] = n3;
            }
            nArray[j] = n4;
        }
    }

    public static int[] mergesort(int n, int n2, IndirectComparator indirectComparator) {
        int[] nArray = IndirectSort.createOrderArray(n, n2);
        if (n2 > 1) {
            int[] nArray2 = (int[])nArray.clone();
            IndirectSort.topDownMergeSort(nArray, nArray2, 0, n2, indirectComparator);
            return nArray2;
        }
        return nArray;
    }

    public static <T> int[] mergesort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        return IndirectSort.mergesort(n, n2, new IndirectComparator.DelegatingComparator<T>(TArray, comparator));
    }

    private static void topDownMergeSort(int[] nArray, int[] nArray2, int n, int n2, IndirectComparator indirectComparator) {
        int n3 = n2 - n;
        if (n3 <= MIN_LENGTH_FOR_INSERTION_SORT) {
            IndirectSort.insertionSort(n, n3, nArray2, indirectComparator);
            return;
        }
        int n4 = n + n2 >>> 1;
        IndirectSort.topDownMergeSort(nArray2, nArray, n, n4, indirectComparator);
        IndirectSort.topDownMergeSort(nArray2, nArray, n4, n2, indirectComparator);
        if (indirectComparator.compare(nArray[n4 - 1], nArray[n4]) <= 0) {
            System.arraycopy(nArray, n, nArray2, n, n3);
        } else {
            n3 = n;
            int n5 = n4;
            while (n < n2) {
                if (n5 != n2 && (n3 >= n4 || indirectComparator.compare(nArray[n3], nArray[n5]) > 0)) {
                    nArray2[n] = nArray[n5];
                    ++n5;
                } else {
                    nArray2[n] = nArray[n3];
                    ++n3;
                }
                ++n;
            }
        }
    }
}

