/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.util.Log;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.xml.sax.SAXException;

public class CSSParser {
    private static final String CLASS = "class";
    private static final String ID = "id";
    private static final String TAG = "AndroidSVG CSSParser";
    private boolean inMediaRule = false;
    private MediaType rendererMediaType = null;

    public CSSParser(MediaType mediaType) {
        this.rendererMediaType = mediaType;
    }

    private static int getChildPosition(List<SVG.SvgContainer> object, int n, SVG.SvgElementBase svgElementBase) {
        if (n < 0) {
            return -1;
        }
        if (object.get(n) != svgElementBase.parent) {
            return -1;
        }
        n = 0;
        object = svgElementBase.parent.getChildren().iterator();
        while (object.hasNext()) {
            if ((SVG.SvgObject)object.next() == svgElementBase) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public static boolean mediaMatches(String object, MediaType mediaType) throws SAXException {
        object = new CSSTextScanner((String)object);
        ((SVGParser.TextScanner)object).skipWhitespace();
        List<MediaType> list = CSSParser.parseMediaList((CSSTextScanner)object);
        if (((SVGParser.TextScanner)object).empty()) {
            return CSSParser.mediaMatches(list, mediaType);
        }
        throw new SAXException("Invalid @media type list");
    }

    private static boolean mediaMatches(List<MediaType> object, MediaType mediaType) {
        MediaType mediaType2;
        object = object.iterator();
        do {
            if (object.hasNext()) continue;
            return false;
        } while ((mediaType2 = (MediaType)((Object)object.next())) != MediaType.all && mediaType2 != mediaType);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAtRule(Ruleset ruleset, CSSTextScanner cSSTextScanner) throws SAXException {
        Object object = cSSTextScanner.nextIdentifier();
        cSSTextScanner.skipWhitespace();
        if (object == null) throw new SAXException("Invalid '@' rule in <style> element");
        if (!this.inMediaRule && ((String)object).equals("media")) {
            object = CSSParser.parseMediaList(cSSTextScanner);
            if (!cSSTextScanner.consume('{')) throw new SAXException("Invalid @media rule: missing rule set");
            cSSTextScanner.skipWhitespace();
            if (CSSParser.mediaMatches((List<MediaType>)object, this.rendererMediaType)) {
                this.inMediaRule = true;
                ruleset.addAll(this.parseRuleset(cSSTextScanner));
                this.inMediaRule = false;
            } else {
                this.parseRuleset(cSSTextScanner);
            }
            if (!cSSTextScanner.consume('}')) {
                throw new SAXException("Invalid @media rule: expected '}' at end of rule set");
            }
        } else {
            CSSParser.warn("Ignoring @%s rule", object);
            this.skipAtRule(cSSTextScanner);
        }
        cSSTextScanner.skipWhitespace();
    }

    protected static List<String> parseClassAttribute(String string2) throws SAXException {
        Serializable serializable;
        CSSTextScanner cSSTextScanner = new CSSTextScanner(string2);
        StringBuilder stringBuilder = null;
        while (true) {
            if (cSSTextScanner.empty()) {
                return stringBuilder;
            }
            String string3 = cSSTextScanner.nextIdentifier();
            if (string3 == null) break;
            serializable = stringBuilder;
            if (stringBuilder == null) {
                serializable = new ArrayList();
            }
            serializable.add(string3);
            cSSTextScanner.skipWhitespace();
            stringBuilder = serializable;
        }
        serializable = new StringBuilder("Invalid value for \"class\" attribute: ");
        ((StringBuilder)serializable).append(string2);
        throw new SAXException(((StringBuilder)serializable).toString());
    }

    private SVG.Style parseDeclarations(CSSTextScanner cSSTextScanner) throws SAXException {
        SVG.Style style2 = new SVG.Style();
        do {
            String string2 = cSSTextScanner.nextIdentifier();
            cSSTextScanner.skipWhitespace();
            if (!cSSTextScanner.consume(':')) break;
            cSSTextScanner.skipWhitespace();
            String string3 = cSSTextScanner.nextPropertyValue();
            if (string3 == null) break;
            cSSTextScanner.skipWhitespace();
            if (cSSTextScanner.consume('!')) {
                cSSTextScanner.skipWhitespace();
                if (cSSTextScanner.consume("important")) {
                    cSSTextScanner.skipWhitespace();
                } else {
                    throw new SAXException("Malformed rule set in <style> element: found unexpected '!'");
                }
            }
            cSSTextScanner.consume(';');
            SVGParser.processStyleProperty(style2, string2, string3);
            cSSTextScanner.skipWhitespace();
            if (!cSSTextScanner.consume('}')) continue;
            return style2;
        } while (!cSSTextScanner.empty());
        throw new SAXException("Malformed rule set in <style> element");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<MediaType> parseMediaList(CSSTextScanner cSSTextScanner) throws SAXException {
        ArrayList<MediaType> arrayList = new ArrayList<MediaType>();
        do {
            if (cSSTextScanner.empty()) {
                return arrayList;
            }
            String string2 = cSSTextScanner.nextToken(',');
            try {
                arrayList.add(MediaType.valueOf(string2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new SAXException("Invalid @media type list");
            }
        } while (cSSTextScanner.skipCommaWhitespace());
        return arrayList;
    }

    private boolean parseRule(Ruleset ruleset, CSSTextScanner object) throws SAXException {
        List<Selector> list = this.parseSelectorGroup((CSSTextScanner)object);
        if (list != null && !list.isEmpty()) {
            if (((SVGParser.TextScanner)object).consume('{')) {
                ((SVGParser.TextScanner)object).skipWhitespace();
                SVG.Style style2 = this.parseDeclarations((CSSTextScanner)object);
                ((SVGParser.TextScanner)object).skipWhitespace();
                object = list.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        return true;
                    }
                    ruleset.add(new Rule((Selector)object.next(), style2));
                }
            }
            throw new SAXException("Malformed rule block in <style> element: missing '{'");
        }
        return false;
    }

    private Ruleset parseRuleset(CSSTextScanner cSSTextScanner) throws SAXException {
        Ruleset ruleset = new Ruleset();
        while (!cSSTextScanner.empty()) {
            if (cSSTextScanner.consume("<!--") || cSSTextScanner.consume("-->")) continue;
            if (cSSTextScanner.consume('@')) {
                this.parseAtRule(ruleset, cSSTextScanner);
                continue;
            }
            if (this.parseRule(ruleset, cSSTextScanner)) continue;
        }
        return ruleset;
    }

    private List<Selector> parseSelectorGroup(CSSTextScanner cSSTextScanner) throws SAXException {
        if (cSSTextScanner.empty()) {
            return null;
        }
        ArrayList<Selector> arrayList = new ArrayList<Selector>(1);
        Selector selector = new Selector();
        while (!cSSTextScanner.empty() && cSSTextScanner.nextSimpleSelector(selector)) {
            if (!cSSTextScanner.skipCommaWhitespace()) continue;
            arrayList.add(selector);
            selector = new Selector();
        }
        if (!selector.isEmpty()) {
            arrayList.add(selector);
        }
        return arrayList;
    }

    private static boolean ruleMatch(Selector selector, int n, List<SVG.SvgContainer> list, int n2, SVG.SvgElementBase svgElementBase) {
        SimpleSelector simpleSelector = selector.get(n);
        if (!CSSParser.selectorMatch(simpleSelector, list, n2, svgElementBase)) {
            return false;
        }
        if (simpleSelector.combinator == Combinator.DESCENDANT) {
            if (n == 0) {
                return true;
            }
            while (true) {
                if (n2 < 0) {
                    return false;
                }
                if (CSSParser.ruleMatchOnAncestors(selector, n - 1, list, n2)) {
                    return true;
                }
                --n2;
            }
        }
        if (simpleSelector.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(selector, n - 1, list, n2);
        }
        int n3 = CSSParser.getChildPosition(list, n2, svgElementBase);
        if (n3 <= 0) {
            return false;
        }
        return CSSParser.ruleMatch(selector, n - 1, list, n2, (SVG.SvgElementBase)svgElementBase.parent.getChildren().get(n3 - 1));
    }

    protected static boolean ruleMatch(Selector selector, SVG.SvgElementBase svgElementBase) {
        ArrayList<SVG.SvgContainer> arrayList = new ArrayList<SVG.SvgContainer>();
        SVG.SvgContainer svgContainer = svgElementBase.parent;
        while (true) {
            if (svgContainer == null) {
                int n = arrayList.size() - 1;
                if (selector.size() == 1) {
                    return CSSParser.selectorMatch(selector.get(0), arrayList, n, svgElementBase);
                }
                return CSSParser.ruleMatch(selector, selector.size() - 1, arrayList, n, svgElementBase);
            }
            arrayList.add(0, svgContainer);
            svgContainer = ((SVG.SvgObject)((Object)svgContainer)).parent;
        }
    }

    private static boolean ruleMatchOnAncestors(Selector selector, int n, List<SVG.SvgContainer> list, int n2) {
        SVG.SvgElementBase svgElementBase;
        SimpleSelector simpleSelector = selector.get(n);
        if (!CSSParser.selectorMatch(simpleSelector, list, n2, svgElementBase = (SVG.SvgElementBase)((Object)list.get(n2)))) {
            return false;
        }
        if (simpleSelector.combinator == Combinator.DESCENDANT) {
            int n3;
            if (n == 0) {
                return true;
            }
            do {
                if (n2 <= 0) {
                    return false;
                }
                n2 = n3 = n2 - 1;
            } while (!CSSParser.ruleMatchOnAncestors(selector, n - 1, list, n3));
            return true;
        }
        if (simpleSelector.combinator == Combinator.CHILD) {
            return CSSParser.ruleMatchOnAncestors(selector, n - 1, list, n2 - 1);
        }
        int n4 = CSSParser.getChildPosition(list, n2, svgElementBase);
        if (n4 <= 0) {
            return false;
        }
        return CSSParser.ruleMatch(selector, n - 1, list, n2, (SVG.SvgElementBase)svgElementBase.parent.getChildren().get(n4 - 1));
    }

    private static boolean selectorMatch(SimpleSelector object, List<SVG.SvgContainer> list, int n, SVG.SvgElementBase svgElementBase) {
        if (((SimpleSelector)object).tag != null && (((SimpleSelector)object).tag.equalsIgnoreCase("G") ? !(svgElementBase instanceof SVG.Group) : !((SimpleSelector)object).tag.equals(svgElementBase.getClass().getSimpleName().toLowerCase(Locale.US)))) {
            return false;
        }
        if (((SimpleSelector)object).attribs != null) {
            for (Attrib attrib : ((SimpleSelector)object).attribs) {
                if (attrib.name == ID) {
                    if (attrib.value.equals(svgElementBase.id)) continue;
                    return false;
                }
                if (attrib.name == CLASS) {
                    if (svgElementBase.classNames == null) {
                        return false;
                    }
                    if (svgElementBase.classNames.contains(attrib.value)) continue;
                }
                return false;
            }
        }
        if (((SimpleSelector)object).pseudos != null) {
            object = ((SimpleSelector)object).pseudos.iterator();
            while (object.hasNext()) {
                if (((String)object.next()).equals("first-child") && CSSParser.getChildPosition(list, n, svgElementBase) == 0) continue;
                return false;
            }
        }
        return true;
    }

    private void skipAtRule(CSSTextScanner cSSTextScanner) {
        int n = 0;
        while (true) {
            if (cSSTextScanner.empty()) {
                return;
            }
            int n2 = cSSTextScanner.nextChar();
            if (n2 == 59 && n == 0) {
                return;
            }
            if (n2 == 123) {
                ++n;
                continue;
            }
            if (n2 != 125 || n <= 0) continue;
            n = n2 = n - 1;
            if (n2 == 0) break;
        }
    }

    private static void warn(String string2, Object ... objectArray) {
        Log.w((String)TAG, (String)String.format(string2, objectArray));
    }

    public Ruleset parse(String object) throws SAXException {
        object = new CSSTextScanner((String)object);
        ((SVGParser.TextScanner)object).skipWhitespace();
        return this.parseRuleset((CSSTextScanner)object);
    }

    public static class Attrib {
        public String name = null;
        public AttribOp operation;
        public String value = null;

        public Attrib(String string2, AttribOp attribOp, String string3) {
            this.name = string2;
            this.operation = attribOp;
            this.value = string3;
        }
    }

    private static final class AttribOp
    extends Enum<AttribOp> {
        public static final /* enum */ AttribOp DASHMATCH;
        private static final /* synthetic */ AttribOp[] ENUM$VALUES;
        public static final /* enum */ AttribOp EQUALS;
        public static final /* enum */ AttribOp EXISTS;
        public static final /* enum */ AttribOp INCLUDES;

        static {
            AttribOp attribOp;
            AttribOp attribOp2;
            AttribOp attribOp3;
            AttribOp attribOp4;
            EXISTS = attribOp4 = new AttribOp();
            EQUALS = attribOp3 = new AttribOp();
            INCLUDES = attribOp2 = new AttribOp();
            DASHMATCH = attribOp = new AttribOp();
            ENUM$VALUES = new AttribOp[]{attribOp4, attribOp3, attribOp2, attribOp};
        }

        public static AttribOp valueOf(String string2) {
            return Enum.valueOf(AttribOp.class, string2);
        }

        public static AttribOp[] values() {
            AttribOp[] attribOpArray = ENUM$VALUES;
            int n = attribOpArray.length;
            AttribOp[] attribOpArray2 = new AttribOp[n];
            System.arraycopy(attribOpArray, 0, attribOpArray2, 0, n);
            return attribOpArray2;
        }
    }

    private static class CSSTextScanner
    extends SVGParser.TextScanner {
        public CSSTextScanner(String string2) {
            super(string2.replaceAll("(?s)/\\*.*?\\*/", ""));
        }

        private String nextAttribValue() {
            if (this.empty()) {
                return null;
            }
            String string2 = this.nextQuotedString();
            if (string2 != null) {
                return string2;
            }
            return this.nextIdentifier();
        }

        private int scanForIdentifier() {
            int n;
            if (this.empty()) {
                return this.position;
            }
            int n2 = this.position;
            int n3 = this.position;
            int n4 = n = this.input.charAt(this.position);
            if (n == 45) {
                n4 = this.advanceChar();
            }
            if (n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122 || n4 == 95) {
                n4 = this.advanceChar();
                while (true) {
                    if (!(n4 >= 65 && n4 <= 90 || n4 >= 97 && n4 <= 122 || n4 >= 48 && n4 <= 57 || n4 == 45 || n4 == 95)) {
                        n3 = this.position;
                        break;
                    }
                    n4 = this.advanceChar();
                }
            }
            this.position = n2;
            return n3;
        }

        public String nextIdentifier() {
            int n = this.scanForIdentifier();
            if (n == this.position) {
                return null;
            }
            String string2 = this.input.substring(this.position, n);
            this.position = n;
            return string2;
        }

        public String nextPropertyValue() {
            if (this.empty()) {
                return null;
            }
            int n = this.position;
            int n2 = this.position;
            int n3 = this.input.charAt(this.position);
            while (n3 != -1 && n3 != 59 && n3 != 125 && n3 != 33 && !this.isEOL(n3)) {
                if (!this.isWhitespace(n3)) {
                    n2 = this.position + 1;
                }
                n3 = this.advanceChar();
            }
            if (this.position > n) {
                return this.input.substring(n, n2);
            }
            this.position = n;
            return null;
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public boolean nextSimpleSelector(Selector var1_1) throws SAXException {
            if (this.empty()) {
                return false;
            }
            var2_2 = this.position;
            if (var1_1.isEmpty()) ** GOTO lbl-1000
            if (this.consume('>')) {
                var3_3 = Combinator.CHILD;
                this.skipWhitespace();
            } else if (this.consume('+')) {
                var3_3 = Combinator.FOLLOWS;
                this.skipWhitespace();
            } else lbl-1000:
            // 2 sources

            {
                var3_3 = null;
            }
            if (this.consume('*')) {
                var4_4 /* !! */  = new SimpleSelector(var3_3, null);
            } else {
                var4_4 /* !! */  = this.nextIdentifier();
                if (var4_4 /* !! */  != null) {
                    var4_4 /* !! */  = new SimpleSelector(var3_3, (String)var4_4 /* !! */ );
                    var1_1.addedElement();
                } else {
                    var4_4 /* !! */  = null;
                }
            }
            while (!this.empty()) {
                block26: {
                    block27: {
                        if (this.consume('.')) {
                            var5_5 = var4_4 /* !! */ ;
                            if (var4_4 /* !! */  == null) {
                                var5_5 = new SimpleSelector(var3_3, null);
                            }
                            if ((var4_4 /* !! */  = this.nextIdentifier()) != null) {
                                var5_5.addAttrib("class", AttribOp.EQUALS, (String)var4_4 /* !! */ );
                                var1_1.addedAttributeOrPseudo();
                                var4_4 /* !! */  = var5_5;
                                continue;
                            }
                            throw new SAXException("Invalid \".class\" selector in <style> element");
                        }
                        var5_5 = var4_4 /* !! */ ;
                        if (this.consume('#')) {
                            var5_5 = var4_4 /* !! */ ;
                            if (var4_4 /* !! */  == null) {
                                var5_5 = new SimpleSelector(var3_3, null);
                            }
                            if ((var4_4 /* !! */  = this.nextIdentifier()) != null) {
                                var5_5.addAttrib("id", AttribOp.EQUALS, (String)var4_4 /* !! */ );
                                var1_1.addedIdAttribute();
                            } else {
                                throw new SAXException("Invalid \"#id\" selector in <style> element");
                            }
                        }
                        if (var5_5 == null) {
                            var4_4 /* !! */  = var5_5;
                            break;
                        }
                        if (!this.consume('[')) break block26;
                        this.skipWhitespace();
                        var6_6 = this.nextIdentifier();
                        if (var6_6 == null) break block27;
                        this.skipWhitespace();
                        var4_4 /* !! */  = this.consume('=') != false ? AttribOp.EQUALS : (this.consume("~=") != false ? AttribOp.INCLUDES : (this.consume("|=") != false ? AttribOp.DASHMATCH : null));
                        if (var4_4 /* !! */  == null) ** GOTO lbl60
                        this.skipWhitespace();
                        var7_7 = this.nextAttribValue();
                        if (var7_7 != null) {
                            this.skipWhitespace();
                        } else {
                            throw new SAXException("Invalid attribute selector in <style> element");
lbl60:
                            // 1 sources

                            var7_7 = null;
                        }
                        if (this.consume(']')) {
                            var8_8 /* !! */  = var4_4 /* !! */ ;
                            if (var4_4 /* !! */  == null) {
                                var8_8 /* !! */  = AttribOp.EXISTS;
                            }
                            var5_5.addAttrib(var6_6, (AttribOp)var8_8 /* !! */ , var7_7);
                            var1_1.addedAttributeOrPseudo();
                            var4_4 /* !! */  = var5_5;
                            continue;
                        }
                        throw new SAXException("Invalid attribute selector in <style> element");
                    }
                    throw new SAXException("Invalid attribute selector in <style> element");
                }
                var4_4 /* !! */  = var5_5;
                if (!this.consume(':')) break;
                var9_9 = this.position;
                var4_4 /* !! */  = var5_5;
                if (this.nextIdentifier() == null) break;
                if (this.consume('(')) {
                    this.skipWhitespace();
                    if (this.nextIdentifier() != null) {
                        this.skipWhitespace();
                        if (!this.consume(')')) {
                            this.position = var9_9 - 1;
                            var4_4 /* !! */  = var5_5;
                            break;
                        }
                    }
                }
                var5_5.addPseudo(this.input.substring(var9_9, this.position));
                var1_1.addedAttributeOrPseudo();
                var4_4 /* !! */  = var5_5;
                break;
            }
            if (var4_4 /* !! */  != null) {
                var1_1.add((SimpleSelector)var4_4 /* !! */ );
                return true;
            }
            this.position = var2_2;
            return false;
        }
    }

    private static final class Combinator
    extends Enum<Combinator> {
        public static final /* enum */ Combinator CHILD;
        public static final /* enum */ Combinator DESCENDANT;
        private static final /* synthetic */ Combinator[] ENUM$VALUES;
        public static final /* enum */ Combinator FOLLOWS;

        static {
            Combinator combinator;
            Combinator combinator2;
            Combinator combinator3;
            DESCENDANT = combinator3 = new Combinator();
            CHILD = combinator2 = new Combinator();
            FOLLOWS = combinator = new Combinator();
            ENUM$VALUES = new Combinator[]{combinator3, combinator2, combinator};
        }

        public static Combinator valueOf(String string2) {
            return Enum.valueOf(Combinator.class, string2);
        }

        public static Combinator[] values() {
            Combinator[] combinatorArray = ENUM$VALUES;
            int n = combinatorArray.length;
            Combinator[] combinatorArray2 = new Combinator[n];
            System.arraycopy(combinatorArray, 0, combinatorArray2, 0, n);
            return combinatorArray2;
        }
    }

    public static final class MediaType
    extends Enum<MediaType> {
        private static final /* synthetic */ MediaType[] ENUM$VALUES;
        public static final /* enum */ MediaType all;
        public static final /* enum */ MediaType aural;
        public static final /* enum */ MediaType braille;
        public static final /* enum */ MediaType embossed;
        public static final /* enum */ MediaType handheld;
        public static final /* enum */ MediaType print;
        public static final /* enum */ MediaType projection;
        public static final /* enum */ MediaType screen;
        public static final /* enum */ MediaType tty;
        public static final /* enum */ MediaType tv;

        static {
            MediaType mediaType;
            MediaType mediaType2;
            MediaType mediaType3;
            MediaType mediaType4;
            MediaType mediaType5;
            MediaType mediaType6;
            MediaType mediaType7;
            MediaType mediaType8;
            MediaType mediaType9;
            MediaType mediaType10;
            all = mediaType10 = new MediaType();
            aural = mediaType9 = new MediaType();
            braille = mediaType8 = new MediaType();
            embossed = mediaType7 = new MediaType();
            handheld = mediaType6 = new MediaType();
            print = mediaType5 = new MediaType();
            projection = mediaType4 = new MediaType();
            screen = mediaType3 = new MediaType();
            tty = mediaType2 = new MediaType();
            tv = mediaType = new MediaType();
            ENUM$VALUES = new MediaType[]{mediaType10, mediaType9, mediaType8, mediaType7, mediaType6, mediaType5, mediaType4, mediaType3, mediaType2, mediaType};
        }

        public static MediaType valueOf(String string2) {
            return Enum.valueOf(MediaType.class, string2);
        }

        public static MediaType[] values() {
            MediaType[] mediaTypeArray = ENUM$VALUES;
            int n = mediaTypeArray.length;
            MediaType[] mediaTypeArray2 = new MediaType[n];
            System.arraycopy(mediaTypeArray, 0, mediaTypeArray2, 0, n);
            return mediaTypeArray2;
        }
    }

    public static class Rule {
        public Selector selector = null;
        public SVG.Style style = null;

        public Rule(Selector selector, SVG.Style style2) {
            this.selector = selector;
            this.style = style2;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.selector);
            stringBuilder.append(" {}");
            return stringBuilder.toString();
        }
    }

    public static class Ruleset {
        private List<Rule> rules = null;

        public void add(Rule rule) {
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>();
            }
            int n = 0;
            while (true) {
                if (n >= this.rules.size()) {
                    this.rules.add(rule);
                    return;
                }
                if (this.rules.get((int)n).selector.specificity > rule.selector.specificity) {
                    this.rules.add(n, rule);
                    return;
                }
                ++n;
            }
        }

        public void addAll(Ruleset object) {
            if (((Ruleset)object).rules == null) {
                return;
            }
            if (this.rules == null) {
                this.rules = new ArrayList<Rule>(((Ruleset)object).rules.size());
            }
            object = ((Ruleset)object).rules.iterator();
            while (object.hasNext()) {
                Rule rule = (Rule)object.next();
                this.rules.add(rule);
            }
            return;
        }

        public List<Rule> getRules() {
            return this.rules;
        }

        public boolean isEmpty() {
            List<Rule> list = this.rules;
            return list == null || list.isEmpty();
        }

        public String toString() {
            if (this.rules == null) {
                return "";
            }
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<Rule> iterator = this.rules.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
                stringBuilder.append('\n');
            }
            return stringBuilder.toString();
        }
    }

    public static class Selector {
        public List<SimpleSelector> selector = null;
        public int specificity = 0;

        public void add(SimpleSelector simpleSelector) {
            if (this.selector == null) {
                this.selector = new ArrayList<SimpleSelector>();
            }
            this.selector.add(simpleSelector);
        }

        public void addedAttributeOrPseudo() {
            this.specificity += 100;
        }

        public void addedElement() {
            ++this.specificity;
        }

        public void addedIdAttribute() {
            this.specificity += 10000;
        }

        public SimpleSelector get(int n) {
            return this.selector.get(n);
        }

        public boolean isEmpty() {
            List<SimpleSelector> list = this.selector;
            boolean bl = list == null ? true : list.isEmpty();
            return bl;
        }

        public int size() {
            List<SimpleSelector> list = this.selector;
            int n = list == null ? 0 : list.size();
            return n;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            Iterator<SimpleSelector> iterator = this.selector.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stringBuilder.append('(');
                    stringBuilder.append(this.specificity);
                    stringBuilder.append(')');
                    return stringBuilder.toString();
                }
                stringBuilder.append(iterator.next());
                stringBuilder.append(' ');
            }
        }
    }

    private static class SimpleSelector {
        private static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$CSSParser$AttribOp;
        public List<Attrib> attribs = null;
        public Combinator combinator = null;
        public List<String> pseudos = null;
        public String tag = null;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$CSSParser$AttribOp() {
            int[] nArray = $SWITCH_TABLE$com$caverock$androidsvg$CSSParser$AttribOp;
            if (nArray != null) {
                return nArray;
            }
            nArray = new int[AttribOp.values().length];
            try {
                nArray[AttribOp.DASHMATCH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AttribOp.EQUALS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AttribOp.EXISTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AttribOp.INCLUDES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $SWITCH_TABLE$com$caverock$androidsvg$CSSParser$AttribOp = nArray;
            return nArray;
        }

        public SimpleSelector(Combinator combinator, String string2) {
            if (combinator == null) {
                combinator = Combinator.DESCENDANT;
            }
            this.combinator = combinator;
            this.tag = string2;
        }

        public void addAttrib(String string2, AttribOp attribOp, String string3) {
            if (this.attribs == null) {
                this.attribs = new ArrayList<Attrib>();
            }
            this.attribs.add(new Attrib(string2, attribOp, string3));
        }

        public void addPseudo(String string2) {
            if (this.pseudos == null) {
                this.pseudos = new ArrayList<String>();
            }
            this.pseudos.add(string2);
        }

        public String toString() {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            if (this.combinator == Combinator.CHILD) {
                stringBuilder.append("> ");
            } else if (this.combinator == Combinator.FOLLOWS) {
                stringBuilder.append("+ ");
            }
            Object object2 = object = this.tag;
            if (object == null) {
                object2 = "*";
            }
            stringBuilder.append((String)object2);
            object2 = this.attribs;
            if (object2 != null) {
                object = object2.iterator();
                while (object.hasNext()) {
                    object2 = (Attrib)object.next();
                    stringBuilder.append('[');
                    stringBuilder.append(((Attrib)object2).name);
                    int n = SimpleSelector.$SWITCH_TABLE$com$caverock$androidsvg$CSSParser$AttribOp()[((Attrib)object2).operation.ordinal()];
                    if (n != 2) {
                        if (n != 3) {
                            if (n == 4) {
                                stringBuilder.append("|=");
                                stringBuilder.append(((Attrib)object2).value);
                            }
                        } else {
                            stringBuilder.append("~=");
                            stringBuilder.append(((Attrib)object2).value);
                        }
                    } else {
                        stringBuilder.append('=');
                        stringBuilder.append(((Attrib)object2).value);
                    }
                    stringBuilder.append(']');
                }
            }
            if ((object2 = this.pseudos) != null) {
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    stringBuilder.append(':');
                    stringBuilder.append((String)object);
                }
            }
            return stringBuilder.toString();
        }
    }
}

