/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Picture;
import android.graphics.RectF;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVGAndroidRenderer;
import com.caverock.androidsvg.SVGExternalFileResolver;
import com.caverock.androidsvg.SVGParseException;
import com.caverock.androidsvg.SVGParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xml.sax.SAXException;

public class SVG {
    private static final int DEFAULT_PICTURE_HEIGHT = 512;
    private static final int DEFAULT_PICTURE_WIDTH = 512;
    private static final List<SvgObject> EMPTY_CHILD_LIST = new ArrayList<SvgObject>(0);
    protected static final long SPECIFIED_ALL = -1L;
    protected static final long SPECIFIED_CLIP = 0x100000L;
    protected static final long SPECIFIED_CLIP_PATH = 0x10000000L;
    protected static final long SPECIFIED_CLIP_RULE = 0x20000000L;
    protected static final long SPECIFIED_COLOR = 4096L;
    protected static final long SPECIFIED_DIRECTION = 0x1000000000L;
    protected static final long SPECIFIED_DISPLAY = 0x1000000L;
    protected static final long SPECIFIED_FILL = 1L;
    protected static final long SPECIFIED_FILL_OPACITY = 4L;
    protected static final long SPECIFIED_FILL_RULE = 2L;
    protected static final long SPECIFIED_FONT_FAMILY = 8192L;
    protected static final long SPECIFIED_FONT_SIZE = 16384L;
    protected static final long SPECIFIED_FONT_STYLE = 65536L;
    protected static final long SPECIFIED_FONT_WEIGHT = 32768L;
    protected static final long SPECIFIED_MARKER_END = 0x800000L;
    protected static final long SPECIFIED_MARKER_MID = 0x400000L;
    protected static final long SPECIFIED_MARKER_START = 0x200000L;
    protected static final long SPECIFIED_MASK = 0x40000000L;
    protected static final long SPECIFIED_NON_INHERITING = 68133849088L;
    protected static final long SPECIFIED_OPACITY = 2048L;
    protected static final long SPECIFIED_OVERFLOW = 524288L;
    protected static final long SPECIFIED_SOLID_COLOR = 0x80000000L;
    protected static final long SPECIFIED_SOLID_OPACITY = 0x100000000L;
    protected static final long SPECIFIED_STOP_COLOR = 0x4000000L;
    protected static final long SPECIFIED_STOP_OPACITY = 0x8000000L;
    protected static final long SPECIFIED_STROKE = 8L;
    protected static final long SPECIFIED_STROKE_DASHARRAY = 512L;
    protected static final long SPECIFIED_STROKE_DASHOFFSET = 1024L;
    protected static final long SPECIFIED_STROKE_LINECAP = 64L;
    protected static final long SPECIFIED_STROKE_LINEJOIN = 128L;
    protected static final long SPECIFIED_STROKE_MITERLIMIT = 256L;
    protected static final long SPECIFIED_STROKE_OPACITY = 16L;
    protected static final long SPECIFIED_STROKE_WIDTH = 32L;
    protected static final long SPECIFIED_TEXT_ANCHOR = 262144L;
    protected static final long SPECIFIED_TEXT_DECORATION = 131072L;
    protected static final long SPECIFIED_VECTOR_EFFECT = 0x800000000L;
    protected static final long SPECIFIED_VIEWPORT_FILL = 0x200000000L;
    protected static final long SPECIFIED_VIEWPORT_FILL_OPACITY = 0x400000000L;
    protected static final long SPECIFIED_VISIBILITY = 0x2000000L;
    private static final double SQRT2 = 1.414213562373095;
    protected static final String SUPPORTED_SVG_VERSION = "1.2";
    private static final String TAG = "AndroidSVG";
    private static final String VERSION = "1.2.2-beta-1";
    private CSSParser.Ruleset cssRules = new CSSParser.Ruleset();
    private String desc = "";
    private SVGExternalFileResolver fileResolver = null;
    private float renderDPI = 96.0f;
    private Svg rootElement = null;
    private String title = "";

    protected SVG() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Box getDocumentDimensions(float f) {
        Length length = this.rootElement.width;
        Length length2 = this.rootElement.height;
        if (length == null || length.isZero() || length.unit == Unit.percent || length.unit == Unit.em || length.unit == Unit.ex) return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
        float f2 = length.floatValue(f);
        if (length2 != null) {
            if (length2.isZero() || length2.unit == Unit.percent || length2.unit == Unit.em || length2.unit == Unit.ex) return new Box(-1.0f, -1.0f, -1.0f, -1.0f);
            f = length2.floatValue(f);
            return new Box(0.0f, 0.0f, f2, f);
        } else {
            f = this.rootElement.viewBox != null ? this.rootElement.viewBox.height * f2 / this.rootElement.viewBox.width : f2;
        }
        return new Box(0.0f, 0.0f, f2, f);
    }

    private SvgElementBase getElementById(SvgContainer object, String string2) {
        SvgElementBase svgElementBase = (SvgElementBase)object;
        if (string2.equals(svgElementBase.id)) {
            return svgElementBase;
        }
        object = object.getChildren().iterator();
        while (true) {
            if (!object.hasNext()) {
                return null;
            }
            SvgObject svgObject = (SvgObject)object.next();
            if (!(svgObject instanceof SvgElementBase)) continue;
            svgElementBase = (SvgElementBase)svgObject;
            if (string2.equals(svgElementBase.id)) {
                return svgElementBase;
            }
            if (svgObject instanceof SvgContainer && (svgElementBase = this.getElementById((SvgContainer)((Object)svgObject), string2)) != null) break;
        }
        return svgElementBase;
    }

    private List<SvgObject> getElementsByTagName(SvgContainer object, Class clazz) {
        ArrayList<SvgObject> arrayList = new ArrayList<SvgObject>();
        if (object.getClass() == clazz) {
            arrayList.add((SvgObject)object);
        }
        object = object.getChildren().iterator();
        while (object.hasNext()) {
            SvgObject svgObject = (SvgObject)object.next();
            if (svgObject.getClass() == clazz) {
                arrayList.add(svgObject);
            }
            if (!(svgObject instanceof SvgContainer)) continue;
            this.getElementsByTagName((SvgContainer)((Object)svgObject), clazz);
        }
        return arrayList;
    }

    public static SVG getFromAsset(AssetManager object, String object2) throws SVGParseException, IOException {
        SVGParser sVGParser = new SVGParser();
        object = object.open((String)object2);
        object2 = sVGParser.parse((InputStream)object);
        ((InputStream)object).close();
        return object2;
    }

    public static SVG getFromInputStream(InputStream inputStream) throws SVGParseException {
        return new SVGParser().parse(inputStream);
    }

    public static SVG getFromResource(Context context, int n) throws SVGParseException {
        return SVG.getFromResource(context.getResources(), n);
    }

    public static SVG getFromResource(Resources resources, int n) throws SVGParseException {
        return new SVGParser().parse(resources.openRawResource(n));
    }

    public static SVG getFromString(String string2) throws SVGParseException {
        return new SVGParser().parse(new ByteArrayInputStream(string2.getBytes()));
    }

    public static String getVersion() {
        return VERSION;
    }

    protected void addCSSRules(CSSParser.Ruleset ruleset) {
        this.cssRules.addAll(ruleset);
    }

    protected List<CSSParser.Rule> getCSSRules() {
        return this.cssRules.getRules();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float getDocumentAspectRatio() {
        float f;
        float f2;
        Object object = this.rootElement;
        if (object == null) throw new IllegalArgumentException("SVG document is empty");
        object = ((Svg)object).width;
        Length length = this.rootElement.height;
        if (object != null && length != null && ((Length)object).unit != Unit.percent && length.unit != Unit.percent) {
            if (((Length)object).isZero() || length.isZero()) return -1.0f;
            f2 = ((Length)object).floatValue(this.renderDPI);
            f = length.floatValue(this.renderDPI);
            return f2 / f;
        }
        if (this.rootElement.viewBox == null || this.rootElement.viewBox.width == 0.0f || this.rootElement.viewBox.height == 0.0f) return -1.0f;
        f2 = this.rootElement.viewBox.width;
        f = this.rootElement.viewBox.height;
        return f2 / f;
    }

    public String getDocumentDescription() {
        if (this.rootElement != null) {
            return this.desc;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public float getDocumentHeight() {
        if (this.rootElement != null) {
            return this.getDocumentDimensions((float)this.renderDPI).height;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public PreserveAspectRatio getDocumentPreserveAspectRatio() {
        Svg svg = this.rootElement;
        if (svg != null) {
            if (svg.preserveAspectRatio == null) {
                return null;
            }
            return this.rootElement.preserveAspectRatio;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public String getDocumentSVGVersion() {
        Svg svg = this.rootElement;
        if (svg != null) {
            return svg.version;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public String getDocumentTitle() {
        if (this.rootElement != null) {
            return this.title;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public RectF getDocumentViewBox() {
        Svg svg = this.rootElement;
        if (svg != null) {
            if (svg.viewBox == null) {
                return null;
            }
            return this.rootElement.viewBox.toRectF();
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public float getDocumentWidth() {
        if (this.rootElement != null) {
            return this.getDocumentDimensions((float)this.renderDPI).width;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    protected SvgObject getElementById(String string2) {
        if (string2.equals(this.rootElement.id)) {
            return this.rootElement;
        }
        return this.getElementById(this.rootElement, string2);
    }

    protected List<SvgObject> getElementsByTagName(Class clazz) {
        return this.getElementsByTagName(this.rootElement, clazz);
    }

    protected SVGExternalFileResolver getFileResolver() {
        return this.fileResolver;
    }

    public float getRenderDPI() {
        return this.renderDPI;
    }

    protected Svg getRootElement() {
        return this.rootElement;
    }

    public Set<String> getViewList() {
        if (this.rootElement != null) {
            Object object = this.getElementsByTagName(View.class);
            HashSet<String> hashSet = new HashSet<String>(object.size());
            Iterator<SvgObject> iterator = object.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return hashSet;
                }
                object = (View)iterator.next();
                if (((View)object).id != null) {
                    hashSet.add(((View)object).id);
                    continue;
                }
                Log.w((String)TAG, (String)"getViewList(): found a <view> without an id attribute");
            }
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    protected boolean hasCSSRules() {
        return this.cssRules.isEmpty() ^ true;
    }

    public void registerExternalFileResolver(SVGExternalFileResolver sVGExternalFileResolver) {
        this.fileResolver = sVGExternalFileResolver;
    }

    public void renderToCanvas(Canvas canvas) {
        this.renderToCanvas(canvas, null);
    }

    public void renderToCanvas(Canvas canvas, RectF object) {
        object = object != null ? Box.fromLimits(object.left, object.top, object.right, object.bottom) : new Box(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        new SVGAndroidRenderer(canvas, (Box)object, this.renderDPI).renderDocument(this, null, null, true);
    }

    public Picture renderToPicture() {
        Cloneable cloneable = this.rootElement.width;
        if (cloneable != null) {
            float f = ((Length)cloneable).floatValue(this.renderDPI);
            cloneable = this.rootElement.viewBox;
            float f2 = cloneable != null ? ((Box)cloneable).height * f / ((Box)cloneable).width : ((cloneable = this.rootElement.height) != null ? ((Length)cloneable).floatValue(this.renderDPI) : f);
            return this.renderToPicture((int)Math.ceil(f), (int)Math.ceil(f2));
        }
        return this.renderToPicture(512, 512);
    }

    public Picture renderToPicture(int n, int n2) {
        Picture picture = new Picture();
        new SVGAndroidRenderer(picture.beginRecording(n, n2), new Box(0.0f, 0.0f, n, n2), this.renderDPI).renderDocument(this, null, null, false);
        picture.endRecording();
        return picture;
    }

    public void renderViewToCanvas(String string2, Canvas canvas) {
        this.renderViewToCanvas(string2, canvas, null);
    }

    public void renderViewToCanvas(String object, Canvas canvas, RectF rectF) {
        if ((object = this.getElementById((String)object)) == null) {
            return;
        }
        if (!(object instanceof View)) {
            return;
        }
        View view = (View)object;
        if (view.viewBox == null) {
            Log.w((String)TAG, (String)"View element is missing a viewBox attribute.");
            return;
        }
        object = rectF != null ? Box.fromLimits(rectF.left, rectF.top, rectF.right, rectF.bottom) : new Box(0.0f, 0.0f, canvas.getWidth(), canvas.getHeight());
        new SVGAndroidRenderer(canvas, (Box)object, this.renderDPI).renderDocument(this, view.viewBox, view.preserveAspectRatio, true);
    }

    public Picture renderViewToPicture(String object, int n, int n2) {
        if ((object = this.getElementById((String)object)) == null) {
            return null;
        }
        if (!(object instanceof View)) {
            return null;
        }
        object = (View)object;
        if (((View)object).viewBox == null) {
            Log.w((String)TAG, (String)"View element is missing a viewBox attribute.");
            return null;
        }
        Picture picture = new Picture();
        new SVGAndroidRenderer(picture.beginRecording(n, n2), new Box(0.0f, 0.0f, n, n2), this.renderDPI).renderDocument(this, ((View)object).viewBox, ((View)object).preserveAspectRatio, false);
        picture.endRecording();
        return picture;
    }

    protected SvgObject resolveIRI(String string2) {
        if (string2 == null) {
            return null;
        }
        if (string2.length() > 1 && string2.startsWith("#")) {
            return this.getElementById(string2.substring(1));
        }
        return null;
    }

    protected void setDesc(String string2) {
        this.desc = string2;
    }

    public void setDocumentHeight(float f) {
        Svg svg = this.rootElement;
        if (svg != null) {
            svg.height = new Length(f);
            return;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setDocumentHeight(String string2) throws SVGParseException {
        Svg svg = this.rootElement;
        if (svg != null) {
            try {
                svg.height = SVGParser.parseLength(string2);
                return;
            }
            catch (SAXException sAXException) {
                throw new SVGParseException(sAXException.getMessage());
            }
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setDocumentPreserveAspectRatio(PreserveAspectRatio preserveAspectRatio) {
        Svg svg = this.rootElement;
        if (svg != null) {
            svg.preserveAspectRatio = preserveAspectRatio;
            return;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setDocumentViewBox(float f, float f2, float f3, float f4) {
        Svg svg = this.rootElement;
        if (svg != null) {
            svg.viewBox = new Box(f, f2, f3, f4);
            return;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setDocumentWidth(float f) {
        Svg svg = this.rootElement;
        if (svg != null) {
            svg.width = new Length(f);
            return;
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setDocumentWidth(String string2) throws SVGParseException {
        Svg svg = this.rootElement;
        if (svg != null) {
            try {
                svg.width = SVGParser.parseLength(string2);
                return;
            }
            catch (SAXException sAXException) {
                throw new SVGParseException(sAXException.getMessage());
            }
        }
        throw new IllegalArgumentException("SVG document is empty");
    }

    public void setRenderDPI(float f) {
        this.renderDPI = f;
    }

    protected void setRootElement(Svg svg) {
        this.rootElement = svg;
    }

    protected void setTitle(String string2) {
        this.title = string2;
    }

    protected static class Box
    implements Cloneable {
        public float height;
        public float minX;
        public float minY;
        public float width;

        public Box(float f, float f2, float f3, float f4) {
            this.minX = f;
            this.minY = f2;
            this.width = f3;
            this.height = f4;
        }

        public static Box fromLimits(float f, float f2, float f3, float f4) {
            return new Box(f, f2, f3 - f, f4 - f2);
        }

        public float maxX() {
            return this.minX + this.width;
        }

        public float maxY() {
            return this.minY + this.height;
        }

        public RectF toRectF() {
            return new RectF(this.minX, this.minY, this.maxX(), this.maxY());
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("[");
            stringBuilder.append(this.minX);
            stringBuilder.append(" ");
            stringBuilder.append(this.minY);
            stringBuilder.append(" ");
            stringBuilder.append(this.width);
            stringBuilder.append(" ");
            stringBuilder.append(this.height);
            stringBuilder.append("]");
            return stringBuilder.toString();
        }

        public void union(Box box) {
            float f = box.minX;
            if (f < this.minX) {
                this.minX = f;
            }
            if ((f = box.minY) < this.minY) {
                this.minY = f;
            }
            if (box.maxX() > this.maxX()) {
                this.width = box.maxX() - this.minX;
            }
            if (box.maxY() > this.maxY()) {
                this.height = box.maxY() - this.minY;
            }
        }
    }

    protected static class CSSClipRect {
        public Length bottom;
        public Length left;
        public Length right;
        public Length top;

        public CSSClipRect(Length length, Length length2, Length length3, Length length4) {
            this.top = length;
            this.right = length2;
            this.bottom = length3;
            this.left = length4;
        }
    }

    protected static class Circle
    extends GraphicsElement {
        public Length cx;
        public Length cy;
        public Length r;

        protected Circle() {
        }
    }

    protected static class ClipPath
    extends Group
    implements NotDirectlyRendered {
        public Boolean clipPathUnitsAreUser;

        protected ClipPath() {
        }
    }

    protected static class Colour
    extends SvgPaint {
        public static final Colour BLACK = new Colour(0);
        public int colour;

        public Colour(int n) {
            this.colour = n;
        }

        public String toString() {
            return String.format("#%06x", this.colour);
        }
    }

    protected static class CurrentColor
    extends SvgPaint {
        private static CurrentColor instance = new CurrentColor();

        private CurrentColor() {
        }

        public static CurrentColor getInstance() {
            return instance;
        }
    }

    protected static class Defs
    extends Group
    implements NotDirectlyRendered {
        protected Defs() {
        }
    }

    protected static class Ellipse
    extends GraphicsElement {
        public Length cx;
        public Length cy;
        public Length rx;
        public Length ry;

        protected Ellipse() {
        }
    }

    protected static class GradientElement
    extends SvgElementBase
    implements SvgContainer {
        public List<SvgObject> children = new ArrayList<SvgObject>();
        public Matrix gradientTransform;
        public Boolean gradientUnitsAreUser;
        public String href;
        public GradientSpread spreadMethod;

        protected GradientElement() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SAXException {
            if (svgObject instanceof Stop) {
                this.children.add(svgObject);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("Gradient elements cannot contain ");
            stringBuilder.append(svgObject);
            stringBuilder.append(" elements.");
            throw new SAXException(stringBuilder.toString());
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }
    }

    protected static final class GradientSpread
    extends Enum<GradientSpread> {
        private static final /* synthetic */ GradientSpread[] ENUM$VALUES;
        public static final /* enum */ GradientSpread pad;
        public static final /* enum */ GradientSpread reflect;
        public static final /* enum */ GradientSpread repeat;

        static {
            GradientSpread gradientSpread;
            GradientSpread gradientSpread2;
            GradientSpread gradientSpread3;
            pad = gradientSpread3 = new GradientSpread();
            reflect = gradientSpread2 = new GradientSpread();
            repeat = gradientSpread = new GradientSpread();
            ENUM$VALUES = new GradientSpread[]{gradientSpread3, gradientSpread2, gradientSpread};
        }

        public static GradientSpread valueOf(String string2) {
            return Enum.valueOf(GradientSpread.class, string2);
        }

        public static GradientSpread[] values() {
            GradientSpread[] gradientSpreadArray = ENUM$VALUES;
            int n = gradientSpreadArray.length;
            GradientSpread[] gradientSpreadArray2 = new GradientSpread[n];
            System.arraycopy(gradientSpreadArray, 0, gradientSpreadArray2, 0, n);
            return gradientSpreadArray2;
        }
    }

    protected static abstract class GraphicsElement
    extends SvgConditionalElement
    implements HasTransform {
        public Matrix transform;

        protected GraphicsElement() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }
    }

    protected static class Group
    extends SvgConditionalContainer
    implements HasTransform {
        public Matrix transform;

        protected Group() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }
    }

    protected static interface HasTransform {
        public void setTransform(Matrix var1);
    }

    protected static class Image
    extends SvgPreserveAspectRatioContainer
    implements HasTransform {
        public Length height;
        public String href;
        public Matrix transform;
        public Length width;
        public Length x;
        public Length y;

        protected Image() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }
    }

    protected static class Length
    implements Cloneable {
        Unit unit = Unit.px;
        float value = 0.0f;

        public Length(float f) {
            this.value = f;
            this.unit = Unit.px;
        }

        public Length(float f, Unit unit) {
            this.value = f;
            this.unit = unit;
        }

        public float floatValue() {
            return this.value;
        }

        public float floatValue(float f) {
            int n = Length.$SWITCH_TABLE$com$caverock$androidsvg$SVG$Unit()[this.unit.ordinal()];
            if (n != 1) {
                switch (n) {
                    default: {
                        return this.value;
                    }
                    case 8: {
                        return this.value * f / 6.0f;
                    }
                    case 7: {
                        return this.value * f / 72.0f;
                    }
                    case 6: {
                        return this.value * f / 25.4f;
                    }
                    case 5: {
                        return this.value * f / 2.54f;
                    }
                    case 4: 
                }
                return this.value * f;
            }
            return this.value;
        }

        public float floatValue(SVGAndroidRenderer object) {
            if (this.unit == Unit.percent) {
                if ((object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits()) == null) {
                    return this.value;
                }
                float f = ((Box)object).width;
                float f2 = ((Box)object).height;
                if (f == f2) {
                    return this.value * f / 100.0f;
                }
                f = (float)(Math.sqrt(f * f + f2 * f2) / 1.414213562373095);
                return this.value * f / 100.0f;
            }
            return this.floatValueX((SVGAndroidRenderer)object);
        }

        public float floatValue(SVGAndroidRenderer sVGAndroidRenderer, float f) {
            if (this.unit == Unit.percent) {
                return this.value * f / 100.0f;
            }
            return this.floatValueX(sVGAndroidRenderer);
        }

        public float floatValueX(SVGAndroidRenderer object) {
            switch (this.unit) {
                default: {
                    return this.value;
                }
                case percent: {
                    object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits();
                    if (object == null) {
                        return this.value;
                    }
                    return this.value * ((Box)object).width / 100.0f;
                }
                case pc: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 6.0f;
                }
                case pt: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 72.0f;
                }
                case mm: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 25.4f;
                }
                case cm: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI() / 2.54f;
                }
                case in: {
                    return this.value * ((SVGAndroidRenderer)object).getDPI();
                }
                case ex: {
                    return this.value * ((SVGAndroidRenderer)object).getCurrentFontXHeight();
                }
                case em: {
                    return this.value * ((SVGAndroidRenderer)object).getCurrentFontSize();
                }
                case px: 
            }
            return this.value;
        }

        public float floatValueY(SVGAndroidRenderer object) {
            if (this.unit == Unit.percent) {
                if ((object = ((SVGAndroidRenderer)object).getCurrentViewPortInUserUnits()) == null) {
                    return this.value;
                }
                return this.value * ((Box)object).height / 100.0f;
            }
            return this.floatValueX((SVGAndroidRenderer)object);
        }

        public boolean isNegative() {
            return this.value < 0.0f;
        }

        public boolean isZero() {
            return this.value == 0.0f;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(String.valueOf(this.value)));
            stringBuilder.append((Object)this.unit);
            return stringBuilder.toString();
        }
    }

    protected static class Line
    extends GraphicsElement {
        public Length x1;
        public Length x2;
        public Length y1;
        public Length y2;

        protected Line() {
        }
    }

    protected static class Marker
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        public Length markerHeight;
        public boolean markerUnitsAreUser;
        public Length markerWidth;
        public Float orient;
        public Length refX;
        public Length refY;

        protected Marker() {
        }
    }

    protected static class Mask
    extends SvgConditionalContainer
    implements NotDirectlyRendered {
        public Length height;
        public Boolean maskContentUnitsAreUser;
        public Boolean maskUnitsAreUser;
        public Length width;
        public Length x;
        public Length y;

        protected Mask() {
        }
    }

    protected static interface NotDirectlyRendered {
    }

    protected static class PaintReference
    extends SvgPaint {
        public SvgPaint fallback;
        public String href;

        public PaintReference(String string2, SvgPaint svgPaint) {
            this.href = string2;
            this.fallback = svgPaint;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.href));
            stringBuilder.append(" ");
            stringBuilder.append(this.fallback);
            return stringBuilder.toString();
        }
    }

    protected static class Path
    extends GraphicsElement {
        public PathDefinition d;
        public Float pathLength;

        protected Path() {
        }
    }

    protected static class PathDefinition
    implements PathInterface {
        private static final byte ARCTO = 4;
        private static final byte CLOSE = 8;
        private static final byte CUBICTO = 2;
        private static final byte LINETO = 1;
        private static final byte MOVETO = 0;
        private static final byte QUADTO = 3;
        private List<Byte> commands = new ArrayList<Byte>();
        private List<Float> coords = new ArrayList<Float>();

        @Override
        public void arcTo(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
            int n = bl ? 2 : 0;
            this.commands.add((byte)(n | 4 | bl2));
            this.coords.add(Float.valueOf(f));
            this.coords.add(Float.valueOf(f2));
            this.coords.add(Float.valueOf(f3));
            this.coords.add(Float.valueOf(f4));
            this.coords.add(Float.valueOf(f5));
        }

        @Override
        public void close() {
            this.commands.add((byte)8);
        }

        @Override
        public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.commands.add((byte)2);
            this.coords.add(Float.valueOf(f));
            this.coords.add(Float.valueOf(f2));
            this.coords.add(Float.valueOf(f3));
            this.coords.add(Float.valueOf(f4));
            this.coords.add(Float.valueOf(f5));
            this.coords.add(Float.valueOf(f6));
        }

        public void enumeratePath(PathInterface pathInterface) {
            Iterator<Float> iterator = this.coords.iterator();
            Iterator<Byte> iterator2 = this.commands.iterator();
            while (iterator2.hasNext()) {
                byte by = iterator2.next();
                if (by != 0) {
                    if (by != 1) {
                        if (by != 2) {
                            if (by != 3) {
                                if (by != 8) {
                                    boolean bl = (by & 2) != 0;
                                    boolean bl2 = (by & 1) != 0;
                                    pathInterface.arcTo(iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue(), bl, bl2, iterator.next().floatValue(), iterator.next().floatValue());
                                    continue;
                                }
                                pathInterface.close();
                                continue;
                            }
                            pathInterface.quadTo(iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue());
                            continue;
                        }
                        pathInterface.cubicTo(iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue(), iterator.next().floatValue());
                        continue;
                    }
                    pathInterface.lineTo(iterator.next().floatValue(), iterator.next().floatValue());
                    continue;
                }
                pathInterface.moveTo(iterator.next().floatValue(), iterator.next().floatValue());
            }
            return;
        }

        public boolean isEmpty() {
            return this.commands.isEmpty();
        }

        @Override
        public void lineTo(float f, float f2) {
            this.commands.add((byte)1);
            this.coords.add(Float.valueOf(f));
            this.coords.add(Float.valueOf(f2));
        }

        @Override
        public void moveTo(float f, float f2) {
            this.commands.add((byte)0);
            this.coords.add(Float.valueOf(f));
            this.coords.add(Float.valueOf(f2));
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.commands.add((byte)3);
            this.coords.add(Float.valueOf(f));
            this.coords.add(Float.valueOf(f2));
            this.coords.add(Float.valueOf(f3));
            this.coords.add(Float.valueOf(f4));
        }
    }

    protected static interface PathInterface {
        public void arcTo(float var1, float var2, float var3, boolean var4, boolean var5, float var6, float var7);

        public void close();

        public void cubicTo(float var1, float var2, float var3, float var4, float var5, float var6);

        public void lineTo(float var1, float var2);

        public void moveTo(float var1, float var2);

        public void quadTo(float var1, float var2, float var3, float var4);
    }

    protected static class Pattern
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        public Length height;
        public String href;
        public Boolean patternContentUnitsAreUser;
        public Matrix patternTransform;
        public Boolean patternUnitsAreUser;
        public Length width;
        public Length x;
        public Length y;

        protected Pattern() {
        }
    }

    protected static class PolyLine
    extends GraphicsElement {
        public float[] points;

        protected PolyLine() {
        }
    }

    protected static class Polygon
    extends PolyLine {
        protected Polygon() {
        }
    }

    protected static class Rect
    extends GraphicsElement {
        public Length height;
        public Length rx;
        public Length ry;
        public Length width;
        public Length x;
        public Length y;

        protected Rect() {
        }
    }

    protected static class SolidColor
    extends SvgElementBase
    implements SvgContainer {
        public Length solidColor;
        public Length solidOpacity;

        protected SolidColor() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SAXException {
        }

        @Override
        public List<SvgObject> getChildren() {
            return EMPTY_CHILD_LIST;
        }
    }

    protected static class Stop
    extends SvgElementBase
    implements SvgContainer {
        public Float offset;

        protected Stop() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SAXException {
        }

        @Override
        public List<SvgObject> getChildren() {
            return EMPTY_CHILD_LIST;
        }
    }

    protected static class Style
    implements Cloneable {
        public static final int FONT_WEIGHT_BOLD = 700;
        public static final int FONT_WEIGHT_BOLDER = 1;
        public static final int FONT_WEIGHT_LIGHTER = -1;
        public static final int FONT_WEIGHT_NORMAL = 400;
        public CSSClipRect clip;
        public String clipPath;
        public FillRule clipRule;
        public Colour color;
        public TextDirection direction;
        public Boolean display;
        public SvgPaint fill;
        public Float fillOpacity;
        public FillRule fillRule;
        public List<String> fontFamily;
        public Length fontSize;
        public FontStyle fontStyle;
        public Integer fontWeight;
        public String markerEnd;
        public String markerMid;
        public String markerStart;
        public String mask;
        public Float opacity;
        public Boolean overflow;
        public SvgPaint solidColor;
        public Float solidOpacity;
        public long specifiedFlags = 0L;
        public SvgPaint stopColor;
        public Float stopOpacity;
        public SvgPaint stroke;
        public Length[] strokeDashArray;
        public Length strokeDashOffset;
        public LineCaps strokeLineCap;
        public LineJoin strokeLineJoin;
        public Float strokeMiterLimit;
        public Float strokeOpacity;
        public Length strokeWidth;
        public TextAnchor textAnchor;
        public TextDecoration textDecoration;
        public VectorEffect vectorEffect;
        public SvgPaint viewportFill;
        public Float viewportFillOpacity;
        public Boolean visibility;

        protected Style() {
        }

        public static Style getDefaultStyle() {
            Float f;
            Style style2 = new Style();
            style2.specifiedFlags = -1L;
            style2.fill = Colour.BLACK;
            style2.fillRule = FillRule.NonZero;
            style2.fillOpacity = f = Float.valueOf(1.0f);
            style2.stroke = null;
            style2.strokeOpacity = f;
            style2.strokeWidth = new Length(1.0f);
            style2.strokeLineCap = LineCaps.Butt;
            style2.strokeLineJoin = LineJoin.Miter;
            style2.strokeMiterLimit = Float.valueOf(4.0f);
            style2.strokeDashArray = null;
            style2.strokeDashOffset = new Length(0.0f);
            style2.opacity = f;
            style2.color = Colour.BLACK;
            style2.fontFamily = null;
            style2.fontSize = new Length(12.0f, Unit.pt);
            style2.fontWeight = 400;
            style2.fontStyle = FontStyle.Normal;
            style2.textDecoration = TextDecoration.None;
            style2.direction = TextDirection.LTR;
            style2.textAnchor = TextAnchor.Start;
            style2.overflow = true;
            style2.clip = null;
            style2.markerStart = null;
            style2.markerMid = null;
            style2.markerEnd = null;
            style2.display = Boolean.TRUE;
            style2.visibility = Boolean.TRUE;
            style2.stopColor = Colour.BLACK;
            style2.stopOpacity = f;
            style2.clipPath = null;
            style2.clipRule = FillRule.NonZero;
            style2.mask = null;
            style2.solidColor = null;
            style2.solidOpacity = f;
            style2.viewportFill = null;
            style2.viewportFillOpacity = f;
            style2.vectorEffect = VectorEffect.None;
            return style2;
        }

        protected Object clone() {
            Style style2;
            block3: {
                Length[] lengthArray;
                try {
                    style2 = (Style)super.clone();
                    lengthArray = this.strokeDashArray;
                    if (lengthArray == null) break block3;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new InternalError(cloneNotSupportedException.toString());
                }
                style2.strokeDashArray = (Length[])lengthArray.clone();
            }
            return style2;
        }

        public void resetNonInheritingProperties() {
            this.resetNonInheritingProperties(false);
        }

        public void resetNonInheritingProperties(boolean bl) {
            this.display = Boolean.TRUE;
            Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
            this.overflow = bl2;
            this.clip = null;
            this.clipPath = null;
            this.opacity = Float.valueOf(1.0f);
            this.stopColor = Colour.BLACK;
            this.stopOpacity = Float.valueOf(1.0f);
            this.mask = null;
            this.solidColor = null;
            this.solidOpacity = Float.valueOf(1.0f);
            this.viewportFill = null;
            this.viewportFillOpacity = Float.valueOf(1.0f);
            this.vectorEffect = VectorEffect.None;
        }

        public static final class FillRule
        extends Enum<FillRule> {
            private static final /* synthetic */ FillRule[] ENUM$VALUES;
            public static final /* enum */ FillRule EvenOdd;
            public static final /* enum */ FillRule NonZero;

            static {
                FillRule fillRule;
                FillRule fillRule2;
                NonZero = fillRule2 = new FillRule();
                EvenOdd = fillRule = new FillRule();
                ENUM$VALUES = new FillRule[]{fillRule2, fillRule};
            }

            public static FillRule valueOf(String string2) {
                return Enum.valueOf(FillRule.class, string2);
            }

            public static FillRule[] values() {
                FillRule[] fillRuleArray = ENUM$VALUES;
                int n = fillRuleArray.length;
                FillRule[] fillRuleArray2 = new FillRule[n];
                System.arraycopy(fillRuleArray, 0, fillRuleArray2, 0, n);
                return fillRuleArray2;
            }
        }

        public static final class FontStyle
        extends Enum<FontStyle> {
            private static final /* synthetic */ FontStyle[] ENUM$VALUES;
            public static final /* enum */ FontStyle Italic;
            public static final /* enum */ FontStyle Normal;
            public static final /* enum */ FontStyle Oblique;

            static {
                FontStyle fontStyle;
                FontStyle fontStyle2;
                FontStyle fontStyle3;
                Normal = fontStyle3 = new FontStyle();
                Italic = fontStyle2 = new FontStyle();
                Oblique = fontStyle = new FontStyle();
                ENUM$VALUES = new FontStyle[]{fontStyle3, fontStyle2, fontStyle};
            }

            public static FontStyle valueOf(String string2) {
                return Enum.valueOf(FontStyle.class, string2);
            }

            public static FontStyle[] values() {
                FontStyle[] fontStyleArray = ENUM$VALUES;
                int n = fontStyleArray.length;
                FontStyle[] fontStyleArray2 = new FontStyle[n];
                System.arraycopy(fontStyleArray, 0, fontStyleArray2, 0, n);
                return fontStyleArray2;
            }
        }

        public static final class LineCaps
        extends Enum<LineCaps> {
            public static final /* enum */ LineCaps Butt;
            private static final /* synthetic */ LineCaps[] ENUM$VALUES;
            public static final /* enum */ LineCaps Round;
            public static final /* enum */ LineCaps Square;

            static {
                LineCaps lineCaps;
                LineCaps lineCaps2;
                LineCaps lineCaps3;
                Butt = lineCaps3 = new LineCaps();
                Round = lineCaps2 = new LineCaps();
                Square = lineCaps = new LineCaps();
                ENUM$VALUES = new LineCaps[]{lineCaps3, lineCaps2, lineCaps};
            }

            public static LineCaps valueOf(String string2) {
                return Enum.valueOf(LineCaps.class, string2);
            }

            public static LineCaps[] values() {
                LineCaps[] lineCapsArray = ENUM$VALUES;
                int n = lineCapsArray.length;
                LineCaps[] lineCapsArray2 = new LineCaps[n];
                System.arraycopy(lineCapsArray, 0, lineCapsArray2, 0, n);
                return lineCapsArray2;
            }
        }

        public static final class LineJoin
        extends Enum<LineJoin> {
            public static final /* enum */ LineJoin Bevel;
            private static final /* synthetic */ LineJoin[] ENUM$VALUES;
            public static final /* enum */ LineJoin Miter;
            public static final /* enum */ LineJoin Round;

            static {
                LineJoin lineJoin;
                LineJoin lineJoin2;
                LineJoin lineJoin3;
                Miter = lineJoin3 = new LineJoin();
                Round = lineJoin2 = new LineJoin();
                Bevel = lineJoin = new LineJoin();
                ENUM$VALUES = new LineJoin[]{lineJoin3, lineJoin2, lineJoin};
            }

            public static LineJoin valueOf(String string2) {
                return Enum.valueOf(LineJoin.class, string2);
            }

            public static LineJoin[] values() {
                LineJoin[] lineJoinArray = ENUM$VALUES;
                int n = lineJoinArray.length;
                LineJoin[] lineJoinArray2 = new LineJoin[n];
                System.arraycopy(lineJoinArray, 0, lineJoinArray2, 0, n);
                return lineJoinArray2;
            }
        }

        public static final class TextAnchor
        extends Enum<TextAnchor> {
            private static final /* synthetic */ TextAnchor[] ENUM$VALUES;
            public static final /* enum */ TextAnchor End;
            public static final /* enum */ TextAnchor Middle;
            public static final /* enum */ TextAnchor Start;

            static {
                TextAnchor textAnchor;
                TextAnchor textAnchor2;
                TextAnchor textAnchor3;
                Start = textAnchor3 = new TextAnchor();
                Middle = textAnchor2 = new TextAnchor();
                End = textAnchor = new TextAnchor();
                ENUM$VALUES = new TextAnchor[]{textAnchor3, textAnchor2, textAnchor};
            }

            public static TextAnchor valueOf(String string2) {
                return Enum.valueOf(TextAnchor.class, string2);
            }

            public static TextAnchor[] values() {
                TextAnchor[] textAnchorArray = ENUM$VALUES;
                int n = textAnchorArray.length;
                TextAnchor[] textAnchorArray2 = new TextAnchor[n];
                System.arraycopy(textAnchorArray, 0, textAnchorArray2, 0, n);
                return textAnchorArray2;
            }
        }

        public static final class TextDecoration
        extends Enum<TextDecoration> {
            public static final /* enum */ TextDecoration Blink;
            private static final /* synthetic */ TextDecoration[] ENUM$VALUES;
            public static final /* enum */ TextDecoration LineThrough;
            public static final /* enum */ TextDecoration None;
            public static final /* enum */ TextDecoration Overline;
            public static final /* enum */ TextDecoration Underline;

            static {
                TextDecoration textDecoration;
                TextDecoration textDecoration2;
                TextDecoration textDecoration3;
                TextDecoration textDecoration4;
                TextDecoration textDecoration5;
                None = textDecoration5 = new TextDecoration();
                Underline = textDecoration4 = new TextDecoration();
                Overline = textDecoration3 = new TextDecoration();
                LineThrough = textDecoration2 = new TextDecoration();
                Blink = textDecoration = new TextDecoration();
                ENUM$VALUES = new TextDecoration[]{textDecoration5, textDecoration4, textDecoration3, textDecoration2, textDecoration};
            }

            public static TextDecoration valueOf(String string2) {
                return Enum.valueOf(TextDecoration.class, string2);
            }

            public static TextDecoration[] values() {
                TextDecoration[] textDecorationArray = ENUM$VALUES;
                int n = textDecorationArray.length;
                TextDecoration[] textDecorationArray2 = new TextDecoration[n];
                System.arraycopy(textDecorationArray, 0, textDecorationArray2, 0, n);
                return textDecorationArray2;
            }
        }

        public static final class TextDirection
        extends Enum<TextDirection> {
            private static final /* synthetic */ TextDirection[] ENUM$VALUES;
            public static final /* enum */ TextDirection LTR;
            public static final /* enum */ TextDirection RTL;

            static {
                TextDirection textDirection;
                TextDirection textDirection2;
                LTR = textDirection2 = new TextDirection();
                RTL = textDirection = new TextDirection();
                ENUM$VALUES = new TextDirection[]{textDirection2, textDirection};
            }

            public static TextDirection valueOf(String string2) {
                return Enum.valueOf(TextDirection.class, string2);
            }

            public static TextDirection[] values() {
                TextDirection[] textDirectionArray = ENUM$VALUES;
                int n = textDirectionArray.length;
                TextDirection[] textDirectionArray2 = new TextDirection[n];
                System.arraycopy(textDirectionArray, 0, textDirectionArray2, 0, n);
                return textDirectionArray2;
            }
        }

        public static final class VectorEffect
        extends Enum<VectorEffect> {
            private static final /* synthetic */ VectorEffect[] ENUM$VALUES;
            public static final /* enum */ VectorEffect NonScalingStroke;
            public static final /* enum */ VectorEffect None;

            static {
                VectorEffect vectorEffect;
                VectorEffect vectorEffect2;
                None = vectorEffect2 = new VectorEffect();
                NonScalingStroke = vectorEffect = new VectorEffect();
                ENUM$VALUES = new VectorEffect[]{vectorEffect2, vectorEffect};
            }

            public static VectorEffect valueOf(String string2) {
                return Enum.valueOf(VectorEffect.class, string2);
            }

            public static VectorEffect[] values() {
                VectorEffect[] vectorEffectArray = ENUM$VALUES;
                int n = vectorEffectArray.length;
                VectorEffect[] vectorEffectArray2 = new VectorEffect[n];
                System.arraycopy(vectorEffectArray, 0, vectorEffectArray2, 0, n);
                return vectorEffectArray2;
            }
        }
    }

    protected static class Svg
    extends SvgViewBoxContainer {
        public Length height;
        public String version;
        public Length width;
        public Length x;
        public Length y;

        protected Svg() {
        }
    }

    protected static interface SvgConditional {
        public String getRequiredExtensions();

        public Set<String> getRequiredFeatures();

        public Set<String> getRequiredFonts();

        public Set<String> getRequiredFormats();

        public Set<String> getSystemLanguage();

        public void setRequiredExtensions(String var1);

        public void setRequiredFeatures(Set<String> var1);

        public void setRequiredFonts(Set<String> var1);

        public void setRequiredFormats(Set<String> var1);

        public void setSystemLanguage(Set<String> var1);
    }

    protected static class SvgConditionalContainer
    extends SvgElement
    implements SvgContainer,
    SvgConditional {
        public List<SvgObject> children = new ArrayList<SvgObject>();
        public String requiredExtensions = null;
        public Set<String> requiredFeatures = null;
        public Set<String> requiredFonts = null;
        public Set<String> requiredFormats = null;
        public Set<String> systemLanguage = null;

        protected SvgConditionalContainer() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SAXException {
            this.children.add(svgObject);
        }

        @Override
        public List<SvgObject> getChildren() {
            return this.children;
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return null;
        }

        @Override
        public void setRequiredExtensions(String string2) {
            this.requiredExtensions = string2;
        }

        @Override
        public void setRequiredFeatures(Set<String> set) {
            this.requiredFeatures = set;
        }

        @Override
        public void setRequiredFonts(Set<String> set) {
            this.requiredFonts = set;
        }

        @Override
        public void setRequiredFormats(Set<String> set) {
            this.requiredFormats = set;
        }

        @Override
        public void setSystemLanguage(Set<String> set) {
            this.systemLanguage = set;
        }
    }

    protected static class SvgConditionalElement
    extends SvgElement
    implements SvgConditional {
        public String requiredExtensions = null;
        public Set<String> requiredFeatures = null;
        public Set<String> requiredFonts = null;
        public Set<String> requiredFormats = null;
        public Set<String> systemLanguage = null;

        protected SvgConditionalElement() {
        }

        @Override
        public String getRequiredExtensions() {
            return this.requiredExtensions;
        }

        @Override
        public Set<String> getRequiredFeatures() {
            return this.requiredFeatures;
        }

        @Override
        public Set<String> getRequiredFonts() {
            return this.requiredFonts;
        }

        @Override
        public Set<String> getRequiredFormats() {
            return this.requiredFormats;
        }

        @Override
        public Set<String> getSystemLanguage() {
            return this.systemLanguage;
        }

        @Override
        public void setRequiredExtensions(String string2) {
            this.requiredExtensions = string2;
        }

        @Override
        public void setRequiredFeatures(Set<String> set) {
            this.requiredFeatures = set;
        }

        @Override
        public void setRequiredFonts(Set<String> set) {
            this.requiredFonts = set;
        }

        @Override
        public void setRequiredFormats(Set<String> set) {
            this.requiredFormats = set;
        }

        @Override
        public void setSystemLanguage(Set<String> set) {
            this.systemLanguage = set;
        }
    }

    protected static interface SvgContainer {
        public void addChild(SvgObject var1) throws SAXException;

        public List<SvgObject> getChildren();
    }

    protected static class SvgElement
    extends SvgElementBase {
        public Box boundingBox = null;

        protected SvgElement() {
        }
    }

    protected static class SvgElementBase
    extends SvgObject {
        public Style baseStyle = null;
        public List<String> classNames = null;
        public String id = null;
        public Boolean spacePreserve = null;
        public Style style = null;

        protected SvgElementBase() {
        }
    }

    protected static class SvgLinearGradient
    extends GradientElement {
        public Length x1;
        public Length x2;
        public Length y1;
        public Length y2;

        protected SvgLinearGradient() {
        }
    }

    protected static class SvgObject {
        public SVG document;
        public SvgContainer parent;

        protected SvgObject() {
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }

    protected static abstract class SvgPaint
    implements Cloneable {
        protected SvgPaint() {
        }
    }

    protected static class SvgPreserveAspectRatioContainer
    extends SvgConditionalContainer {
        public PreserveAspectRatio preserveAspectRatio = null;

        protected SvgPreserveAspectRatioContainer() {
        }
    }

    protected static class SvgRadialGradient
    extends GradientElement {
        public Length cx;
        public Length cy;
        public Length fx;
        public Length fy;
        public Length r;

        protected SvgRadialGradient() {
        }
    }

    protected static class SvgViewBoxContainer
    extends SvgPreserveAspectRatioContainer {
        public Box viewBox;

        protected SvgViewBoxContainer() {
        }
    }

    protected static class Switch
    extends Group {
        protected Switch() {
        }
    }

    protected static class Symbol
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        protected Symbol() {
        }
    }

    protected static class TRef
    extends TextContainer
    implements TextChild {
        public String href;
        private TextRoot textRoot;

        protected TRef() {
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }
    }

    protected static class TSpan
    extends TextPositionedContainer
    implements TextChild {
        private TextRoot textRoot;

        protected TSpan() {
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }
    }

    protected static class Text
    extends TextPositionedContainer
    implements TextRoot,
    HasTransform {
        public Matrix transform;

        protected Text() {
        }

        @Override
        public void setTransform(Matrix matrix) {
            this.transform = matrix;
        }
    }

    protected static interface TextChild {
        public TextRoot getTextRoot();

        public void setTextRoot(TextRoot var1);
    }

    protected static class TextContainer
    extends SvgConditionalContainer {
        protected TextContainer() {
        }

        @Override
        public void addChild(SvgObject svgObject) throws SAXException {
            if (svgObject instanceof TextChild) {
                this.children.add(svgObject);
                return;
            }
            StringBuilder stringBuilder = new StringBuilder("Text content elements cannot contain ");
            stringBuilder.append(svgObject);
            stringBuilder.append(" elements.");
            throw new SAXException(stringBuilder.toString());
        }
    }

    protected static class TextPath
    extends TextContainer
    implements TextChild {
        public String href;
        public Length startOffset;
        private TextRoot textRoot;

        protected TextPath() {
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }
    }

    protected static class TextPositionedContainer
    extends TextContainer {
        public List<Length> dx;
        public List<Length> dy;
        public List<Length> x;
        public List<Length> y;

        protected TextPositionedContainer() {
        }
    }

    protected static interface TextRoot {
    }

    protected static class TextSequence
    extends SvgObject
    implements TextChild {
        public String text;
        private TextRoot textRoot;

        public TextSequence(String string2) {
            this.text = string2;
        }

        @Override
        public TextRoot getTextRoot() {
            return this.textRoot;
        }

        @Override
        public void setTextRoot(TextRoot textRoot) {
            this.textRoot = textRoot;
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(this.getClass().getSimpleName()));
            stringBuilder.append(" '");
            stringBuilder.append(this.text);
            stringBuilder.append("'");
            return stringBuilder.toString();
        }
    }

    protected static final class Unit
    extends Enum<Unit> {
        private static final /* synthetic */ Unit[] ENUM$VALUES;
        public static final /* enum */ Unit cm;
        public static final /* enum */ Unit em;
        public static final /* enum */ Unit ex;
        public static final /* enum */ Unit in;
        public static final /* enum */ Unit mm;
        public static final /* enum */ Unit pc;
        public static final /* enum */ Unit percent;
        public static final /* enum */ Unit pt;
        public static final /* enum */ Unit px;

        static {
            Unit unit;
            Unit unit2;
            Unit unit3;
            Unit unit4;
            Unit unit5;
            Unit unit6;
            Unit unit7;
            Unit unit8;
            Unit unit9;
            px = unit9 = new Unit();
            em = unit8 = new Unit();
            ex = unit7 = new Unit();
            in = unit6 = new Unit();
            cm = unit5 = new Unit();
            mm = unit4 = new Unit();
            pt = unit3 = new Unit();
            pc = unit2 = new Unit();
            percent = unit = new Unit();
            ENUM$VALUES = new Unit[]{unit9, unit8, unit7, unit6, unit5, unit4, unit3, unit2, unit};
        }

        public static Unit valueOf(String string2) {
            return Enum.valueOf(Unit.class, string2);
        }

        public static Unit[] values() {
            Unit[] unitArray = ENUM$VALUES;
            int n = unitArray.length;
            Unit[] unitArray2 = new Unit[n];
            System.arraycopy(unitArray, 0, unitArray2, 0, n);
            return unitArray2;
        }
    }

    protected static class Use
    extends Group {
        public Length height;
        public String href;
        public Length width;
        public Length x;
        public Length y;

        protected Use() {
        }
    }

    protected static class View
    extends SvgViewBoxContainer
    implements NotDirectlyRendered {
        protected View() {
        }
    }
}

