/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.PathMeasure;
import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Base64;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGExternalFileResolver;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;

public class SVGAndroidRenderer {
    private static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineCaps;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineJoin;
    private static final float BEZIER_ARC_FACTOR = 0.5522848f;
    private static final String DEFAULT_FONT_FAMILY = "sans-serif";
    private static final int LUMINANCE_FACTOR_SHIFT = 15;
    private static final int LUMINANCE_TO_ALPHA_BLUE = 2362;
    private static final int LUMINANCE_TO_ALPHA_GREEN = 23442;
    private static final int LUMINANCE_TO_ALPHA_RED = 6963;
    private static final String TAG = "SVGAndroidRenderer";
    private static HashSet<String> supportedFeatures;
    private Stack<Bitmap> bitmapStack;
    private Canvas canvas;
    private Stack<Canvas> canvasStack;
    private SVG.Box canvasViewPort;
    private boolean directRenderingMode;
    private SVG document;
    private float dpi;
    private Stack<Matrix> matrixStack;
    private Stack<SVG.SvgContainer> parentStack;
    private RendererState state;
    private Stack<RendererState> stateStack;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule() {
        int[] nArray = $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule;
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[SVG.Style.FillRule.values().length];
        try {
            nArray[SVG.Style.FillRule.EvenOdd.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SVG.Style.FillRule.NonZero.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule = nArray;
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineCaps() {
        int[] nArray = $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineCaps;
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[SVG.Style.LineCaps.values().length];
        try {
            nArray[SVG.Style.LineCaps.Butt.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SVG.Style.LineCaps.Round.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SVG.Style.LineCaps.Square.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineCaps = nArray;
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ int[] $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineJoin() {
        int[] nArray = $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineJoin;
        if (nArray != null) {
            return nArray;
        }
        nArray = new int[SVG.Style.LineJoin.values().length];
        try {
            nArray[SVG.Style.LineJoin.Bevel.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SVG.Style.LineJoin.Miter.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[SVG.Style.LineJoin.Round.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineJoin = nArray;
        return nArray;
    }

    protected SVGAndroidRenderer(Canvas canvas, SVG.Box box, float f) {
        this.canvas = canvas;
        this.dpi = f;
        this.canvasViewPort = box;
    }

    private void addObjectToClip(SVG.GraphicsElement graphicsElement, Path path, Matrix matrix) {
        block10: {
            Path path2;
            block7: {
                block9: {
                    block8: {
                        block6: {
                            this.updateStyleForElement(this.state, graphicsElement);
                            if (!this.display()) {
                                return;
                            }
                            if (!this.visible()) {
                                return;
                            }
                            if (graphicsElement.transform != null) {
                                matrix.preConcat(graphicsElement.transform);
                            }
                            if (!(graphicsElement instanceof SVG.Rect)) break block6;
                            path2 = this.makePathAndBoundingBox((SVG.Rect)graphicsElement);
                            break block7;
                        }
                        if (!(graphicsElement instanceof SVG.Circle)) break block8;
                        path2 = this.makePathAndBoundingBox((SVG.Circle)graphicsElement);
                        break block7;
                    }
                    if (!(graphicsElement instanceof SVG.Ellipse)) break block9;
                    path2 = this.makePathAndBoundingBox((SVG.Ellipse)graphicsElement);
                    break block7;
                }
                if (!(graphicsElement instanceof SVG.PolyLine)) break block10;
                path2 = this.makePathAndBoundingBox((SVG.PolyLine)graphicsElement);
            }
            this.checkForClipPath(graphicsElement);
            path.setFillType(path2.getFillType());
            path.addPath(path2, matrix);
        }
    }

    private void addObjectToClip(SVG.Path path, Path path2, Matrix matrix) {
        this.updateStyleForElement(this.state, path);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (path.transform != null) {
            matrix.preConcat(path.transform);
        }
        Path path3 = new PathConverter(path.d).getPath();
        if (path.boundingBox == null) {
            path.boundingBox = this.calculatePathBounds(path3);
        }
        this.checkForClipPath(path);
        path2.setFillType(this.getClipRuleFromState());
        path2.addPath(path3, matrix);
    }

    private void addObjectToClip(SVG.SvgObject svgObject, boolean bl, Path path, Matrix matrix) {
        if (!this.display()) {
            return;
        }
        this.clipStatePush();
        if (svgObject instanceof SVG.Use) {
            if (bl) {
                this.addObjectToClip((SVG.Use)svgObject, path, matrix);
            } else {
                SVGAndroidRenderer.error("<use> elements inside a <clipPath> cannot reference another <use>", new Object[0]);
            }
        } else if (svgObject instanceof SVG.Path) {
            this.addObjectToClip((SVG.Path)svgObject, path, matrix);
        } else if (svgObject instanceof SVG.Text) {
            this.addObjectToClip((SVG.Text)svgObject, path, matrix);
        } else if (svgObject instanceof SVG.GraphicsElement) {
            this.addObjectToClip((SVG.GraphicsElement)svgObject, path, matrix);
        } else {
            SVGAndroidRenderer.error("Invalid %s element found in clipPath definition", svgObject.getClass().getSimpleName());
        }
        this.clipStatePop();
    }

    private void addObjectToClip(SVG.Text text, Path path, Matrix matrix) {
        this.updateStyleForElement(this.state, text);
        if (!this.display()) {
            return;
        }
        if (text.transform != null) {
            matrix.preConcat(text.transform);
        }
        Object object = text.x;
        float f = 0.0f;
        float f2 = object != null && text.x.size() != 0 ? ((SVG.Length)text.x.get(0)).floatValueX(this) : 0.0f;
        float f3 = text.y != null && text.y.size() != 0 ? ((SVG.Length)text.y.get(0)).floatValueY(this) : 0.0f;
        float f4 = text.dx != null && text.dx.size() != 0 ? ((SVG.Length)text.dx.get(0)).floatValueX(this) : 0.0f;
        float f5 = f;
        if (text.dy != null) {
            f5 = text.dy.size() == 0 ? f : ((SVG.Length)text.dy.get(0)).floatValueY(this);
        }
        f = f2;
        if (this.state.style.textAnchor != SVG.Style.TextAnchor.Start) {
            float f6;
            f = f6 = this.calculateTextWidth(text);
            if (this.state.style.textAnchor == SVG.Style.TextAnchor.Middle) {
                f = f6 / 2.0f;
            }
            f = f2 - f;
        }
        if (text.boundingBox == null) {
            object = new TextBoundsCalculator(f, f3);
            this.enumerateTextSpans(text, (TextProcessor)object);
            text.boundingBox = new SVG.Box(((TextBoundsCalculator)object).bbox.left, ((TextBoundsCalculator)object).bbox.top, ((TextBoundsCalculator)object).bbox.width(), ((TextBoundsCalculator)object).bbox.height());
        }
        this.checkForClipPath(text);
        object = new Path();
        this.enumerateTextSpans(text, new PlainTextToPath(f + f4, f3 + f5, (Path)object));
        path.setFillType(this.getClipRuleFromState());
        path.addPath((Path)object, matrix);
    }

    private void addObjectToClip(SVG.Use use, Path path, Matrix matrix) {
        SVG.SvgObject svgObject;
        this.updateStyleForElement(this.state, use);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (use.transform != null) {
            matrix.preConcat(use.transform);
        }
        if ((svgObject = use.document.resolveIRI(use.href)) == null) {
            SVGAndroidRenderer.error("Use reference '%s' not found", use.href);
            return;
        }
        this.checkForClipPath(use);
        this.addObjectToClip(svgObject, false, path, matrix);
    }

    private static void arcTo(float f, float f2, float f3, float f4, float f5, boolean bl, boolean bl2, float f6, float f7, SVG.PathInterface pathInterface) {
        if (f == f6 && f2 == f7) {
            return;
        }
        if (f3 != 0.0f && f4 != 0.0f) {
            float f8 = Math.abs(f3);
            float f9 = Math.abs(f4);
            double d = (float)Math.toRadians((double)f5 % 360.0);
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            double d4 = (double)(f - f6) / 2.0;
            d = (double)(f2 - f7) / 2.0;
            double d5 = d2 * d4 + d3 * d;
            double d6 = -d3 * d4 + d * d2;
            d = f8 * f8;
            d4 = f9 * f9;
            double d7 = d5 * d5;
            double d8 = d6 * d6;
            double d9 = d7 / d + d8 / d4;
            double d10 = 1.0;
            f4 = f8;
            f3 = f9;
            if (d9 > 1.0) {
                f4 = f8 * (float)Math.sqrt(d9);
                f3 = f9 * (float)Math.sqrt(d9);
                d = f4 * f4;
                d4 = f3 * f3;
            }
            int n = bl == bl2 ? -1 : 1;
            d9 = n;
            d8 = d * d8;
            d7 = d4 * d7;
            d = d4 = (d * d4 - d8 - d7) / (d8 + d7);
            if (d4 < 0.0) {
                d = 0.0;
            }
            d4 = d9 * Math.sqrt(d);
            double d11 = f4;
            d = f3;
            d7 = d11 * d6 / d * d4;
            d9 = d4 * -(d * d5 / d11);
            double d12 = (double)(f + f6) / 2.0;
            d8 = (double)(f2 + f7) / 2.0;
            d4 = (d5 - d7) / d11;
            double d13 = (d6 - d9) / d;
            d5 = (-d5 - d7) / d11;
            d11 = (-d6 - d9) / d;
            double d14 = d4 * d4 + d13 * d13;
            d6 = Math.sqrt(d14);
            d = d13 < 0.0 ? -1.0 : 1.0;
            d6 = Math.toDegrees(d * Math.acos(d4 / d6));
            d14 = Math.sqrt(d14 * (d5 * d5 + d11 * d11));
            d = d10;
            if (d4 * d11 - d13 * d5 < 0.0) {
                d = -1.0;
            }
            d4 = Math.toDegrees(d * Math.acos((d4 * d5 + d13 * d11) / d14));
            if (!bl2 && d4 > 0.0) {
                d = d4 - 360.0;
            } else {
                d = d4;
                if (bl2) {
                    d = d4;
                    if (d4 < 0.0) {
                        d = d4 + 360.0;
                    }
                }
            }
            float[] fArray = SVGAndroidRenderer.arcToBeziers(d6 % 360.0, d % 360.0);
            Matrix matrix = new Matrix();
            matrix.postScale(f4, f3);
            matrix.postRotate(f5);
            matrix.postTranslate((float)(d12 + (d2 * d7 - d3 * d9)), (float)(d8 + (d3 * d7 + d2 * d9)));
            matrix.mapPoints(fArray);
            fArray[fArray.length - 2] = f6;
            fArray[fArray.length - 1] = f7;
            n = 0;
            while (true) {
                if (n >= fArray.length) {
                    return;
                }
                pathInterface.cubicTo(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n + 3], fArray[n + 4], fArray[n + 5]);
                n += 6;
            }
        }
        pathInterface.lineTo(f6, f7);
    }

    private static float[] arcToBeziers(double d, double d2) {
        int n = (int)Math.ceil(Math.abs(d2) / 90.0);
        d = Math.toRadians(d);
        float f = (float)(Math.toRadians(d2) / (double)n);
        d2 = f;
        double d3 = d2 / 2.0;
        d3 = Math.sin(d3) * 1.3333333333333333 / (Math.cos(d3) + 1.0);
        float[] fArray = new float[n * 6];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            double d4 = (double)((float)n2 * f) + d;
            double d5 = Math.cos(d4);
            double d6 = Math.sin(d4);
            int n4 = n3 + 1;
            fArray[n3] = (float)(d5 - d3 * d6);
            n3 = n4 + 1;
            fArray[n4] = (float)(d6 + d5 * d3);
            d5 = d4 + d2;
            d4 = Math.cos(d5);
            d5 = Math.sin(d5);
            n4 = n3 + 1;
            fArray[n3] = (float)(d3 * d5 + d4);
            int n5 = n4 + 1;
            fArray[n4] = (float)(d5 - d3 * d4);
            n3 = n5 + 1;
            fArray[n5] = (float)d4;
            fArray[n3] = (float)d5;
            ++n2;
            ++n3;
        }
        return fArray;
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.Line object) {
        float f = ((SVG.Line)object).x1 != null ? ((SVG.Line)object).x1.floatValueX(this) : 0.0f;
        float f2 = ((SVG.Line)object).y1 != null ? ((SVG.Line)object).y1.floatValueY(this) : 0.0f;
        float f3 = ((SVG.Line)object).x2 != null ? ((SVG.Line)object).x2.floatValueX(this) : 0.0f;
        float f4 = ((SVG.Line)object).y2 != null ? ((SVG.Line)object).y2.floatValueY(this) : 0.0f;
        object = new ArrayList(2);
        float f5 = f3 - f;
        float f6 = f4 - f2;
        object.add(new MarkerVector(f, f2, f5, f6));
        object.add(new MarkerVector(f3, f4, f5, f6));
        return object;
    }

    private List<MarkerVector> calculateMarkerPositions(SVG.PolyLine object) {
        int n = ((SVG.PolyLine)object).points.length;
        int n2 = 2;
        if (n < 2) {
            return null;
        }
        ArrayList<MarkerVector> arrayList = new ArrayList<MarkerVector>();
        MarkerVector markerVector = new MarkerVector(((SVG.PolyLine)object).points[0], ((SVG.PolyLine)object).points[1], 0.0f, 0.0f);
        float f = 0.0f;
        float f2 = 0.0f;
        while (true) {
            if (n2 >= n) {
                if (object instanceof SVG.Polygon) {
                    if (f != ((SVG.PolyLine)object).points[0] && f2 != ((SVG.PolyLine)object).points[1]) {
                        f = ((SVG.PolyLine)object).points[0];
                        f2 = ((SVG.PolyLine)object).points[1];
                        markerVector.add(f, f2);
                        arrayList.add(markerVector);
                        object = new MarkerVector(f, f2, f - markerVector.x, f2 - markerVector.y);
                        ((MarkerVector)object).add((MarkerVector)arrayList.get(0));
                        arrayList.add((MarkerVector)object);
                        arrayList.set(0, (MarkerVector)object);
                    }
                } else {
                    arrayList.add(markerVector);
                }
                return arrayList;
            }
            f = ((SVG.PolyLine)object).points[n2];
            f2 = ((SVG.PolyLine)object).points[n2 + 1];
            markerVector.add(f, f2);
            arrayList.add(markerVector);
            markerVector = new MarkerVector(f, f2, f - markerVector.x, f2 - markerVector.y);
            n2 += 2;
        }
    }

    private SVG.Box calculatePathBounds(Path path) {
        RectF rectF = new RectF();
        path.computeBounds(rectF, true);
        return new SVG.Box(rectF.left, rectF.top, rectF.width(), rectF.height());
    }

    private float calculateTextWidth(SVG.TextContainer textContainer) {
        TextWidthCalculator textWidthCalculator = new TextWidthCalculator();
        this.enumerateTextSpans(textContainer, textWidthCalculator);
        return textWidthCalculator.x;
    }

    private Matrix calculateViewBoxTransform(SVG.Box box, SVG.Box box2, PreserveAspectRatio preserveAspectRatio) {
        Matrix matrix;
        block5: {
            float f;
            float f2;
            float f3;
            block10: {
                float f4;
                float f5;
                block8: {
                    block9: {
                        block6: {
                            block7: {
                                matrix = new Matrix();
                                if (preserveAspectRatio == null || preserveAspectRatio.getAlignment() == null) break block5;
                                f3 = box.width / box2.width;
                                f2 = box.height / box2.height;
                                f = -box2.minX;
                                f5 = -box2.minY;
                                if (preserveAspectRatio.equals(PreserveAspectRatio.STRETCH)) {
                                    matrix.preTranslate(box.minX, box.minY);
                                    matrix.preScale(f3, f2);
                                    matrix.preTranslate(f, f5);
                                    return matrix;
                                }
                                f3 = preserveAspectRatio.getScale() == PreserveAspectRatio.Scale.Slice ? Math.max(f3, f2) : Math.min(f3, f2);
                                f2 = box.width / f3;
                                f4 = box.height / f3;
                                int n = SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$PreserveAspectRatio$Alignment()[preserveAspectRatio.getAlignment().ordinal()];
                                if (n == 3) break block6;
                                if (n == 4) break block7;
                                if (n == 6) break block6;
                                if (n == 7) break block7;
                                if (n == 9) break block6;
                                if (n == 10) break block7;
                                f2 = f;
                                break block8;
                            }
                            f2 = box2.width - f2;
                            break block9;
                        }
                        f2 = (box2.width - f2) / 2.0f;
                    }
                    f2 = f - f2;
                }
                switch (preserveAspectRatio.getAlignment()) {
                    default: {
                        f = f5;
                        break block10;
                    }
                    case XMinYMax: 
                    case XMidYMax: 
                    case XMaxYMax: {
                        f = box2.height - f4;
                        break;
                    }
                    case XMinYMid: 
                    case XMidYMid: 
                    case XMaxYMid: {
                        f = (box2.height - f4) / 2.0f;
                    }
                }
                f = f5 - f;
            }
            matrix.preTranslate(box.minX, box.minY);
            matrix.preScale(f3, f3);
            matrix.preTranslate(f2, f);
        }
        return matrix;
    }

    private void checkForClipPath(SVG.SvgElement svgElement) {
        this.checkForClipPath(svgElement, svgElement.boundingBox);
    }

    private void checkForClipPath(SVG.SvgElement svgElement, SVG.Box object) {
        if (this.state.style.clipPath == null) {
            return;
        }
        SVG.SvgObject svgObject = svgElement.document.resolveIRI(this.state.style.clipPath);
        if (svgObject == null) {
            SVGAndroidRenderer.error("ClipPath reference '%s' not found", this.state.style.clipPath);
            return;
        }
        svgObject = (SVG.ClipPath)svgObject;
        if (((SVG.ClipPath)svgObject).children.isEmpty()) {
            this.canvas.clipRect(0, 0, 0, 0);
            return;
        }
        boolean bl = ((SVG.ClipPath)svgObject).clipPathUnitsAreUser == null || ((SVG.ClipPath)svgObject).clipPathUnitsAreUser != false;
        if (svgElement instanceof SVG.Group && !bl) {
            SVGAndroidRenderer.warn("<clipPath clipPathUnits=\"objectBoundingBox\"> is not supported when referenced from container elements (like %s)", svgElement.getClass().getSimpleName());
            return;
        }
        this.clipStatePush();
        if (!bl) {
            svgElement = new Matrix();
            svgElement.preTranslate(((SVG.Box)object).minX, ((SVG.Box)object).minY);
            svgElement.preScale(((SVG.Box)object).width, ((SVG.Box)object).height);
            this.canvas.concat((Matrix)svgElement);
        }
        if (((SVG.ClipPath)svgObject).transform != null) {
            this.canvas.concat(((SVG.ClipPath)svgObject).transform);
        }
        this.state = this.findInheritFromAncestorState(svgObject);
        this.checkForClipPath((SVG.SvgElement)svgObject);
        svgElement = new Path();
        object = ((SVG.ClipPath)svgObject).children.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.canvas.clipPath((Path)svgElement);
                this.clipStatePop();
                return;
            }
            this.addObjectToClip((SVG.SvgObject)object.next(), true, (Path)svgElement, new Matrix());
        }
    }

    private void checkForGradiantsAndPatterns(SVG.SvgElement svgElement) {
        if (this.state.style.fill instanceof SVG.PaintReference) {
            this.decodePaintReference(true, svgElement.boundingBox, (SVG.PaintReference)this.state.style.fill);
        }
        if (this.state.style.stroke instanceof SVG.PaintReference) {
            this.decodePaintReference(false, svgElement.boundingBox, (SVG.PaintReference)this.state.style.stroke);
        }
    }

    private Bitmap checkForImageDataURL(String object) {
        if (!((String)object).startsWith("data:")) {
            return null;
        }
        if (((String)object).length() < 14) {
            return null;
        }
        int n = ((String)object).indexOf(44);
        if (n != -1 && n >= 12) {
            if (!";base64".equals(((String)object).substring(n - 7, n))) {
                return null;
            }
            object = Base64.decode((String)((String)object).substring(n + 1), (int)0);
            return BitmapFactory.decodeByteArray((byte[])object, (int)0, (int)((Object)object).length);
        }
        return null;
    }

    private Typeface checkGenericFont(String object, Integer n, SVG.Style.FontStyle fontStyle) {
        SVG.Style.FontStyle fontStyle2 = SVG.Style.FontStyle.Italic;
        int n2 = 1;
        boolean bl = fontStyle == fontStyle2;
        if (n > 500) {
            if (bl) {
                n2 = 3;
            }
        } else {
            n2 = bl ? 2 : 0;
        }
        object = ((String)object).equals("serif") ? Typeface.create((Typeface)Typeface.SERIF, (int)n2) : (((String)object).equals(DEFAULT_FONT_FAMILY) ? Typeface.create((Typeface)Typeface.SANS_SERIF, (int)n2) : (((String)object).equals("monospace") ? Typeface.create((Typeface)Typeface.MONOSPACE, (int)n2) : (((String)object).equals("cursive") ? Typeface.create((Typeface)Typeface.SANS_SERIF, (int)n2) : (((String)object).equals("fantasy") ? Typeface.create((Typeface)Typeface.SANS_SERIF, (int)n2) : null))));
        return object;
    }

    private void checkXMLSpaceAttribute(SVG.SvgObject svgObject) {
        if (!(svgObject instanceof SVG.SvgElementBase)) {
            return;
        }
        svgObject = (SVG.SvgElementBase)svgObject;
        if (((SVG.SvgElementBase)svgObject).spacePreserve != null) {
            this.state.spacePreserve = ((SVG.SvgElementBase)svgObject).spacePreserve;
        }
    }

    private int clamp255(float f) {
        int n;
        int n2 = (int)(f * 256.0f);
        if (n2 < 0) {
            n = 0;
        } else {
            n = n2;
            if (n2 > 255) {
                n = 255;
            }
        }
        return n;
    }

    private void clipStatePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private void clipStatePush() {
        this.canvas.save(1);
        this.stateStack.push(this.state);
        this.state = (RendererState)this.state.clone();
    }

    private static void debug(String string2, Object ... objectArray) {
    }

    private void decodePaintReference(boolean bl, SVG.Box object, SVG.PaintReference paintReference) {
        SVG.SvgObject svgObject = this.document.resolveIRI(paintReference.href);
        if (svgObject == null) {
            object = bl ? "Fill" : "Stroke";
            SVGAndroidRenderer.error("%s reference '%s' not found", object, paintReference.href);
            if (paintReference.fallback != null) {
                this.setPaintColour(this.state, bl, paintReference.fallback);
            } else if (bl) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        if (svgObject instanceof SVG.SvgLinearGradient) {
            this.makeLinearGradiant(bl, (SVG.Box)object, (SVG.SvgLinearGradient)svgObject);
        }
        if (svgObject instanceof SVG.SvgRadialGradient) {
            this.makeRadialGradiant(bl, (SVG.Box)object, (SVG.SvgRadialGradient)svgObject);
        }
        if (svgObject instanceof SVG.SolidColor) {
            this.setSolidColor(bl, (SVG.SolidColor)svgObject);
        }
    }

    private boolean display() {
        if (this.state.style.display != null) {
            return this.state.style.display;
        }
        return true;
    }

    private void doFilledPath(SVG.SvgElement svgElement, Path path) {
        SVG.SvgObject svgObject;
        if (this.state.style.fill instanceof SVG.PaintReference && (svgObject = this.document.resolveIRI(((SVG.PaintReference)this.state.style.fill).href)) instanceof SVG.Pattern) {
            this.fillWithPattern(svgElement, path, (SVG.Pattern)svgObject);
            return;
        }
        this.canvas.drawPath(path, this.state.fillPaint);
    }

    private void doStroke(Path path) {
        if (this.state.style.vectorEffect == SVG.Style.VectorEffect.NonScalingStroke) {
            Matrix matrix = this.canvas.getMatrix();
            Path path2 = new Path();
            path.transform(matrix, path2);
            this.canvas.setMatrix(new Matrix());
            Shader shader = this.state.strokePaint.getShader();
            path = new Matrix();
            if (shader != null) {
                shader.getLocalMatrix((Matrix)path);
                Matrix matrix2 = new Matrix((Matrix)path);
                matrix2.postConcat(matrix);
                shader.setLocalMatrix(matrix2);
            }
            this.canvas.drawPath(path2, this.state.strokePaint);
            this.canvas.setMatrix(matrix);
            if (shader != null) {
                shader.setLocalMatrix((Matrix)path);
            }
        } else {
            this.canvas.drawPath(path, this.state.strokePaint);
        }
    }

    private void duplicateCanvas() {
        try {
            Bitmap bitmap = Bitmap.createBitmap((int)this.canvas.getWidth(), (int)this.canvas.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.bitmapStack.push(bitmap);
            Canvas canvas = new Canvas(bitmap);
            canvas.setMatrix(this.canvas.getMatrix());
            this.canvas = canvas;
            return;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            SVGAndroidRenderer.error("Not enough memory to create temporary bitmaps for mask processing", new Object[0]);
            throw outOfMemoryError;
        }
    }

    private void enumerateTextSpans(SVG.TextContainer svgObject, TextProcessor textProcessor) {
        if (!this.display()) {
            return;
        }
        Iterator iterator = svgObject.children.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            svgObject = (SVG.SvgObject)iterator.next();
            if (svgObject instanceof SVG.TextSequence) {
                textProcessor.processText(this.textXMLSpaceTransform(((SVG.TextSequence)svgObject).text, bl, iterator.hasNext() ^ true));
            } else {
                this.processTextChild(svgObject, textProcessor);
            }
            bl = false;
        }
        return;
    }

    private static void error(String string2, Object ... objectArray) {
        Log.e((String)TAG, (String)String.format(string2, objectArray));
    }

    private void extractRawText(SVG.TextContainer object, StringBuilder stringBuilder) {
        object = ((SVG.TextContainer)object).children.iterator();
        boolean bl = true;
        while (object.hasNext()) {
            SVG.SvgObject svgObject = (SVG.SvgObject)object.next();
            if (svgObject instanceof SVG.TextContainer) {
                this.extractRawText((SVG.TextContainer)svgObject, stringBuilder);
            } else if (svgObject instanceof SVG.TextSequence) {
                stringBuilder.append(this.textXMLSpaceTransform(((SVG.TextSequence)svgObject).text, bl, object.hasNext() ^ true));
            }
            bl = false;
        }
        return;
    }

    private void fillInChainedGradientFields(SVG.GradientElement gradientElement, String object) {
        SVG.SvgObject svgObject = gradientElement.document.resolveIRI((String)object);
        if (svgObject == null) {
            SVGAndroidRenderer.warn("Gradient reference '%s' not found", object);
            return;
        }
        if (!(svgObject instanceof SVG.GradientElement)) {
            SVGAndroidRenderer.error("Gradient href attributes must point to other gradient elements", new Object[0]);
            return;
        }
        if (svgObject == gradientElement) {
            SVGAndroidRenderer.error("Circular reference in gradient href attribute '%s'", object);
            return;
        }
        object = (SVG.GradientElement)svgObject;
        if (gradientElement.gradientUnitsAreUser == null) {
            gradientElement.gradientUnitsAreUser = ((SVG.GradientElement)object).gradientUnitsAreUser;
        }
        if (gradientElement.gradientTransform == null) {
            gradientElement.gradientTransform = ((SVG.GradientElement)object).gradientTransform;
        }
        if (gradientElement.spreadMethod == null) {
            gradientElement.spreadMethod = ((SVG.GradientElement)object).spreadMethod;
        }
        if (gradientElement.children.isEmpty()) {
            gradientElement.children = ((SVG.GradientElement)object).children;
        }
        try {
            if (gradientElement instanceof SVG.SvgLinearGradient) {
                this.fillInChainedGradientFields((SVG.SvgLinearGradient)gradientElement, (SVG.SvgLinearGradient)svgObject);
            } else {
                this.fillInChainedGradientFields((SVG.SvgRadialGradient)gradientElement, (SVG.SvgRadialGradient)svgObject);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        if (((SVG.GradientElement)object).href != null) {
            this.fillInChainedGradientFields(gradientElement, ((SVG.GradientElement)object).href);
        }
    }

    private void fillInChainedGradientFields(SVG.SvgLinearGradient svgLinearGradient, SVG.SvgLinearGradient svgLinearGradient2) {
        if (svgLinearGradient.x1 == null) {
            svgLinearGradient.x1 = svgLinearGradient2.x1;
        }
        if (svgLinearGradient.y1 == null) {
            svgLinearGradient.y1 = svgLinearGradient2.y1;
        }
        if (svgLinearGradient.x2 == null) {
            svgLinearGradient.x2 = svgLinearGradient2.x2;
        }
        if (svgLinearGradient.y2 == null) {
            svgLinearGradient.y2 = svgLinearGradient2.y2;
        }
    }

    private void fillInChainedGradientFields(SVG.SvgRadialGradient svgRadialGradient, SVG.SvgRadialGradient svgRadialGradient2) {
        if (svgRadialGradient.cx == null) {
            svgRadialGradient.cx = svgRadialGradient2.cx;
        }
        if (svgRadialGradient.cy == null) {
            svgRadialGradient.cy = svgRadialGradient2.cy;
        }
        if (svgRadialGradient.r == null) {
            svgRadialGradient.r = svgRadialGradient2.r;
        }
        if (svgRadialGradient.fx == null) {
            svgRadialGradient.fx = svgRadialGradient2.fx;
        }
        if (svgRadialGradient.fy == null) {
            svgRadialGradient.fy = svgRadialGradient2.fy;
        }
    }

    private void fillInChainedPatternFields(SVG.Pattern pattern, String object) {
        SVG.SvgObject svgObject = pattern.document.resolveIRI((String)object);
        if (svgObject == null) {
            SVGAndroidRenderer.warn("Pattern reference '%s' not found", object);
            return;
        }
        if (!(svgObject instanceof SVG.Pattern)) {
            SVGAndroidRenderer.error("Pattern href attributes must point to other pattern elements", new Object[0]);
            return;
        }
        if (svgObject == pattern) {
            SVGAndroidRenderer.error("Circular reference in pattern href attribute '%s'", object);
            return;
        }
        object = (SVG.Pattern)svgObject;
        if (pattern.patternUnitsAreUser == null) {
            pattern.patternUnitsAreUser = ((SVG.Pattern)object).patternUnitsAreUser;
        }
        if (pattern.patternContentUnitsAreUser == null) {
            pattern.patternContentUnitsAreUser = ((SVG.Pattern)object).patternContentUnitsAreUser;
        }
        if (pattern.patternTransform == null) {
            pattern.patternTransform = ((SVG.Pattern)object).patternTransform;
        }
        if (pattern.x == null) {
            pattern.x = ((SVG.Pattern)object).x;
        }
        if (pattern.y == null) {
            pattern.y = ((SVG.Pattern)object).y;
        }
        if (pattern.width == null) {
            pattern.width = ((SVG.Pattern)object).width;
        }
        if (pattern.height == null) {
            pattern.height = ((SVG.Pattern)object).height;
        }
        if (pattern.children.isEmpty()) {
            pattern.children = ((SVG.Pattern)object).children;
        }
        if (pattern.viewBox == null) {
            pattern.viewBox = ((SVG.Pattern)object).viewBox;
        }
        if (pattern.preserveAspectRatio == null) {
            pattern.preserveAspectRatio = ((SVG.Pattern)object).preserveAspectRatio;
        }
        if (((SVG.Pattern)object).href != null) {
            this.fillInChainedPatternFields(pattern, ((SVG.Pattern)object).href);
        }
    }

    /*
     * Exception decompiling
     */
    private void fillWithPattern(SVG.SvgElement var1_1, Path var2_2, SVG.Pattern var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[UNCONDITIONALDOLOOP]], but top level block is 3[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject svgObject) {
        RendererState rendererState = new RendererState();
        this.updateStyle(rendererState, SVG.Style.getDefaultStyle());
        return this.findInheritFromAncestorState(svgObject, rendererState);
    }

    private RendererState findInheritFromAncestorState(SVG.SvgObject object, RendererState rendererState) {
        ArrayList<SVG.SvgElementBase> arrayList = new ArrayList<SVG.SvgElementBase>();
        while (true) {
            if (object instanceof SVG.SvgElementBase) {
                arrayList.add(0, (SVG.SvgElementBase)object);
            }
            if (((SVG.SvgObject)object).parent == null) {
                object = arrayList.iterator();
                while (true) {
                    if (!object.hasNext()) {
                        rendererState.viewBox = this.document.getRootElement().viewBox;
                        if (rendererState.viewBox == null) {
                            rendererState.viewBox = this.canvasViewPort;
                        }
                        rendererState.viewPort = this.canvasViewPort;
                        rendererState.directRendering = this.state.directRendering;
                        return rendererState;
                    }
                    this.updateStyleForElement(rendererState, (SVG.SvgElementBase)object.next());
                }
            }
            object = (SVG.SvgObject)((Object)((SVG.SvgObject)object).parent);
        }
    }

    private SVG.Style.TextAnchor getAnchorPosition() {
        if (this.state.style.direction != SVG.Style.TextDirection.LTR && this.state.style.textAnchor != SVG.Style.TextAnchor.Middle) {
            SVG.Style.TextAnchor textAnchor = this.state.style.textAnchor == SVG.Style.TextAnchor.Start ? SVG.Style.TextAnchor.End : SVG.Style.TextAnchor.Start;
            return textAnchor;
        }
        return this.state.style.textAnchor;
    }

    private Path.FillType getClipRuleFromState() {
        if (this.state.style.clipRule == null) {
            return Path.FillType.WINDING;
        }
        if (SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule()[this.state.style.clipRule.ordinal()] != 2) {
            return Path.FillType.WINDING;
        }
        return Path.FillType.EVEN_ODD;
    }

    private Path.FillType getFillTypeFromState() {
        if (this.state.style.fillRule == null) {
            return Path.FillType.WINDING;
        }
        if (SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$FillRule()[this.state.style.fillRule.ordinal()] != 2) {
            return Path.FillType.WINDING;
        }
        return Path.FillType.EVEN_ODD;
    }

    private static void info(String string2, Object ... objectArray) {
        Log.i((String)TAG, (String)String.format(string2, objectArray));
    }

    private static void initialiseSupportedFeaturesMap() {
        synchronized (SVGAndroidRenderer.class) {
            HashSet<String> hashSet = new HashSet<String>();
            supportedFeatures = hashSet;
            hashSet.add("Structure");
            supportedFeatures.add("BasicStructure");
            supportedFeatures.add("ConditionalProcessing");
            supportedFeatures.add("Image");
            supportedFeatures.add("Style");
            supportedFeatures.add("ViewportAttribute");
            supportedFeatures.add("Shape");
            supportedFeatures.add("BasicText");
            supportedFeatures.add("PaintAttribute");
            supportedFeatures.add("BasicPaintAttribute");
            supportedFeatures.add("OpacityAttribute");
            supportedFeatures.add("BasicGraphicsAttribute");
            supportedFeatures.add("Marker");
            supportedFeatures.add("Gradient");
            supportedFeatures.add("Pattern");
            supportedFeatures.add("Clip");
            supportedFeatures.add("BasicClip");
            supportedFeatures.add("Mask");
            supportedFeatures.add("View");
            return;
        }
    }

    private boolean isSpecified(SVG.Style style2, long l) {
        return (style2.specifiedFlags & l) != 0L;
    }

    private void makeLinearGradiant(boolean bl, SVG.Box object, SVG.SvgLinearGradient svgLinearGradient) {
        int n;
        float f;
        float f2;
        float f3;
        Cloneable cloneable;
        if (svgLinearGradient.href != null) {
            this.fillInChainedGradientFields((SVG.GradientElement)svgLinearGradient, svgLinearGradient.href);
        }
        Object object2 = svgLinearGradient.gradientUnitsAreUser;
        int n2 = 0;
        int n3 = object2 != null && svgLinearGradient.gradientUnitsAreUser != false ? 1 : 0;
        object2 = this.state;
        object2 = bl ? ((RendererState)object2).fillPaint : ((RendererState)object2).strokePaint;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (n3 != 0) {
            cloneable = this.getCurrentViewPortInUserUnits();
            f3 = svgLinearGradient.x1 != null ? svgLinearGradient.x1.floatValueX(this) : 0.0f;
            f2 = svgLinearGradient.y1 != null ? svgLinearGradient.y1.floatValueY(this) : 0.0f;
            f = svgLinearGradient.x2 != null ? svgLinearGradient.x2.floatValueX(this) : cloneable.width;
            if (svgLinearGradient.y2 != null) {
                f5 = svgLinearGradient.y2.floatValueY(this);
            }
            f4 = f5;
            f5 = f2;
            f2 = f3;
            f3 = f;
            f = f4;
        } else {
            f3 = svgLinearGradient.x1 != null ? svgLinearGradient.x1.floatValue(this, 1.0f) : 0.0f;
            f2 = svgLinearGradient.y1 != null ? svgLinearGradient.y1.floatValue(this, 1.0f) : 0.0f;
            f = svgLinearGradient.x2 != null ? svgLinearGradient.x2.floatValue(this, 1.0f) : 1.0f;
            f5 = f4;
            if (svgLinearGradient.y2 != null) {
                f5 = svgLinearGradient.y2.floatValue(this, 1.0f);
            }
            f4 = f3;
            f3 = f;
            f = f5;
            f5 = f2;
            f2 = f4;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(svgLinearGradient);
        Matrix matrix = new Matrix();
        if (n3 == 0) {
            matrix.preTranslate(((SVG.Box)object).minX, ((SVG.Box)object).minY);
            matrix.preScale(((SVG.Box)object).width, ((SVG.Box)object).height);
        }
        if (svgLinearGradient.gradientTransform != null) {
            matrix.preConcat(svgLinearGradient.gradientTransform);
        }
        if ((n = svgLinearGradient.children.size()) == 0) {
            this.statePop();
            if (bl) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        f4 = -1.0f;
        Iterator iterator = svgLinearGradient.children.iterator();
        n3 = n2;
        while (true) {
            if (!iterator.hasNext()) {
                if (f2 == f3 && f5 == f || n == 1) {
                    this.statePop();
                    object2.setColor(nArray[n - 1]);
                    return;
                }
                cloneable = Shader.TileMode.CLAMP;
                object = cloneable;
                if (svgLinearGradient.spreadMethod != null) {
                    if (svgLinearGradient.spreadMethod == SVG.GradientSpread.reflect) {
                        object = Shader.TileMode.MIRROR;
                    } else {
                        object = cloneable;
                        if (svgLinearGradient.spreadMethod == SVG.GradientSpread.repeat) {
                            object = Shader.TileMode.REPEAT;
                        }
                    }
                }
                this.statePop();
                object = new LinearGradient(f2, f5, f3, f, nArray, fArray, (Shader.TileMode)object);
                object.setLocalMatrix(matrix);
                object2.setShader((Shader)object);
                return;
            }
            object = (SVG.Stop)((SVG.SvgObject)iterator.next());
            if (n3 != 0 && !(((SVG.Stop)object).offset.floatValue() >= f4)) {
                fArray[n3] = f4;
            } else {
                fArray[n3] = ((SVG.Stop)object).offset.floatValue();
                f4 = ((SVG.Stop)object).offset.floatValue();
            }
            this.statePush();
            this.updateStyleForElement(this.state, (SVG.SvgElementBase)object);
            cloneable = (SVG.Colour)this.state.style.stopColor;
            object = cloneable;
            if (cloneable == null) {
                object = SVG.Colour.BLACK;
            }
            n2 = this.clamp255(this.state.style.stopOpacity.floatValue());
            nArray[n3] = ((SVG.Colour)object).colour | n2 << 24;
            ++n3;
            this.statePop();
        }
    }

    private Path makePathAndBoundingBox(SVG.Circle circle) {
        float f;
        SVG.Length length = circle.cx;
        float f2 = 0.0f;
        float f3 = length != null ? circle.cx.floatValueX(this) : 0.0f;
        if (circle.cy != null) {
            f2 = circle.cy.floatValueY(this);
        }
        float f4 = circle.r.floatValue(this);
        float f5 = f3 - f4;
        float f6 = f2 - f4;
        float f7 = f3 + f4;
        float f8 = f2 + f4;
        if (circle.boundingBox == null) {
            f = 2.0f * f4;
            circle.boundingBox = new SVG.Box(f5, f6, f, f);
        }
        float f9 = 0.5522848f * f4;
        circle = new Path();
        circle.moveTo(f3, f6);
        float f10 = f3 + f9;
        f4 = f2 - f9;
        circle.cubicTo(f10, f6, f7, f4, f7, f2);
        f = f2 + f9;
        circle.cubicTo(f7, f, f10, f8, f3, f8);
        f7 = f3 - f9;
        circle.cubicTo(f7, f8, f5, f, f5, f2);
        circle.cubicTo(f5, f4, f7, f6, f3, f6);
        circle.close();
        return circle;
    }

    private Path makePathAndBoundingBox(SVG.Ellipse ellipse) {
        SVG.Length length = ellipse.cx;
        float f = 0.0f;
        float f2 = length != null ? ellipse.cx.floatValueX(this) : 0.0f;
        if (ellipse.cy != null) {
            f = ellipse.cy.floatValueY(this);
        }
        float f3 = ellipse.rx.floatValueX(this);
        float f4 = ellipse.ry.floatValueY(this);
        float f5 = f2 - f3;
        float f6 = f - f4;
        float f7 = f2 + f3;
        float f8 = f + f4;
        if (ellipse.boundingBox == null) {
            ellipse.boundingBox = new SVG.Box(f5, f6, f3 * 2.0f, 2.0f * f4);
        }
        float f9 = 0.5522848f * f4;
        ellipse = new Path();
        ellipse.moveTo(f2, f6);
        float f10 = f2 + (f3 *= 0.5522848f);
        f4 = f - f9;
        ellipse.cubicTo(f10, f6, f7, f4, f7, f);
        ellipse.cubicTo(f7, f9 += f, f10, f8, f2, f8);
        f7 = f2 - f3;
        ellipse.cubicTo(f7, f8, f5, f9, f5, f);
        ellipse.cubicTo(f5, f4, f7, f6, f2, f6);
        ellipse.close();
        return ellipse;
    }

    private Path makePathAndBoundingBox(SVG.Line line) {
        SVG.Length length = line.x1;
        float f = 0.0f;
        float f2 = length == null ? 0.0f : line.x1.floatValueX(this);
        float f3 = line.y1 == null ? 0.0f : line.y1.floatValueY(this);
        float f4 = line.x2 == null ? 0.0f : line.x2.floatValueX(this);
        if (line.y2 != null) {
            f = line.y2.floatValueY(this);
        }
        if (line.boundingBox == null) {
            line.boundingBox = new SVG.Box(Math.min(f2, f3), Math.min(f3, f), Math.abs(f4 - f2), Math.abs(f - f3));
        }
        line = new Path();
        line.moveTo(f2, f3);
        line.lineTo(f4, f);
        return line;
    }

    private Path makePathAndBoundingBox(SVG.PolyLine polyLine) {
        Path path = new Path();
        path.moveTo(polyLine.points[0], polyLine.points[1]);
        int n = 2;
        while (true) {
            if (n >= polyLine.points.length) {
                if (polyLine instanceof SVG.Polygon) {
                    path.close();
                }
                if (polyLine.boundingBox == null) {
                    polyLine.boundingBox = this.calculatePathBounds(path);
                }
                path.setFillType(this.getClipRuleFromState());
                return path;
            }
            path.lineTo(polyLine.points[n], polyLine.points[n + 1]);
            n += 2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Path makePathAndBoundingBox(SVG.Rect var1_1) {
        if (var1_1.rx == null && var1_1.ry == null) {
            var2_2 = 0.0f;
            var3_3 = 0.0f;
        } else if (var1_1.rx == null) {
            var3_3 = var1_1.ry.floatValueY(this);
lbl7:
            // 2 sources

            while (true) {
                var4_4 = var3_3;
                var2_2 = var3_3;
                var3_3 = var4_4;
                break;
            }
        } else {
            if (var1_1.ry == null) {
                var3_3 = var1_1.rx.floatValueX(this);
                ** continue;
            }
            var2_2 = var1_1.rx.floatValueX(this);
            var3_3 = var1_1.ry.floatValueY(this);
        }
        var5_5 = Math.min(var2_2, var1_1.width.floatValueX(this) / 2.0f);
        var4_4 = Math.min(var3_3, var1_1.height.floatValueY(this) / 2.0f);
        var3_3 = var1_1.x != null ? var1_1.x.floatValueX(this) : 0.0f;
        var2_2 = var1_1.y != null ? var1_1.y.floatValueY(this) : 0.0f;
        var6_6 = var1_1.width.floatValueX(this);
        var7_7 = var1_1.height.floatValueY(this);
        if (var1_1.boundingBox == null) {
            var1_1.boundingBox = new SVG.Box(var3_3, var2_2, var6_6, var7_7);
        }
        var6_6 = var3_3 + var6_6;
        var8_8 = var2_2 + var7_7;
        var1_1 = new Path();
        if (var5_5 != 0.0f && var4_4 != 0.0f) {
            var9_9 = var5_5 * 0.5522848f;
            var10_10 = 0.5522848f * var4_4;
            var11_11 = var2_2 + var4_4;
            var1_1.moveTo(var3_3, var11_11);
            var12_12 = var11_11 - var10_10;
            var7_7 = var3_3 + var5_5;
            var13_13 = var7_7 - var9_9;
            var1_1.cubicTo(var3_3, var12_12, var13_13, var2_2, var7_7, var2_2);
            var5_5 = var6_6 - var5_5;
            var1_1.lineTo(var5_5, var2_2);
            var9_9 = var5_5 + var9_9;
            var1_1.cubicTo(var9_9, var2_2, var6_6, var12_12, var6_6, var11_11);
            var2_2 = var8_8 - var4_4;
            var1_1.lineTo(var6_6, var2_2);
            var4_4 = var2_2 + var10_10;
            var14_14 = var1_1;
            var1_1.cubicTo(var6_6, var4_4, var9_9, var8_8, var5_5, var8_8);
            var14_14.lineTo(var7_7, var8_8);
            var14_14.cubicTo(var13_13, var8_8, var3_3, var4_4, var3_3, var2_2);
            var14_14.lineTo(var3_3, var11_11);
        } else {
            var14_15 = var1_1;
            var14_15.moveTo(var3_3, var2_2);
            var14_15.lineTo(var6_6, var2_2);
            var14_15.lineTo(var6_6, var8_8);
            var14_15.lineTo(var3_3, var8_8);
            var14_15.lineTo(var3_3, var2_2);
        }
        var1_1.close();
        return var1_1;
    }

    private void makeRadialGradiant(boolean bl, SVG.Box object, SVG.SvgRadialGradient svgRadialGradient) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        Cloneable cloneable;
        if (svgRadialGradient.href != null) {
            this.fillInChainedGradientFields((SVG.GradientElement)svgRadialGradient, svgRadialGradient.href);
        }
        Object object2 = svgRadialGradient.gradientUnitsAreUser;
        int n2 = 0;
        int n3 = object2 != null && svgRadialGradient.gradientUnitsAreUser != false ? 1 : 0;
        object2 = this.state;
        object2 = bl ? ((RendererState)object2).fillPaint : ((RendererState)object2).strokePaint;
        if (n3 != 0) {
            cloneable = new SVG.Length(50.0f, SVG.Unit.percent);
            f4 = svgRadialGradient.cx != null ? svgRadialGradient.cx.floatValueX(this) : cloneable.floatValueX(this);
            f3 = svgRadialGradient.cy != null ? svgRadialGradient.cy.floatValueY(this) : cloneable.floatValueY(this);
            if (svgRadialGradient.r != null) {
                cloneable = svgRadialGradient.r;
            }
            f2 = cloneable.floatValue(this);
            f = f3;
            f3 = f2;
        } else {
            f3 = svgRadialGradient.cx != null ? svgRadialGradient.cx.floatValue(this, 1.0f) : 0.5f;
            f4 = svgRadialGradient.cy != null ? svgRadialGradient.cy.floatValue(this, 1.0f) : 0.5f;
            f = svgRadialGradient.r != null ? svgRadialGradient.r.floatValue(this, 1.0f) : 0.5f;
            f2 = f3;
            f3 = f;
            f = f4;
            f4 = f2;
        }
        this.statePush();
        this.state = this.findInheritFromAncestorState(svgRadialGradient);
        Matrix matrix = new Matrix();
        if (n3 == 0) {
            matrix.preTranslate(((SVG.Box)object).minX, ((SVG.Box)object).minY);
            matrix.preScale(((SVG.Box)object).width, ((SVG.Box)object).height);
        }
        if (svgRadialGradient.gradientTransform != null) {
            matrix.preConcat(svgRadialGradient.gradientTransform);
        }
        if ((n = svgRadialGradient.children.size()) == 0) {
            this.statePop();
            if (bl) {
                this.state.hasFill = false;
            } else {
                this.state.hasStroke = false;
            }
            return;
        }
        int[] nArray = new int[n];
        float[] fArray = new float[n];
        f2 = -1.0f;
        Iterator iterator = svgRadialGradient.children.iterator();
        n3 = n2;
        while (true) {
            if (!iterator.hasNext()) {
                if (f3 != 0.0f && n != 1) {
                    cloneable = Shader.TileMode.CLAMP;
                    object = cloneable;
                    if (svgRadialGradient.spreadMethod != null) {
                        if (svgRadialGradient.spreadMethod == SVG.GradientSpread.reflect) {
                            object = Shader.TileMode.MIRROR;
                        } else {
                            object = cloneable;
                            if (svgRadialGradient.spreadMethod == SVG.GradientSpread.repeat) {
                                object = Shader.TileMode.REPEAT;
                            }
                        }
                    }
                    this.statePop();
                    object = new RadialGradient(f4, f, f3, nArray, fArray, (Shader.TileMode)object);
                    object.setLocalMatrix(matrix);
                    object2.setShader((Shader)object);
                    return;
                }
                this.statePop();
                object2.setColor(nArray[n - 1]);
                return;
            }
            object = (SVG.Stop)((SVG.SvgObject)iterator.next());
            if (n3 != 0 && !(((SVG.Stop)object).offset.floatValue() >= f2)) {
                fArray[n3] = f2;
            } else {
                fArray[n3] = ((SVG.Stop)object).offset.floatValue();
                f2 = ((SVG.Stop)object).offset.floatValue();
            }
            this.statePush();
            this.updateStyleForElement(this.state, (SVG.SvgElementBase)object);
            cloneable = (SVG.Colour)this.state.style.stopColor;
            object = cloneable;
            if (cloneable == null) {
                object = SVG.Colour.BLACK;
            }
            n2 = this.clamp255(this.state.style.stopOpacity.floatValue());
            nArray[n3] = ((SVG.Colour)object).colour | n2 << 24;
            ++n3;
            this.statePop();
        }
    }

    private void parentPop() {
        this.parentStack.pop();
        this.matrixStack.pop();
    }

    private void parentPush(SVG.SvgContainer svgContainer) {
        this.parentStack.push(svgContainer);
        this.matrixStack.push(this.canvas.getMatrix());
    }

    private void popLayer(SVG.SvgElement svgElement) {
        if (this.state.style.mask != null && this.state.directRendering) {
            SVG.SvgObject svgObject = this.document.resolveIRI(this.state.style.mask);
            this.duplicateCanvas();
            this.renderMask((SVG.Mask)svgObject, svgElement);
            svgElement = this.processMaskBitmaps();
            svgObject = this.canvasStack.pop();
            this.canvas = svgObject;
            svgObject.save();
            this.canvas.setMatrix(new Matrix());
            this.canvas.drawBitmap((Bitmap)svgElement, 0.0f, 0.0f, this.state.fillPaint);
            svgElement.recycle();
            this.canvas.restore();
        }
        this.statePop();
    }

    private Bitmap processMaskBitmaps() {
        Bitmap bitmap = this.bitmapStack.pop();
        Bitmap bitmap2 = this.bitmapStack.pop();
        int n = bitmap.getWidth();
        int n2 = bitmap.getHeight();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int n3 = 0;
        block0: while (true) {
            if (n3 >= n2) {
                bitmap.recycle();
                return bitmap2;
            }
            bitmap.getPixels(nArray, 0, n, 0, n3, n, 1);
            bitmap2.getPixels(nArray2, 0, n, 0, n3, n, 1);
            int n4 = 0;
            while (true) {
                if (n4 >= n) {
                    bitmap2.setPixels(nArray2, 0, n, 0, n3, n, 1);
                    ++n3;
                    continue block0;
                }
                int n5 = nArray[n4];
                int n6 = n5 >> 24 & 0xFF;
                if (n6 == 0) {
                    nArray2[n4] = 0;
                } else {
                    n5 = ((n5 >> 16 & 0xFF) * 6963 + (n5 >> 8 & 0xFF) * 23442 + (n5 & 0xFF) * 2362) * n6 / 8355840;
                    n6 = nArray2[n4];
                    nArray2[n4] = n6 & 0xFFFFFF | (n6 >> 24 & 0xFF) * n5 / 255 << 24;
                }
                ++n4;
            }
            break;
        }
    }

    private void processTextChild(SVG.SvgObject object, TextProcessor textProcessor) {
        if (!textProcessor.doTextContainer((SVG.TextContainer)object)) {
            return;
        }
        if (object instanceof SVG.TextPath) {
            this.statePush();
            this.renderTextPath((SVG.TextPath)object);
            this.statePop();
        } else if (object instanceof SVG.TSpan) {
            SVGAndroidRenderer.debug("TSpan render", new Object[0]);
            this.statePush();
            SVG.TSpan tSpan = (SVG.TSpan)object;
            this.updateStyleForElement(this.state, tSpan);
            if (this.display()) {
                float f;
                float f2;
                float f3;
                boolean bl = textProcessor instanceof PlainTextDrawer;
                float f4 = 0.0f;
                float f5 = 0.0f;
                if (bl) {
                    f3 = tSpan.x != null && tSpan.x.size() != 0 ? ((SVG.Length)tSpan.x.get(0)).floatValueX(this) : ((PlainTextDrawer)textProcessor).x;
                    f2 = tSpan.y != null && tSpan.y.size() != 0 ? ((SVG.Length)tSpan.y.get(0)).floatValueY(this) : ((PlainTextDrawer)textProcessor).y;
                    f = tSpan.dx != null && tSpan.dx.size() != 0 ? ((SVG.Length)tSpan.dx.get(0)).floatValueX(this) : 0.0f;
                    f4 = f5;
                    if (tSpan.dy != null) {
                        f4 = tSpan.dy.size() == 0 ? f5 : ((SVG.Length)tSpan.dy.get(0)).floatValueY(this);
                    }
                    f5 = f4;
                    f4 = f3;
                    f3 = f5;
                } else {
                    f3 = 0.0f;
                    f2 = 0.0f;
                    f = 0.0f;
                }
                this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)tSpan.getTextRoot()));
                if (bl) {
                    object = (PlainTextDrawer)textProcessor;
                    ((PlainTextDrawer)object).x = f4 + f;
                    ((PlainTextDrawer)object).y = f2 + f3;
                }
                bl = this.pushLayer();
                this.enumerateTextSpans(tSpan, textProcessor);
                if (bl) {
                    this.popLayer(tSpan);
                }
            }
            this.statePop();
        } else if (object instanceof SVG.TRef) {
            this.statePush();
            Object object2 = (SVG.TRef)object;
            this.updateStyleForElement(this.state, (SVG.SvgElementBase)object2);
            if (this.display()) {
                this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)((SVG.TRef)object2).getTextRoot()));
                object = ((SVG.SvgObject)object).document.resolveIRI(((SVG.TRef)object2).href);
                if (object != null && object instanceof SVG.TextContainer) {
                    object2 = new StringBuilder();
                    this.extractRawText((SVG.TextContainer)object, (StringBuilder)object2);
                    if (((StringBuilder)object2).length() > 0) {
                        textProcessor.processText(((StringBuilder)object2).toString());
                    }
                } else {
                    SVGAndroidRenderer.error("Tref reference '%s' not found", ((SVG.TRef)object2).href);
                }
            }
            this.statePop();
        }
    }

    private boolean pushLayer() {
        if (!this.requiresCompositing()) {
            return false;
        }
        this.canvas.saveLayerAlpha(null, this.clamp255(this.state.style.opacity.floatValue()), 4);
        this.stateStack.push(this.state);
        Object object = (RendererState)this.state.clone();
        this.state = object;
        if (((RendererState)object).style.mask != null && this.state.directRendering) {
            object = this.document.resolveIRI(this.state.style.mask);
            if (object != null && object instanceof SVG.Mask) {
                this.canvasStack.push(this.canvas);
                this.duplicateCanvas();
            } else {
                SVGAndroidRenderer.error("Mask reference '%s' not found", this.state.style.mask);
                this.state.style.mask = null;
            }
        }
        return true;
    }

    private void render(SVG.Circle circle) {
        SVGAndroidRenderer.debug("Circle render", new Object[0]);
        if (circle.r != null && !circle.r.isZero()) {
            this.updateStyleForElement(this.state, circle);
            if (!this.display()) {
                return;
            }
            if (!this.visible()) {
                return;
            }
            if (circle.transform != null) {
                this.canvas.concat(circle.transform);
            }
            Path path = this.makePathAndBoundingBox(circle);
            this.updateParentBoundingBox(circle);
            this.checkForGradiantsAndPatterns(circle);
            this.checkForClipPath(circle);
            boolean bl = this.pushLayer();
            if (this.state.hasFill) {
                this.doFilledPath(circle, path);
            }
            if (this.state.hasStroke) {
                this.doStroke(path);
            }
            if (bl) {
                this.popLayer(circle);
            }
        }
    }

    private void render(SVG.Ellipse ellipse) {
        SVGAndroidRenderer.debug("Ellipse render", new Object[0]);
        if (ellipse.rx != null && ellipse.ry != null && !ellipse.rx.isZero() && !ellipse.ry.isZero()) {
            this.updateStyleForElement(this.state, ellipse);
            if (!this.display()) {
                return;
            }
            if (!this.visible()) {
                return;
            }
            if (ellipse.transform != null) {
                this.canvas.concat(ellipse.transform);
            }
            Path path = this.makePathAndBoundingBox(ellipse);
            this.updateParentBoundingBox(ellipse);
            this.checkForGradiantsAndPatterns(ellipse);
            this.checkForClipPath(ellipse);
            boolean bl = this.pushLayer();
            if (this.state.hasFill) {
                this.doFilledPath(ellipse, path);
            }
            if (this.state.hasStroke) {
                this.doStroke(path);
            }
            if (bl) {
                this.popLayer(ellipse);
            }
        }
    }

    private void render(SVG.Group group) {
        SVGAndroidRenderer.debug("Group render", new Object[0]);
        this.updateStyleForElement(this.state, group);
        if (!this.display()) {
            return;
        }
        if (group.transform != null) {
            this.canvas.concat(group.transform);
        }
        this.checkForClipPath(group);
        boolean bl = this.pushLayer();
        this.renderChildren(group, true);
        if (bl) {
            this.popLayer(group);
        }
        this.updateParentBoundingBox(group);
    }

    private void render(SVG.Image image) {
        SVGAndroidRenderer.debug("Image render", new Object[0]);
        if (image.width != null && !image.width.isZero() && image.height != null && !image.height.isZero()) {
            if (image.href == null) {
                return;
            }
            PreserveAspectRatio preserveAspectRatio = image.preserveAspectRatio != null ? image.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
            Bitmap bitmap = this.checkForImageDataURL(image.href);
            Object object = bitmap;
            if (bitmap == null) {
                object = this.document.getFileResolver();
                if (object == null) {
                    return;
                }
                object = ((SVGExternalFileResolver)object).resolveImage(image.href);
            }
            if (object == null) {
                SVGAndroidRenderer.error("Could not locate image '%s'", image.href);
                return;
            }
            this.updateStyleForElement(this.state, image);
            if (!this.display()) {
                return;
            }
            if (!this.visible()) {
                return;
            }
            if (image.transform != null) {
                this.canvas.concat(image.transform);
            }
            float f = image.x != null ? image.x.floatValueX(this) : 0.0f;
            float f2 = image.y != null ? image.y.floatValueY(this) : 0.0f;
            float f3 = image.width.floatValueX(this);
            float f4 = image.height.floatValueX(this);
            this.state.viewPort = new SVG.Box(f, f2, f3, f4);
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
            }
            image.boundingBox = new SVG.Box(0.0f, 0.0f, object.getWidth(), object.getHeight());
            this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, image.boundingBox, preserveAspectRatio));
            this.updateParentBoundingBox(image);
            this.checkForClipPath(image);
            boolean bl = this.pushLayer();
            this.viewportFill();
            this.canvas.drawBitmap((Bitmap)object, 0.0f, 0.0f, new Paint());
            if (bl) {
                this.popLayer(image);
            }
        }
    }

    private void render(SVG.Line line) {
        SVGAndroidRenderer.debug("Line render", new Object[0]);
        this.updateStyleForElement(this.state, line);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke) {
            return;
        }
        if (line.transform != null) {
            this.canvas.concat(line.transform);
        }
        Path path = this.makePathAndBoundingBox(line);
        this.updateParentBoundingBox(line);
        this.checkForGradiantsAndPatterns(line);
        this.checkForClipPath(line);
        boolean bl = this.pushLayer();
        this.doStroke(path);
        this.renderMarkers(line);
        if (bl) {
            this.popLayer(line);
        }
    }

    private void render(SVG.Path path) {
        SVGAndroidRenderer.debug("Path render", new Object[0]);
        if (path.d == null) {
            return;
        }
        this.updateStyleForElement(this.state, path);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (path.transform != null) {
            this.canvas.concat(path.transform);
        }
        Path path2 = new PathConverter(path.d).getPath();
        if (path.boundingBox == null) {
            path.boundingBox = this.calculatePathBounds(path2);
        }
        this.updateParentBoundingBox(path);
        this.checkForGradiantsAndPatterns(path);
        this.checkForClipPath(path);
        boolean bl = this.pushLayer();
        if (this.state.hasFill) {
            path2.setFillType(this.getFillTypeFromState());
            this.doFilledPath(path, path2);
        }
        if (this.state.hasStroke) {
            this.doStroke(path2);
        }
        this.renderMarkers(path);
        if (bl) {
            this.popLayer(path);
        }
    }

    private void render(SVG.PolyLine polyLine) {
        SVGAndroidRenderer.debug("PolyLine render", new Object[0]);
        this.updateStyleForElement(this.state, polyLine);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (polyLine.transform != null) {
            this.canvas.concat(polyLine.transform);
        }
        if (polyLine.points.length < 2) {
            return;
        }
        Path path = this.makePathAndBoundingBox(polyLine);
        this.updateParentBoundingBox(polyLine);
        this.checkForGradiantsAndPatterns(polyLine);
        this.checkForClipPath(polyLine);
        boolean bl = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(polyLine, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        this.renderMarkers(polyLine);
        if (bl) {
            this.popLayer(polyLine);
        }
    }

    private void render(SVG.Polygon polygon) {
        SVGAndroidRenderer.debug("Polygon render", new Object[0]);
        this.updateStyleForElement(this.state, polygon);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        if (!this.state.hasStroke && !this.state.hasFill) {
            return;
        }
        if (polygon.transform != null) {
            this.canvas.concat(polygon.transform);
        }
        if (polygon.points.length < 2) {
            return;
        }
        Path path = this.makePathAndBoundingBox(polygon);
        this.updateParentBoundingBox(polygon);
        this.checkForGradiantsAndPatterns(polygon);
        this.checkForClipPath(polygon);
        boolean bl = this.pushLayer();
        if (this.state.hasFill) {
            this.doFilledPath(polygon, path);
        }
        if (this.state.hasStroke) {
            this.doStroke(path);
        }
        this.renderMarkers(polygon);
        if (bl) {
            this.popLayer(polygon);
        }
    }

    private void render(SVG.Rect rect) {
        SVGAndroidRenderer.debug("Rect render", new Object[0]);
        if (rect.width != null && rect.height != null && !rect.width.isZero() && !rect.height.isZero()) {
            this.updateStyleForElement(this.state, rect);
            if (!this.display()) {
                return;
            }
            if (!this.visible()) {
                return;
            }
            if (rect.transform != null) {
                this.canvas.concat(rect.transform);
            }
            Path path = this.makePathAndBoundingBox(rect);
            this.updateParentBoundingBox(rect);
            this.checkForGradiantsAndPatterns(rect);
            this.checkForClipPath(rect);
            boolean bl = this.pushLayer();
            if (this.state.hasFill) {
                this.doFilledPath(rect, path);
            }
            if (this.state.hasStroke) {
                this.doStroke(path);
            }
            if (bl) {
                this.popLayer(rect);
            }
        }
    }

    private void render(SVG.Svg svg) {
        this.render(svg, svg.width, svg.height);
    }

    private void render(SVG.Svg svg, SVG.Length length, SVG.Length length2) {
        this.render(svg, length, length2, svg.viewBox, svg.preserveAspectRatio);
    }

    private void render(SVG.Svg svg, SVG.Length length, SVG.Length length2, SVG.Box box, PreserveAspectRatio object) {
        float f;
        SVGAndroidRenderer.debug("Svg render", new Object[0]);
        if (length != null && length.isZero() || length2 != null && length2.isZero()) {
            return;
        }
        PreserveAspectRatio preserveAspectRatio = object;
        if (object == null) {
            preserveAspectRatio = svg.preserveAspectRatio != null ? svg.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        }
        this.updateStyleForElement(this.state, svg);
        if (!this.display()) {
            return;
        }
        object = svg.parent;
        float f2 = 0.0f;
        float f3 = 0.0f;
        if (object != null) {
            f = svg.x != null ? svg.x.floatValueX(this) : 0.0f;
            if (svg.y != null) {
                f3 = svg.y.floatValueY(this);
            }
            f2 = f;
            f = f3;
            f3 = f2;
        } else {
            f = 0.0f;
            f3 = f2;
        }
        object = this.getCurrentViewPortInUserUnits();
        f2 = length != null ? length.floatValueX(this) : ((SVG.Box)object).width;
        float f4 = length2 != null ? length2.floatValueY(this) : ((SVG.Box)object).height;
        this.state.viewPort = new SVG.Box(f3, f, f2, f4);
        if (!this.state.style.overflow.booleanValue()) {
            this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
        }
        this.checkForClipPath(svg, this.state.viewPort);
        if (box != null) {
            this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, box, preserveAspectRatio));
            this.state.viewBox = svg.viewBox;
        } else {
            this.canvas.translate(f3, f);
        }
        boolean bl = this.pushLayer();
        this.viewportFill();
        this.renderChildren(svg, true);
        if (bl) {
            this.popLayer(svg);
        }
        this.updateParentBoundingBox(svg);
    }

    private void render(SVG.SvgObject svgObject) {
        if (svgObject instanceof SVG.NotDirectlyRendered) {
            return;
        }
        this.statePush();
        this.checkXMLSpaceAttribute(svgObject);
        if (svgObject instanceof SVG.Svg) {
            this.render((SVG.Svg)svgObject);
        } else if (svgObject instanceof SVG.Use) {
            this.render((SVG.Use)svgObject);
        } else if (svgObject instanceof SVG.Switch) {
            this.render((SVG.Switch)svgObject);
        } else if (svgObject instanceof SVG.Group) {
            this.render((SVG.Group)svgObject);
        } else if (svgObject instanceof SVG.Image) {
            this.render((SVG.Image)svgObject);
        } else if (svgObject instanceof SVG.Path) {
            this.render((SVG.Path)svgObject);
        } else if (svgObject instanceof SVG.Rect) {
            this.render((SVG.Rect)svgObject);
        } else if (svgObject instanceof SVG.Circle) {
            this.render((SVG.Circle)svgObject);
        } else if (svgObject instanceof SVG.Ellipse) {
            this.render((SVG.Ellipse)svgObject);
        } else if (svgObject instanceof SVG.Line) {
            this.render((SVG.Line)svgObject);
        } else if (svgObject instanceof SVG.Polygon) {
            this.render((SVG.Polygon)svgObject);
        } else if (svgObject instanceof SVG.PolyLine) {
            this.render((SVG.PolyLine)svgObject);
        } else if (svgObject instanceof SVG.Text) {
            this.render((SVG.Text)svgObject);
        }
        this.statePop();
    }

    private void render(SVG.Switch switch_) {
        SVGAndroidRenderer.debug("Switch render", new Object[0]);
        this.updateStyleForElement(this.state, switch_);
        if (!this.display()) {
            return;
        }
        if (switch_.transform != null) {
            this.canvas.concat(switch_.transform);
        }
        this.checkForClipPath(switch_);
        boolean bl = this.pushLayer();
        this.renderSwitchChild(switch_);
        if (bl) {
            this.popLayer(switch_);
        }
        this.updateParentBoundingBox(switch_);
    }

    private void render(SVG.Symbol symbol, SVG.Length length, SVG.Length length2) {
        SVGAndroidRenderer.debug("Symbol render", new Object[0]);
        if (length != null && length.isZero() || length2 != null && length2.isZero()) {
            return;
        }
        PreserveAspectRatio preserveAspectRatio = symbol.preserveAspectRatio != null ? symbol.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
        this.updateStyleForElement(this.state, symbol);
        float f = length != null ? length.floatValueX(this) : this.state.viewPort.width;
        float f2 = length2 != null ? length2.floatValueX(this) : this.state.viewPort.height;
        this.state.viewPort = new SVG.Box(0.0f, 0.0f, f, f2);
        if (!this.state.style.overflow.booleanValue()) {
            this.setClipRect(this.state.viewPort.minX, this.state.viewPort.minY, this.state.viewPort.width, this.state.viewPort.height);
        }
        if (symbol.viewBox != null) {
            this.canvas.concat(this.calculateViewBoxTransform(this.state.viewPort, symbol.viewBox, preserveAspectRatio));
            this.state.viewBox = symbol.viewBox;
        }
        boolean bl = this.pushLayer();
        this.renderChildren(symbol, true);
        if (bl) {
            this.popLayer(symbol);
        }
        this.updateParentBoundingBox(symbol);
    }

    private void render(SVG.Text text) {
        SVGAndroidRenderer.debug("Text render", new Object[0]);
        this.updateStyleForElement(this.state, text);
        if (!this.display()) {
            return;
        }
        if (text.transform != null) {
            this.canvas.concat(text.transform);
        }
        Object object = text.x;
        float f = 0.0f;
        float f2 = object != null && text.x.size() != 0 ? ((SVG.Length)text.x.get(0)).floatValueX(this) : 0.0f;
        float f3 = text.y != null && text.y.size() != 0 ? ((SVG.Length)text.y.get(0)).floatValueY(this) : 0.0f;
        float f4 = text.dx != null && text.dx.size() != 0 ? ((SVG.Length)text.dx.get(0)).floatValueX(this) : 0.0f;
        float f5 = f;
        if (text.dy != null) {
            f5 = text.dy.size() == 0 ? f : ((SVG.Length)text.dy.get(0)).floatValueY(this);
        }
        object = this.getAnchorPosition();
        f = f2;
        if (object != SVG.Style.TextAnchor.Start) {
            float f6;
            f = f6 = this.calculateTextWidth(text);
            if (object == SVG.Style.TextAnchor.Middle) {
                f = f6 / 2.0f;
            }
            f = f2 - f;
        }
        if (text.boundingBox == null) {
            object = new TextBoundsCalculator(f, f3);
            this.enumerateTextSpans(text, (TextProcessor)object);
            text.boundingBox = new SVG.Box(((TextBoundsCalculator)object).bbox.left, ((TextBoundsCalculator)object).bbox.top, ((TextBoundsCalculator)object).bbox.width(), ((TextBoundsCalculator)object).bbox.height());
        }
        this.updateParentBoundingBox(text);
        this.checkForGradiantsAndPatterns(text);
        this.checkForClipPath(text);
        boolean bl = this.pushLayer();
        this.enumerateTextSpans(text, new PlainTextDrawer(f + f4, f3 + f5));
        if (bl) {
            this.popLayer(text);
        }
    }

    private void render(SVG.Use use) {
        SVGAndroidRenderer.debug("Use render", new Object[0]);
        if (use.width != null && use.width.isZero() || use.height != null && use.height.isZero()) {
            return;
        }
        this.updateStyleForElement(this.state, use);
        if (!this.display()) {
            return;
        }
        SVG.SvgObject svgObject = use.document.resolveIRI(use.href);
        if (svgObject == null) {
            SVGAndroidRenderer.error("Use reference '%s' not found", use.href);
            return;
        }
        if (use.transform != null) {
            this.canvas.concat(use.transform);
        }
        Object object = new Matrix();
        SVG.Length length = use.x;
        float f = 0.0f;
        float f2 = length != null ? use.x.floatValueX(this) : 0.0f;
        if (use.y != null) {
            f = use.y.floatValueY(this);
        }
        object.preTranslate(f2, f);
        this.canvas.concat(object);
        this.checkForClipPath(use);
        boolean bl = this.pushLayer();
        this.parentPush(use);
        if (svgObject instanceof SVG.Svg) {
            this.statePush();
            svgObject = (SVG.Svg)svgObject;
            object = use.width != null ? use.width : ((SVG.Svg)svgObject).width;
            length = use.height != null ? use.height : ((SVG.Svg)svgObject).height;
            this.render((SVG.Svg)svgObject, (SVG.Length)object, length);
            this.statePop();
        } else if (svgObject instanceof SVG.Symbol) {
            object = use.width != null ? use.width : new SVG.Length(100.0f, SVG.Unit.percent);
            length = use.height != null ? use.height : new SVG.Length(100.0f, SVG.Unit.percent);
            this.statePush();
            this.render((SVG.Symbol)svgObject, (SVG.Length)object, length);
            this.statePop();
        } else {
            this.render(svgObject);
        }
        this.parentPop();
        if (bl) {
            this.popLayer(use);
        }
        this.updateParentBoundingBox(use);
    }

    private void renderChildren(SVG.SvgContainer object, boolean bl) {
        if (bl) {
            this.parentPush((SVG.SvgContainer)object);
        }
        object = object.getChildren().iterator();
        while (true) {
            if (!object.hasNext()) {
                if (bl) {
                    this.parentPop();
                }
                return;
            }
            this.render((SVG.SvgObject)object.next());
        }
    }

    private void renderMarker(SVG.Marker marker, MarkerVector object) {
        block18: {
            float f;
            float f2;
            float f3;
            float f4;
            Float f5;
            block12: {
                float f6;
                float f7;
                block17: {
                    float f8;
                    block15: {
                        block16: {
                            block13: {
                                block14: {
                                    block11: {
                                        block9: {
                                            block10: {
                                                this.statePush();
                                                f5 = marker.orient;
                                                f8 = 0.0f;
                                                if (f5 == null) break block9;
                                                if (!Float.isNaN(marker.orient.floatValue())) break block10;
                                                if (((MarkerVector)object).dx == 0.0f && ((MarkerVector)object).dy == 0.0f) break block9;
                                                f7 = (float)Math.toDegrees(Math.atan2(((MarkerVector)object).dy, ((MarkerVector)object).dx));
                                                break block11;
                                            }
                                            f7 = marker.orient.floatValue();
                                            break block11;
                                        }
                                        f7 = 0.0f;
                                    }
                                    f4 = marker.markerUnitsAreUser ? 1.0f : this.state.style.strokeWidth.floatValue(this.dpi);
                                    this.state = this.findInheritFromAncestorState(marker);
                                    f5 = new Matrix();
                                    f5.preTranslate(((MarkerVector)object).x, ((MarkerVector)object).y);
                                    f5.preRotate(f7);
                                    f5.preScale(f4, f4);
                                    f3 = marker.refX != null ? marker.refX.floatValueX(this) : 0.0f;
                                    f2 = marker.refY != null ? marker.refY.floatValueY(this) : 0.0f;
                                    object = marker.markerWidth;
                                    f = 3.0f;
                                    f4 = object != null ? marker.markerWidth.floatValueX(this) : 3.0f;
                                    if (marker.markerHeight != null) {
                                        f = marker.markerHeight.floatValueY(this);
                                    }
                                    if (marker.viewBox == null) break block12;
                                    float f9 = f4 / marker.viewBox.width;
                                    float f10 = f / marker.viewBox.height;
                                    object = marker.preserveAspectRatio != null ? marker.preserveAspectRatio : PreserveAspectRatio.LETTERBOX;
                                    f7 = f9;
                                    f6 = f10;
                                    if (!((PreserveAspectRatio)object).equals(PreserveAspectRatio.STRETCH)) {
                                        f7 = ((PreserveAspectRatio)object).getScale() == PreserveAspectRatio.Scale.Slice ? Math.max(f9, f10) : Math.min(f9, f10);
                                        f6 = f7;
                                    }
                                    f5.preTranslate(-f3 * f7, -f2 * f6);
                                    this.canvas.concat((Matrix)f5);
                                    f3 = marker.viewBox.width * f7;
                                    f2 = marker.viewBox.height * f6;
                                    int n = SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$PreserveAspectRatio$Alignment()[((PreserveAspectRatio)object).getAlignment().ordinal()];
                                    if (n == 3) break block13;
                                    if (n == 4) break block14;
                                    if (n == 6) break block13;
                                    if (n == 7) break block14;
                                    if (n == 9) break block13;
                                    if (n == 10) break block14;
                                    f3 = 0.0f;
                                    break block15;
                                }
                                f3 = f4 - f3;
                                break block16;
                            }
                            f3 = (f4 - f3) / 2.0f;
                        }
                        f3 = 0.0f - f3;
                    }
                    switch (((PreserveAspectRatio)object).getAlignment()) {
                        default: {
                            f2 = f8;
                            break block17;
                        }
                        case XMinYMax: 
                        case XMidYMax: 
                        case XMaxYMax: {
                            f2 = f - f2;
                            break;
                        }
                        case XMinYMid: 
                        case XMidYMid: 
                        case XMaxYMid: {
                            f2 = (f - f2) / 2.0f;
                        }
                    }
                    f2 = 0.0f - f2;
                }
                if (!this.state.style.overflow.booleanValue()) {
                    this.setClipRect(f3, f2, f4, f);
                }
                f5.reset();
                f5.preScale(f7, f6);
                this.canvas.concat((Matrix)f5);
                break block18;
            }
            f5.preTranslate(-f3, -f2);
            this.canvas.concat((Matrix)f5);
            if (!this.state.style.overflow.booleanValue()) {
                this.setClipRect(0.0f, 0.0f, f4, f);
            }
        }
        boolean bl = this.pushLayer();
        this.renderChildren(marker, false);
        if (bl) {
            this.popLayer(marker);
        }
        this.statePop();
    }

    /*
     * Unable to fully structure code
     */
    private void renderMarkers(SVG.GraphicsElement var1_1) {
        if (this.state.style.markerStart == null && this.state.style.markerMid == null && this.state.style.markerEnd == null) {
            return;
        }
        if (this.state.style.markerStart == null) ** GOTO lbl9
        var2_2 = var1_1.document.resolveIRI(this.state.style.markerStart);
        if (var2_2 != null) {
            var2_2 = (SVG.Marker)var2_2;
        } else {
            SVGAndroidRenderer.error("Marker reference '%s' not found", new Object[]{this.state.style.markerStart});
lbl9:
            // 2 sources

            var2_2 = null;
        }
        if (this.state.style.markerMid == null) ** GOTO lbl16
        var3_3 = var1_1.document.resolveIRI(this.state.style.markerMid);
        if (var3_3 != null) {
            var3_3 = (SVG.Marker)var3_3;
        } else {
            SVGAndroidRenderer.error("Marker reference '%s' not found", new Object[]{this.state.style.markerMid});
lbl16:
            // 2 sources

            var3_3 = null;
        }
        if (this.state.style.markerEnd == null) ** GOTO lbl23
        var4_4 = var1_1.document.resolveIRI(this.state.style.markerEnd);
        if (var4_4 != null) {
            var4_4 = (SVG.Marker)var4_4;
        } else {
            SVGAndroidRenderer.error("Marker reference '%s' not found", new Object[]{this.state.style.markerEnd});
lbl23:
            // 2 sources

            var4_4 = null;
        }
        var1_1 = var1_1 instanceof SVG.Path != false ? new MarkerPositionCalculator(((SVG.Path)var1_1).d).getMarkers() : (var1_1 instanceof SVG.Line != false ? this.calculateMarkerPositions((SVG.Line)var1_1) : this.calculateMarkerPositions((SVG.PolyLine)var1_1));
        if (var1_1 == null) {
            return;
        }
        var5_5 = var1_1.size();
        if (var5_5 == 0) {
            return;
        }
        var6_6 = this.state.style;
        var7_7 = this.state.style;
        this.state.style.markerEnd = null;
        var7_7.markerMid = null;
        var6_6.markerStart = null;
        if (var2_2 != null) {
            this.renderMarker((SVG.Marker)var2_2, var1_1.get(0));
        }
        if (var3_3 != null) {
            for (var8_8 = 1; var8_8 < var5_5 - 1; ++var8_8) {
                this.renderMarker((SVG.Marker)var3_3, var1_1.get(var8_8));
            }
        }
        if (var4_4 != null) {
            this.renderMarker((SVG.Marker)var4_4, var1_1.get(var5_5 - 1));
        }
    }

    private void renderMask(SVG.Mask mask, SVG.SvgElement svgElement) {
        float f;
        float f2;
        SVGAndroidRenderer.debug("Mask render", new Object[0]);
        Object object = mask.maskUnitsAreUser;
        boolean bl = true;
        boolean bl2 = object != null && mask.maskUnitsAreUser != false;
        if (bl2) {
            float f3;
            f2 = mask.width != null ? mask.width.floatValueX(this) : svgElement.boundingBox.width;
            f = mask.height != null ? mask.height.floatValueY(this) : svgElement.boundingBox.height;
            if (mask.x != null) {
                mask.x.floatValueX(this);
            } else {
                f3 = svgElement.boundingBox.minX;
                f3 = svgElement.boundingBox.width;
            }
            if (mask.y != null) {
                mask.y.floatValueY(this);
            } else {
                f3 = svgElement.boundingBox.minY;
                f3 = svgElement.boundingBox.height;
            }
        } else {
            if (mask.x != null) {
                mask.x.floatValue(this, 1.0f);
            }
            if (mask.y != null) {
                mask.y.floatValue(this, 1.0f);
            }
            object = mask.width;
            f = 1.2f;
            f2 = object != null ? mask.width.floatValue(this, 1.0f) : 1.2f;
            if (mask.height != null) {
                f = mask.height.floatValue(this, 1.0f);
            }
            float f4 = svgElement.boundingBox.minX;
            f4 = svgElement.boundingBox.width;
            f4 = svgElement.boundingBox.minY;
            f4 = svgElement.boundingBox.height;
            f2 *= svgElement.boundingBox.width;
            f *= svgElement.boundingBox.height;
        }
        if (f2 != 0.0f && f != 0.0f) {
            this.statePush();
            this.state = object = this.findInheritFromAncestorState(mask);
            ((RendererState)object).style.opacity = Float.valueOf(1.0f);
            bl2 = bl;
            if (mask.maskContentUnitsAreUser != null) {
                bl2 = bl;
                if (!mask.maskContentUnitsAreUser.booleanValue()) {
                    bl2 = false;
                }
            }
            if (!bl2) {
                this.canvas.translate(svgElement.boundingBox.minX, svgElement.boundingBox.minY);
                this.canvas.scale(svgElement.boundingBox.width, svgElement.boundingBox.height);
            }
            this.renderChildren(mask, false);
            this.statePop();
        }
    }

    private void renderSwitchChild(SVG.Switch svgObject2) {
        String string2 = Locale.getDefault().getLanguage();
        SVGExternalFileResolver sVGExternalFileResolver = this.document.getFileResolver();
        block0: for (SVG.SvgObject svgObject : ((SVG.SvgConditionalContainer)svgObject2).getChildren()) {
            Set<String> set;
            Iterator iterator;
            if (!(svgObject instanceof SVG.SvgConditional) || (iterator = (SVG.SvgConditional)((Object)svgObject)).getRequiredExtensions() != null || (set = iterator.getSystemLanguage()) != null && (set.isEmpty() || !set.contains(string2))) continue;
            set = iterator.getRequiredFeatures();
            if (set != null) {
                if (supportedFeatures == null) {
                    SVGAndroidRenderer.initialiseSupportedFeaturesMap();
                }
                if (set.isEmpty() || !supportedFeatures.containsAll(set)) continue;
            }
            if ((set = iterator.getRequiredFormats()) != null) {
                if (set.isEmpty() || sVGExternalFileResolver == null) continue;
                set = set.iterator();
                while (set.hasNext()) {
                    if (sVGExternalFileResolver.isFormatSupported((String)set.next())) continue;
                    continue block0;
                }
            }
            if ((iterator = iterator.getRequiredFonts()) != null) {
                if (iterator.isEmpty() || sVGExternalFileResolver == null) continue;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    if (sVGExternalFileResolver.resolveFont((String)iterator.next(), this.state.style.fontWeight, String.valueOf((Object)this.state.style.fontStyle)) != null) continue;
                    continue block0;
                }
            }
            this.render(svgObject);
            break;
        }
    }

    private void renderTextPath(SVG.TextPath textPath) {
        SVGAndroidRenderer.debug("TextPath render", new Object[0]);
        this.updateStyleForElement(this.state, textPath);
        if (!this.display()) {
            return;
        }
        if (!this.visible()) {
            return;
        }
        SVG.SvgObject svgObject = textPath.document.resolveIRI(textPath.href);
        if (svgObject == null) {
            SVGAndroidRenderer.error("TextPath reference '%s' not found", textPath.href);
            return;
        }
        Object object = (SVG.Path)svgObject;
        svgObject = new PathConverter(object.d).getPath();
        if (object.transform != null) {
            svgObject.transform(object.transform);
        }
        object = new PathMeasure((Path)svgObject, false);
        float f = textPath.startOffset != null ? textPath.startOffset.floatValue(this, object.getLength()) : 0.0f;
        object = this.getAnchorPosition();
        float f2 = f;
        if (object != SVG.Style.TextAnchor.Start) {
            float f3;
            f2 = f3 = this.calculateTextWidth(textPath);
            if (object == SVG.Style.TextAnchor.Middle) {
                f2 = f3 / 2.0f;
            }
            f2 = f - f2;
        }
        this.checkForGradiantsAndPatterns((SVG.SvgElement)((Object)textPath.getTextRoot()));
        boolean bl = this.pushLayer();
        this.enumerateTextSpans(textPath, new PathTextDrawer((Path)svgObject, f2, 0.0f));
        if (bl) {
            this.popLayer(textPath);
        }
    }

    private boolean requiresCompositing() {
        if (this.state.style.mask != null && !this.state.directRendering) {
            SVGAndroidRenderer.warn("Masks are not supported when using getPicture()", new Object[0]);
        }
        return this.state.style.opacity.floatValue() < 1.0f || this.state.style.mask != null && this.state.directRendering;
    }

    private void resetState() {
        this.state = new RendererState();
        this.stateStack = new Stack();
        this.updateStyle(this.state, SVG.Style.getDefaultStyle());
        this.state.viewPort = this.canvasViewPort;
        this.state.spacePreserve = false;
        this.state.directRendering = this.directRenderingMode;
        this.stateStack.push((RendererState)this.state.clone());
        this.canvasStack = new Stack();
        this.bitmapStack = new Stack();
        this.matrixStack = new Stack();
        this.parentStack = new Stack();
    }

    private void setClipRect(float f, float f2, float f3, float f4) {
        float f5 = f3 + f;
        float f6 = f4 + f2;
        float f7 = f;
        float f8 = f2;
        f4 = f5;
        f3 = f6;
        if (this.state.style.clip != null) {
            f7 = f + this.state.style.clip.left.floatValueX(this);
            f8 = f2 + this.state.style.clip.top.floatValueY(this);
            f4 = f5 - this.state.style.clip.right.floatValueX(this);
            f3 = f6 - this.state.style.clip.bottom.floatValueY(this);
        }
        this.canvas.clipRect(f7, f8, f4, f3);
    }

    private void setPaintColour(RendererState rendererState, boolean bl, SVG.SvgPaint svgPaint) {
        block7: {
            int n;
            float f;
            block6: {
                block5: {
                    Object object = rendererState.style;
                    object = bl ? ((SVG.Style)object).fillOpacity : ((SVG.Style)object).strokeOpacity;
                    f = ((Float)object).floatValue();
                    if (!(svgPaint instanceof SVG.Colour)) break block5;
                    n = ((SVG.Colour)svgPaint).colour;
                    break block6;
                }
                if (!(svgPaint instanceof SVG.CurrentColor)) break block7;
                n = rendererState.style.color.colour;
            }
            n |= this.clamp255(f) << 24;
            if (bl) {
                rendererState.fillPaint.setColor(n);
            } else {
                rendererState.strokePaint.setColor(n);
            }
        }
    }

    private void setSolidColor(boolean bl, SVG.SolidColor object) {
        boolean bl2 = true;
        boolean bl3 = true;
        if (bl) {
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x80000000L)) {
                this.state.style.fill = ((SVG.SolidColor)object).baseStyle.solidColor;
                RendererState rendererState = this.state;
                if (((SVG.SolidColor)object).baseStyle.solidColor == null) {
                    bl3 = false;
                }
                rendererState.hasFill = bl3;
            }
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x100000000L)) {
                this.state.style.fillOpacity = ((SVG.SolidColor)object).baseStyle.solidOpacity;
            }
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x180000000L)) {
                object = this.state;
                this.setPaintColour((RendererState)object, bl, ((RendererState)object).style.fill);
            }
        } else {
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x80000000L)) {
                this.state.style.stroke = ((SVG.SolidColor)object).baseStyle.solidColor;
                RendererState rendererState = this.state;
                bl3 = ((SVG.SolidColor)object).baseStyle.solidColor != null ? bl2 : false;
                rendererState.hasStroke = bl3;
            }
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x100000000L)) {
                this.state.style.strokeOpacity = ((SVG.SolidColor)object).baseStyle.solidOpacity;
            }
            if (this.isSpecified(((SVG.SolidColor)object).baseStyle, 0x180000000L)) {
                object = this.state;
                this.setPaintColour((RendererState)object, bl, ((RendererState)object).style.stroke);
            }
        }
    }

    private void statePop() {
        this.canvas.restore();
        this.state = this.stateStack.pop();
    }

    private void statePush() {
        this.canvas.save();
        this.stateStack.push(this.state);
        this.state = (RendererState)this.state.clone();
    }

    private String textXMLSpaceTransform(String string2, boolean bl, boolean bl2) {
        String string3;
        if (this.state.spacePreserve) {
            return string2.replaceAll("[\\n\\t]", " ");
        }
        string2 = string3 = string2.replaceAll("\\n", "").replaceAll("\\t", " ");
        if (bl) {
            string2 = string3.replaceAll("^\\s+", "");
        }
        string3 = string2;
        if (bl2) {
            string3 = string2.replaceAll("\\s+$", "");
        }
        return string3.replaceAll("\\s{2,}", " ");
    }

    private void updateParentBoundingBox(SVG.SvgElement svgElement) {
        if (svgElement.parent == null) {
            return;
        }
        if (svgElement.boundingBox == null) {
            return;
        }
        Matrix matrix = new Matrix();
        if (this.matrixStack.peek().invert(matrix)) {
            Object object = new float[8];
            object[0] = svgElement.boundingBox.minX;
            object[1] = svgElement.boundingBox.minY;
            float f = svgElement.boundingBox.maxX();
            int n = 2;
            object[2] = f;
            object[3] = svgElement.boundingBox.minY;
            object[4] = svgElement.boundingBox.maxX();
            object[5] = svgElement.boundingBox.maxY();
            object[6] = svgElement.boundingBox.minX;
            object[7] = svgElement.boundingBox.maxY();
            matrix.preConcat(this.canvas.getMatrix());
            matrix.mapPoints(object);
            svgElement = new RectF(object[0], object[1], object[0], object[1]);
            while (true) {
                int n2;
                if (n > 6) {
                    object = (SVG.SvgElement)((Object)this.parentStack.peek());
                    if (object.boundingBox == null) {
                        object.boundingBox = SVG.Box.fromLimits(((RectF)svgElement).left, ((RectF)svgElement).top, ((RectF)svgElement).right, ((RectF)svgElement).bottom);
                        break;
                    }
                    object.boundingBox.union(SVG.Box.fromLimits(((RectF)svgElement).left, ((RectF)svgElement).top, ((RectF)svgElement).right, ((RectF)svgElement).bottom));
                    break;
                }
                if (object[n] < ((RectF)svgElement).left) {
                    ((RectF)svgElement).left = object[n];
                }
                if (object[n] > ((RectF)svgElement).right) {
                    ((RectF)svgElement).right = object[n];
                }
                if (object[n2 = n + 1] < ((RectF)svgElement).top) {
                    ((RectF)svgElement).top = object[n2];
                }
                if (object[n2] > ((RectF)svgElement).bottom) {
                    ((RectF)svgElement).bottom = object[n2];
                }
                n += 2;
            }
        }
    }

    private void updateStyle(RendererState rendererState, SVG.Style style2) {
        float f;
        Object object;
        int n;
        if (this.isSpecified(style2, 4096L)) {
            rendererState.style.color = style2.color;
        }
        if (this.isSpecified(style2, 2048L)) {
            rendererState.style.opacity = style2.opacity;
        }
        boolean bl = this.isSpecified(style2, 1L);
        boolean bl2 = false;
        if (bl) {
            rendererState.style.fill = style2.fill;
            bl = style2.fill != null;
            rendererState.hasFill = bl;
        }
        if (this.isSpecified(style2, 4L)) {
            rendererState.style.fillOpacity = style2.fillOpacity;
        }
        if (this.isSpecified(style2, 6149L)) {
            this.setPaintColour(rendererState, true, rendererState.style.fill);
        }
        if (this.isSpecified(style2, 2L)) {
            rendererState.style.fillRule = style2.fillRule;
        }
        if (this.isSpecified(style2, 8L)) {
            rendererState.style.stroke = style2.stroke;
            bl = style2.stroke != null;
            rendererState.hasStroke = bl;
        }
        if (this.isSpecified(style2, 16L)) {
            rendererState.style.strokeOpacity = style2.strokeOpacity;
        }
        if (this.isSpecified(style2, 6168L)) {
            this.setPaintColour(rendererState, false, rendererState.style.stroke);
        }
        if (this.isSpecified(style2, 0x800000000L)) {
            rendererState.style.vectorEffect = style2.vectorEffect;
        }
        if (this.isSpecified(style2, 32L)) {
            rendererState.style.strokeWidth = style2.strokeWidth;
            rendererState.strokePaint.setStrokeWidth(rendererState.style.strokeWidth.floatValue(this));
        }
        if (this.isSpecified(style2, 64L)) {
            rendererState.style.strokeLineCap = style2.strokeLineCap;
            n = SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineCaps()[style2.strokeLineCap.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        rendererState.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
                    }
                } else {
                    rendererState.strokePaint.setStrokeCap(Paint.Cap.ROUND);
                }
            } else {
                rendererState.strokePaint.setStrokeCap(Paint.Cap.BUTT);
            }
        }
        if (this.isSpecified(style2, 128L)) {
            rendererState.style.strokeLineJoin = style2.strokeLineJoin;
            n = SVGAndroidRenderer.$SWITCH_TABLE$com$caverock$androidsvg$SVG$Style$LineJoin()[style2.strokeLineJoin.ordinal()];
            if (n != 1) {
                if (n != 2) {
                    if (n == 3) {
                        rendererState.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
                    }
                } else {
                    rendererState.strokePaint.setStrokeJoin(Paint.Join.ROUND);
                }
            } else {
                rendererState.strokePaint.setStrokeJoin(Paint.Join.MITER);
            }
        }
        if (this.isSpecified(style2, 256L)) {
            rendererState.style.strokeMiterLimit = style2.strokeMiterLimit;
            rendererState.strokePaint.setStrokeMiter(style2.strokeMiterLimit.floatValue());
        }
        if (this.isSpecified(style2, 512L)) {
            rendererState.style.strokeDashArray = style2.strokeDashArray;
        }
        if (this.isSpecified(style2, 1024L)) {
            rendererState.style.strokeDashOffset = style2.strokeDashOffset;
        }
        bl = this.isSpecified(style2, 1536L);
        SVGExternalFileResolver sVGExternalFileResolver = null;
        Object object2 = null;
        if (bl) {
            if (rendererState.style.strokeDashArray == null) {
                rendererState.strokePaint.setPathEffect(null);
            } else {
                int n2 = rendererState.style.strokeDashArray.length;
                n = n2 % 2 == 0 ? n2 : n2 * 2;
                object = new float[n];
                int n3 = 0;
                float f2 = 0.0f;
                while (true) {
                    if (n3 >= n) {
                        float f3;
                        if (f2 == 0.0f) {
                            rendererState.strokePaint.setPathEffect(null);
                            break;
                        }
                        f = f3 = rendererState.style.strokeDashOffset.floatValue(this);
                        if (f3 < 0.0f) {
                            f = f3 % f2 + f2;
                        }
                        rendererState.strokePaint.setPathEffect((PathEffect)new DashPathEffect(object, f));
                        break;
                    }
                    object[n3] = rendererState.style.strokeDashArray[n3 % n2].floatValue(this);
                    f2 += object[n3];
                    ++n3;
                }
            }
        }
        if (this.isSpecified(style2, 16384L)) {
            f = this.getCurrentFontSize();
            rendererState.style.fontSize = style2.fontSize;
            rendererState.fillPaint.setTextSize(style2.fontSize.floatValue(this, f));
            rendererState.strokePaint.setTextSize(style2.fontSize.floatValue(this, f));
        }
        if (this.isSpecified(style2, 8192L)) {
            rendererState.style.fontFamily = style2.fontFamily;
        }
        if (this.isSpecified(style2, 32768L)) {
            if (style2.fontWeight == -1 && rendererState.style.fontWeight > 100) {
                object = rendererState.style;
                object.fontWeight = object.fontWeight - 100;
            } else if (style2.fontWeight == 1 && rendererState.style.fontWeight < 900) {
                object = rendererState.style;
                object.fontWeight = object.fontWeight + 100;
            } else {
                rendererState.style.fontWeight = style2.fontWeight;
            }
        }
        if (this.isSpecified(style2, 65536L)) {
            rendererState.style.fontStyle = style2.fontStyle;
        }
        if (this.isSpecified(style2, 106496L)) {
            object = sVGExternalFileResolver;
            if (rendererState.style.fontFamily != null) {
                Object object3 = this.document;
                object = sVGExternalFileResolver;
                if (object3 != null) {
                    sVGExternalFileResolver = ((SVG)object3).getFileResolver();
                    object3 = rendererState.style.fontFamily.iterator();
                    do {
                        if (!object3.hasNext()) {
                            object = object2;
                            break;
                        }
                        object2 = (String)object3.next();
                        object = this.checkGenericFont((String)object2, rendererState.style.fontWeight, rendererState.style.fontStyle);
                        if (object == null && sVGExternalFileResolver != null) {
                            object = sVGExternalFileResolver.resolveFont((String)object2, rendererState.style.fontWeight, String.valueOf((Object)rendererState.style.fontStyle));
                        }
                        object2 = object;
                    } while (object == null);
                }
            }
            object2 = object;
            if (object == null) {
                object2 = this.checkGenericFont(DEFAULT_FONT_FAMILY, rendererState.style.fontWeight, rendererState.style.fontStyle);
            }
            rendererState.fillPaint.setTypeface((Typeface)object2);
            rendererState.strokePaint.setTypeface((Typeface)object2);
        }
        if (this.isSpecified(style2, 131072L)) {
            rendererState.style.textDecoration = style2.textDecoration;
            object = rendererState.fillPaint;
            bl = style2.textDecoration == SVG.Style.TextDecoration.LineThrough;
            object.setStrikeThruText(bl);
            object = rendererState.fillPaint;
            bl = style2.textDecoration == SVG.Style.TextDecoration.Underline;
            object.setUnderlineText(bl);
            if (Build.VERSION.SDK_INT >= 17) {
                object = rendererState.strokePaint;
                bl = style2.textDecoration == SVG.Style.TextDecoration.LineThrough;
                object.setStrikeThruText(bl);
                object = rendererState.strokePaint;
                bl = bl2;
                if (style2.textDecoration == SVG.Style.TextDecoration.Underline) {
                    bl = true;
                }
                object.setUnderlineText(bl);
            }
        }
        if (this.isSpecified(style2, 0x1000000000L)) {
            rendererState.style.direction = style2.direction;
        }
        if (this.isSpecified(style2, 262144L)) {
            rendererState.style.textAnchor = style2.textAnchor;
        }
        if (this.isSpecified(style2, 524288L)) {
            rendererState.style.overflow = style2.overflow;
        }
        if (this.isSpecified(style2, 0x200000L)) {
            rendererState.style.markerStart = style2.markerStart;
        }
        if (this.isSpecified(style2, 0x400000L)) {
            rendererState.style.markerMid = style2.markerMid;
        }
        if (this.isSpecified(style2, 0x800000L)) {
            rendererState.style.markerEnd = style2.markerEnd;
        }
        if (this.isSpecified(style2, 0x1000000L)) {
            rendererState.style.display = style2.display;
        }
        if (this.isSpecified(style2, 0x2000000L)) {
            rendererState.style.visibility = style2.visibility;
        }
        if (this.isSpecified(style2, 0x100000L)) {
            rendererState.style.clip = style2.clip;
        }
        if (this.isSpecified(style2, 0x10000000L)) {
            rendererState.style.clipPath = style2.clipPath;
        }
        if (this.isSpecified(style2, 0x20000000L)) {
            rendererState.style.clipRule = style2.clipRule;
        }
        if (this.isSpecified(style2, 0x40000000L)) {
            rendererState.style.mask = style2.mask;
        }
        if (this.isSpecified(style2, 0x4000000L)) {
            rendererState.style.stopColor = style2.stopColor;
        }
        if (this.isSpecified(style2, 0x8000000L)) {
            rendererState.style.stopOpacity = style2.stopOpacity;
        }
        if (this.isSpecified(style2, 0x200000000L)) {
            rendererState.style.viewportFill = style2.viewportFill;
        }
        if (this.isSpecified(style2, 0x400000000L)) {
            rendererState.style.viewportFillOpacity = style2.viewportFillOpacity;
        }
    }

    private void updateStyleForElement(RendererState rendererState, SVG.SvgElementBase svgElementBase) {
        boolean bl = svgElementBase.parent == null;
        rendererState.style.resetNonInheritingProperties(bl);
        if (svgElementBase.baseStyle != null) {
            this.updateStyle(rendererState, svgElementBase.baseStyle);
        }
        if (this.document.hasCSSRules()) {
            for (CSSParser.Rule rule : this.document.getCSSRules()) {
                if (!CSSParser.ruleMatch(rule.selector, svgElementBase)) continue;
                this.updateStyle(rendererState, rule.style);
            }
        }
        if (svgElementBase.style != null) {
            this.updateStyle(rendererState, svgElementBase.style);
        }
    }

    private void viewportFill() {
        block6: {
            int n;
            block5: {
                block4: {
                    if (!(this.state.style.viewportFill instanceof SVG.Colour)) break block4;
                    n = ((SVG.Colour)this.state.style.viewportFill).colour;
                    break block5;
                }
                if (!(this.state.style.viewportFill instanceof SVG.CurrentColor)) break block6;
                n = this.state.style.color.colour;
            }
            int n2 = n;
            if (this.state.style.viewportFillOpacity != null) {
                n2 = n | this.clamp255(this.state.style.viewportFillOpacity.floatValue()) << 24;
            }
            this.canvas.drawColor(n2);
        }
    }

    private boolean visible() {
        if (this.state.style.visibility != null) {
            return this.state.style.visibility;
        }
        return true;
    }

    private static void warn(String string2, Object ... objectArray) {
        Log.w((String)TAG, (String)String.format(string2, objectArray));
    }

    protected float getCurrentFontSize() {
        return this.state.fillPaint.getTextSize();
    }

    protected float getCurrentFontXHeight() {
        return this.state.fillPaint.getTextSize() / 2.0f;
    }

    protected SVG.Box getCurrentViewPortInUserUnits() {
        if (this.state.viewBox != null) {
            return this.state.viewBox;
        }
        return this.state.viewPort;
    }

    protected float getDPI() {
        return this.dpi;
    }

    protected void renderDocument(SVG object, SVG.Box box, PreserveAspectRatio preserveAspectRatio, boolean bl) {
        this.document = object;
        this.directRenderingMode = bl;
        if ((object = ((SVG)object).getRootElement()) == null) {
            SVGAndroidRenderer.warn("Nothing to render. Document is empty.", new Object[0]);
            return;
        }
        this.resetState();
        this.checkXMLSpaceAttribute((SVG.SvgObject)object);
        SVG.Length length = ((SVG.Svg)object).width;
        SVG.Length length2 = ((SVG.Svg)object).height;
        if (box == null) {
            box = ((SVG.Svg)object).viewBox;
        }
        if (preserveAspectRatio == null) {
            preserveAspectRatio = ((SVG.Svg)object).preserveAspectRatio;
        }
        this.render((SVG.Svg)object, length, length2, box, preserveAspectRatio);
    }

    private class MarkerPositionCalculator
    implements SVG.PathInterface {
        private boolean closepathReAdjustPending;
        private MarkerVector lastPos = null;
        private List<MarkerVector> markers = new ArrayList<MarkerVector>();
        private boolean normalCubic = true;
        private boolean startArc = false;
        private float startX;
        private float startY;
        private int subpathStartIndex = -1;

        public MarkerPositionCalculator(SVG.PathDefinition pathDefinition) {
            if (pathDefinition == null) {
                return;
            }
            pathDefinition.enumeratePath(this);
            if (this.closepathReAdjustPending) {
                this.lastPos.add(this.markers.get(this.subpathStartIndex));
                this.markers.set(this.subpathStartIndex, this.lastPos);
                this.closepathReAdjustPending = false;
            }
            if ((SVGAndroidRenderer.this = this.lastPos) != null) {
                this.markers.add((MarkerVector)SVGAndroidRenderer.this);
            }
        }

        @Override
        public void arcTo(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
            this.startArc = true;
            this.normalCubic = false;
            SVGAndroidRenderer.arcTo(this.lastPos.x, this.lastPos.y, f, f2, f3, bl, bl2, f4, f5, this);
            this.normalCubic = true;
            this.closepathReAdjustPending = false;
        }

        @Override
        public void close() {
            this.markers.add(this.lastPos);
            this.lineTo(this.startX, this.startY);
            this.closepathReAdjustPending = true;
        }

        @Override
        public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            if (this.normalCubic || this.startArc) {
                this.lastPos.add(f, f2);
                this.markers.add(this.lastPos);
                this.startArc = false;
            }
            this.lastPos = new MarkerVector(f5, f6, f5 - f3, f6 - f4);
            this.closepathReAdjustPending = false;
        }

        public List<MarkerVector> getMarkers() {
            return this.markers;
        }

        @Override
        public void lineTo(float f, float f2) {
            this.lastPos.add(f, f2);
            this.markers.add(this.lastPos);
            this.lastPos = new MarkerVector(f, f2, f - this.lastPos.x, f2 - this.lastPos.y);
            this.closepathReAdjustPending = false;
        }

        @Override
        public void moveTo(float f, float f2) {
            MarkerVector markerVector;
            if (this.closepathReAdjustPending) {
                this.lastPos.add(this.markers.get(this.subpathStartIndex));
                this.markers.set(this.subpathStartIndex, this.lastPos);
                this.closepathReAdjustPending = false;
            }
            if ((markerVector = this.lastPos) != null) {
                this.markers.add(markerVector);
            }
            this.startX = f;
            this.startY = f2;
            this.lastPos = new MarkerVector(f, f2, 0.0f, 0.0f);
            this.subpathStartIndex = this.markers.size();
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.lastPos.add(f, f2);
            this.markers.add(this.lastPos);
            this.lastPos = new MarkerVector(f3, f4, f3 - f, f4 - f2);
            this.closepathReAdjustPending = false;
        }
    }

    private class MarkerVector {
        public float dx = 0.0f;
        public float dy = 0.0f;
        public float x;
        public float y;

        public MarkerVector(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            double d = Math.sqrt(f3 * f3 + f4 * f4);
            if (d != 0.0) {
                this.dx = (float)((double)f3 / d);
                this.dy = (float)((double)f4 / d);
            }
        }

        public void add(float f, float f2) {
            double d;
            if ((d = Math.sqrt((f -= this.x) * f + (f2 -= this.y) * f2)) != 0.0) {
                this.dx += (float)((double)f / d);
                this.dy += (float)((double)f2 / d);
            }
        }

        public void add(MarkerVector markerVector) {
            this.dx += markerVector.dx;
            this.dy += markerVector.dy;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("(");
            stringBuilder.append(this.x);
            stringBuilder.append(",");
            stringBuilder.append(this.y);
            stringBuilder.append(" ");
            stringBuilder.append(this.dx);
            stringBuilder.append(",");
            stringBuilder.append(this.dy);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private class PathConverter
    implements SVG.PathInterface {
        float lastX;
        float lastY;
        Path path = new Path();

        public PathConverter(SVG.PathDefinition pathDefinition) {
            if (pathDefinition == null) {
                return;
            }
            pathDefinition.enumeratePath(this);
        }

        @Override
        public void arcTo(float f, float f2, float f3, boolean bl, boolean bl2, float f4, float f5) {
            SVGAndroidRenderer.arcTo(this.lastX, this.lastY, f, f2, f3, bl, bl2, f4, f5, this);
            this.lastX = f4;
            this.lastY = f5;
        }

        @Override
        public void close() {
            this.path.close();
        }

        @Override
        public void cubicTo(float f, float f2, float f3, float f4, float f5, float f6) {
            this.path.cubicTo(f, f2, f3, f4, f5, f6);
            this.lastX = f5;
            this.lastY = f6;
        }

        public Path getPath() {
            return this.path;
        }

        @Override
        public void lineTo(float f, float f2) {
            this.path.lineTo(f, f2);
            this.lastX = f;
            this.lastY = f2;
        }

        @Override
        public void moveTo(float f, float f2) {
            this.path.moveTo(f, f2);
            this.lastX = f;
            this.lastY = f2;
        }

        @Override
        public void quadTo(float f, float f2, float f3, float f4) {
            this.path.quadTo(f, f2, f3, f4);
            this.lastX = f3;
            this.lastY = f4;
        }
    }

    private class PathTextDrawer
    extends PlainTextDrawer {
        private Path path;

        public PathTextDrawer(Path path, float f, float f2) {
            super(f, f2);
            this.path = path;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(string2, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawTextOnPath(string2, this.path, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class PlainTextDrawer
    extends TextProcessor {
        public float x;
        public float y;

        public PlainTextDrawer(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        @Override
        public void processText(String string2) {
            SVGAndroidRenderer.debug("TextSequence render", new Object[0]);
            if (SVGAndroidRenderer.this.visible()) {
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasFill) {
                    SVGAndroidRenderer.this.canvas.drawText(string2, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint);
                }
                if (((SVGAndroidRenderer)SVGAndroidRenderer.this).state.hasStroke) {
                    SVGAndroidRenderer.this.canvas.drawText(string2, this.x, this.y, ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.strokePaint);
                }
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class PlainTextToPath
    extends TextProcessor {
        public Path textAsPath;
        public float x;
        public float y;

        public PlainTextToPath(float f, float f2, Path path) {
            this.x = f;
            this.y = f2;
            this.textAsPath = path;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer textContainer) {
            if (textContainer instanceof SVG.TextPath) {
                SVGAndroidRenderer.warn("Using <textPath> elements in a clip path is not supported.", new Object[0]);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                Path path = new Path();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextPath(string2, 0, string2.length(), this.x, this.y, path);
                this.textAsPath.addPath(path);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private class RendererState
    implements Cloneable {
        public boolean directRendering;
        public Paint fillPaint;
        public boolean hasFill;
        public boolean hasStroke;
        public boolean spacePreserve;
        public Paint strokePaint;
        public SVG.Style style;
        public SVG.Box viewBox;
        public SVG.Box viewPort;

        public RendererState() {
            SVGAndroidRenderer.this = new Paint();
            this.fillPaint = SVGAndroidRenderer.this;
            SVGAndroidRenderer.this.setFlags(385);
            this.fillPaint.setStyle(Paint.Style.FILL);
            this.fillPaint.setTypeface(Typeface.DEFAULT);
            SVGAndroidRenderer.this = new Paint();
            this.strokePaint = SVGAndroidRenderer.this;
            SVGAndroidRenderer.this.setFlags(385);
            this.strokePaint.setStyle(Paint.Style.STROKE);
            this.strokePaint.setTypeface(Typeface.DEFAULT);
            this.style = SVG.Style.getDefaultStyle();
        }

        protected Object clone() {
            try {
                Paint paint;
                RendererState rendererState = (RendererState)super.clone();
                rendererState.style = (SVG.Style)this.style.clone();
                rendererState.fillPaint = paint = new Paint(this.fillPaint);
                rendererState.strokePaint = paint = new Paint(this.strokePaint);
                return rendererState;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new InternalError(cloneNotSupportedException.toString());
            }
        }
    }

    private class TextBoundsCalculator
    extends TextProcessor {
        RectF bbox;
        float x;
        float y;

        public TextBoundsCalculator(float f, float f2) {
            this.bbox = new RectF();
            this.x = f;
            this.y = f2;
        }

        @Override
        public boolean doTextContainer(SVG.TextContainer svgObject) {
            if (svgObject instanceof SVG.TextPath) {
                SVG.SvgElement svgElement = (SVG.TextPath)svgObject;
                svgObject = svgObject.document.resolveIRI(svgElement.href);
                if (svgObject == null) {
                    SVGAndroidRenderer.error("TextPath path reference '%s' not found", new Object[]{svgElement.href});
                    return false;
                }
                svgElement = (SVG.Path)svgObject;
                svgObject = new PathConverter(((SVG.Path)svgElement).d).getPath();
                if (((SVG.Path)svgElement).transform != null) {
                    svgObject.transform(((SVG.Path)svgElement).transform);
                }
                svgElement = new RectF();
                svgObject.computeBounds((RectF)svgElement, true);
                this.bbox.union((RectF)svgElement);
                return false;
            }
            return true;
        }

        @Override
        public void processText(String string2) {
            if (SVGAndroidRenderer.this.visible()) {
                Rect rect = new Rect();
                ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.getTextBounds(string2, 0, string2.length(), rect);
                rect = new RectF(rect);
                rect.offset(this.x, this.y);
                this.bbox.union((RectF)rect);
            }
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }

    private abstract class TextProcessor {
        private TextProcessor() {
        }

        public boolean doTextContainer(SVG.TextContainer textContainer) {
            return true;
        }

        public abstract void processText(String var1);
    }

    private class TextWidthCalculator
    extends TextProcessor {
        public float x = 0.0f;

        private TextWidthCalculator() {
        }

        @Override
        public void processText(String string2) {
            this.x += ((SVGAndroidRenderer)SVGAndroidRenderer.this).state.fillPaint.measureText(string2);
        }
    }
}

