/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.R;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class SVGImageView
extends ImageView {
    private static Method setLayerTypeMethod;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SVGImageView(Context context) {
        super(context);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVGImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 0);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.init(attributeSet, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVGImageView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        this.init(attributeSet, n);
    }

    private void init(AttributeSet attributeSet, int n) {
        block9: {
            String string2;
            block10: {
                block8: {
                    if (this.isInEditMode()) {
                        return;
                    }
                    attributeSet = this.getContext().getTheme().obtainStyledAttributes(attributeSet, R.styleable.SVGImageView, n, 0);
                    n = attributeSet.getResourceId(0, -1);
                    if (n == -1) break block8;
                    this.setImageResource(n);
                    return;
                }
                string2 = attributeSet.getString(0);
                if (string2 == null) break block9;
                boolean bl = this.internalSetImageURI(Uri.parse((String)string2), false);
                if (!bl) break block10;
                attributeSet.recycle();
                return;
            }
            this.setImageAsset(string2);
        }
        attributeSet.recycle();
        return;
        finally {
            attributeSet.recycle();
        }
    }

    private boolean internalSetImageURI(Uri uri, boolean bl) {
        InputStream inputStream;
        try {
            inputStream = this.getContext().getContentResolver().openInputStream(uri);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (bl) {
                StringBuilder stringBuilder = new StringBuilder("File not found: ");
                stringBuilder.append(uri);
                Log.e((String)"SVGImageView", (String)stringBuilder.toString());
            }
            return false;
        }
        new LoadURITask().execute(new InputStream[]{inputStream});
        return true;
    }

    private void setSoftwareLayerType() {
        if (setLayerTypeMethod == null) {
            return;
        }
        try {
            Field field = View.class.getField("LAYER_TYPE_SOFTWARE");
            View view = new View(this.getContext());
            int n = field.getInt(view);
            setLayerTypeMethod.invoke((Object)this, n, null);
        }
        catch (Exception exception) {
            Log.w((String)"SVGImageView", (String)"Unexpected failure calling setLayerType", (Throwable)exception);
        }
    }

    public void setImageAsset(String string2) {
        new LoadAssetTask().execute(new String[]{string2});
    }

    public void setImageResource(int n) {
        new LoadResourceTask().execute(new Integer[]{n});
    }

    public void setImageURI(Uri uri) {
        this.internalSetImageURI(uri, true);
    }

    public void setSVG(SVG sVG) {
        if (sVG != null) {
            this.setSoftwareLayerType();
            this.setImageDrawable((Drawable)new PictureDrawable(sVG.renderToPicture()));
            return;
        }
        throw new IllegalArgumentException("Null value passed to setSVG()");
    }

    private class LoadAssetTask
    extends AsyncTask<String, Integer, Picture> {
        private LoadAssetTask() {
        }

        protected Picture doInBackground(String ... stringArray) {
            try {
                Picture picture = SVG.getFromAsset(SVGImageView.this.getContext().getAssets(), stringArray[0]).renderToPicture();
                return picture;
            }
            catch (IOException iOException) {
                StringBuilder stringBuilder = new StringBuilder("Unable to load asset file: ");
                stringBuilder.append(stringArray);
                Log.e((String)"SVGImageView", (String)stringBuilder.toString(), (Throwable)iOException);
            }
            catch (FileNotFoundException fileNotFoundException) {
                StringBuilder stringBuilder = new StringBuilder("File not found: ");
                stringBuilder.append(stringArray);
                Log.e((String)"SVGImageView", (String)stringBuilder.toString());
            }
            catch (SVGParseException sVGParseException) {
                StringBuilder stringBuilder = new StringBuilder("Error loading file ");
                stringBuilder.append(stringArray);
                stringBuilder.append(": ");
                stringBuilder.append(sVGParseException.getMessage());
                Log.e((String)"SVGImageView", (String)stringBuilder.toString());
            }
            return null;
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }

    private class LoadResourceTask
    extends AsyncTask<Integer, Integer, Picture> {
        private LoadResourceTask() {
        }

        protected Picture doInBackground(Integer ... integerArray) {
            try {
                Picture picture = SVG.getFromResource(SVGImageView.this.getContext(), (int)integerArray[0]).renderToPicture();
                return picture;
            }
            catch (SVGParseException sVGParseException) {
                Log.e((String)"SVGImageView", (String)String.format("Error loading resource 0x%x: %s", integerArray, sVGParseException.getMessage()));
                return null;
            }
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }

    private class LoadURITask
    extends AsyncTask<InputStream, Integer, Picture> {
        private LoadURITask() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected Picture doInBackground(InputStream ... inputStreamArray) {
            Throwable throwable222222;
            Picture picture = SVG.getFromInputStream(inputStreamArray[0]).renderToPicture();
            try {
                inputStreamArray[0].close();
                return picture;
            }
            catch (IOException iOException) {
                return picture;
            }
            {
                block10: {
                    catch (Throwable throwable222222) {
                        break block10;
                    }
                    catch (SVGParseException sVGParseException) {}
                    {
                        StringBuilder stringBuilder = new StringBuilder("Parse error loading URI: ");
                        stringBuilder.append(sVGParseException.getMessage());
                        Log.e((String)"SVGImageView", (String)stringBuilder.toString());
                    }
                    inputStreamArray[0].close();
                    return null;
                }
                inputStreamArray[0].close();
            }
            catch (IOException iOException) {
                throw throwable222222;
            }
            {
                throw throwable222222;
                catch (IOException iOException) {
                    return null;
                }
            }
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }
}

