/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.graphics.Matrix;
import android.util.Log;
import com.caverock.androidsvg.CSSParser;
import com.caverock.androidsvg.IntegerParser;
import com.caverock.androidsvg.NumberParser;
import com.caverock.androidsvg.PreserveAspectRatio;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DefaultHandler2;

public class SVGParser
extends DefaultHandler2 {
    private static final String CURRENTCOLOR = "currentColor";
    private static final String FEATURE_STRING_PREFIX = "http://www.w3.org/TR/SVG11/feature#";
    private static final String NONE = "none";
    private static final String SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    private static final String TAG = "SVGParser";
    private static final String VALID_DISPLAY_VALUES = "|inline|block|list-item|run-in|compact|marker|table|inline-table|table-row-group|table-header-group|table-footer-group|table-row|table-column-group|table-column|table-cell|table-caption|none|";
    private static final String VALID_VISIBILITY_VALUES = "|visible|hidden|collapse|";
    private static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    private static HashMap<String, PreserveAspectRatio.Alignment> aspectRatioKeywords;
    private static HashMap<String, Integer> colourKeywords;
    private static HashMap<String, SVG.Length> fontSizeKeywords;
    private static HashMap<String, Integer> fontWeightKeywords;
    private SVG.SvgContainer currentElement = null;
    private int ignoreDepth;
    private boolean ignoring = false;
    private boolean inMetadataElement = false;
    private boolean inStyleElement = false;
    private StringBuilder metadataElementContents = null;
    private SVGElem metadataTag = null;
    private StringBuilder styleElementContents = null;
    private HashSet<String> supportedFormats = null;
    private SVG svgDocument = null;

    private void circle(Attributes attributes) throws SAXException {
        this.debug("<circle>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Circle circle = new SVG.Circle();
            circle.document = this.svgDocument;
            circle.parent = this.currentElement;
            this.parseAttributesCore(circle, attributes);
            this.parseAttributesStyle(circle, attributes);
            this.parseAttributesTransform(circle, attributes);
            this.parseAttributesConditional(circle, attributes);
            this.parseAttributesCircle(circle, attributes);
            this.currentElement.addChild(circle);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void clipPath(Attributes attributes) throws SAXException {
        this.debug("<clipPath>", new Object[0]);
        if (this.currentElement != null) {
            SVG.ClipPath clipPath = new SVG.ClipPath();
            clipPath.document = this.svgDocument;
            clipPath.parent = this.currentElement;
            this.parseAttributesCore(clipPath, attributes);
            this.parseAttributesStyle(clipPath, attributes);
            this.parseAttributesTransform(clipPath, attributes);
            this.parseAttributesConditional(clipPath, attributes);
            this.parseAttributesClipPath(clipPath, attributes);
            this.currentElement.addChild(clipPath);
            this.currentElement = clipPath;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void debug(String string2, Object ... objectArray) {
    }

    private void defs(Attributes attributes) throws SAXException {
        this.debug("<defs>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Defs defs = new SVG.Defs();
            defs.document = this.svgDocument;
            defs.parent = this.currentElement;
            this.parseAttributesCore(defs, attributes);
            this.parseAttributesStyle(defs, attributes);
            this.parseAttributesTransform(defs, attributes);
            this.currentElement.addChild(defs);
            this.currentElement = defs;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void dumpNode(SVG.SvgObject object, String charSequence) {
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(charSequence));
        stringBuilder.append(object);
        Log.d((String)TAG, (String)stringBuilder.toString());
        if (object instanceof SVG.SvgConditionalContainer) {
            charSequence = new StringBuilder(String.valueOf(charSequence));
            ((StringBuilder)charSequence).append("  ");
            charSequence = ((StringBuilder)charSequence).toString();
            object = ((SVG.SvgConditionalContainer)object).children.iterator();
            while (object.hasNext()) {
                this.dumpNode((SVG.SvgObject)object.next(), (String)charSequence);
            }
        }
    }

    private void ellipse(Attributes attributes) throws SAXException {
        this.debug("<ellipse>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Ellipse ellipse = new SVG.Ellipse();
            ellipse.document = this.svgDocument;
            ellipse.parent = this.currentElement;
            this.parseAttributesCore(ellipse, attributes);
            this.parseAttributesStyle(ellipse, attributes);
            this.parseAttributesTransform(ellipse, attributes);
            this.parseAttributesConditional(ellipse, attributes);
            this.parseAttributesEllipse(ellipse, attributes);
            this.currentElement.addChild(ellipse);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private static SVG.Style.FontStyle fontStyleKeyword(String string2) {
        if ("italic".equals(string2)) {
            return SVG.Style.FontStyle.Italic;
        }
        if ("normal".equals(string2)) {
            return SVG.Style.FontStyle.Normal;
        }
        if ("oblique".equals(string2)) {
            return SVG.Style.FontStyle.Oblique;
        }
        return null;
    }

    private void g(Attributes attributes) throws SAXException {
        this.debug("<g>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Group group = new SVG.Group();
            group.document = this.svgDocument;
            group.parent = this.currentElement;
            this.parseAttributesCore(group, attributes);
            this.parseAttributesStyle(group, attributes);
            this.parseAttributesTransform(group, attributes);
            this.parseAttributesConditional(group, attributes);
            this.currentElement.addChild(group);
            this.currentElement = group;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void image(Attributes attributes) throws SAXException {
        this.debug("<image>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Image image = new SVG.Image();
            image.document = this.svgDocument;
            image.parent = this.currentElement;
            this.parseAttributesCore(image, attributes);
            this.parseAttributesStyle(image, attributes);
            this.parseAttributesTransform(image, attributes);
            this.parseAttributesConditional(image, attributes);
            this.parseAttributesImage(image, attributes);
            this.currentElement.addChild(image);
            this.currentElement = image;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private static void initialiseAspectRatioKeywordsMap() {
        synchronized (SVGParser.class) {
            HashMap<String, PreserveAspectRatio.Alignment> hashMap = new HashMap<String, PreserveAspectRatio.Alignment>(10);
            aspectRatioKeywords = hashMap;
            hashMap.put(NONE, PreserveAspectRatio.Alignment.None);
            aspectRatioKeywords.put("xMinYMin", PreserveAspectRatio.Alignment.XMinYMin);
            aspectRatioKeywords.put("xMidYMin", PreserveAspectRatio.Alignment.XMidYMin);
            aspectRatioKeywords.put("xMaxYMin", PreserveAspectRatio.Alignment.XMaxYMin);
            aspectRatioKeywords.put("xMinYMid", PreserveAspectRatio.Alignment.XMinYMid);
            aspectRatioKeywords.put("xMidYMid", PreserveAspectRatio.Alignment.XMidYMid);
            aspectRatioKeywords.put("xMaxYMid", PreserveAspectRatio.Alignment.XMaxYMid);
            aspectRatioKeywords.put("xMinYMax", PreserveAspectRatio.Alignment.XMinYMax);
            aspectRatioKeywords.put("xMidYMax", PreserveAspectRatio.Alignment.XMidYMax);
            aspectRatioKeywords.put("xMaxYMax", PreserveAspectRatio.Alignment.XMaxYMax);
            return;
        }
    }

    private static void initialiseColourKeywordsMap() {
        synchronized (SVGParser.class) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
            colourKeywords = hashMap;
            hashMap.put("aliceblue", 0xF0F8FF);
            colourKeywords.put("antiquewhite", 16444375);
            colourKeywords.put("aqua", 65535);
            colourKeywords.put("aquamarine", 8388564);
            colourKeywords.put("azure", 0xF0FFFF);
            colourKeywords.put("beige", 16119260);
            colourKeywords.put("bisque", 16770244);
            colourKeywords.put("black", 0);
            colourKeywords.put("blanchedalmond", 16772045);
            colourKeywords.put("blue", 255);
            colourKeywords.put("blueviolet", 9055202);
            colourKeywords.put("brown", 0xA52A2A);
            colourKeywords.put("burlywood", 14596231);
            colourKeywords.put("cadetblue", 6266528);
            colourKeywords.put("chartreuse", 0x7FFF00);
            colourKeywords.put("chocolate", 13789470);
            colourKeywords.put("coral", 16744272);
            colourKeywords.put("cornflowerblue", 6591981);
            colourKeywords.put("cornsilk", 16775388);
            colourKeywords.put("crimson", 14423100);
            colourKeywords.put("cyan", 65535);
            colourKeywords.put("darkblue", 139);
            colourKeywords.put("darkcyan", 35723);
            colourKeywords.put("darkgoldenrod", 12092939);
            colourKeywords.put("darkgray", 0xA9A9A9);
            colourKeywords.put("darkgreen", 25600);
            colourKeywords.put("darkgrey", 0xA9A9A9);
            colourKeywords.put("darkkhaki", 12433259);
            colourKeywords.put("darkmagenta", 0x8B008B);
            colourKeywords.put("darkolivegreen", 5597999);
            colourKeywords.put("darkorange", 16747520);
            colourKeywords.put("darkorchid", 10040012);
            colourKeywords.put("darkred", 0x8B0000);
            colourKeywords.put("darksalmon", 15308410);
            colourKeywords.put("darkseagreen", 9419919);
            colourKeywords.put("darkslateblue", 4734347);
            colourKeywords.put("darkslategray", 0x2F4F4F);
            colourKeywords.put("darkslategrey", 0x2F4F4F);
            colourKeywords.put("darkturquoise", 52945);
            colourKeywords.put("darkviolet", 9699539);
            colourKeywords.put("deeppink", 16716947);
            colourKeywords.put("deepskyblue", 49151);
            colourKeywords.put("dimgray", 0x696969);
            colourKeywords.put("dimgrey", 0x696969);
            colourKeywords.put("dodgerblue", 2003199);
            colourKeywords.put("firebrick", 0xB22222);
            colourKeywords.put("floralwhite", 0xFFFAF0);
            colourKeywords.put("forestgreen", 0x228B22);
            colourKeywords.put("fuchsia", 0xFF00FF);
            colourKeywords.put("gainsboro", 0xDCDCDC);
            colourKeywords.put("ghostwhite", 0xF8F8FF);
            colourKeywords.put("gold", 16766720);
            colourKeywords.put("goldenrod", 14329120);
            colourKeywords.put("gray", 0x808080);
            colourKeywords.put("green", 32768);
            colourKeywords.put("greenyellow", 11403055);
            colourKeywords.put("grey", 0x808080);
            colourKeywords.put("honeydew", 0xF0FFF0);
            colourKeywords.put("hotpink", 16738740);
            colourKeywords.put("indianred", 0xCD5C5C);
            colourKeywords.put("indigo", 4915330);
            colourKeywords.put("ivory", 0xFFFFF0);
            colourKeywords.put("khaki", 15787660);
            colourKeywords.put("lavender", 15132410);
            colourKeywords.put("lavenderblush", 0xFFF0F5);
            colourKeywords.put("lawngreen", 8190976);
            colourKeywords.put("lemonchiffon", 16775885);
            colourKeywords.put("lightblue", 11393254);
            colourKeywords.put("lightcoral", 0xF08080);
            colourKeywords.put("lightcyan", 0xE0FFFF);
            colourKeywords.put("lightgoldenrodyellow", 16448210);
            colourKeywords.put("lightgray", 0xD3D3D3);
            colourKeywords.put("lightgreen", 0x90EE90);
            colourKeywords.put("lightgrey", 0xD3D3D3);
            colourKeywords.put("lightpink", 16758465);
            colourKeywords.put("lightsalmon", 16752762);
            colourKeywords.put("lightseagreen", 2142890);
            colourKeywords.put("lightskyblue", 8900346);
            colourKeywords.put("lightslategray", 0x778899);
            colourKeywords.put("lightslategrey", 0x778899);
            colourKeywords.put("lightsteelblue", 11584734);
            colourKeywords.put("lightyellow", 0xFFFFE0);
            colourKeywords.put("lime", 65280);
            colourKeywords.put("limegreen", 3329330);
            colourKeywords.put("linen", 16445670);
            colourKeywords.put("magenta", 0xFF00FF);
            colourKeywords.put("maroon", 0x800000);
            colourKeywords.put("mediumaquamarine", 6737322);
            colourKeywords.put("mediumblue", 205);
            colourKeywords.put("mediumorchid", 12211667);
            colourKeywords.put("mediumpurple", 9662683);
            colourKeywords.put("mediumseagreen", 3978097);
            colourKeywords.put("mediumslateblue", 8087790);
            colourKeywords.put("mediumspringgreen", 64154);
            colourKeywords.put("mediumturquoise", 4772300);
            colourKeywords.put("mediumvioletred", 13047173);
            colourKeywords.put("midnightblue", 1644912);
            colourKeywords.put("mintcream", 0xF5FFFA);
            colourKeywords.put("mistyrose", 16770273);
            colourKeywords.put("moccasin", 16770229);
            colourKeywords.put("navajowhite", 16768685);
            colourKeywords.put("navy", 128);
            colourKeywords.put("oldlace", 16643558);
            colourKeywords.put("olive", 0x808000);
            colourKeywords.put("olivedrab", 7048739);
            colourKeywords.put("orange", 16753920);
            colourKeywords.put("orangered", 16729344);
            colourKeywords.put("orchid", 14315734);
            colourKeywords.put("palegoldenrod", 0xEEE8AA);
            colourKeywords.put("palegreen", 10025880);
            colourKeywords.put("paleturquoise", 0xAFEEEE);
            colourKeywords.put("palevioletred", 14381203);
            colourKeywords.put("papayawhip", 16773077);
            colourKeywords.put("peachpuff", 16767673);
            colourKeywords.put("peru", 13468991);
            colourKeywords.put("pink", 16761035);
            colourKeywords.put("plum", 0xDDA0DD);
            colourKeywords.put("powderblue", 11591910);
            colourKeywords.put("purple", 0x800080);
            colourKeywords.put("red", 0xFF0000);
            colourKeywords.put("rosybrown", 12357519);
            colourKeywords.put("royalblue", 4286945);
            colourKeywords.put("saddlebrown", 9127187);
            colourKeywords.put("salmon", 16416882);
            colourKeywords.put("sandybrown", 16032864);
            colourKeywords.put("seagreen", 3050327);
            colourKeywords.put("seashell", 0xFFF5EE);
            colourKeywords.put("sienna", 10506797);
            colourKeywords.put("silver", 0xC0C0C0);
            colourKeywords.put("skyblue", 8900331);
            colourKeywords.put("slateblue", 6970061);
            colourKeywords.put("slategray", 7372944);
            colourKeywords.put("slategrey", 7372944);
            colourKeywords.put("snow", 0xFFFAFA);
            colourKeywords.put("springgreen", 65407);
            colourKeywords.put("steelblue", 4620980);
            colourKeywords.put("tan", 13808780);
            colourKeywords.put("teal", 32896);
            colourKeywords.put("thistle", 14204888);
            colourKeywords.put("tomato", 16737095);
            colourKeywords.put("turquoise", 4251856);
            colourKeywords.put("violet", 0xEE82EE);
            colourKeywords.put("wheat", 16113331);
            colourKeywords.put("white", 0xFFFFFF);
            colourKeywords.put("whitesmoke", 0xF5F5F5);
            colourKeywords.put("yellow", 0xFFFF00);
            colourKeywords.put("yellowgreen", 10145074);
            return;
        }
    }

    private static void initialiseFontSizeKeywordsMap() {
        synchronized (SVGParser.class) {
            Cloneable cloneable = new HashMap(9);
            fontSizeKeywords = cloneable;
            Cloneable cloneable2 = new SVG.Length(0.694f, SVG.Unit.pt);
            ((HashMap)cloneable).put("xx-small", cloneable2);
            cloneable = fontSizeKeywords;
            cloneable2 = new SVG.Length(0.833f, SVG.Unit.pt);
            ((HashMap)cloneable).put("x-small", cloneable2);
            cloneable2 = fontSizeKeywords;
            cloneable = new SVG.Length(10.0f, SVG.Unit.pt);
            ((HashMap)cloneable2).put("small", cloneable);
            cloneable2 = fontSizeKeywords;
            cloneable = new SVG.Length(12.0f, SVG.Unit.pt);
            ((HashMap)cloneable2).put("medium", cloneable);
            cloneable2 = fontSizeKeywords;
            cloneable = new SVG.Length(14.4f, SVG.Unit.pt);
            ((HashMap)cloneable2).put("large", cloneable);
            cloneable = fontSizeKeywords;
            cloneable2 = new SVG.Length(17.3f, SVG.Unit.pt);
            ((HashMap)cloneable).put("x-large", cloneable2);
            cloneable = fontSizeKeywords;
            cloneable2 = new SVG.Length(20.7f, SVG.Unit.pt);
            ((HashMap)cloneable).put("xx-large", cloneable2);
            cloneable2 = fontSizeKeywords;
            cloneable = new SVG.Length(83.33f, SVG.Unit.percent);
            ((HashMap)cloneable2).put("smaller", cloneable);
            cloneable2 = fontSizeKeywords;
            cloneable = new SVG.Length(120.0f, SVG.Unit.percent);
            ((HashMap)cloneable2).put("larger", cloneable);
            return;
        }
    }

    private static void initialiseFontWeightKeywordsMap() {
        synchronized (SVGParser.class) {
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(13);
            fontWeightKeywords = hashMap;
            hashMap.put("normal", 400);
            fontWeightKeywords.put("bold", 700);
            fontWeightKeywords.put("bolder", 1);
            fontWeightKeywords.put("lighter", -1);
            fontWeightKeywords.put("100", 100);
            fontWeightKeywords.put("200", 200);
            fontWeightKeywords.put("300", 300);
            fontWeightKeywords.put("400", 400);
            fontWeightKeywords.put("500", 500);
            fontWeightKeywords.put("600", 600);
            fontWeightKeywords.put("700", 700);
            fontWeightKeywords.put("800", 800);
            fontWeightKeywords.put("900", 900);
            return;
        }
    }

    private void line(Attributes attributes) throws SAXException {
        this.debug("<line>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Line line = new SVG.Line();
            line.document = this.svgDocument;
            line.parent = this.currentElement;
            this.parseAttributesCore(line, attributes);
            this.parseAttributesStyle(line, attributes);
            this.parseAttributesTransform(line, attributes);
            this.parseAttributesConditional(line, attributes);
            this.parseAttributesLine(line, attributes);
            this.currentElement.addChild(line);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void linearGradient(Attributes attributes) throws SAXException {
        this.debug("<linearGradiant>", new Object[0]);
        if (this.currentElement != null) {
            SVG.SvgLinearGradient svgLinearGradient = new SVG.SvgLinearGradient();
            svgLinearGradient.document = this.svgDocument;
            svgLinearGradient.parent = this.currentElement;
            this.parseAttributesCore(svgLinearGradient, attributes);
            this.parseAttributesStyle(svgLinearGradient, attributes);
            this.parseAttributesGradient(svgLinearGradient, attributes);
            this.parseAttributesLinearGradient(svgLinearGradient, attributes);
            this.currentElement.addChild(svgLinearGradient);
            this.currentElement = svgLinearGradient;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void marker(Attributes attributes) throws SAXException {
        this.debug("<marker>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Marker marker = new SVG.Marker();
            marker.document = this.svgDocument;
            marker.parent = this.currentElement;
            this.parseAttributesCore(marker, attributes);
            this.parseAttributesStyle(marker, attributes);
            this.parseAttributesConditional(marker, attributes);
            this.parseAttributesViewBox(marker, attributes);
            this.parseAttributesMarker(marker, attributes);
            this.currentElement.addChild(marker);
            this.currentElement = marker;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void mask(Attributes attributes) throws SAXException {
        this.debug("<mask>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Mask mask = new SVG.Mask();
            mask.document = this.svgDocument;
            mask.parent = this.currentElement;
            this.parseAttributesCore(mask, attributes);
            this.parseAttributesStyle(mask, attributes);
            this.parseAttributesConditional(mask, attributes);
            this.parseAttributesMask(mask, attributes);
            this.currentElement.addChild(mask);
            this.currentElement = mask;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void parseAttributesCircle(SVG.Circle circle, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 7) {
                if (n2 != 8) {
                    if (n2 == 50) {
                        circle.r = SVGParser.parseLength(string2);
                        if (circle.r.isNegative()) {
                            throw new SAXException("Invalid <circle> element. r cannot be negative");
                        }
                    }
                } else {
                    circle.cy = SVGParser.parseLength(string2);
                }
            } else {
                circle.cx = SVGParser.parseLength(string2);
            }
            ++n;
        }
        return;
    }

    private void parseAttributesClipPath(SVG.ClipPath clipPath, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            if (n >= attributes.getLength()) {
                return;
            }
            String string2 = attributes.getValue(n).trim();
            if (SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()] == 4) {
                if ("objectBoundingBox".equals(string2)) {
                    clipPath.clipPathUnitsAreUser = false;
                } else {
                    if (!"userSpaceOnUse".equals(string2)) break;
                    clipPath.clipPathUnitsAreUser = true;
                }
            }
            ++n;
        }
        throw new SAXException("Invalid value for attribute clipPathUnits");
    }

    private void parseAttributesConditional(SVG.SvgConditional svgConditional, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            Object object = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 74) {
                switch (n2) {
                    default: {
                        break;
                    }
                    case 56: {
                        object = SVGParser.parseFontFamily((String)object);
                        HashSet<String> hashSet = object != null ? new HashSet<String>((Collection<String>)object) : new HashSet<String>(0);
                        svgConditional.setRequiredFonts(hashSet);
                        break;
                    }
                    case 55: {
                        svgConditional.setRequiredFormats(SVGParser.parseRequiredFormats((String)object));
                        break;
                    }
                    case 54: {
                        svgConditional.setRequiredExtensions((String)object);
                        break;
                    }
                    case 53: {
                        svgConditional.setRequiredFeatures(SVGParser.parseRequiredFeatures((String)object));
                        break;
                    }
                }
            } else {
                svgConditional.setSystemLanguage(SVGParser.parseSystemLanguage((String)object));
            }
            ++n;
        }
        return;
    }

    private void parseAttributesCore(SVG.SvgElementBase object, Attributes object2) throws SAXException {
        for (int i = 0; i < object2.getLength(); ++i) {
            String string2 = object2.getQName(i);
            if (!string2.equals("id") && !string2.equals("xml:id")) {
                if (!string2.equals("xml:space")) continue;
                if ("default".equals(object2 = object2.getValue(i).trim())) {
                    ((SVG.SvgElementBase)object).spacePreserve = Boolean.FALSE;
                    break;
                }
                if ("preserve".equals(object2)) {
                    ((SVG.SvgElementBase)object).spacePreserve = Boolean.TRUE;
                    break;
                }
                object = new StringBuilder("Invalid value for \"xml:space\" attribute: ");
                ((StringBuilder)object).append((String)object2);
                throw new SAXException(((StringBuilder)object).toString());
            }
            ((SVG.SvgElementBase)object).id = object2.getValue(i).trim();
            break;
        }
    }

    private void parseAttributesEllipse(SVG.Ellipse ellipse, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 7) {
                if (n2 != 8) {
                    if (n2 != 57) {
                        if (n2 == 58) {
                            ellipse.ry = SVGParser.parseLength(string2);
                            if (ellipse.ry.isNegative()) {
                                throw new SAXException("Invalid <ellipse> element. ry cannot be negative");
                            }
                        }
                    } else {
                        ellipse.rx = SVGParser.parseLength(string2);
                        if (ellipse.rx.isNegative()) {
                            throw new SAXException("Invalid <ellipse> element. rx cannot be negative");
                        }
                    }
                } else {
                    ellipse.cy = SVGParser.parseLength(string2);
                }
            } else {
                ellipse.cx = SVGParser.parseLength(string2);
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttributesGradient(SVG.GradientElement gradientElement, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 24) {
                if (n2 != 25) {
                    if (n2 != 27) {
                        if (n2 == 61) {
                            try {
                                gradientElement.spreadMethod = SVG.GradientSpread.valueOf(string2);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                StringBuilder stringBuilder = new StringBuilder("Invalid spreadMethod attribute. \"");
                                stringBuilder.append(string2);
                                stringBuilder.append("\" is not a valid value.");
                                throw new SAXException(stringBuilder.toString());
                            }
                        }
                    } else if (XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                        gradientElement.href = string2;
                    }
                } else if ("objectBoundingBox".equals(string2)) {
                    gradientElement.gradientUnitsAreUser = false;
                } else {
                    if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute gradientUnits");
                    gradientElement.gradientUnitsAreUser = true;
                }
            } else {
                gradientElement.gradientTransform = this.parseTransformList(string2);
            }
            ++n;
        }
        return;
    }

    private void parseAttributesImage(SVG.Image image, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            block12: {
                String string2;
                block9: {
                    block10: {
                        block11: {
                            if (n >= attributes.getLength()) {
                                return;
                            }
                            string2 = attributes.getValue(n).trim();
                            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                            if (n2 == 26) break block9;
                            if (n2 == 27) break block10;
                            if (n2 == 49) break block11;
                            switch (n2) {
                                default: {
                                    break block12;
                                }
                                case 84: {
                                    image.y = SVGParser.parseLength(string2);
                                    break block12;
                                }
                                case 83: {
                                    image.x = SVGParser.parseLength(string2);
                                    break block12;
                                }
                                case 82: {
                                    image.width = SVGParser.parseLength(string2);
                                    if (image.width.isNegative()) {
                                        throw new SAXException("Invalid <use> element. width cannot be negative");
                                    }
                                    break block12;
                                }
                            }
                        }
                        SVGParser.parsePreserveAspectRatio(image, string2);
                        break block12;
                    }
                    if (XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                        image.href = string2;
                    }
                    break block12;
                }
                image.height = SVGParser.parseLength(string2);
                if (image.height.isNegative()) break;
            }
            ++n;
        }
        throw new SAXException("Invalid <use> element. height cannot be negative");
    }

    private void parseAttributesLine(SVG.Line line, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(n))) {
                default: {
                    break;
                }
                case y2: {
                    line.y2 = SVGParser.parseLength(string2);
                    break;
                }
                case x2: {
                    line.x2 = SVGParser.parseLength(string2);
                    break;
                }
                case y1: {
                    line.y1 = SVGParser.parseLength(string2);
                    break;
                }
                case x1: {
                    line.x1 = SVGParser.parseLength(string2);
                }
            }
            ++n;
        }
        return;
    }

    private void parseAttributesLinearGradient(SVG.SvgLinearGradient svgLinearGradient, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            switch (SVGAttr.fromString(attributes.getLocalName(n))) {
                default: {
                    break;
                }
                case y2: {
                    svgLinearGradient.y2 = SVGParser.parseLength(string2);
                    break;
                }
                case x2: {
                    svgLinearGradient.x2 = SVGParser.parseLength(string2);
                    break;
                }
                case y1: {
                    svgLinearGradient.y1 = SVGParser.parseLength(string2);
                    break;
                }
                case x1: {
                    svgLinearGradient.x1 = SVGParser.parseLength(string2);
                }
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttributesMarker(SVG.Marker marker, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            block14: {
                String string2;
                block11: {
                    block12: {
                        block13: {
                            if (n >= attributes.getLength()) {
                                return;
                            }
                            string2 = attributes.getValue(n).trim();
                            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                            if (n2 == 42) break block11;
                            if (n2 == 51) break block12;
                            if (n2 == 52) break block13;
                            switch (n2) {
                                default: {
                                    break block14;
                                }
                                case 35: {
                                    marker.markerWidth = SVGParser.parseLength(string2);
                                    if (marker.markerWidth.isNegative()) {
                                        throw new SAXException("Invalid <marker> element. markerWidth cannot be negative");
                                    }
                                    break block14;
                                }
                                case 34: {
                                    if ("strokeWidth".equals(string2)) {
                                        marker.markerUnitsAreUser = false;
                                    } else {
                                        if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute markerUnits");
                                        marker.markerUnitsAreUser = true;
                                    }
                                    break block14;
                                }
                                case 33: {
                                    marker.markerHeight = SVGParser.parseLength(string2);
                                    if (marker.markerHeight.isNegative()) {
                                        throw new SAXException("Invalid <marker> element. markerHeight cannot be negative");
                                    }
                                    break block14;
                                }
                            }
                        }
                        marker.refY = SVGParser.parseLength(string2);
                        break block14;
                    }
                    marker.refX = SVGParser.parseLength(string2);
                    break block14;
                }
                marker.orient = "auto".equals(string2) ? Float.valueOf(Float.NaN) : Float.valueOf(SVGParser.parseFloat(string2));
            }
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttributesMask(SVG.Mask mask, Attributes attributes) throws SAXException {
        int n = 0;
        Boolean bl = false;
        while (true) {
            block15: {
                String string2;
                block12: {
                    block13: {
                        block14: {
                            if (n >= attributes.getLength()) {
                                return;
                            }
                            string2 = attributes.getValue(n).trim();
                            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                            if (n2 == 26) break block12;
                            if (n2 == 37) break block13;
                            if (n2 == 38) break block14;
                            switch (n2) {
                                default: {
                                    break block15;
                                }
                                case 84: {
                                    mask.y = SVGParser.parseLength(string2);
                                    break block15;
                                }
                                case 83: {
                                    mask.x = SVGParser.parseLength(string2);
                                    break block15;
                                }
                                case 82: {
                                    mask.width = SVGParser.parseLength(string2);
                                    if (mask.width.isNegative()) {
                                        throw new SAXException("Invalid <mask> element. width cannot be negative");
                                    }
                                    break block15;
                                }
                            }
                        }
                        if ("objectBoundingBox".equals(string2)) {
                            mask.maskUnitsAreUser = bl;
                        } else {
                            if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute maskUnits");
                            mask.maskUnitsAreUser = true;
                        }
                        break block15;
                    }
                    if ("objectBoundingBox".equals(string2)) {
                        mask.maskContentUnitsAreUser = bl;
                    } else {
                        if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute maskContentUnits");
                        mask.maskContentUnitsAreUser = true;
                    }
                    break block15;
                }
                mask.height = SVGParser.parseLength(string2);
                if (mask.height.isNegative()) throw new SAXException("Invalid <mask> element. height cannot be negative");
            }
            ++n;
        }
    }

    private void parseAttributesPath(SVG.Path path, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 14) {
                if (n2 == 44) {
                    path.pathLength = Float.valueOf(SVGParser.parseFloat(string2));
                    if (path.pathLength.floatValue() < 0.0f) {
                        throw new SAXException("Invalid <path> element. pathLength cannot be negative");
                    }
                }
            } else {
                path.d = SVGParser.parsePath(string2);
            }
            ++n;
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseAttributesPattern(SVG.Pattern pattern, Attributes attributes) throws SAXException {
        int n = 0;
        Boolean bl = false;
        while (true) {
            block20: {
                String string2;
                block18: {
                    block19: {
                        if (n >= attributes.getLength()) {
                            return;
                        }
                        string2 = attributes.getValue(n).trim();
                        int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                        if (n2 == 26) break block18;
                        if (n2 == 27) break block19;
                        switch (n2) {
                            default: {
                                switch (n2) {
                                    default: {
                                        break block20;
                                    }
                                    case 84: {
                                        pattern.y = SVGParser.parseLength(string2);
                                        break block20;
                                    }
                                    case 83: {
                                        pattern.x = SVGParser.parseLength(string2);
                                        break block20;
                                    }
                                    case 82: {
                                        pattern.width = SVGParser.parseLength(string2);
                                        if (pattern.width.isNegative()) {
                                            throw new SAXException("Invalid <pattern> element. width cannot be negative");
                                        }
                                        break block20;
                                    }
                                }
                            }
                            case 47: {
                                if ("objectBoundingBox".equals(string2)) {
                                    pattern.patternUnitsAreUser = bl;
                                } else {
                                    if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute patternUnits");
                                    pattern.patternUnitsAreUser = true;
                                }
                                break block20;
                            }
                            case 46: {
                                pattern.patternTransform = this.parseTransformList(string2);
                                break block20;
                            }
                            case 45: {
                                if ("objectBoundingBox".equals(string2)) {
                                    pattern.patternContentUnitsAreUser = bl;
                                } else {
                                    if (!"userSpaceOnUse".equals(string2)) throw new SAXException("Invalid value for attribute patternContentUnits");
                                    pattern.patternContentUnitsAreUser = true;
                                }
                                break block20;
                            }
                        }
                    }
                    if (XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                        pattern.href = string2;
                    }
                    break block20;
                }
                pattern.height = SVGParser.parseLength(string2);
                if (pattern.height.isNegative()) throw new SAXException("Invalid <pattern> element. height cannot be negative");
            }
            ++n;
        }
    }

    private void parseAttributesPolyLine(SVG.PolyLine object, Attributes attributes, String string2) throws SAXException {
        int n = 0;
        while (true) {
            block6: {
                if (n >= attributes.getLength()) {
                    return;
                }
                if (SVGAttr.fromString(attributes.getLocalName(n)) == SVGAttr.points) {
                    block7: {
                        Object object2 = new TextScanner(attributes.getValue(n));
                        Object object3 = new ArrayList();
                        ((TextScanner)object2).skipWhitespace();
                        while (true) {
                            if (((TextScanner)object2).empty()) {
                                ((SVG.PolyLine)object).points = new float[object3.size()];
                                object3 = object3.iterator();
                                int n2 = 0;
                                while (object3.hasNext()) {
                                    object2 = (Float)object3.next();
                                    ((SVG.PolyLine)object).points[n2] = ((Float)object2).floatValue();
                                    ++n2;
                                }
                                break block6;
                            }
                            Float f = ((TextScanner)object2).nextFloat();
                            if (f == null) break block7;
                            ((TextScanner)object2).skipCommaWhitespace();
                            Float f2 = ((TextScanner)object2).nextFloat();
                            if (f2 == null) break;
                            ((TextScanner)object2).skipCommaWhitespace();
                            object3.add(f);
                            object3.add(f2);
                        }
                        object = new StringBuilder("Invalid <");
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("> points attribute. There should be an even number of coordinates.");
                        throw new SAXException(((StringBuilder)object).toString());
                    }
                    object = new StringBuilder("Invalid <");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append("> points attribute. Non-coordinate content found in list.");
                    throw new SAXException(((StringBuilder)object).toString());
                }
            }
            ++n;
        }
    }

    private void parseAttributesRadialGradient(SVG.SvgRadialGradient svgRadialGradient, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 7) {
                if (n2 != 8) {
                    if (n2 != 12) {
                        if (n2 != 13) {
                            if (n2 == 50) {
                                svgRadialGradient.r = SVGParser.parseLength(string2);
                                if (svgRadialGradient.r.isNegative()) {
                                    throw new SAXException("Invalid <radialGradient> element. r cannot be negative");
                                }
                            }
                        } else {
                            svgRadialGradient.fy = SVGParser.parseLength(string2);
                        }
                    } else {
                        svgRadialGradient.fx = SVGParser.parseLength(string2);
                    }
                } else {
                    svgRadialGradient.cy = SVGParser.parseLength(string2);
                }
            } else {
                svgRadialGradient.cx = SVGParser.parseLength(string2);
            }
            ++n;
        }
        return;
    }

    private void parseAttributesRect(SVG.Rect rect, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            block13: {
                String string2;
                block10: {
                    block11: {
                        block12: {
                            if (n >= attributes.getLength()) {
                                return;
                            }
                            string2 = attributes.getValue(n).trim();
                            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                            if (n2 == 26) break block10;
                            if (n2 == 57) break block11;
                            if (n2 == 58) break block12;
                            switch (n2) {
                                default: {
                                    break block13;
                                }
                                case 84: {
                                    rect.y = SVGParser.parseLength(string2);
                                    break block13;
                                }
                                case 83: {
                                    rect.x = SVGParser.parseLength(string2);
                                    break block13;
                                }
                                case 82: {
                                    rect.width = SVGParser.parseLength(string2);
                                    if (rect.width.isNegative()) {
                                        throw new SAXException("Invalid <rect> element. width cannot be negative");
                                    }
                                    break block13;
                                }
                            }
                        }
                        rect.ry = SVGParser.parseLength(string2);
                        if (rect.ry.isNegative()) {
                            throw new SAXException("Invalid <rect> element. ry cannot be negative");
                        }
                        break block13;
                    }
                    rect.rx = SVGParser.parseLength(string2);
                    if (rect.rx.isNegative()) {
                        throw new SAXException("Invalid <rect> element. rx cannot be negative");
                    }
                    break block13;
                }
                rect.height = SVGParser.parseLength(string2);
                if (rect.height.isNegative()) break;
            }
            ++n;
        }
        throw new SAXException("Invalid <rect> element. height cannot be negative");
    }

    private void parseAttributesSVG(SVG.Svg svg, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            block10: {
                String string2;
                block8: {
                    block9: {
                        if (n >= attributes.getLength()) {
                            return;
                        }
                        string2 = attributes.getValue(n).trim();
                        int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                        if (n2 == 26) break block8;
                        if (n2 == 80) break block9;
                        switch (n2) {
                            default: {
                                break block10;
                            }
                            case 84: {
                                svg.y = SVGParser.parseLength(string2);
                                break block10;
                            }
                            case 83: {
                                svg.x = SVGParser.parseLength(string2);
                                break block10;
                            }
                            case 82: {
                                svg.width = SVGParser.parseLength(string2);
                                if (svg.width.isNegative()) {
                                    throw new SAXException("Invalid <svg> element. width cannot be negative");
                                }
                                break block10;
                            }
                        }
                    }
                    svg.version = string2;
                    break block10;
                }
                svg.height = SVGParser.parseLength(string2);
                if (svg.height.isNegative()) break;
            }
            ++n;
        }
        throw new SAXException("Invalid <svg> element. height cannot be negative");
    }

    private void parseAttributesStop(SVG.Stop stop, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            if (SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()] == 40) {
                stop.offset = this.parseGradiantOffset(string2);
            }
            ++n;
        }
        return;
    }

    private void parseAttributesStyle(SVG.SvgElementBase svgElementBase, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            if (string2.length() != 0) {
                int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                if (n2 != 1) {
                    if (n2 != 73) {
                        if (svgElementBase.baseStyle == null) {
                            svgElementBase.baseStyle = new SVG.Style();
                        }
                        SVGParser.processStyleProperty(svgElementBase.baseStyle, attributes.getLocalName(n), attributes.getValue(n).trim());
                    } else {
                        SVGParser.parseStyle(svgElementBase, string2);
                    }
                } else {
                    svgElementBase.classNames = CSSParser.parseClassAttribute(string2);
                }
            }
            ++n;
        }
        return;
    }

    private void parseAttributesTRef(SVG.TRef tRef, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            if (SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()] == 27 && XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                tRef.href = string2;
            }
            ++n;
        }
        return;
    }

    private void parseAttributesTextPath(SVG.TextPath textPath, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 27) {
                if (n2 == 62) {
                    textPath.startOffset = SVGParser.parseLength(string2);
                }
            } else if (XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                textPath.href = string2;
            }
            ++n;
        }
        return;
    }

    private void parseAttributesTextPosition(SVG.TextPositionedContainer textPositionedContainer, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 10) {
                if (n2 != 11) {
                    if (n2 != 83) {
                        if (n2 == 84) {
                            textPositionedContainer.y = SVGParser.parseLengthList(string2);
                        }
                    } else {
                        textPositionedContainer.x = SVGParser.parseLengthList(string2);
                    }
                } else {
                    textPositionedContainer.dy = SVGParser.parseLengthList(string2);
                }
            } else {
                textPositionedContainer.dx = SVGParser.parseLengthList(string2);
            }
            ++n;
        }
        return;
    }

    private void parseAttributesTransform(SVG.HasTransform hasTransform, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            if (SVGAttr.fromString(attributes.getLocalName(n)) == SVGAttr.transform) {
                hasTransform.setTransform(this.parseTransformList(attributes.getValue(n)));
            }
            ++n;
        }
        return;
    }

    private void parseAttributesUse(SVG.Use use, Attributes attributes) throws SAXException {
        int n = 0;
        while (true) {
            block11: {
                String string2;
                block9: {
                    block10: {
                        if (n >= attributes.getLength()) {
                            return;
                        }
                        string2 = attributes.getValue(n).trim();
                        int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                        if (n2 == 26) break block9;
                        if (n2 == 27) break block10;
                        switch (n2) {
                            default: {
                                break block11;
                            }
                            case 84: {
                                use.y = SVGParser.parseLength(string2);
                                break block11;
                            }
                            case 83: {
                                use.x = SVGParser.parseLength(string2);
                                break block11;
                            }
                            case 82: {
                                use.width = SVGParser.parseLength(string2);
                                if (use.width.isNegative()) {
                                    throw new SAXException("Invalid <use> element. width cannot be negative");
                                }
                                break block11;
                            }
                        }
                    }
                    if (XLINK_NAMESPACE.equals(attributes.getURI(n))) {
                        use.href = string2;
                    }
                    break block11;
                }
                use.height = SVGParser.parseLength(string2);
                if (use.height.isNegative()) break;
            }
            ++n;
        }
        throw new SAXException("Invalid <use> element. height cannot be negative");
    }

    private void parseAttributesViewBox(SVG.SvgViewBoxContainer svgViewBoxContainer, Attributes attributes) throws SAXException {
        int n = 0;
        while (n < attributes.getLength()) {
            String string2 = attributes.getValue(n).trim();
            int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
            if (n2 != 49) {
                if (n2 == 81) {
                    svgViewBoxContainer.viewBox = SVGParser.parseViewBox(string2);
                }
            } else {
                SVGParser.parsePreserveAspectRatio(svgViewBoxContainer, string2);
            }
            ++n;
        }
        return;
    }

    private void parseCSSStyleSheet(String string2) throws SAXException {
        CSSParser cSSParser = new CSSParser(CSSParser.MediaType.screen);
        this.svgDocument.addCSSRules(cSSParser.parse(string2));
    }

    private static SVG.CSSClipRect parseClip(String string2) throws SAXException {
        if ("auto".equals(string2)) {
            return null;
        }
        if (string2.toLowerCase(Locale.US).startsWith("rect(")) {
            TextScanner textScanner = new TextScanner(string2.substring(5));
            textScanner.skipWhitespace();
            SVG.Length length = SVGParser.parseLengthOrAuto(textScanner);
            textScanner.skipCommaWhitespace();
            SVG.Length length2 = SVGParser.parseLengthOrAuto(textScanner);
            textScanner.skipCommaWhitespace();
            Object object = SVGParser.parseLengthOrAuto(textScanner);
            textScanner.skipCommaWhitespace();
            SVG.Length length3 = SVGParser.parseLengthOrAuto(textScanner);
            textScanner.skipWhitespace();
            if (textScanner.consume(')')) {
                return new SVG.CSSClipRect(length, length2, (SVG.Length)object, length3);
            }
            object = new StringBuilder("Bad rect() clip definition: ");
            ((StringBuilder)object).append(string2);
            throw new SAXException(((StringBuilder)object).toString());
        }
        throw new SAXException("Invalid clip attribute shape. Only rect() is supported.");
    }

    private static SVG.Colour parseColour(String string2) throws SAXException {
        if (string2.charAt(0) == '#') {
            Object object = IntegerParser.parseHex(string2, 1, string2.length());
            if (object != null) {
                int n = ((IntegerParser)object).getEndPos();
                if (n == 7) {
                    return new SVG.Colour(((IntegerParser)object).value());
                }
                if (n == 4) {
                    int n2 = ((IntegerParser)object).value();
                    n = n2 & 0xF00;
                    int n3 = n2 & 0xF0;
                    return new SVG.Colour((n2 &= 0xF) | (n << 12 | n << 16 | n3 << 8 | n3 << 4 | n2 << 4));
                }
                object = new StringBuilder("Bad hex colour value: ");
                ((StringBuilder)object).append(string2);
                throw new SAXException(((StringBuilder)object).toString());
            }
            object = new StringBuilder("Bad hex colour value: ");
            ((StringBuilder)object).append(string2);
            throw new SAXException(((StringBuilder)object).toString());
        }
        if (string2.toLowerCase(Locale.US).startsWith("rgb(")) {
            Object object = new TextScanner(string2.substring(4));
            ((TextScanner)object).skipWhitespace();
            int n = SVGParser.parseColourComponent((TextScanner)object);
            ((TextScanner)object).skipCommaWhitespace();
            int n4 = SVGParser.parseColourComponent((TextScanner)object);
            ((TextScanner)object).skipCommaWhitespace();
            int n5 = SVGParser.parseColourComponent((TextScanner)object);
            ((TextScanner)object).skipWhitespace();
            if (((TextScanner)object).consume(')')) {
                return new SVG.Colour(n << 16 | n4 << 8 | n5);
            }
            object = new StringBuilder("Bad rgb() colour value: ");
            ((StringBuilder)object).append(string2);
            throw new SAXException(((StringBuilder)object).toString());
        }
        return SVGParser.parseColourKeyword(string2);
    }

    private static int parseColourComponent(TextScanner textScanner) throws SAXException {
        float f;
        float f2 = f = textScanner.nextFloat().floatValue();
        if (textScanner.consume('%')) {
            f2 = f * 256.0f / 100.0f;
        }
        int n = f2 < 0.0f ? 0 : (f2 > 255.0f ? 255 : (int)f2);
        return n;
    }

    private static SVG.Colour parseColourKeyword(String string2) throws SAXException {
        Comparable<Integer> comparable;
        if (colourKeywords == null) {
            SVGParser.initialiseColourKeywordsMap();
        }
        if ((comparable = colourKeywords.get(string2.toLowerCase(Locale.US))) != null) {
            return new SVG.Colour((Integer)comparable);
        }
        comparable = new StringBuilder("Invalid colour keyword: ");
        ((StringBuilder)comparable).append(string2);
        throw new SAXException(((StringBuilder)comparable).toString());
    }

    private static SVG.SvgPaint parseColourSpecifer(String string2) throws SAXException {
        if (string2.equals(NONE)) {
            return null;
        }
        if (string2.equals(CURRENTCOLOR)) {
            return SVG.CurrentColor.getInstance();
        }
        return SVGParser.parseColour(string2);
    }

    private static SVG.Style.FillRule parseFillRule(String string2) throws SAXException {
        if ("nonzero".equals(string2)) {
            return SVG.Style.FillRule.NonZero;
        }
        if ("evenodd".equals(string2)) {
            return SVG.Style.FillRule.EvenOdd;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid fill-rule property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static float parseFloat(String string2) throws SAXException {
        int n = string2.length();
        if (n != 0) {
            return SVGParser.parseFloat(string2, 0, n);
        }
        throw new SAXException("Invalid float value (empty string)");
    }

    private static float parseFloat(String string2, int n, int n2) throws SAXException {
        Object object = NumberParser.parseNumber(string2, n, n2);
        if (object != null) {
            return ((NumberParser)object).value();
        }
        object = new StringBuilder("Invalid float value: ");
        ((StringBuilder)object).append(string2);
        throw new SAXException(((StringBuilder)object).toString());
    }

    private static void parseFont(SVG.Style style2, String object) throws SAXException {
        block10: {
            Object object2;
            Object object3;
            String string2;
            Object object4 = new StringBuilder(String.valueOf('|'));
            ((StringBuilder)object4).append((String)object);
            ((StringBuilder)object4).append('|');
            if ("|caption|icon|menu|message-box|small-caption|status-bar|".indexOf(((StringBuilder)object4).toString()) != -1) {
                return;
            }
            TextScanner textScanner = new TextScanner((String)object);
            object = null;
            object4 = null;
            CharSequence charSequence = object4;
            while (true) {
                string2 = textScanner.nextToken('/');
                textScanner.skipWhitespace();
                if (string2 == null) break block10;
                if (object != null && object4 != null) {
                    object3 = object;
                    break;
                }
                if (string2.equals("normal")) continue;
                object2 = object;
                if (object == null) {
                    object2 = object = fontWeightKeywords.get(string2);
                    if (object != null) continue;
                }
                object = object4;
                if (object4 == null) {
                    object = object4 = SVGParser.fontStyleKeyword(string2);
                    if (object4 != null) {
                        object = object2;
                        continue;
                    }
                }
                object4 = object;
                object3 = object2;
                if (charSequence != null) break;
                object4 = object;
                object3 = object2;
                if (!string2.equals("small-caps")) break;
                charSequence = string2;
                object4 = object;
                object = object2;
            }
            object2 = SVGParser.parseFontSize(string2);
            if (textScanner.consume('/')) {
                textScanner.skipWhitespace();
                object = textScanner.nextToken();
                if (object != null) {
                    SVGParser.parseLength((String)object);
                    textScanner.skipWhitespace();
                } else {
                    throw new SAXException("Invalid font style attribute: missing line-height");
                }
            }
            style2.fontFamily = SVGParser.parseFontFamily(textScanner.restOfText());
            style2.fontSize = object2;
            int n = object3 == null ? 400 : (Integer)object3;
            style2.fontWeight = n;
            object = object4;
            if (object4 == null) {
                object = SVG.Style.FontStyle.Normal;
            }
            style2.fontStyle = object;
            style2.specifiedFlags |= 0x1E000L;
            return;
        }
        throw new SAXException("Invalid font style attribute: missing font size and family");
    }

    private static List<String> parseFontFamily(String object) throws SAXException {
        block3: {
            Object object2;
            TextScanner textScanner = new TextScanner((String)object);
            object = null;
            do {
                object2 = textScanner.nextQuotedString();
                String string2 = object2;
                if (object2 == null) {
                    string2 = textScanner.nextToken(',');
                }
                if (string2 == null) break block3;
                object2 = object;
                if (object == null) {
                    object2 = new ArrayList();
                }
                object2.add(string2);
                textScanner.skipCommaWhitespace();
                object = object2;
            } while (!textScanner.empty());
            object = object2;
        }
        return object;
    }

    private static SVG.Length parseFontSize(String string2) throws SAXException {
        SVG.Length length;
        if (fontSizeKeywords == null) {
            SVGParser.initialiseFontSizeKeywordsMap();
        }
        SVG.Length length2 = length = fontSizeKeywords.get(string2);
        if (length == null) {
            length2 = SVGParser.parseLength(string2);
        }
        return length2;
    }

    private static SVG.Style.FontStyle parseFontStyle(String string2) throws SAXException {
        Object object = SVGParser.fontStyleKeyword(string2);
        if (object != null) {
            return object;
        }
        object = new StringBuilder("Invalid font-style property: ");
        ((StringBuilder)object).append(string2);
        throw new SAXException(((StringBuilder)object).toString());
    }

    private static Integer parseFontWeight(String string2) throws SAXException {
        Comparable<Integer> comparable;
        if (fontWeightKeywords == null) {
            SVGParser.initialiseFontWeightKeywordsMap();
        }
        if ((comparable = fontWeightKeywords.get(string2)) != null) {
            return comparable;
        }
        comparable = new StringBuilder("Invalid font-weight property: ");
        ((StringBuilder)comparable).append(string2);
        throw new SAXException(((StringBuilder)comparable).toString());
    }

    private static String parseFunctionalIRI(String charSequence, String string2) throws SAXException {
        if (((String)charSequence).equals(NONE)) {
            return null;
        }
        if (((String)charSequence).startsWith("url(") && ((String)charSequence).endsWith(")")) {
            return ((String)charSequence).substring(4, ((String)charSequence).length() - 1).trim();
        }
        charSequence = new StringBuilder("Bad ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(" attribute. Expected \"none\" or \"url()\" format");
        throw new SAXException(((StringBuilder)charSequence).toString());
    }

    private Float parseGradiantOffset(String string2) throws SAXException {
        if (string2.length() != 0) {
            float f;
            float f2;
            block8: {
                int n = string2.length();
                int n2 = string2.length();
                boolean bl = true;
                if (string2.charAt(n2 - 1) == '%') {
                    --n;
                } else {
                    bl = false;
                }
                try {
                    float f3 = SVGParser.parseFloat(string2, 0, n);
                    f2 = 100.0f;
                    f = f3;
                    if (!bl) break block8;
                    f = f3 / 100.0f;
                }
                catch (NumberFormatException numberFormatException) {
                    StringBuilder stringBuilder = new StringBuilder("Invalid offset value in <stop>: ");
                    stringBuilder.append(string2);
                    throw new SAXException(stringBuilder.toString(), numberFormatException);
                }
            }
            if (f < 0.0f) {
                f = 0.0f;
            } else if (f > 100.0f) {
                f = f2;
            }
            return Float.valueOf(f);
        }
        throw new SAXException("Invalid offset value in <stop> (empty string)");
    }

    protected static SVG.Length parseLength(String string2) throws SAXException {
        if (string2.length() != 0) {
            Object object;
            int n;
            int n2 = string2.length();
            SVG.Unit unit = SVG.Unit.px;
            char c = string2.charAt(n2 - 1);
            if (c == '%') {
                n = n2 - 1;
                object = SVG.Unit.percent;
            } else {
                n = n2;
                object = unit;
                if (n2 > 2) {
                    n = n2;
                    object = unit;
                    if (Character.isLetter(c)) {
                        n = n2;
                        object = unit;
                        if (Character.isLetter(string2.charAt(n2 - 2))) {
                            n = n2 - 2;
                            object = string2.substring(n);
                            try {
                                object = SVG.Unit.valueOf(((String)object).toLowerCase(Locale.US));
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                StringBuilder stringBuilder = new StringBuilder("Invalid length unit specifier: ");
                                stringBuilder.append(string2);
                                throw new SAXException(stringBuilder.toString());
                            }
                        }
                    }
                }
            }
            try {
                object = new SVG.Length(SVGParser.parseFloat(string2, 0, n), (SVG.Unit)((Object)object));
                return object;
            }
            catch (NumberFormatException numberFormatException) {
                object = new StringBuilder("Invalid length value: ");
                ((StringBuilder)object).append(string2);
                throw new SAXException(((StringBuilder)object).toString(), numberFormatException);
            }
        }
        throw new SAXException("Invalid length value (empty string)");
    }

    private static List<SVG.Length> parseLengthList(String object) throws SAXException {
        if (((String)object).length() != 0) {
            ArrayList<SVG.Length> arrayList = new ArrayList<SVG.Length>(1);
            TextScanner textScanner = new TextScanner((String)object);
            textScanner.skipWhitespace();
            while (true) {
                if (textScanner.empty()) {
                    return arrayList;
                }
                Float f = textScanner.nextFloat();
                if (f == null) break;
                SVG.Unit unit = textScanner.nextUnit();
                object = unit;
                if (unit == null) {
                    object = SVG.Unit.px;
                }
                arrayList.add(new SVG.Length(f.floatValue(), (SVG.Unit)((Object)object)));
                textScanner.skipCommaWhitespace();
            }
            object = new StringBuilder("Invalid length list value: ");
            ((StringBuilder)object).append(textScanner.ahead());
            throw new SAXException(((StringBuilder)object).toString());
        }
        throw new SAXException("Invalid length list (empty string)");
    }

    private static SVG.Length parseLengthOrAuto(TextScanner textScanner) {
        if (textScanner.consume("auto")) {
            return new SVG.Length(0.0f);
        }
        return textScanner.nextLength();
    }

    private static float parseOpacity(String string2) throws SAXException {
        float f;
        float f2 = SVGParser.parseFloat(string2);
        if (f2 < 0.0f) {
            f = 0.0f;
        } else {
            f = f2;
            if (f2 > 1.0f) {
                f = 1.0f;
            }
        }
        return f;
    }

    private static Boolean parseOverflow(String string2) throws SAXException {
        if (!"visible".equals(string2) && !"auto".equals(string2)) {
            if (!"hidden".equals(string2) && !"scroll".equals(string2)) {
                StringBuilder stringBuilder = new StringBuilder("Invalid toverflow property: ");
                stringBuilder.append(string2);
                throw new SAXException(stringBuilder.toString());
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static SVG.SvgPaint parsePaintSpecifier(String object, String string2) throws SAXException {
        if (((String)object).startsWith("url(")) {
            int n = ((String)object).indexOf(")");
            if (n != -1) {
                String string3 = ((String)object).substring(4, n).trim();
                string2 = null;
                String string4 = ((String)object).substring(n + 1).trim();
                object = string2;
                if (string4.length() > 0) {
                    object = SVGParser.parseColourSpecifer(string4);
                }
                return new SVG.PaintReference(string3, (SVG.SvgPaint)object);
            }
            object = new StringBuilder("Bad ");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" attribute. Unterminated url() reference");
            throw new SAXException(((StringBuilder)object).toString());
        }
        return SVGParser.parseColourSpecifer((String)object);
    }

    /*
     * Unable to fully structure code
     */
    private static SVG.PathDefinition parsePath(String var0) throws SAXException {
        var1_1 = new TextScanner((String)var0);
        var2_2 = new SVG.PathDefinition();
        if (var1_1.empty()) {
            return var2_2;
        }
        var3_3 = var1_1.nextChar();
        if (var3_3 != 77 && var3_3 != 109) {
            return var2_2;
        }
        var4_4 = 0.0f;
        var5_5 = 0.0f;
        var6_6 = 0.0f;
        var7_7 = 0.0f;
        var8_8 = 0.0f;
        var9_9 = 0.0f;
        block12: while (true) {
            var1_1.skipWhitespace();
            var10_10 = 108;
            block0 : switch (var3_3) {
                default: {
                    return var2_2;
                }
                case 90: 
                case 122: {
                    var2_2.close();
                    var5_5 = var4_4 = var8_8;
                    var6_6 = var9_9;
lbl24:
                    // 3 sources

                    while (true) {
                        var7_7 = var6_6;
                        break block0;
                        break;
                    }
                }
                case 86: 
                case 118: {
                    var11_11 = var1_1.nextFloat();
                    if (var11_11 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var0 = var11_11;
                    if (var3_3 == 118) {
                        var0 = Float.valueOf(var11_11.floatValue() + var6_6);
                    }
                    var2_2.lineTo(var4_4, var0.floatValue());
                    var6_6 = var0.floatValue();
                    ** GOTO lbl24
                }
                case 84: 
                case 116: {
                    var12_12 = Float.valueOf(var4_4 * 2.0f - var5_5);
                    var13_13 = Float.valueOf(2.0f * var6_6 - var7_7);
                    var14_14 = var1_1.nextFloat();
                    var15_15 = var1_1.checkedNextFloat(var14_14);
                    if (var15_15 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var11_11 = var14_14;
                    var0 = var15_15;
                    if (var3_3 == 116) {
                        var11_11 = Float.valueOf(var14_14.floatValue() + var4_4);
                        var0 = Float.valueOf(var15_15.floatValue() + var6_6);
                    }
                    var2_2.quadTo(var12_12.floatValue(), var13_13.floatValue(), var11_11.floatValue(), var0.floatValue());
                    var5_5 = var12_12.floatValue();
                    var7_7 = var13_13.floatValue();
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    break;
                }
                case 83: 
                case 115: {
                    var12_12 = var1_1.nextFloat();
                    var13_13 = var1_1.checkedNextFloat(var12_12);
                    var16_16 = var1_1.checkedNextFloat(var13_13);
                    var17_17 = var1_1.checkedNextFloat(var16_16);
                    if (var17_17 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var14_14 = var12_12;
                    var15_15 = var13_13;
                    var11_11 = var16_16;
                    var0 = var17_17;
                    if (var3_3 == 115) {
                        var11_11 = Float.valueOf(var16_16.floatValue() + var4_4);
                        var0 = Float.valueOf(var17_17.floatValue() + var6_6);
                        var14_14 = Float.valueOf(var12_12.floatValue() + var4_4);
                        var15_15 = Float.valueOf(var13_13.floatValue() + var6_6);
                    }
                    var2_2.cubicTo(Float.valueOf(var4_4 * 2.0f - var5_5).floatValue(), Float.valueOf(2.0f * var6_6 - var7_7).floatValue(), var14_14.floatValue(), var15_15.floatValue(), var11_11.floatValue(), var0.floatValue());
                    var5_5 = var14_14.floatValue();
                    var7_7 = var15_15.floatValue();
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    break;
                }
                case 81: 
                case 113: {
                    var12_12 = var1_1.nextFloat();
                    var13_13 = var1_1.checkedNextFloat(var12_12);
                    var16_16 = var1_1.checkedNextFloat(var13_13);
                    var17_17 = var1_1.checkedNextFloat(var16_16);
                    if (var17_17 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var14_14 = var12_12;
                    var15_15 = var13_13;
                    var11_11 = var16_16;
                    var0 = var17_17;
                    if (var3_3 == 113) {
                        var11_11 = Float.valueOf(var16_16.floatValue() + var4_4);
                        var0 = Float.valueOf(var17_17.floatValue() + var6_6);
                        var14_14 = Float.valueOf(var12_12.floatValue() + var4_4);
                        var15_15 = Float.valueOf(var13_13.floatValue() + var6_6);
                    }
                    var2_2.quadTo(var14_14.floatValue(), var15_15.floatValue(), var11_11.floatValue(), var0.floatValue());
                    var5_5 = var14_14.floatValue();
                    var7_7 = var15_15.floatValue();
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    break;
                }
                case 77: 
                case 109: {
                    var14_14 = var1_1.nextFloat();
                    var15_15 = var1_1.checkedNextFloat(var14_14);
                    if (var15_15 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var11_11 = var14_14;
                    var0 = var15_15;
                    if (var3_3 == 109) {
                        var11_11 = var14_14;
                        var0 = var15_15;
                        if (!var2_2.isEmpty()) {
                            var11_11 = Float.valueOf(var14_14.floatValue() + var4_4);
                            var0 = Float.valueOf(var15_15.floatValue() + var6_6);
                        }
                    }
                    var2_2.moveTo(var11_11.floatValue(), var0.floatValue());
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    var3_3 = var3_3 == 109 ? var10_10 : 76;
                    var8_8 = var5_5 = var4_4;
                    var9_9 = var7_7 = var6_6;
                    break;
                }
                case 76: 
                case 108: {
                    var14_14 = var1_1.nextFloat();
                    var15_15 = var1_1.checkedNextFloat(var14_14);
                    if (var15_15 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var11_11 = var14_14;
                    var0 = var15_15;
                    if (var3_3 == 108) {
                        var11_11 = Float.valueOf(var14_14.floatValue() + var4_4);
                        var0 = Float.valueOf(var15_15.floatValue() + var6_6);
                    }
                    var2_2.lineTo(var11_11.floatValue(), var0.floatValue());
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    var5_5 = var4_4;
                    ** continue;
                }
                case 72: 
                case 104: {
                    var11_11 = var1_1.nextFloat();
                    if (var11_11 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var0 = var11_11;
                    if (var3_3 == 104) {
                        var0 = Float.valueOf(var11_11.floatValue() + var4_4);
                    }
                    var2_2.lineTo(var0.floatValue(), var6_6);
                    var5_5 = var4_4 = var0.floatValue();
                    break;
                }
                case 67: 
                case 99: {
                    var18_18 = var1_1.nextFloat();
                    var19_19 = var1_1.checkedNextFloat(var18_18);
                    var16_16 = var1_1.checkedNextFloat(var19_19);
                    var17_17 = var1_1.checkedNextFloat(var16_16);
                    var20_20 = var1_1.checkedNextFloat(var17_17);
                    var21_21 = var1_1.checkedNextFloat(var20_20);
                    if (var21_21 == null) {
                        var0 = new StringBuilder("Bad path coords for ");
                        var0.append((char)var3_3);
                        var0.append(" path segment");
                        Log.e((String)"SVGParser", (String)var0.toString());
                        return var2_2;
                    }
                    var12_12 = var18_18;
                    var13_13 = var19_19;
                    var14_14 = var16_16;
                    var15_15 = var17_17;
                    var11_11 = var20_20;
                    var0 = var21_21;
                    if (var3_3 == 99) {
                        var11_11 = Float.valueOf(var20_20.floatValue() + var4_4);
                        var0 = Float.valueOf(var21_21.floatValue() + var6_6);
                        var12_12 = Float.valueOf(var18_18.floatValue() + var4_4);
                        var13_13 = Float.valueOf(var19_19.floatValue() + var6_6);
                        var14_14 = Float.valueOf(var16_16.floatValue() + var4_4);
                        var15_15 = Float.valueOf(var17_17.floatValue() + var6_6);
                    }
                    var2_2.cubicTo(var12_12.floatValue(), var13_13.floatValue(), var14_14.floatValue(), var15_15.floatValue(), var11_11.floatValue(), var0.floatValue());
                    var5_5 = var14_14.floatValue();
                    var7_7 = var15_15.floatValue();
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    break;
                }
                case 65: 
                case 97: {
                    var12_12 = var1_1.nextFloat();
                    var17_17 = var1_1.checkedNextFloat(var12_12);
                    var16_16 = var1_1.checkedNextFloat(var17_17);
                    var19_19 = var1_1.checkedNextFlag(var16_16);
                    var13_13 = var1_1.checkedNextFlag(var19_19);
                    var14_14 = var1_1.checkedNextFloat(var13_13);
                    var15_15 = var1_1.checkedNextFloat(var14_14);
                    if (var15_15 == null || var12_12.floatValue() < 0.0f || var17_17.floatValue() < 0.0f) break block12;
                    var11_11 = var14_14;
                    var0 = var15_15;
                    if (var3_3 == 97) {
                        var11_11 = Float.valueOf(var14_14.floatValue() + var4_4);
                        var0 = Float.valueOf(var15_15.floatValue() + var6_6);
                    }
                    var2_2.arcTo(var12_12.floatValue(), var17_17.floatValue(), var16_16.floatValue(), var19_19.booleanValue(), var13_13.booleanValue(), var11_11.floatValue(), var0.floatValue());
                    var4_4 = var11_11.floatValue();
                    var6_6 = var0.floatValue();
                    var5_5 = var4_4;
                    var7_7 = var6_6;
                }
            }
            var1_1.skipCommaWhitespace();
            if (var1_1.empty()) {
                return var2_2;
            }
            if (!var1_1.hasLetter()) continue;
            var3_3 = var1_1.nextChar();
        }
        var0 = new StringBuilder("Bad path coords for ");
        var0.append((char)var3_3);
        var0.append(" path segment");
        Log.e((String)"SVGParser", (String)var0.toString());
        return var2_2;
    }

    private static void parsePreserveAspectRatio(SVG.SvgPreserveAspectRatioContainer object, String string2) throws SAXException {
        Object object2;
        if (aspectRatioKeywords == null) {
            SVGParser.initialiseAspectRatioKeywordsMap();
        }
        TextScanner textScanner = new TextScanner(string2);
        textScanner.skipWhitespace();
        Object var3_3 = null;
        Object object3 = object2 = textScanner.nextToken();
        if ("defer".equals(object2)) {
            textScanner.skipWhitespace();
            object3 = textScanner.nextToken();
        }
        object2 = aspectRatioKeywords.get(object3);
        textScanner.skipWhitespace();
        object3 = var3_3;
        if (!textScanner.empty()) {
            object3 = textScanner.nextToken();
            if (object3.equals("meet")) {
                object3 = PreserveAspectRatio.Scale.Meet;
            } else if (object3.equals("slice")) {
                object3 = PreserveAspectRatio.Scale.Slice;
            } else {
                object = new StringBuilder("Invalid preserveAspectRatio definition: ");
                ((StringBuilder)object).append(string2);
                throw new SAXException(((StringBuilder)object).toString());
            }
        }
        ((SVG.SvgPreserveAspectRatioContainer)object).preserveAspectRatio = new PreserveAspectRatio((PreserveAspectRatio.Alignment)((Object)object2), (PreserveAspectRatio.Scale)((Object)object3));
    }

    private static Set<String> parseRequiredFeatures(String string2) throws SAXException {
        TextScanner textScanner = new TextScanner(string2);
        HashSet<String> hashSet = new HashSet<String>();
        while (!textScanner.empty()) {
            string2 = textScanner.nextToken();
            if (string2.startsWith(FEATURE_STRING_PREFIX)) {
                hashSet.add(string2.substring(35));
            } else {
                hashSet.add("UNSUPPORTED");
            }
            textScanner.skipWhitespace();
        }
        return hashSet;
    }

    private static Set<String> parseRequiredFormats(String object) throws SAXException {
        TextScanner textScanner = new TextScanner((String)object);
        object = new HashSet();
        while (!textScanner.empty()) {
            ((HashSet)object).add(textScanner.nextToken());
            textScanner.skipWhitespace();
        }
        return object;
    }

    private static SVG.Length[] parseStrokeDashArray(String string2) throws SAXException {
        Object object = new TextScanner(string2);
        ((TextScanner)object).skipWhitespace();
        if (((TextScanner)object).empty()) {
            return null;
        }
        SVG.Length length = ((TextScanner)object).nextLength();
        if (length == null) {
            return null;
        }
        if (!length.isNegative()) {
            block6: {
                float f = length.floatValue();
                ArrayList<SVG.Length> arrayList = new ArrayList<SVG.Length>();
                arrayList.add(length);
                while (true) {
                    if (((TextScanner)object).empty()) {
                        if (f == 0.0f) {
                            return null;
                        }
                        return arrayList.toArray(new SVG.Length[arrayList.size()]);
                    }
                    ((TextScanner)object).skipCommaWhitespace();
                    length = ((TextScanner)object).nextLength();
                    if (length == null) break block6;
                    if (length.isNegative()) break;
                    arrayList.add(length);
                    f += length.floatValue();
                }
                object = new StringBuilder("Invalid stroke-dasharray. Dash segemnts cannot be negative: ");
                ((StringBuilder)object).append(string2);
                throw new SAXException(((StringBuilder)object).toString());
            }
            object = new StringBuilder("Invalid stroke-dasharray. Non-Length content found: ");
            ((StringBuilder)object).append(string2);
            throw new SAXException(((StringBuilder)object).toString());
        }
        object = new StringBuilder("Invalid stroke-dasharray. Dash segemnts cannot be negative: ");
        ((StringBuilder)object).append(string2);
        throw new SAXException(((StringBuilder)object).toString());
    }

    private static SVG.Style.LineCaps parseStrokeLineCap(String string2) throws SAXException {
        if ("butt".equals(string2)) {
            return SVG.Style.LineCaps.Butt;
        }
        if ("round".equals(string2)) {
            return SVG.Style.LineCaps.Round;
        }
        if ("square".equals(string2)) {
            return SVG.Style.LineCaps.Square;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid stroke-linecap property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static SVG.Style.LineJoin parseStrokeLineJoin(String string2) throws SAXException {
        if ("miter".equals(string2)) {
            return SVG.Style.LineJoin.Miter;
        }
        if ("round".equals(string2)) {
            return SVG.Style.LineJoin.Round;
        }
        if ("bevel".equals(string2)) {
            return SVG.Style.LineJoin.Bevel;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid stroke-linejoin property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static void parseStyle(SVG.SvgElementBase svgElementBase, String object) throws SAXException {
        object = new TextScanner(((String)object).replaceAll("/\\*.*?\\*/", ""));
        while (true) {
            String string2;
            String string3;
            block6: {
                block5: {
                    string3 = ((TextScanner)object).nextToken(':');
                    ((TextScanner)object).skipWhitespace();
                    if (!((TextScanner)object).consume(':')) break block5;
                    ((TextScanner)object).skipWhitespace();
                    string2 = ((TextScanner)object).nextToken(';');
                    if (string2 != null) break block6;
                }
                return;
            }
            ((TextScanner)object).skipWhitespace();
            if (!((TextScanner)object).empty() && !((TextScanner)object).consume(';')) continue;
            if (svgElementBase.style == null) {
                svgElementBase.style = new SVG.Style();
            }
            SVGParser.processStyleProperty(svgElementBase.style, string3, string2);
            ((TextScanner)object).skipWhitespace();
        }
    }

    private static Set<String> parseSystemLanguage(String string2) throws SAXException {
        TextScanner textScanner = new TextScanner(string2);
        HashSet<String> hashSet = new HashSet<String>();
        while (!textScanner.empty()) {
            String string3 = textScanner.nextToken();
            int n = string3.indexOf(45);
            string2 = string3;
            if (n != -1) {
                string2 = string3.substring(0, n);
            }
            hashSet.add(new Locale(string2, "", "").getLanguage());
            textScanner.skipWhitespace();
        }
        return hashSet;
    }

    private static SVG.Style.TextAnchor parseTextAnchor(String string2) throws SAXException {
        if ("start".equals(string2)) {
            return SVG.Style.TextAnchor.Start;
        }
        if ("middle".equals(string2)) {
            return SVG.Style.TextAnchor.Middle;
        }
        if ("end".equals(string2)) {
            return SVG.Style.TextAnchor.End;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid text-anchor property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static SVG.Style.TextDecoration parseTextDecoration(String string2) throws SAXException {
        if (NONE.equals(string2)) {
            return SVG.Style.TextDecoration.None;
        }
        if ("underline".equals(string2)) {
            return SVG.Style.TextDecoration.Underline;
        }
        if ("overline".equals(string2)) {
            return SVG.Style.TextDecoration.Overline;
        }
        if ("line-through".equals(string2)) {
            return SVG.Style.TextDecoration.LineThrough;
        }
        if ("blink".equals(string2)) {
            return SVG.Style.TextDecoration.Blink;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid text-decoration property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static SVG.Style.TextDirection parseTextDirection(String string2) throws SAXException {
        if ("ltr".equals(string2)) {
            return SVG.Style.TextDirection.LTR;
        }
        if ("rtl".equals(string2)) {
            return SVG.Style.TextDirection.RTL;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid direction property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    /*
     * Enabled aggressive block sorting
     */
    private Matrix parseTransformList(String charSequence) throws SAXException {
        Matrix matrix = new Matrix();
        Object object = new TextScanner((String)charSequence);
        ((TextScanner)object).skipWhitespace();
        while (true) {
            block27: {
                Object object2;
                block30: {
                    Float f;
                    Float f2;
                    block29: {
                        block28: {
                            if (((TextScanner)object).empty()) {
                                return matrix;
                            }
                            object2 = ((TextScanner)object).nextFunction();
                            if (object2 == null) {
                                object = new StringBuilder("Bad transform function encountered in transform list: ");
                                ((StringBuilder)object).append((String)charSequence);
                                throw new SAXException(((StringBuilder)object).toString());
                            }
                            if (((String)object2).equals("matrix")) {
                                ((TextScanner)object).skipWhitespace();
                                Float f3 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipCommaWhitespace();
                                Float f4 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipCommaWhitespace();
                                object2 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipCommaWhitespace();
                                Float f5 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipCommaWhitespace();
                                Float f6 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipCommaWhitespace();
                                f2 = ((TextScanner)object).nextFloat();
                                ((TextScanner)object).skipWhitespace();
                                if (f2 != null && ((TextScanner)object).consume(')')) {
                                    f = new Matrix();
                                    f.setValues(new float[]{f3.floatValue(), ((Float)object2).floatValue(), f6.floatValue(), f4.floatValue(), f5.floatValue(), f2.floatValue(), 0.0f, 0.0f, 1.0f});
                                    matrix.preConcat((Matrix)f);
                                    break block27;
                                } else {
                                    object = new StringBuilder("Invalid transform list: ");
                                    ((StringBuilder)object).append((String)charSequence);
                                    throw new SAXException(((StringBuilder)object).toString());
                                }
                            }
                            if (!((String)object2).equals("translate")) break block28;
                            ((TextScanner)object).skipWhitespace();
                            object2 = ((TextScanner)object).nextFloat();
                            f2 = ((TextScanner)object).possibleNextFloat();
                            ((TextScanner)object).skipWhitespace();
                            if (object2 != null && ((TextScanner)object).consume(')')) {
                                if (f2 == null) {
                                    matrix.preTranslate(((Float)object2).floatValue(), 0.0f);
                                    break block27;
                                } else {
                                    matrix.preTranslate(((Float)object2).floatValue(), f2.floatValue());
                                }
                                break block27;
                            } else {
                                object = new StringBuilder("Invalid transform list: ");
                                ((StringBuilder)object).append((String)charSequence);
                                throw new SAXException(((StringBuilder)object).toString());
                            }
                        }
                        if (!((String)object2).equals("scale")) break block29;
                        ((TextScanner)object).skipWhitespace();
                        f2 = ((TextScanner)object).nextFloat();
                        object2 = ((TextScanner)object).possibleNextFloat();
                        ((TextScanner)object).skipWhitespace();
                        if (f2 != null && ((TextScanner)object).consume(')')) {
                            if (object2 == null) {
                                matrix.preScale(f2.floatValue(), f2.floatValue());
                                break block27;
                            } else {
                                matrix.preScale(f2.floatValue(), ((Float)object2).floatValue());
                            }
                            break block27;
                        } else {
                            object = new StringBuilder("Invalid transform list: ");
                            ((StringBuilder)object).append((String)charSequence);
                            throw new SAXException(((StringBuilder)object).toString());
                        }
                    }
                    if (!((String)object2).equals("rotate")) break block30;
                    ((TextScanner)object).skipWhitespace();
                    f2 = ((TextScanner)object).nextFloat();
                    f = ((TextScanner)object).possibleNextFloat();
                    object2 = ((TextScanner)object).possibleNextFloat();
                    ((TextScanner)object).skipWhitespace();
                    if (f2 != null && ((TextScanner)object).consume(')')) {
                        if (f == null) {
                            matrix.preRotate(f2.floatValue());
                            break block27;
                        } else {
                            if (object2 == null) {
                                object = new StringBuilder("Invalid transform list: ");
                                ((StringBuilder)object).append((String)charSequence);
                                throw new SAXException(((StringBuilder)object).toString());
                            }
                            matrix.preRotate(f2.floatValue(), f.floatValue(), ((Float)object2).floatValue());
                        }
                        break block27;
                    } else {
                        object = new StringBuilder("Invalid transform list: ");
                        ((StringBuilder)object).append((String)charSequence);
                        throw new SAXException(((StringBuilder)object).toString());
                    }
                }
                if (((String)object2).equals("skewX")) {
                    ((TextScanner)object).skipWhitespace();
                    object2 = ((TextScanner)object).nextFloat();
                    ((TextScanner)object).skipWhitespace();
                    if (object2 != null && ((TextScanner)object).consume(')')) {
                        matrix.preSkew((float)Math.tan(Math.toRadians(((Float)object2).floatValue())), 0.0f);
                        break block27;
                    } else {
                        object = new StringBuilder("Invalid transform list: ");
                        ((StringBuilder)object).append((String)charSequence);
                        throw new SAXException(((StringBuilder)object).toString());
                    }
                }
                if (((String)object2).equals("skewY")) {
                    ((TextScanner)object).skipWhitespace();
                    object2 = ((TextScanner)object).nextFloat();
                    ((TextScanner)object).skipWhitespace();
                    if (object2 != null && ((TextScanner)object).consume(')')) {
                        matrix.preSkew(0.0f, (float)Math.tan(Math.toRadians(((Float)object2).floatValue())));
                        break block27;
                    } else {
                        object = new StringBuilder("Invalid transform list: ");
                        ((StringBuilder)object).append((String)charSequence);
                        throw new SAXException(((StringBuilder)object).toString());
                    }
                }
                if (object2 != null) {
                    charSequence = new StringBuilder("Invalid transform list fn: ");
                    ((StringBuilder)charSequence).append((String)object2);
                    ((StringBuilder)charSequence).append(")");
                    throw new SAXException(((StringBuilder)charSequence).toString());
                }
            }
            if (((TextScanner)object).empty()) {
                return matrix;
            }
            ((TextScanner)object).skipCommaWhitespace();
        }
    }

    private static SVG.Style.VectorEffect parseVectorEffect(String string2) throws SAXException {
        if (NONE.equals(string2)) {
            return SVG.Style.VectorEffect.None;
        }
        if ("non-scaling-stroke".equals(string2)) {
            return SVG.Style.VectorEffect.NonScalingStroke;
        }
        StringBuilder stringBuilder = new StringBuilder("Invalid vector-effect property: ");
        stringBuilder.append(string2);
        throw new SAXException(stringBuilder.toString());
    }

    private static SVG.Box parseViewBox(String object) throws SAXException {
        Object object2 = new TextScanner((String)object);
        ((TextScanner)object2).skipWhitespace();
        Float f = ((TextScanner)object2).nextFloat();
        ((TextScanner)object2).skipCommaWhitespace();
        Float f2 = ((TextScanner)object2).nextFloat();
        ((TextScanner)object2).skipCommaWhitespace();
        object = ((TextScanner)object2).nextFloat();
        ((TextScanner)object2).skipCommaWhitespace();
        object2 = ((TextScanner)object2).nextFloat();
        if (f != null && f2 != null && object != null && object2 != null) {
            if (!(((Float)object).floatValue() < 0.0f)) {
                if (!(((Float)object2).floatValue() < 0.0f)) {
                    return new SVG.Box(f.floatValue(), f2.floatValue(), ((Float)object).floatValue(), ((Float)object2).floatValue());
                }
                throw new SAXException("Invalid viewBox. height cannot be negative");
            }
            throw new SAXException("Invalid viewBox. width cannot be negative");
        }
        throw new SAXException("Invalid viewBox definition - should have four numbers");
    }

    private void path(Attributes attributes) throws SAXException {
        this.debug("<path>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Path path = new SVG.Path();
            path.document = this.svgDocument;
            path.parent = this.currentElement;
            this.parseAttributesCore(path, attributes);
            this.parseAttributesStyle(path, attributes);
            this.parseAttributesTransform(path, attributes);
            this.parseAttributesConditional(path, attributes);
            this.parseAttributesPath(path, attributes);
            this.currentElement.addChild(path);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void pattern(Attributes attributes) throws SAXException {
        this.debug("<pattern>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Pattern pattern = new SVG.Pattern();
            pattern.document = this.svgDocument;
            pattern.parent = this.currentElement;
            this.parseAttributesCore(pattern, attributes);
            this.parseAttributesStyle(pattern, attributes);
            this.parseAttributesConditional(pattern, attributes);
            this.parseAttributesViewBox(pattern, attributes);
            this.parseAttributesPattern(pattern, attributes);
            this.currentElement.addChild(pattern);
            this.currentElement = pattern;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void polygon(Attributes attributes) throws SAXException {
        this.debug("<polygon>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Polygon polygon = new SVG.Polygon();
            polygon.document = this.svgDocument;
            polygon.parent = this.currentElement;
            this.parseAttributesCore(polygon, attributes);
            this.parseAttributesStyle(polygon, attributes);
            this.parseAttributesTransform(polygon, attributes);
            this.parseAttributesConditional(polygon, attributes);
            this.parseAttributesPolyLine(polygon, attributes, "polygon");
            this.currentElement.addChild(polygon);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void polyline(Attributes attributes) throws SAXException {
        this.debug("<polyline>", new Object[0]);
        if (this.currentElement != null) {
            SVG.PolyLine polyLine = new SVG.PolyLine();
            polyLine.document = this.svgDocument;
            polyLine.parent = this.currentElement;
            this.parseAttributesCore(polyLine, attributes);
            this.parseAttributesStyle(polyLine, attributes);
            this.parseAttributesTransform(polyLine, attributes);
            this.parseAttributesConditional(polyLine, attributes);
            this.parseAttributesPolyLine(polyLine, attributes, "polyline");
            this.currentElement.addChild(polyLine);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void processStyleProperty(SVG.Style object, String charSequence, String string2) throws SAXException {
        if (string2.length() == 0) {
            return;
        }
        if (string2.equals("inherit")) {
            return;
        }
        int n = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString((String)charSequence).ordinal()];
        if (n != 2) {
            if (n != 3) {
                if (n != 5) {
                    if (n != 6) {
                        if (n != 9) {
                            if (n != 36) {
                                if (n != 41) {
                                    if (n != 43) {
                                        if (n != 79) {
                                            if (n != 59) {
                                                if (n != 60) {
                                                    if (n != 75) {
                                                        if (n != 76) {
                                                            switch (n) {
                                                                default: {
                                                                    switch (n) {
                                                                        default: {
                                                                            switch (n) {
                                                                                default: {
                                                                                    switch (n) {
                                                                                        default: {
                                                                                            return;
                                                                                        }
                                                                                        case 91: {
                                                                                            if (string2.indexOf(124) < 0) {
                                                                                                charSequence = new StringBuilder(String.valueOf('|'));
                                                                                                ((StringBuilder)charSequence).append(string2);
                                                                                                ((StringBuilder)charSequence).append('|');
                                                                                                if (VALID_VISIBILITY_VALUES.indexOf(((StringBuilder)charSequence).toString()) != -1) {
                                                                                                    ((SVG.Style)object).visibility = string2.equals("visible");
                                                                                                    ((SVG.Style)object).specifiedFlags |= 0x2000000L;
                                                                                                    return;
                                                                                                }
                                                                                            }
                                                                                            object = new StringBuilder("Invalid value for \"visibility\" attribute: ");
                                                                                            ((StringBuilder)object).append(string2);
                                                                                            throw new SAXException(((StringBuilder)object).toString());
                                                                                        }
                                                                                        case 90: {
                                                                                            ((SVG.Style)object).viewportFillOpacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                                                                            ((SVG.Style)object).specifiedFlags |= 0x400000000L;
                                                                                            return;
                                                                                        }
                                                                                        case 89: 
                                                                                    }
                                                                                    ((SVG.Style)object).viewportFill = string2.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x200000000L;
                                                                                    return;
                                                                                }
                                                                                case 72: {
                                                                                    ((SVG.Style)object).strokeWidth = SVGParser.parseLength(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x20L;
                                                                                    return;
                                                                                }
                                                                                case 71: {
                                                                                    ((SVG.Style)object).strokeOpacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x10L;
                                                                                    return;
                                                                                }
                                                                                case 70: {
                                                                                    ((SVG.Style)object).strokeMiterLimit = Float.valueOf(SVGParser.parseFloat(string2));
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x100L;
                                                                                    return;
                                                                                }
                                                                                case 69: {
                                                                                    ((SVG.Style)object).strokeLineJoin = SVGParser.parseStrokeLineJoin(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x80L;
                                                                                    return;
                                                                                }
                                                                                case 68: {
                                                                                    ((SVG.Style)object).strokeLineCap = SVGParser.parseStrokeLineCap(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x40L;
                                                                                    return;
                                                                                }
                                                                                case 67: {
                                                                                    ((SVG.Style)object).strokeDashOffset = SVGParser.parseLength(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x400L;
                                                                                    return;
                                                                                }
                                                                                case 66: {
                                                                                    ((SVG.Style)object).strokeDashArray = NONE.equals(string2) ? null : SVGParser.parseStrokeDashArray(string2);
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x200L;
                                                                                    return;
                                                                                }
                                                                                case 65: {
                                                                                    ((SVG.Style)object).stroke = SVGParser.parsePaintSpecifier(string2, "stroke");
                                                                                    ((SVG.Style)object).specifiedFlags |= 8L;
                                                                                    return;
                                                                                }
                                                                                case 64: {
                                                                                    ((SVG.Style)object).stopOpacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                                                                    ((SVG.Style)object).specifiedFlags |= 0x8000000L;
                                                                                    return;
                                                                                }
                                                                                case 63: 
                                                                            }
                                                                            ((SVG.Style)object).stopColor = string2.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(string2);
                                                                            ((SVG.Style)object).specifiedFlags |= 0x4000000L;
                                                                            return;
                                                                        }
                                                                        case 32: {
                                                                            ((SVG.Style)object).markerEnd = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
                                                                            ((SVG.Style)object).specifiedFlags |= 0x800000L;
                                                                            return;
                                                                        }
                                                                        case 31: {
                                                                            ((SVG.Style)object).markerMid = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
                                                                            ((SVG.Style)object).specifiedFlags |= 0x400000L;
                                                                            return;
                                                                        }
                                                                        case 30: {
                                                                            ((SVG.Style)object).markerStart = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
                                                                            ((SVG.Style)object).specifiedFlags |= 0x200000L;
                                                                            return;
                                                                        }
                                                                        case 29: {
                                                                            ((SVG.Style)object).markerMid = ((SVG.Style)object).markerStart = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
                                                                            ((SVG.Style)object).markerEnd = ((SVG.Style)object).markerStart;
                                                                            ((SVG.Style)object).specifiedFlags |= 0xE00000L;
                                                                            return;
                                                                        }
                                                                    }
                                                                }
                                                                case 23: {
                                                                    ((SVG.Style)object).fontStyle = SVGParser.parseFontStyle(string2);
                                                                    ((SVG.Style)object).specifiedFlags |= 0x10000L;
                                                                    return;
                                                                }
                                                                case 22: {
                                                                    ((SVG.Style)object).fontWeight = SVGParser.parseFontWeight(string2);
                                                                    ((SVG.Style)object).specifiedFlags |= 0x8000L;
                                                                    return;
                                                                }
                                                                case 21: {
                                                                    ((SVG.Style)object).fontSize = SVGParser.parseFontSize(string2);
                                                                    ((SVG.Style)object).specifiedFlags |= 0x4000L;
                                                                    return;
                                                                }
                                                                case 20: {
                                                                    ((SVG.Style)object).fontFamily = SVGParser.parseFontFamily(string2);
                                                                    ((SVG.Style)object).specifiedFlags |= 0x2000L;
                                                                    return;
                                                                }
                                                                case 19: {
                                                                    SVGParser.parseFont((SVG.Style)object, string2);
                                                                    return;
                                                                }
                                                                case 18: {
                                                                    ((SVG.Style)object).fillOpacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                                                    ((SVG.Style)object).specifiedFlags |= 4L;
                                                                    return;
                                                                }
                                                                case 17: {
                                                                    ((SVG.Style)object).fillRule = SVGParser.parseFillRule(string2);
                                                                    ((SVG.Style)object).specifiedFlags |= 2L;
                                                                    return;
                                                                }
                                                                case 16: {
                                                                    ((SVG.Style)object).fill = SVGParser.parsePaintSpecifier(string2, "fill");
                                                                    ((SVG.Style)object).specifiedFlags |= 1L;
                                                                    return;
                                                                }
                                                                case 15: {
                                                                    if (string2.indexOf(124) < 0) {
                                                                        charSequence = new StringBuilder(String.valueOf('|'));
                                                                        ((StringBuilder)charSequence).append(string2);
                                                                        ((StringBuilder)charSequence).append('|');
                                                                        if (VALID_DISPLAY_VALUES.indexOf(((StringBuilder)charSequence).toString()) != -1) {
                                                                            ((SVG.Style)object).display = string2.equals(NONE) ^ true;
                                                                            ((SVG.Style)object).specifiedFlags |= 0x1000000L;
                                                                            return;
                                                                        }
                                                                    }
                                                                    object = new StringBuilder("Invalid value for \"display\" attribute: ");
                                                                    ((StringBuilder)object).append(string2);
                                                                    throw new SAXException(((StringBuilder)object).toString());
                                                                }
                                                            }
                                                        }
                                                        ((SVG.Style)object).textDecoration = SVGParser.parseTextDecoration(string2);
                                                        ((SVG.Style)object).specifiedFlags |= 0x20000L;
                                                        return;
                                                    }
                                                    ((SVG.Style)object).textAnchor = SVGParser.parseTextAnchor(string2);
                                                    ((SVG.Style)object).specifiedFlags |= 0x40000L;
                                                    return;
                                                }
                                                ((SVG.Style)object).solidOpacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                                ((SVG.Style)object).specifiedFlags |= 0x100000000L;
                                                return;
                                            }
                                            ((SVG.Style)object).solidColor = string2.equals(CURRENTCOLOR) ? SVG.CurrentColor.getInstance() : SVGParser.parseColour(string2);
                                            ((SVG.Style)object).specifiedFlags |= 0x80000000L;
                                            return;
                                        }
                                        ((SVG.Style)object).vectorEffect = SVGParser.parseVectorEffect(string2);
                                        ((SVG.Style)object).specifiedFlags |= 0x800000000L;
                                        return;
                                    }
                                    ((SVG.Style)object).overflow = SVGParser.parseOverflow(string2);
                                    ((SVG.Style)object).specifiedFlags |= 0x80000L;
                                    return;
                                }
                                ((SVG.Style)object).opacity = Float.valueOf(SVGParser.parseOpacity(string2));
                                ((SVG.Style)object).specifiedFlags |= 0x800L;
                                return;
                            }
                            ((SVG.Style)object).mask = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
                            ((SVG.Style)object).specifiedFlags |= 0x40000000L;
                            return;
                        }
                        ((SVG.Style)object).direction = SVGParser.parseTextDirection(string2);
                        ((SVG.Style)object).specifiedFlags |= 0x1000000000L;
                        return;
                    }
                    ((SVG.Style)object).color = SVGParser.parseColour(string2);
                    ((SVG.Style)object).specifiedFlags |= 0x1000L;
                    return;
                }
                ((SVG.Style)object).clipRule = SVGParser.parseFillRule(string2);
                ((SVG.Style)object).specifiedFlags |= 0x20000000L;
                return;
            }
            ((SVG.Style)object).clipPath = SVGParser.parseFunctionalIRI(string2, (String)charSequence);
            ((SVG.Style)object).specifiedFlags |= 0x10000000L;
            return;
        }
        ((SVG.Style)object).clip = SVGParser.parseClip(string2);
        ((SVG.Style)object).specifiedFlags |= 0x100000L;
    }

    private void radialGradient(Attributes attributes) throws SAXException {
        this.debug("<radialGradient>", new Object[0]);
        if (this.currentElement != null) {
            SVG.SvgRadialGradient svgRadialGradient = new SVG.SvgRadialGradient();
            svgRadialGradient.document = this.svgDocument;
            svgRadialGradient.parent = this.currentElement;
            this.parseAttributesCore(svgRadialGradient, attributes);
            this.parseAttributesStyle(svgRadialGradient, attributes);
            this.parseAttributesGradient(svgRadialGradient, attributes);
            this.parseAttributesRadialGradient(svgRadialGradient, attributes);
            this.currentElement.addChild(svgRadialGradient);
            this.currentElement = svgRadialGradient;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void rect(Attributes attributes) throws SAXException {
        this.debug("<rect>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Rect rect = new SVG.Rect();
            rect.document = this.svgDocument;
            rect.parent = this.currentElement;
            this.parseAttributesCore(rect, attributes);
            this.parseAttributesStyle(rect, attributes);
            this.parseAttributesTransform(rect, attributes);
            this.parseAttributesConditional(rect, attributes);
            this.parseAttributesRect(rect, attributes);
            this.currentElement.addChild(rect);
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void solidColor(Attributes attributes) throws SAXException {
        this.debug("<solidColor>", new Object[0]);
        if (this.currentElement != null) {
            SVG.SolidColor solidColor = new SVG.SolidColor();
            solidColor.document = this.svgDocument;
            solidColor.parent = this.currentElement;
            this.parseAttributesCore(solidColor, attributes);
            this.parseAttributesStyle(solidColor, attributes);
            this.currentElement.addChild(solidColor);
            this.currentElement = solidColor;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void stop(Attributes attributes) throws SAXException {
        this.debug("<stop>", new Object[0]);
        SVG.SvgContainer svgContainer = this.currentElement;
        if (svgContainer != null) {
            if (svgContainer instanceof SVG.GradientElement) {
                svgContainer = new SVG.Stop();
                ((SVG.Stop)svgContainer).document = this.svgDocument;
                ((SVG.Stop)svgContainer).parent = this.currentElement;
                this.parseAttributesCore((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesStyle((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesStop((SVG.Stop)svgContainer, attributes);
                this.currentElement.addChild((SVG.SvgObject)((Object)svgContainer));
                this.currentElement = svgContainer;
                return;
            }
            throw new SAXException("Invalid document. <stop> elements are only valid inside <linearGradiant> or <radialGradient> elements.");
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void style(Attributes attributes) throws SAXException {
        int n = 0;
        this.debug("<style>", new Object[0]);
        if (this.currentElement != null) {
            String string2 = "all";
            boolean bl = true;
            while (true) {
                if (n >= attributes.getLength()) {
                    if (bl && CSSParser.mediaMatches(string2, CSSParser.MediaType.screen)) {
                        this.inStyleElement = true;
                    } else {
                        this.ignoring = true;
                        this.ignoreDepth = 1;
                    }
                    return;
                }
                String string3 = attributes.getValue(n).trim();
                int n2 = SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGAttr()[SVGAttr.fromString(attributes.getLocalName(n)).ordinal()];
                if (n2 != 39) {
                    if (n2 == 78) {
                        bl = string3.equals("text/css");
                    }
                } else {
                    string2 = string3;
                }
                ++n;
            }
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void svg(Attributes object) throws SAXException {
        this.debug("<svg>", new Object[0]);
        SVG.Svg svg = new SVG.Svg();
        svg.document = this.svgDocument;
        svg.parent = this.currentElement;
        this.parseAttributesCore(svg, (Attributes)object);
        this.parseAttributesStyle(svg, (Attributes)object);
        this.parseAttributesConditional(svg, (Attributes)object);
        this.parseAttributesViewBox(svg, (Attributes)object);
        this.parseAttributesSVG(svg, (Attributes)object);
        object = this.currentElement;
        if (object == null) {
            this.svgDocument.setRootElement(svg);
        } else {
            object.addChild(svg);
        }
        this.currentElement = svg;
    }

    private void symbol(Attributes attributes) throws SAXException {
        this.debug("<symbol>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Symbol symbol = new SVG.Symbol();
            symbol.document = this.svgDocument;
            symbol.parent = this.currentElement;
            this.parseAttributesCore(symbol, attributes);
            this.parseAttributesStyle(symbol, attributes);
            this.parseAttributesConditional(symbol, attributes);
            this.parseAttributesViewBox(symbol, attributes);
            this.currentElement.addChild(symbol);
            this.currentElement = symbol;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void text(Attributes attributes) throws SAXException {
        this.debug("<text>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Text text = new SVG.Text();
            text.document = this.svgDocument;
            text.parent = this.currentElement;
            this.parseAttributesCore(text, attributes);
            this.parseAttributesStyle(text, attributes);
            this.parseAttributesTransform(text, attributes);
            this.parseAttributesConditional(text, attributes);
            this.parseAttributesTextPosition(text, attributes);
            this.currentElement.addChild(text);
            this.currentElement = text;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void textPath(Attributes attributes) throws SAXException {
        this.debug("<textPath>", new Object[0]);
        if (this.currentElement != null) {
            SVG.TextPath textPath = new SVG.TextPath();
            textPath.document = this.svgDocument;
            textPath.parent = this.currentElement;
            this.parseAttributesCore(textPath, attributes);
            this.parseAttributesStyle(textPath, attributes);
            this.parseAttributesConditional(textPath, attributes);
            this.parseAttributesTextPath(textPath, attributes);
            this.currentElement.addChild(textPath);
            this.currentElement = textPath;
            if (textPath.parent instanceof SVG.TextRoot) {
                textPath.setTextRoot((SVG.TextRoot)((Object)textPath.parent));
            } else {
                textPath.setTextRoot(((SVG.TextChild)((Object)textPath.parent)).getTextRoot());
            }
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void tref(Attributes attributes) throws SAXException {
        this.debug("<tref>", new Object[0]);
        SVG.SvgContainer svgContainer = this.currentElement;
        if (svgContainer != null) {
            if (svgContainer instanceof SVG.TextContainer) {
                svgContainer = new SVG.TRef();
                ((SVG.TRef)svgContainer).document = this.svgDocument;
                ((SVG.TRef)svgContainer).parent = this.currentElement;
                this.parseAttributesCore((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesStyle((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesConditional((SVG.SvgConditional)((Object)svgContainer), attributes);
                this.parseAttributesTRef((SVG.TRef)svgContainer, attributes);
                this.currentElement.addChild((SVG.SvgObject)((Object)svgContainer));
                if (((SVG.TRef)svgContainer).parent instanceof SVG.TextRoot) {
                    ((SVG.TRef)svgContainer).setTextRoot((SVG.TextRoot)((Object)((SVG.TRef)svgContainer).parent));
                } else {
                    ((SVG.TRef)svgContainer).setTextRoot(((SVG.TextChild)((Object)((SVG.TRef)svgContainer).parent)).getTextRoot());
                }
                return;
            }
            throw new SAXException("Invalid document. <tref> elements are only valid inside <text> or <tspan> elements.");
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void tspan(Attributes attributes) throws SAXException {
        this.debug("<tspan>", new Object[0]);
        SVG.SvgContainer svgContainer = this.currentElement;
        if (svgContainer != null) {
            if (svgContainer instanceof SVG.TextContainer) {
                svgContainer = new SVG.TSpan();
                ((SVG.TSpan)svgContainer).document = this.svgDocument;
                ((SVG.TSpan)svgContainer).parent = this.currentElement;
                this.parseAttributesCore((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesStyle((SVG.SvgElementBase)((Object)svgContainer), attributes);
                this.parseAttributesConditional((SVG.SvgConditional)((Object)svgContainer), attributes);
                this.parseAttributesTextPosition((SVG.TextPositionedContainer)svgContainer, attributes);
                this.currentElement.addChild((SVG.SvgObject)((Object)svgContainer));
                this.currentElement = svgContainer;
                if (((SVG.TSpan)svgContainer).parent instanceof SVG.TextRoot) {
                    ((SVG.TSpan)svgContainer).setTextRoot((SVG.TextRoot)((Object)((SVG.TSpan)svgContainer).parent));
                } else {
                    ((SVG.TSpan)svgContainer).setTextRoot(((SVG.TextChild)((Object)((SVG.TSpan)svgContainer).parent)).getTextRoot());
                }
                return;
            }
            throw new SAXException("Invalid document. <tspan> elements are only valid inside <text> or other <tspan> elements.");
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void use(Attributes attributes) throws SAXException {
        this.debug("<use>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Use use = new SVG.Use();
            use.document = this.svgDocument;
            use.parent = this.currentElement;
            this.parseAttributesCore(use, attributes);
            this.parseAttributesStyle(use, attributes);
            this.parseAttributesTransform(use, attributes);
            this.parseAttributesConditional(use, attributes);
            this.parseAttributesUse(use, attributes);
            this.currentElement.addChild(use);
            this.currentElement = use;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void view(Attributes attributes) throws SAXException {
        this.debug("<view>", new Object[0]);
        if (this.currentElement != null) {
            SVG.View view = new SVG.View();
            view.document = this.svgDocument;
            view.parent = this.currentElement;
            this.parseAttributesCore(view, attributes);
            this.parseAttributesConditional(view, attributes);
            this.parseAttributesViewBox(view, attributes);
            this.currentElement.addChild(view);
            this.currentElement = view;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    private void zwitch(Attributes attributes) throws SAXException {
        this.debug("<switch>", new Object[0]);
        if (this.currentElement != null) {
            SVG.Switch switch_ = new SVG.Switch();
            switch_.document = this.svgDocument;
            switch_.parent = this.currentElement;
            this.parseAttributesCore(switch_, attributes);
            this.parseAttributesStyle(switch_, attributes);
            this.parseAttributesTransform(switch_, attributes);
            this.parseAttributesConditional(switch_, attributes);
            this.currentElement.addChild(switch_);
            this.currentElement = switch_;
            return;
        }
        throw new SAXException("Invalid document. Root element must be <svg>");
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inMetadataElement) {
            if (this.metadataElementContents == null) {
                this.metadataElementContents = new StringBuilder(n2);
            }
            this.metadataElementContents.append(cArray, n, n2);
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(n2);
            }
            this.styleElementContents.append(cArray, n, n2);
            return;
        }
        Object object = this.currentElement;
        if (object instanceof SVG.TextContainer) {
            object = (SVG.SvgConditionalContainer)object;
            int n3 = ((SVG.SvgConditionalContainer)object).children.size();
            object = n3 == 0 ? null : ((SVG.SvgConditionalContainer)object).children.get(n3 - 1);
            if (object instanceof SVG.TextSequence) {
                object = (SVG.TextSequence)object;
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(((SVG.TextSequence)object).text));
                stringBuilder.append(new String(cArray, n, n2));
                ((SVG.TextSequence)object).text = stringBuilder.toString();
            } else {
                ((SVG.SvgConditionalContainer)this.currentElement).addChild(new SVG.TextSequence(new String(cArray, n, n2)));
            }
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.ignoring) {
            return;
        }
        if (this.inStyleElement) {
            if (this.styleElementContents == null) {
                this.styleElementContents = new StringBuilder(n2);
            }
            this.styleElementContents.append(cArray, n, n2);
        }
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String charSequence, String string2, String string3) throws SAXException {
        if (this.ignoring) {
            int n;
            this.ignoreDepth = n = this.ignoreDepth - 1;
            if (n == 0) {
                this.ignoring = false;
                return;
            }
        }
        if (!SVG_NAMESPACE.equals(charSequence) && !"".equals(charSequence)) {
            return;
        }
        switch (SVGElem.fromString(string2)) {
            default: {
                break;
            }
            case style: {
                charSequence = this.styleElementContents;
                if (charSequence == null) break;
                this.inStyleElement = false;
                this.parseCSSStyleSheet(((StringBuilder)charSequence).toString());
                this.styleElementContents.setLength(0);
                return;
            }
            case desc: 
            case title: {
                this.inMetadataElement = false;
                if (this.metadataTag == SVGElem.title) {
                    this.svgDocument.setTitle(this.metadataElementContents.toString());
                } else if (this.metadataTag == SVGElem.desc) {
                    this.svgDocument.setDesc(this.metadataElementContents.toString());
                }
                this.metadataElementContents.setLength(0);
                return;
            }
            case svg: 
            case clipPath: 
            case defs: 
            case g: 
            case image: 
            case linearGradient: 
            case marker: 
            case mask: 
            case pattern: 
            case radialGradient: 
            case solidColor: 
            case stop: 
            case SWITCH: 
            case symbol: 
            case text: 
            case textPath: 
            case tspan: 
            case use: 
            case view: {
                this.currentElement = ((SVG.SvgObject)((Object)this.currentElement)).parent;
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected SVG parse(InputStream var1_1) throws SVGParseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [7 : 137->179)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void setSupportedFormats(String[] stringArray) {
        HashSet hashSet = new HashSet(stringArray.length);
        this.supportedFormats = hashSet;
        Collections.addAll(hashSet, stringArray);
    }

    @Override
    public void startDocument() throws SAXException {
        this.svgDocument = new SVG();
    }

    @Override
    public void startElement(String object, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.ignoring) {
            ++this.ignoreDepth;
            return;
        }
        if (!SVG_NAMESPACE.equals(object) && !"".equals(object)) {
            return;
        }
        object = SVGElem.fromString(string2);
        switch (SVGParser.$SWITCH_TABLE$com$caverock$androidsvg$SVGParser$SVGElem()[((Enum)object).ordinal()]) {
            default: {
                this.ignoring = true;
                this.ignoreDepth = 1;
                break;
            }
            case 31: {
                this.view(attributes);
                break;
            }
            case 30: {
                this.use(attributes);
                break;
            }
            case 29: {
                this.tspan(attributes);
                break;
            }
            case 28: {
                this.tref(attributes);
                break;
            }
            case 26: {
                this.textPath(attributes);
                break;
            }
            case 25: {
                this.text(attributes);
                break;
            }
            case 24: {
                this.symbol(attributes);
                break;
            }
            case 23: {
                this.zwitch(attributes);
                break;
            }
            case 22: {
                this.style(attributes);
                break;
            }
            case 21: {
                this.stop(attributes);
                break;
            }
            case 20: {
                this.solidColor(attributes);
                break;
            }
            case 19: {
                this.rect(attributes);
                break;
            }
            case 18: {
                this.radialGradient(attributes);
                break;
            }
            case 17: {
                this.polyline(attributes);
                break;
            }
            case 16: {
                this.polygon(attributes);
                break;
            }
            case 15: {
                this.pattern(attributes);
                break;
            }
            case 14: {
                this.path(attributes);
                break;
            }
            case 13: {
                this.mask(attributes);
                break;
            }
            case 12: {
                this.marker(attributes);
                break;
            }
            case 11: {
                this.linearGradient(attributes);
                break;
            }
            case 10: {
                this.line(attributes);
                break;
            }
            case 9: {
                this.image(attributes);
                break;
            }
            case 7: {
                this.ellipse(attributes);
                break;
            }
            case 6: 
            case 27: {
                this.inMetadataElement = true;
                this.metadataTag = object;
                break;
            }
            case 5: {
                this.defs(attributes);
                break;
            }
            case 4: {
                this.clipPath(attributes);
                break;
            }
            case 3: {
                this.circle(attributes);
                break;
            }
            case 2: 
            case 8: {
                this.g(attributes);
                break;
            }
            case 1: {
                this.svg(attributes);
            }
        }
    }

    private static final class SVGAttr
    extends Enum<SVGAttr> {
        public static final /* enum */ SVGAttr CLASS;
        private static final /* synthetic */ SVGAttr[] ENUM$VALUES;
        public static final /* enum */ SVGAttr UNSUPPORTED;
        private static HashMap<String, SVGAttr> cache;
        public static final /* enum */ SVGAttr clip;
        public static final /* enum */ SVGAttr clipPathUnits;
        public static final /* enum */ SVGAttr clip_path;
        public static final /* enum */ SVGAttr clip_rule;
        public static final /* enum */ SVGAttr color;
        public static final /* enum */ SVGAttr cx;
        public static final /* enum */ SVGAttr cy;
        public static final /* enum */ SVGAttr d;
        public static final /* enum */ SVGAttr direction;
        public static final /* enum */ SVGAttr display;
        public static final /* enum */ SVGAttr dx;
        public static final /* enum */ SVGAttr dy;
        public static final /* enum */ SVGAttr fill;
        public static final /* enum */ SVGAttr fill_opacity;
        public static final /* enum */ SVGAttr fill_rule;
        public static final /* enum */ SVGAttr font;
        public static final /* enum */ SVGAttr font_family;
        public static final /* enum */ SVGAttr font_size;
        public static final /* enum */ SVGAttr font_style;
        public static final /* enum */ SVGAttr font_weight;
        public static final /* enum */ SVGAttr fx;
        public static final /* enum */ SVGAttr fy;
        public static final /* enum */ SVGAttr gradientTransform;
        public static final /* enum */ SVGAttr gradientUnits;
        public static final /* enum */ SVGAttr height;
        public static final /* enum */ SVGAttr href;
        public static final /* enum */ SVGAttr id;
        public static final /* enum */ SVGAttr marker;
        public static final /* enum */ SVGAttr markerHeight;
        public static final /* enum */ SVGAttr markerUnits;
        public static final /* enum */ SVGAttr markerWidth;
        public static final /* enum */ SVGAttr marker_end;
        public static final /* enum */ SVGAttr marker_mid;
        public static final /* enum */ SVGAttr marker_start;
        public static final /* enum */ SVGAttr mask;
        public static final /* enum */ SVGAttr maskContentUnits;
        public static final /* enum */ SVGAttr maskUnits;
        public static final /* enum */ SVGAttr media;
        public static final /* enum */ SVGAttr offset;
        public static final /* enum */ SVGAttr opacity;
        public static final /* enum */ SVGAttr orient;
        public static final /* enum */ SVGAttr overflow;
        public static final /* enum */ SVGAttr pathLength;
        public static final /* enum */ SVGAttr patternContentUnits;
        public static final /* enum */ SVGAttr patternTransform;
        public static final /* enum */ SVGAttr patternUnits;
        public static final /* enum */ SVGAttr points;
        public static final /* enum */ SVGAttr preserveAspectRatio;
        public static final /* enum */ SVGAttr r;
        public static final /* enum */ SVGAttr refX;
        public static final /* enum */ SVGAttr refY;
        public static final /* enum */ SVGAttr requiredExtensions;
        public static final /* enum */ SVGAttr requiredFeatures;
        public static final /* enum */ SVGAttr requiredFonts;
        public static final /* enum */ SVGAttr requiredFormats;
        public static final /* enum */ SVGAttr rx;
        public static final /* enum */ SVGAttr ry;
        public static final /* enum */ SVGAttr solid_color;
        public static final /* enum */ SVGAttr solid_opacity;
        public static final /* enum */ SVGAttr spreadMethod;
        public static final /* enum */ SVGAttr startOffset;
        public static final /* enum */ SVGAttr stop_color;
        public static final /* enum */ SVGAttr stop_opacity;
        public static final /* enum */ SVGAttr stroke;
        public static final /* enum */ SVGAttr stroke_dasharray;
        public static final /* enum */ SVGAttr stroke_dashoffset;
        public static final /* enum */ SVGAttr stroke_linecap;
        public static final /* enum */ SVGAttr stroke_linejoin;
        public static final /* enum */ SVGAttr stroke_miterlimit;
        public static final /* enum */ SVGAttr stroke_opacity;
        public static final /* enum */ SVGAttr stroke_width;
        public static final /* enum */ SVGAttr style;
        public static final /* enum */ SVGAttr systemLanguage;
        public static final /* enum */ SVGAttr text_anchor;
        public static final /* enum */ SVGAttr text_decoration;
        public static final /* enum */ SVGAttr transform;
        public static final /* enum */ SVGAttr type;
        public static final /* enum */ SVGAttr vector_effect;
        public static final /* enum */ SVGAttr version;
        public static final /* enum */ SVGAttr viewBox;
        public static final /* enum */ SVGAttr viewport_fill;
        public static final /* enum */ SVGAttr viewport_fill_opacity;
        public static final /* enum */ SVGAttr visibility;
        public static final /* enum */ SVGAttr width;
        public static final /* enum */ SVGAttr x;
        public static final /* enum */ SVGAttr x1;
        public static final /* enum */ SVGAttr x2;
        public static final /* enum */ SVGAttr y;
        public static final /* enum */ SVGAttr y1;
        public static final /* enum */ SVGAttr y2;

        static {
            SVGAttr sVGAttr;
            SVGAttr sVGAttr2;
            SVGAttr sVGAttr3;
            SVGAttr sVGAttr4;
            SVGAttr sVGAttr5;
            SVGAttr sVGAttr6;
            SVGAttr sVGAttr7;
            SVGAttr sVGAttr8;
            SVGAttr sVGAttr9;
            SVGAttr sVGAttr10;
            SVGAttr sVGAttr11;
            SVGAttr sVGAttr12;
            SVGAttr sVGAttr13;
            SVGAttr sVGAttr14;
            SVGAttr sVGAttr15;
            SVGAttr sVGAttr16;
            SVGAttr sVGAttr17;
            SVGAttr sVGAttr18;
            SVGAttr sVGAttr19;
            SVGAttr sVGAttr20;
            SVGAttr sVGAttr21;
            SVGAttr sVGAttr22;
            SVGAttr sVGAttr23;
            SVGAttr sVGAttr24;
            SVGAttr sVGAttr25;
            SVGAttr sVGAttr26;
            SVGAttr sVGAttr27;
            SVGAttr sVGAttr28;
            SVGAttr sVGAttr29;
            SVGAttr sVGAttr30;
            SVGAttr sVGAttr31;
            SVGAttr sVGAttr32;
            SVGAttr sVGAttr33;
            SVGAttr sVGAttr34;
            SVGAttr sVGAttr35;
            SVGAttr sVGAttr36;
            SVGAttr sVGAttr37;
            SVGAttr sVGAttr38;
            SVGAttr sVGAttr39;
            SVGAttr sVGAttr40;
            SVGAttr sVGAttr41;
            SVGAttr sVGAttr42;
            SVGAttr sVGAttr43;
            SVGAttr sVGAttr44;
            SVGAttr sVGAttr45;
            SVGAttr sVGAttr46;
            SVGAttr sVGAttr47;
            SVGAttr sVGAttr48;
            SVGAttr sVGAttr49;
            SVGAttr sVGAttr50;
            SVGAttr sVGAttr51;
            SVGAttr sVGAttr52;
            SVGAttr sVGAttr53;
            SVGAttr sVGAttr54;
            SVGAttr sVGAttr55;
            SVGAttr sVGAttr56;
            SVGAttr sVGAttr57;
            SVGAttr sVGAttr58;
            SVGAttr sVGAttr59;
            SVGAttr sVGAttr60;
            SVGAttr sVGAttr61;
            SVGAttr sVGAttr62;
            SVGAttr sVGAttr63;
            SVGAttr sVGAttr64;
            SVGAttr sVGAttr65;
            SVGAttr sVGAttr66;
            SVGAttr sVGAttr67;
            SVGAttr sVGAttr68;
            SVGAttr sVGAttr69;
            SVGAttr sVGAttr70;
            SVGAttr sVGAttr71;
            SVGAttr sVGAttr72;
            SVGAttr sVGAttr73;
            SVGAttr sVGAttr74;
            SVGAttr sVGAttr75;
            SVGAttr sVGAttr76;
            SVGAttr sVGAttr77;
            SVGAttr sVGAttr78;
            SVGAttr sVGAttr79;
            SVGAttr sVGAttr80;
            SVGAttr sVGAttr81;
            SVGAttr sVGAttr82;
            SVGAttr sVGAttr83;
            SVGAttr sVGAttr84;
            SVGAttr sVGAttr85;
            SVGAttr sVGAttr86;
            SVGAttr sVGAttr87;
            SVGAttr sVGAttr88;
            SVGAttr sVGAttr89;
            SVGAttr sVGAttr90;
            SVGAttr sVGAttr91;
            SVGAttr sVGAttr92;
            CLASS = sVGAttr92 = new SVGAttr();
            clip = sVGAttr91 = new SVGAttr();
            clip_path = sVGAttr90 = new SVGAttr();
            clipPathUnits = sVGAttr89 = new SVGAttr();
            clip_rule = sVGAttr88 = new SVGAttr();
            color = sVGAttr87 = new SVGAttr();
            cx = sVGAttr86 = new SVGAttr();
            cy = sVGAttr85 = new SVGAttr();
            direction = sVGAttr84 = new SVGAttr();
            dx = sVGAttr83 = new SVGAttr();
            dy = sVGAttr82 = new SVGAttr();
            fx = sVGAttr81 = new SVGAttr();
            fy = sVGAttr80 = new SVGAttr();
            d = sVGAttr79 = new SVGAttr();
            display = sVGAttr78 = new SVGAttr();
            fill = sVGAttr77 = new SVGAttr();
            fill_rule = sVGAttr76 = new SVGAttr();
            fill_opacity = sVGAttr75 = new SVGAttr();
            font = sVGAttr74 = new SVGAttr();
            font_family = sVGAttr73 = new SVGAttr();
            font_size = sVGAttr72 = new SVGAttr();
            font_weight = sVGAttr71 = new SVGAttr();
            font_style = sVGAttr70 = new SVGAttr();
            gradientTransform = sVGAttr69 = new SVGAttr();
            gradientUnits = sVGAttr68 = new SVGAttr();
            height = sVGAttr67 = new SVGAttr();
            href = sVGAttr66 = new SVGAttr();
            id = sVGAttr65 = new SVGAttr();
            marker = sVGAttr64 = new SVGAttr();
            marker_start = sVGAttr63 = new SVGAttr();
            marker_mid = sVGAttr62 = new SVGAttr();
            marker_end = sVGAttr61 = new SVGAttr();
            markerHeight = sVGAttr60 = new SVGAttr();
            markerUnits = sVGAttr59 = new SVGAttr();
            markerWidth = sVGAttr58 = new SVGAttr();
            mask = sVGAttr57 = new SVGAttr();
            maskContentUnits = sVGAttr56 = new SVGAttr();
            maskUnits = sVGAttr55 = new SVGAttr();
            media = sVGAttr54 = new SVGAttr();
            offset = sVGAttr53 = new SVGAttr();
            opacity = sVGAttr52 = new SVGAttr();
            orient = sVGAttr51 = new SVGAttr();
            overflow = sVGAttr50 = new SVGAttr();
            pathLength = sVGAttr49 = new SVGAttr();
            patternContentUnits = sVGAttr48 = new SVGAttr();
            patternTransform = sVGAttr47 = new SVGAttr();
            patternUnits = sVGAttr46 = new SVGAttr();
            points = sVGAttr45 = new SVGAttr();
            preserveAspectRatio = sVGAttr44 = new SVGAttr();
            r = sVGAttr43 = new SVGAttr();
            refX = sVGAttr42 = new SVGAttr();
            refY = sVGAttr41 = new SVGAttr();
            requiredFeatures = sVGAttr40 = new SVGAttr();
            requiredExtensions = sVGAttr39 = new SVGAttr();
            requiredFormats = sVGAttr38 = new SVGAttr();
            requiredFonts = sVGAttr37 = new SVGAttr();
            rx = sVGAttr36 = new SVGAttr();
            ry = sVGAttr35 = new SVGAttr();
            solid_color = sVGAttr34 = new SVGAttr();
            solid_opacity = sVGAttr33 = new SVGAttr();
            spreadMethod = sVGAttr32 = new SVGAttr();
            startOffset = sVGAttr31 = new SVGAttr();
            stop_color = sVGAttr30 = new SVGAttr();
            stop_opacity = sVGAttr29 = new SVGAttr();
            stroke = sVGAttr28 = new SVGAttr();
            stroke_dasharray = sVGAttr27 = new SVGAttr();
            stroke_dashoffset = sVGAttr26 = new SVGAttr();
            stroke_linecap = sVGAttr25 = new SVGAttr();
            stroke_linejoin = sVGAttr24 = new SVGAttr();
            stroke_miterlimit = sVGAttr23 = new SVGAttr();
            stroke_opacity = sVGAttr22 = new SVGAttr();
            stroke_width = sVGAttr21 = new SVGAttr();
            style = sVGAttr20 = new SVGAttr();
            systemLanguage = sVGAttr19 = new SVGAttr();
            text_anchor = sVGAttr18 = new SVGAttr();
            text_decoration = sVGAttr17 = new SVGAttr();
            transform = sVGAttr16 = new SVGAttr();
            type = sVGAttr15 = new SVGAttr();
            vector_effect = sVGAttr14 = new SVGAttr();
            version = sVGAttr13 = new SVGAttr();
            viewBox = sVGAttr12 = new SVGAttr();
            width = sVGAttr11 = new SVGAttr();
            x = sVGAttr10 = new SVGAttr();
            y = sVGAttr9 = new SVGAttr();
            x1 = sVGAttr8 = new SVGAttr();
            y1 = sVGAttr7 = new SVGAttr();
            x2 = sVGAttr6 = new SVGAttr();
            y2 = sVGAttr5 = new SVGAttr();
            viewport_fill = sVGAttr4 = new SVGAttr();
            viewport_fill_opacity = sVGAttr3 = new SVGAttr();
            visibility = sVGAttr2 = new SVGAttr();
            UNSUPPORTED = sVGAttr = new SVGAttr();
            ENUM$VALUES = new SVGAttr[]{sVGAttr92, sVGAttr91, sVGAttr90, sVGAttr89, sVGAttr88, sVGAttr87, sVGAttr86, sVGAttr85, sVGAttr84, sVGAttr83, sVGAttr82, sVGAttr81, sVGAttr80, sVGAttr79, sVGAttr78, sVGAttr77, sVGAttr76, sVGAttr75, sVGAttr74, sVGAttr73, sVGAttr72, sVGAttr71, sVGAttr70, sVGAttr69, sVGAttr68, sVGAttr67, sVGAttr66, sVGAttr65, sVGAttr64, sVGAttr63, sVGAttr62, sVGAttr61, sVGAttr60, sVGAttr59, sVGAttr58, sVGAttr57, sVGAttr56, sVGAttr55, sVGAttr54, sVGAttr53, sVGAttr52, sVGAttr51, sVGAttr50, sVGAttr49, sVGAttr48, sVGAttr47, sVGAttr46, sVGAttr45, sVGAttr44, sVGAttr43, sVGAttr42, sVGAttr41, sVGAttr40, sVGAttr39, sVGAttr38, sVGAttr37, sVGAttr36, sVGAttr35, sVGAttr34, sVGAttr33, sVGAttr32, sVGAttr31, sVGAttr30, sVGAttr29, sVGAttr28, sVGAttr27, sVGAttr26, sVGAttr25, sVGAttr24, sVGAttr23, sVGAttr22, sVGAttr21, sVGAttr20, sVGAttr19, sVGAttr18, sVGAttr17, sVGAttr16, sVGAttr15, sVGAttr14, sVGAttr13, sVGAttr12, sVGAttr11, sVGAttr10, sVGAttr9, sVGAttr8, sVGAttr7, sVGAttr6, sVGAttr5, sVGAttr4, sVGAttr3, sVGAttr2, sVGAttr};
            cache = new HashMap();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static SVGAttr fromString(String string2) {
            SVGAttr sVGAttr = cache.get(string2);
            if (sVGAttr != null) {
                return sVGAttr;
            }
            if (string2.equals("class")) {
                HashMap<String, SVGAttr> hashMap = cache;
                sVGAttr = CLASS;
                hashMap.put(string2, sVGAttr);
                return sVGAttr;
            }
            if (string2.indexOf(95) != -1) {
                HashMap<String, SVGAttr> hashMap = cache;
                sVGAttr = UNSUPPORTED;
                hashMap.put(string2, sVGAttr);
                return sVGAttr;
            }
            try {
                sVGAttr = SVGAttr.valueOf(string2.replace('-', '_'));
                if (sVGAttr != CLASS) {
                    cache.put(string2, sVGAttr);
                    return sVGAttr;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            HashMap<String, SVGAttr> hashMap = cache;
            sVGAttr = UNSUPPORTED;
            hashMap.put(string2, sVGAttr);
            return sVGAttr;
        }

        public static SVGAttr valueOf(String string2) {
            return Enum.valueOf(SVGAttr.class, string2);
        }

        public static SVGAttr[] values() {
            SVGAttr[] sVGAttrArray = ENUM$VALUES;
            int n = sVGAttrArray.length;
            SVGAttr[] sVGAttrArray2 = new SVGAttr[n];
            System.arraycopy(sVGAttrArray, 0, sVGAttrArray2, 0, n);
            return sVGAttrArray2;
        }
    }

    private static final class SVGElem
    extends Enum<SVGElem> {
        private static final /* synthetic */ SVGElem[] ENUM$VALUES;
        public static final /* enum */ SVGElem SWITCH;
        public static final /* enum */ SVGElem UNSUPPORTED;
        public static final /* enum */ SVGElem a;
        private static HashMap<String, SVGElem> cache;
        public static final /* enum */ SVGElem circle;
        public static final /* enum */ SVGElem clipPath;
        public static final /* enum */ SVGElem defs;
        public static final /* enum */ SVGElem desc;
        public static final /* enum */ SVGElem ellipse;
        public static final /* enum */ SVGElem g;
        public static final /* enum */ SVGElem image;
        public static final /* enum */ SVGElem line;
        public static final /* enum */ SVGElem linearGradient;
        public static final /* enum */ SVGElem marker;
        public static final /* enum */ SVGElem mask;
        public static final /* enum */ SVGElem path;
        public static final /* enum */ SVGElem pattern;
        public static final /* enum */ SVGElem polygon;
        public static final /* enum */ SVGElem polyline;
        public static final /* enum */ SVGElem radialGradient;
        public static final /* enum */ SVGElem rect;
        public static final /* enum */ SVGElem solidColor;
        public static final /* enum */ SVGElem stop;
        public static final /* enum */ SVGElem style;
        public static final /* enum */ SVGElem svg;
        public static final /* enum */ SVGElem symbol;
        public static final /* enum */ SVGElem text;
        public static final /* enum */ SVGElem textPath;
        public static final /* enum */ SVGElem title;
        public static final /* enum */ SVGElem tref;
        public static final /* enum */ SVGElem tspan;
        public static final /* enum */ SVGElem use;
        public static final /* enum */ SVGElem view;

        static {
            SVGElem sVGElem;
            SVGElem sVGElem2;
            SVGElem sVGElem3;
            SVGElem sVGElem4;
            SVGElem sVGElem5;
            SVGElem sVGElem6;
            SVGElem sVGElem7;
            SVGElem sVGElem8;
            SVGElem sVGElem9;
            SVGElem sVGElem10;
            SVGElem sVGElem11;
            SVGElem sVGElem12;
            SVGElem sVGElem13;
            SVGElem sVGElem14;
            SVGElem sVGElem15;
            SVGElem sVGElem16;
            SVGElem sVGElem17;
            SVGElem sVGElem18;
            SVGElem sVGElem19;
            SVGElem sVGElem20;
            SVGElem sVGElem21;
            SVGElem sVGElem22;
            SVGElem sVGElem23;
            SVGElem sVGElem24;
            SVGElem sVGElem25;
            SVGElem sVGElem26;
            SVGElem sVGElem27;
            SVGElem sVGElem28;
            SVGElem sVGElem29;
            SVGElem sVGElem30;
            SVGElem sVGElem31;
            SVGElem sVGElem32;
            svg = sVGElem32 = new SVGElem();
            a = sVGElem31 = new SVGElem();
            circle = sVGElem30 = new SVGElem();
            clipPath = sVGElem29 = new SVGElem();
            defs = sVGElem28 = new SVGElem();
            desc = sVGElem27 = new SVGElem();
            ellipse = sVGElem26 = new SVGElem();
            g = sVGElem25 = new SVGElem();
            image = sVGElem24 = new SVGElem();
            line = sVGElem23 = new SVGElem();
            linearGradient = sVGElem22 = new SVGElem();
            marker = sVGElem21 = new SVGElem();
            mask = sVGElem20 = new SVGElem();
            path = sVGElem19 = new SVGElem();
            pattern = sVGElem18 = new SVGElem();
            polygon = sVGElem17 = new SVGElem();
            polyline = sVGElem16 = new SVGElem();
            radialGradient = sVGElem15 = new SVGElem();
            rect = sVGElem14 = new SVGElem();
            solidColor = sVGElem13 = new SVGElem();
            stop = sVGElem12 = new SVGElem();
            style = sVGElem11 = new SVGElem();
            SWITCH = sVGElem10 = new SVGElem();
            symbol = sVGElem9 = new SVGElem();
            text = sVGElem8 = new SVGElem();
            textPath = sVGElem7 = new SVGElem();
            title = sVGElem6 = new SVGElem();
            tref = sVGElem5 = new SVGElem();
            tspan = sVGElem4 = new SVGElem();
            use = sVGElem3 = new SVGElem();
            view = sVGElem2 = new SVGElem();
            UNSUPPORTED = sVGElem = new SVGElem();
            ENUM$VALUES = new SVGElem[]{sVGElem32, sVGElem31, sVGElem30, sVGElem29, sVGElem28, sVGElem27, sVGElem26, sVGElem25, sVGElem24, sVGElem23, sVGElem22, sVGElem21, sVGElem20, sVGElem19, sVGElem18, sVGElem17, sVGElem16, sVGElem15, sVGElem14, sVGElem13, sVGElem12, sVGElem11, sVGElem10, sVGElem9, sVGElem8, sVGElem7, sVGElem6, sVGElem5, sVGElem4, sVGElem3, sVGElem2, sVGElem};
            cache = new HashMap();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static SVGElem fromString(String string2) {
            SVGElem sVGElem = cache.get(string2);
            if (sVGElem != null) {
                return sVGElem;
            }
            if (string2.equals("switch")) {
                HashMap<String, SVGElem> hashMap = cache;
                SVGElem sVGElem2 = SWITCH;
                hashMap.put(string2, sVGElem2);
                return sVGElem2;
            }
            try {
                SVGElem sVGElem3 = SVGElem.valueOf(string2);
                if (sVGElem3 != SWITCH) {
                    cache.put(string2, sVGElem3);
                    return sVGElem3;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            HashMap<String, SVGElem> hashMap = cache;
            SVGElem sVGElem4 = UNSUPPORTED;
            hashMap.put(string2, sVGElem4);
            return sVGElem4;
        }

        public static SVGElem valueOf(String string2) {
            return Enum.valueOf(SVGElem.class, string2);
        }

        public static SVGElem[] values() {
            SVGElem[] sVGElemArray = ENUM$VALUES;
            int n = sVGElemArray.length;
            SVGElem[] sVGElemArray2 = new SVGElem[n];
            System.arraycopy(sVGElemArray, 0, sVGElemArray2, 0, n);
            return sVGElemArray2;
        }
    }

    protected static class TextScanner {
        protected String input;
        protected int inputLength = 0;
        protected int position = 0;

        public TextScanner(String string2) {
            this.input = string2 = string2.trim();
            this.inputLength = string2.length();
        }

        protected int advanceChar() {
            int n = this.position;
            int n2 = this.inputLength;
            if (n == n2) {
                return -1;
            }
            this.position = ++n;
            if (n < n2) {
                return this.input.charAt(n);
            }
            return -1;
        }

        public String ahead() {
            int n = this.position;
            while (!this.empty() && !this.isWhitespace(this.input.charAt(this.position))) {
                ++this.position;
            }
            String string2 = this.input.substring(n, this.position);
            this.position = n;
            return string2;
        }

        public Boolean checkedNextFlag(Object object) {
            if (object == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFlag();
        }

        public Float checkedNextFloat(Object object) {
            if (object == null) {
                return null;
            }
            this.skipCommaWhitespace();
            return this.nextFloat();
        }

        public boolean consume(char c) {
            int n = this.position;
            boolean bl = n < this.inputLength && this.input.charAt(n) == c;
            if (bl) {
                ++this.position;
            }
            return bl;
        }

        public boolean consume(String string2) {
            int n = this.position;
            int n2 = string2.length();
            boolean bl = n <= this.inputLength - n2 && this.input.substring(n, n + n2).equals(string2);
            if (bl) {
                this.position += n2;
            }
            return bl;
        }

        public boolean empty() {
            return this.position == this.inputLength;
        }

        public boolean hasLetter() {
            int n = this.position;
            if (n == this.inputLength) {
                return false;
            }
            return (n = (int)this.input.charAt(n)) >= 97 && n <= 122 || n >= 65 && n <= 90;
            {
            }
        }

        protected boolean isEOL(int n) {
            return n == 10 || n == 13;
        }

        protected boolean isWhitespace(int n) {
            return n == 32 || n == 10 || n == 13 || n == 9;
        }

        public Integer nextChar() {
            int n = this.position;
            if (n == this.inputLength) {
                return null;
            }
            String string2 = this.input;
            this.position = n + 1;
            return string2.charAt(n);
        }

        public Boolean nextFlag() {
            int n = this.position;
            if (n == this.inputLength) {
                return null;
            }
            char c = this.input.charAt(n);
            if (c != '0' && c != '1') {
                return null;
            }
            n = this.position;
            boolean bl = true;
            this.position = n + 1;
            if (c != '1') {
                bl = false;
            }
            return bl;
        }

        public Float nextFloat() {
            NumberParser numberParser = NumberParser.parseNumber(this.input, this.position, this.inputLength);
            if (numberParser == null) {
                return null;
            }
            this.position = numberParser.getEndPos();
            return Float.valueOf(numberParser.value());
        }

        public String nextFunction() {
            if (this.empty()) {
                return null;
            }
            int n = this.position;
            int n2 = this.input.charAt(n);
            while (n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90) {
                n2 = this.advanceChar();
            }
            int n3 = this.position;
            while (true) {
                if (!this.isWhitespace(n2)) {
                    if (n2 == 40) {
                        ++this.position;
                        return this.input.substring(n, n3);
                    }
                    this.position = n;
                    return null;
                }
                n2 = this.advanceChar();
            }
        }

        public Integer nextInteger() {
            IntegerParser integerParser = IntegerParser.parseInt(this.input, this.position, this.inputLength);
            if (integerParser == null) {
                return null;
            }
            this.position = integerParser.getEndPos();
            return integerParser.value();
        }

        public SVG.Length nextLength() {
            Float f = this.nextFloat();
            if (f == null) {
                return null;
            }
            SVG.Unit unit = this.nextUnit();
            if (unit == null) {
                return new SVG.Length(f.floatValue(), SVG.Unit.px);
            }
            return new SVG.Length(f.floatValue(), unit);
        }

        public String nextQuotedString() {
            if (this.empty()) {
                return null;
            }
            int n = this.position;
            char c = this.input.charAt(n);
            if (c != '\'' && c != '\"') {
                return null;
            }
            int n2 = this.advanceChar();
            while (n2 != -1 && n2 != c) {
                n2 = this.advanceChar();
            }
            if (n2 == -1) {
                this.position = n;
                return null;
            }
            this.position = n2 = this.position + 1;
            return this.input.substring(n + 1, n2 - 1);
        }

        public String nextToken() {
            return this.nextToken(' ');
        }

        public String nextToken(char c) {
            if (this.empty()) {
                return null;
            }
            int n = this.input.charAt(this.position);
            if (!this.isWhitespace(n) && n != c) {
                int n2 = this.position;
                n = this.advanceChar();
                while (n != -1 && n != c && !this.isWhitespace(n)) {
                    n = this.advanceChar();
                }
                return this.input.substring(n2, this.position);
            }
            return null;
        }

        public SVG.Unit nextUnit() {
            if (this.empty()) {
                return null;
            }
            if (this.input.charAt(this.position) == '%') {
                ++this.position;
                return SVG.Unit.percent;
            }
            int n = this.position;
            if (n > this.inputLength - 2) {
                return null;
            }
            try {
                SVG.Unit unit = SVG.Unit.valueOf(this.input.substring(n, n + 2).toLowerCase(Locale.US));
                this.position += 2;
                return unit;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }

        public Float possibleNextFloat() {
            this.skipCommaWhitespace();
            NumberParser numberParser = NumberParser.parseNumber(this.input, this.position, this.inputLength);
            if (numberParser == null) {
                return null;
            }
            this.position = numberParser.getEndPos();
            return Float.valueOf(numberParser.value());
        }

        public String restOfText() {
            if (this.empty()) {
                return null;
            }
            int n = this.position;
            this.position = this.inputLength;
            return this.input.substring(n);
        }

        public boolean skipCommaWhitespace() {
            this.skipWhitespace();
            int n = this.position++;
            if (n == this.inputLength) {
                return false;
            }
            if (this.input.charAt(n) != ',') {
                return false;
            }
            this.skipWhitespace();
            return true;
        }

        public void skipWhitespace() {
            while (true) {
                int n;
                if ((n = this.position++) < this.inputLength && this.isWhitespace(this.input.charAt(n))) continue;
                return;
            }
        }
    }
}

