/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Typeface;
import android.os.Build;
import android.util.Log;
import com.caverock.androidsvg.SVGExternalFileResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;

public class SimpleAssetResolver
extends SVGExternalFileResolver {
    private static final String TAG = "SimpleAssetResolver";
    private static final Set<String> supportedFormats = new HashSet<String>(8);
    private AssetManager assetManager;

    public SimpleAssetResolver(AssetManager assetManager) {
        Set<String> set = supportedFormats;
        set.add("image/svg+xml");
        set.add("image/jpeg");
        set.add("image/png");
        set.add("image/pjpeg");
        set.add("image/gif");
        set.add("image/bmp");
        set.add("image/x-windows-bmp");
        if (Build.VERSION.SDK_INT >= 14) {
            set.add("image/webp");
        }
        this.assetManager = assetManager;
    }

    @Override
    public boolean isFormatSupported(String string2) {
        return supportedFormats.contains(string2);
    }

    @Override
    public Typeface resolveFont(String string2, int n, String string3) {
        CharSequence charSequence = TAG;
        StringBuilder stringBuilder = new StringBuilder("resolveFont(");
        stringBuilder.append(string2);
        stringBuilder.append(",");
        stringBuilder.append(n);
        stringBuilder.append(",");
        stringBuilder.append(string3);
        stringBuilder.append(")");
        Log.i((String)charSequence, (String)stringBuilder.toString());
        try {
            string3 = this.assetManager;
            charSequence = new StringBuilder(String.valueOf(string2));
            ((StringBuilder)charSequence).append(".ttf");
            string3 = Typeface.createFromAsset((AssetManager)string3, (String)((StringBuilder)charSequence).toString());
            return string3;
        }
        catch (Exception exception) {
            try {
                AssetManager assetManager = this.assetManager;
                charSequence = new StringBuilder(String.valueOf(string2));
                ((StringBuilder)charSequence).append(".otf");
                string2 = Typeface.createFromAsset((AssetManager)assetManager, (String)((StringBuilder)charSequence).toString());
                return string2;
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    @Override
    public Bitmap resolveImage(String string2) {
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder("resolveImage(");
        stringBuilder.append(string2);
        stringBuilder.append(")");
        Log.i((String)string3, (String)stringBuilder.toString());
        try {
            string2 = BitmapFactory.decodeStream((InputStream)this.assetManager.open(string2));
            return string2;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

