/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.datetimeoptionspicker;

import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.chivorn.datetimeoptionspicker.R;
import com.chivorn.datetimeoptionspicker.lib.WheelView;
import com.chivorn.datetimeoptionspicker.listener.CustomListener;
import com.chivorn.datetimeoptionspicker.view.BasePickerView;
import com.chivorn.datetimeoptionspicker.view.WheelTime;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateTimePickerView
extends BasePickerView
implements View.OnClickListener {
    private static final String TAG_CANCEL = "cancel";
    private static final String TAG_SUBMIT = "submit";
    private int Color_Background_Title;
    private int Color_Background_Wheel;
    private int Color_Cancel;
    private int Color_Submit;
    private int Color_Title;
    private int Size_Content;
    private int Size_Submit_Cancel;
    private int Size_Title;
    private String Str_Cancel;
    private String Str_Submit;
    private String Str_Title;
    private int backgroundId;
    private Button btnCancel;
    private Button btnSubmit;
    private boolean cancelable;
    private CustomListener customListener;
    private boolean cyclic;
    private Calendar date;
    private int dividerColor;
    private WheelView.DividerType dividerType;
    private Calendar endDate;
    private int endYear;
    private int gravity = 17;
    private boolean isCenterLabel;
    private boolean isDialog;
    private boolean isLunarCalendar;
    private String label_day;
    private String label_hours;
    private String label_mins;
    private String label_month;
    private String label_seconds;
    private String label_year;
    private int layoutRes;
    private float lineSpacingMultiplier = 1.6f;
    private Calendar startDate;
    private int startYear;
    private int textColorCenter;
    private int textColorOut;
    private OnTimeSelectListener timeSelectListener;
    private TextView tvTitle;
    private boolean[] type;
    WheelTime wheelTime;
    private int xoffset_day;
    private int xoffset_hours;
    private int xoffset_mins;
    private int xoffset_month;
    private int xoffset_seconds;
    private int xoffset_year;

    public DateTimePickerView(Builder builder) {
        super(builder.context);
        this.timeSelectListener = builder.timeSelectListener;
        this.gravity = builder.gravity;
        this.type = builder.type;
        this.Str_Submit = builder.Str_Submit;
        this.Str_Cancel = builder.Str_Cancel;
        this.Str_Title = builder.Str_Title;
        this.Color_Submit = builder.Color_Submit;
        this.Color_Cancel = builder.Color_Cancel;
        this.Color_Title = builder.Color_Title;
        this.Color_Background_Wheel = builder.Color_Background_Wheel;
        this.Color_Background_Title = builder.Color_Background_Title;
        this.Size_Submit_Cancel = builder.Size_Submit_Cancel;
        this.Size_Title = builder.Size_Title;
        this.Size_Content = builder.Size_Content;
        this.startYear = builder.startYear;
        this.endYear = builder.endYear;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.date = builder.date;
        this.cyclic = builder.cyclic;
        this.isCenterLabel = builder.isCenterLabel;
        this.isLunarCalendar = builder.isLunarCalendar;
        this.cancelable = builder.cancelable;
        this.label_year = builder.label_year;
        this.label_month = builder.label_month;
        this.label_day = builder.label_day;
        this.label_hours = builder.label_hours;
        this.label_mins = builder.label_mins;
        this.label_seconds = builder.label_seconds;
        this.xoffset_year = builder.xoffset_year;
        this.xoffset_month = builder.xoffset_month;
        this.xoffset_day = builder.xoffset_day;
        this.xoffset_hours = builder.xoffset_hours;
        this.xoffset_mins = builder.xoffset_mins;
        this.xoffset_seconds = builder.xoffset_seconds;
        this.textColorCenter = builder.textColorCenter;
        this.textColorOut = builder.textColorOut;
        this.dividerColor = builder.dividerColor;
        this.customListener = builder.customListener;
        this.layoutRes = builder.layoutRes;
        this.lineSpacingMultiplier = builder.lineSpacingMultiplier;
        this.isDialog = builder.isDialog;
        this.dividerType = builder.dividerType;
        this.backgroundId = builder.backgroundId;
        this.decorView = builder.decorView;
        this.initView(builder.context);
    }

    private void initView(Context object) {
        int n;
        int n2;
        this.setDialogOutSideCancelable(this.cancelable);
        this.initViews(this.backgroundId);
        this.init();
        this.initEvents();
        Object object2 = this.customListener;
        if (object2 == null) {
            LayoutInflater.from((Context)object).inflate(R.layout.datetimeoptionspicker_time, this.contentContainer);
            this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
            this.btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
            this.btnCancel = (Button)this.findViewById(R.id.btnCancel);
            this.btnSubmit.setTag((Object)TAG_SUBMIT);
            this.btnCancel.setTag((Object)TAG_CANCEL);
            this.btnSubmit.setOnClickListener((View.OnClickListener)this);
            this.btnCancel.setOnClickListener((View.OnClickListener)this);
            Button button = this.btnSubmit;
            object2 = TextUtils.isEmpty((CharSequence)this.Str_Submit) ? object.getResources().getString(R.string.datetimeoptionspicker_submit) : this.Str_Submit;
            button.setText((CharSequence)object2);
            object2 = this.btnCancel;
            object = TextUtils.isEmpty((CharSequence)this.Str_Cancel) ? object.getResources().getString(R.string.datetimeoptionspicker_cancel) : this.Str_Cancel;
            object2.setText((CharSequence)object);
            object2 = this.tvTitle;
            object = TextUtils.isEmpty((CharSequence)this.Str_Title) ? "" : this.Str_Title;
            object2.setText((CharSequence)object);
            object = this.btnSubmit;
            n = n2 = this.Color_Submit;
            if (n2 == 0) {
                n = this.pickerview_timebtn_nor;
            }
            object.setTextColor(n);
            object = this.btnCancel;
            n = n2 = this.Color_Cancel;
            if (n2 == 0) {
                n = this.pickerview_timebtn_nor;
            }
            object.setTextColor(n);
            object = this.tvTitle;
            n = n2 = this.Color_Title;
            if (n2 == 0) {
                n = this.pickerview_topbar_title;
            }
            object.setTextColor(n);
            this.btnSubmit.setTextSize((float)this.Size_Submit_Cancel);
            this.btnCancel.setTextSize((float)this.Size_Submit_Cancel);
            this.tvTitle.setTextSize((float)this.Size_Title);
            object = (RelativeLayout)this.findViewById(R.id.rv_topbar);
            n = n2 = this.Color_Background_Title;
            if (n2 == 0) {
                n = this.pickerview_bg_topbar;
            }
            object.setBackgroundColor(n);
        } else {
            object2.customLayout(LayoutInflater.from((Context)object).inflate(this.layoutRes, this.contentContainer));
        }
        object = (LinearLayout)this.findViewById(R.id.timepicker);
        n = n2 = this.Color_Background_Wheel;
        if (n2 == 0) {
            n = this.bgColor_default;
        }
        object.setBackgroundColor(n);
        object = new WheelTime((View)object, this.type, this.gravity, this.Size_Content);
        this.wheelTime = object;
        ((WheelTime)object).setLunarCalendar(this.isLunarCalendar);
        n2 = this.startYear;
        if (n2 != 0 && (n = this.endYear) != 0 && n2 <= n) {
            this.setRange();
        }
        if ((object = this.startDate) != null && this.endDate != null) {
            if (((Calendar)object).getTimeInMillis() <= this.endDate.getTimeInMillis()) {
                this.setRangDate();
            }
        } else if (object != null && this.endDate == null) {
            this.setRangDate();
        } else if (object == null && this.endDate != null) {
            this.setRangDate();
        }
        this.setTime();
        this.wheelTime.setLabels(this.label_year, this.label_month, this.label_day, this.label_hours, this.label_mins, this.label_seconds);
        this.wheelTime.setTextXOffset(this.xoffset_year, this.xoffset_month, this.xoffset_day, this.xoffset_hours, this.xoffset_mins, this.xoffset_seconds);
        this.setOutSideCancelable(this.cancelable);
        this.wheelTime.setCyclic(this.cyclic);
        this.wheelTime.setDividerColor(this.dividerColor);
        this.wheelTime.setDividerType(this.dividerType);
        this.wheelTime.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wheelTime.setTextColorOut(this.textColorOut);
        this.wheelTime.setTextColorCenter(this.textColorCenter);
        this.wheelTime.isCenterLabel(this.isCenterLabel);
    }

    private void setRangDate() {
        this.wheelTime.setRangDate(this.startDate, this.endDate);
        Calendar calendar = this.startDate;
        if (calendar != null && this.endDate != null) {
            calendar = this.date;
            if (calendar == null || calendar.getTimeInMillis() < this.startDate.getTimeInMillis() || this.date.getTimeInMillis() > this.endDate.getTimeInMillis()) {
                this.date = this.startDate;
            }
        } else if (calendar != null) {
            this.date = calendar;
        } else {
            calendar = this.endDate;
            if (calendar != null) {
                this.date = calendar;
            }
        }
    }

    private void setRange() {
        this.wheelTime.setStartYear(this.startYear);
        this.wheelTime.setEndYear(this.endYear);
    }

    private void setTime() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = this.date;
        if (calendar2 == null) {
            calendar.setTimeInMillis(System.currentTimeMillis());
            n6 = calendar.get(1);
            n5 = calendar.get(2);
            n4 = calendar.get(5);
            n3 = calendar.get(11);
            n2 = calendar.get(12);
            n = calendar.get(13);
        } else {
            n6 = calendar2.get(1);
            n5 = this.date.get(2);
            n4 = this.date.get(5);
            n3 = this.date.get(11);
            n2 = this.date.get(12);
            n = this.date.get(13);
        }
        this.wheelTime.setPicker(n6, n5, n4, n3, n2, n);
    }

    @Override
    public boolean isDialog() {
        return this.isDialog;
    }

    public boolean isLunarCalendar() {
        return this.wheelTime.isLunarCalendar();
    }

    public void onClick(View view) {
        if (((String)view.getTag()).equals(TAG_SUBMIT)) {
            this.returnData();
        }
        this.dismiss();
    }

    public void returnData() {
        if (this.timeSelectListener != null) {
            try {
                Date date = WheelTime.dateFormat.parse(this.wheelTime.getTime());
                this.timeSelectListener.onTimeSelect(date, this.clickView);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
        }
    }

    public void setDate(Calendar calendar) {
        this.date = calendar;
        this.setTime();
    }

    public void setLunarCalendar(boolean bl) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(WheelTime.dateFormat.parse(this.wheelTime.getTime()));
            int n = calendar.get(1);
            int n2 = calendar.get(2);
            int n3 = calendar.get(5);
            int n4 = calendar.get(11);
            int n5 = calendar.get(12);
            int n6 = calendar.get(13);
            this.wheelTime.setLunarCalendar(bl);
            this.wheelTime.setLabels(this.label_year, this.label_month, this.label_day, this.label_hours, this.label_mins, this.label_seconds);
            this.wheelTime.setPicker(n, n2, n3, n4, n5, n6);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
    }

    public static class Builder {
        private int Color_Background_Title;
        private int Color_Background_Wheel;
        private int Color_Cancel;
        private int Color_Submit;
        private int Color_Title;
        private int Size_Content = 18;
        private int Size_Submit_Cancel = 17;
        private int Size_Title = 18;
        private String Str_Cancel;
        private String Str_Submit;
        private String Str_Title;
        private int backgroundId;
        private boolean cancelable = true;
        private Context context;
        private CustomListener customListener;
        private boolean cyclic = false;
        private Calendar date;
        public ViewGroup decorView;
        private int dividerColor;
        private WheelView.DividerType dividerType;
        private Calendar endDate;
        private int endYear;
        private int gravity = 17;
        private boolean isCenterLabel = true;
        private boolean isDialog;
        private boolean isLunarCalendar = false;
        private String label_day;
        private String label_hours;
        private String label_mins;
        private String label_month;
        private String label_seconds;
        private String label_year;
        private int layoutRes = R.layout.datetimeoptionspicker_time;
        private float lineSpacingMultiplier = 1.6f;
        private Calendar startDate;
        private int startYear;
        private int textColorCenter;
        private int textColorOut;
        private OnTimeSelectListener timeSelectListener;
        private boolean[] type = new boolean[]{true, true, true, true, true, true};
        private int xoffset_day;
        private int xoffset_hours;
        private int xoffset_mins;
        private int xoffset_month;
        private int xoffset_seconds;
        private int xoffset_year;

        public Builder(Context context, OnTimeSelectListener onTimeSelectListener) {
            this.context = context;
            this.timeSelectListener = onTimeSelectListener;
        }

        public DateTimePickerView build() {
            return new DateTimePickerView(this);
        }

        public Builder gravity(int n) {
            this.gravity = n;
            return this;
        }

        public Builder isCenterLabel(boolean bl) {
            this.isCenterLabel = bl;
            return this;
        }

        public Builder isCyclic(boolean bl) {
            this.cyclic = bl;
            return this;
        }

        public Builder isDialog(boolean bl) {
            this.isDialog = bl;
            return this;
        }

        public Builder setBackgroundId(int n) {
            this.backgroundId = n;
            return this;
        }

        public Builder setBgColor(int n) {
            this.Color_Background_Wheel = n;
            return this;
        }

        public Builder setCancelColor(int n) {
            this.Color_Cancel = n;
            return this;
        }

        public Builder setCancelText(String string2) {
            this.Str_Cancel = string2;
            return this;
        }

        public Builder setContentSize(int n) {
            this.Size_Content = n;
            return this;
        }

        public Builder setDate(Calendar calendar) {
            this.date = calendar;
            return this;
        }

        public Builder setDecorView(ViewGroup viewGroup) {
            this.decorView = viewGroup;
            return this;
        }

        public Builder setDividerColor(int n) {
            this.dividerColor = n;
            return this;
        }

        public Builder setDividerType(WheelView.DividerType dividerType) {
            this.dividerType = dividerType;
            return this;
        }

        public Builder setLabel(String string2, String string3, String string4, String string5, String string6, String string7) {
            this.label_year = string2;
            this.label_month = string3;
            this.label_day = string4;
            this.label_hours = string5;
            this.label_mins = string6;
            this.label_seconds = string7;
            return this;
        }

        public Builder setLayoutRes(int n, CustomListener customListener) {
            this.layoutRes = n;
            this.customListener = customListener;
            return this;
        }

        public Builder setLineSpacingMultiplier(float f) {
            this.lineSpacingMultiplier = f;
            return this;
        }

        public Builder setLunarCalendar(boolean bl) {
            this.isLunarCalendar = bl;
            return this;
        }

        public Builder setOutSideCancelable(boolean bl) {
            this.cancelable = bl;
            return this;
        }

        public Builder setRangDate(Calendar calendar, Calendar calendar2) {
            this.startDate = calendar;
            this.endDate = calendar2;
            return this;
        }

        public Builder setRange(int n, int n2) {
            this.startYear = n;
            this.endYear = n2;
            return this;
        }

        public Builder setSubCalSize(int n) {
            this.Size_Submit_Cancel = n;
            return this;
        }

        public Builder setSubmitColor(int n) {
            this.Color_Submit = n;
            return this;
        }

        public Builder setSubmitText(String string2) {
            this.Str_Submit = string2;
            return this;
        }

        public Builder setTextColorCenter(int n) {
            this.textColorCenter = n;
            return this;
        }

        public Builder setTextColorOut(int n) {
            this.textColorOut = n;
            return this;
        }

        public Builder setTextXOffset(int n, int n2, int n3, int n4, int n5, int n6) {
            this.xoffset_year = n;
            this.xoffset_month = n2;
            this.xoffset_day = n3;
            this.xoffset_hours = n4;
            this.xoffset_mins = n5;
            this.xoffset_seconds = n6;
            return this;
        }

        public Builder setTitleBgColor(int n) {
            this.Color_Background_Title = n;
            return this;
        }

        public Builder setTitleColor(int n) {
            this.Color_Title = n;
            return this;
        }

        public Builder setTitleSize(int n) {
            this.Size_Title = n;
            return this;
        }

        public Builder setTitleText(String string2) {
            this.Str_Title = string2;
            return this;
        }

        public Builder setType(boolean[] blArray) {
            this.type = blArray;
            return this;
        }
    }

    public static interface OnTimeSelectListener {
        public void onTimeSelect(Date var1, View var2);
    }
}

