/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.datetimeoptionspicker;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.chivorn.datetimeoptionspicker.R;
import com.chivorn.datetimeoptionspicker.lib.WheelView;
import com.chivorn.datetimeoptionspicker.listener.CustomListener;
import com.chivorn.datetimeoptionspicker.view.BasePickerView;
import com.chivorn.datetimeoptionspicker.view.WheelOptions;
import java.util.List;

public class OptionsPickerView<T>
extends BasePickerView
implements View.OnClickListener {
    private static final String TAG_CANCEL = "cancel";
    private static final String TAG_SUBMIT = "submit";
    private int Color_Background_Title;
    private int Color_Background_Wheel;
    private int Color_Cancel;
    private int Color_Submit;
    private int Color_Title;
    private int Size_Content;
    private int Size_Submit_Cancel;
    private int Size_Title;
    private String Str_Cancel;
    private String Str_Submit;
    private String Str_Title;
    private int backgroundId;
    private Button btnCancel;
    private Button btnSubmit;
    private boolean cancelable;
    private CustomListener customListener;
    private boolean cyclic1;
    private boolean cyclic2;
    private boolean cyclic3;
    private int dividerColor;
    private WheelView.DividerType dividerType;
    private Typeface font;
    private boolean isCenterLabel;
    private boolean isDialog;
    private String label1;
    private String label2;
    private String label3;
    private int layoutRes;
    private float lineSpacingMultiplier = 1.6f;
    private boolean linkage;
    private int option1;
    private int option2;
    private int option3;
    private OnOptionsSelectListener optionsSelectListener;
    private RelativeLayout rv_top_bar;
    private int textColorCenter;
    private int textColorOut;
    private TextView tvTitle;
    WheelOptions<T> wheelOptions;
    private int xoffset_one;
    private int xoffset_three;
    private int xoffset_two;

    public OptionsPickerView(Builder builder) {
        super(builder.context);
        this.optionsSelectListener = builder.optionsSelectListener;
        this.Str_Submit = builder.Str_Submit;
        this.Str_Cancel = builder.Str_Cancel;
        this.Str_Title = builder.Str_Title;
        this.Color_Submit = builder.Color_Submit;
        this.Color_Cancel = builder.Color_Cancel;
        this.Color_Title = builder.Color_Title;
        this.Color_Background_Wheel = builder.Color_Background_Wheel;
        this.Color_Background_Title = builder.Color_Background_Title;
        this.Size_Submit_Cancel = builder.Size_Submit_Cancel;
        this.Size_Title = builder.Size_Title;
        this.Size_Content = builder.Size_Content;
        this.cyclic1 = builder.cyclic1;
        this.cyclic2 = builder.cyclic2;
        this.cyclic3 = builder.cyclic3;
        this.cancelable = builder.cancelable;
        this.linkage = builder.linkage;
        this.isCenterLabel = builder.isCenterLabel;
        this.label1 = builder.label1;
        this.label2 = builder.label2;
        this.label3 = builder.label3;
        this.font = builder.font;
        this.option1 = builder.option1;
        this.option2 = builder.option2;
        this.option3 = builder.option3;
        this.xoffset_one = builder.xoffset_one;
        this.xoffset_two = builder.xoffset_two;
        this.xoffset_three = builder.xoffset_three;
        this.textColorCenter = builder.textColorCenter;
        this.textColorOut = builder.textColorOut;
        this.dividerColor = builder.dividerColor;
        this.lineSpacingMultiplier = builder.lineSpacingMultiplier;
        this.customListener = builder.customListener;
        this.layoutRes = builder.layoutRes;
        this.isDialog = builder.isDialog;
        this.dividerType = builder.dividerType;
        this.backgroundId = builder.backgroundId;
        this.decorView = builder.decorView;
        this.initView(builder.context);
    }

    private void SetCurrentItems() {
        WheelOptions<T> wheelOptions = this.wheelOptions;
        if (wheelOptions != null) {
            wheelOptions.setCurrentItems(this.option1, this.option2, this.option3);
        }
    }

    private void initView(Context object) {
        int n;
        int n2;
        this.setDialogOutSideCancelable(this.cancelable);
        this.initViews(this.backgroundId);
        this.init();
        this.initEvents();
        Object object2 = this.customListener;
        if (object2 == null) {
            LayoutInflater.from((Context)object).inflate(this.layoutRes, this.contentContainer);
            this.tvTitle = (TextView)this.findViewById(R.id.tvTitle);
            this.rv_top_bar = (RelativeLayout)this.findViewById(R.id.rv_topbar);
            this.btnSubmit = (Button)this.findViewById(R.id.btnSubmit);
            this.btnCancel = (Button)this.findViewById(R.id.btnCancel);
            this.btnSubmit.setTag((Object)TAG_SUBMIT);
            this.btnCancel.setTag((Object)TAG_CANCEL);
            this.btnSubmit.setOnClickListener((View.OnClickListener)this);
            this.btnCancel.setOnClickListener((View.OnClickListener)this);
            Button button = this.btnSubmit;
            object2 = TextUtils.isEmpty((CharSequence)this.Str_Submit) ? object.getResources().getString(R.string.datetimeoptionspicker_submit) : this.Str_Submit;
            button.setText((CharSequence)object2);
            object2 = this.btnCancel;
            object = TextUtils.isEmpty((CharSequence)this.Str_Cancel) ? object.getResources().getString(R.string.datetimeoptionspicker_cancel) : this.Str_Cancel;
            object2.setText((CharSequence)object);
            object2 = this.tvTitle;
            object = TextUtils.isEmpty((CharSequence)this.Str_Title) ? "" : this.Str_Title;
            object2.setText((CharSequence)object);
            object = this.btnSubmit;
            n = n2 = this.Color_Submit;
            if (n2 == 0) {
                n = this.pickerview_timebtn_nor;
            }
            object.setTextColor(n);
            object = this.btnCancel;
            n = n2 = this.Color_Cancel;
            if (n2 == 0) {
                n = this.pickerview_timebtn_nor;
            }
            object.setTextColor(n);
            object = this.tvTitle;
            n = n2 = this.Color_Title;
            if (n2 == 0) {
                n = this.pickerview_topbar_title;
            }
            object.setTextColor(n);
            object = this.rv_top_bar;
            n = n2 = this.Color_Background_Title;
            if (n2 == 0) {
                n = this.pickerview_bg_topbar;
            }
            object.setBackgroundColor(n);
            this.btnSubmit.setTextSize((float)this.Size_Submit_Cancel);
            this.btnCancel.setTextSize((float)this.Size_Submit_Cancel);
            this.tvTitle.setTextSize((float)this.Size_Title);
            this.tvTitle.setText((CharSequence)this.Str_Title);
        } else {
            object2.customLayout(LayoutInflater.from((Context)object).inflate(this.layoutRes, this.contentContainer));
        }
        object = (LinearLayout)this.findViewById(R.id.optionspicker);
        n = n2 = this.Color_Background_Wheel;
        if (n2 == 0) {
            n = this.bgColor_default;
        }
        object.setBackgroundColor(n);
        this.wheelOptions = object = new WheelOptions((View)object, this.linkage);
        ((WheelOptions)object).setTextContentSize(this.Size_Content);
        this.wheelOptions.setLabels(this.label1, this.label2, this.label3);
        this.wheelOptions.setTextXOffset(this.xoffset_one, this.xoffset_two, this.xoffset_three);
        this.wheelOptions.setCyclic(this.cyclic1, this.cyclic2, this.cyclic3);
        this.wheelOptions.setTypeface(this.font);
        this.setOutSideCancelable(this.cancelable);
        object = this.tvTitle;
        if (object != null) {
            object.setText((CharSequence)this.Str_Title);
        }
        this.wheelOptions.setDividerColor(this.dividerColor);
        this.wheelOptions.setDividerType(this.dividerType);
        this.wheelOptions.setLineSpacingMultiplier(this.lineSpacingMultiplier);
        this.wheelOptions.setTextColorOut(this.textColorOut);
        this.wheelOptions.setTextColorCenter(this.textColorCenter);
        this.wheelOptions.isCenterLabel(this.isCenterLabel);
    }

    @Override
    public boolean isDialog() {
        return this.isDialog;
    }

    public void onClick(View view) {
        if (((String)view.getTag()).equals(TAG_SUBMIT)) {
            this.returnData();
        }
        this.dismiss();
    }

    public void returnData() {
        if (this.optionsSelectListener != null) {
            int[] nArray = this.wheelOptions.getCurrentItems();
            this.optionsSelectListener.onOptionsSelect(nArray[0], nArray[1], nArray[2], this.clickView);
        }
    }

    public void setNPicker(List<T> list, List<T> list2, List<T> list3) {
        this.wheelOptions.setNPicker(list, list2, list3);
        this.SetCurrentItems();
    }

    public void setPicker(List<T> list) {
        this.setPicker(list, null, null);
    }

    public void setPicker(List<T> list, List<List<T>> list2) {
        this.setPicker(list, list2, null);
    }

    public void setPicker(List<T> list, List<List<T>> list2, List<List<List<T>>> list3) {
        this.wheelOptions.setPicker(list, list2, list3);
        this.SetCurrentItems();
    }

    public void setSelectOptions(int n) {
        this.option1 = n;
        this.SetCurrentItems();
    }

    public void setSelectOptions(int n, int n2) {
        this.option1 = n;
        this.option2 = n2;
        this.SetCurrentItems();
    }

    public void setSelectOptions(int n, int n2, int n3) {
        this.option1 = n;
        this.option2 = n2;
        this.option3 = n3;
        this.SetCurrentItems();
    }

    public static class Builder {
        private int Color_Background_Title;
        private int Color_Background_Wheel;
        private int Color_Cancel;
        private int Color_Submit;
        private int Color_Title;
        private int Size_Content = 18;
        private int Size_Submit_Cancel = 17;
        private int Size_Title = 18;
        private String Str_Cancel;
        private String Str_Submit;
        private String Str_Title;
        private int backgroundId;
        private boolean cancelable = true;
        private Context context;
        private CustomListener customListener;
        private boolean cyclic1 = false;
        private boolean cyclic2 = false;
        private boolean cyclic3 = false;
        public ViewGroup decorView;
        private int dividerColor;
        private WheelView.DividerType dividerType;
        private Typeface font;
        private boolean isCenterLabel = true;
        private boolean isDialog;
        private String label1;
        private String label2;
        private String label3;
        private int layoutRes = R.layout.datetimeoptionspicker_options;
        private float lineSpacingMultiplier = 1.6f;
        private boolean linkage = true;
        private int option1;
        private int option2;
        private int option3;
        private OnOptionsSelectListener optionsSelectListener;
        private int textColorCenter;
        private int textColorOut;
        private int xoffset_one;
        private int xoffset_three;
        private int xoffset_two;

        public Builder(Context context, OnOptionsSelectListener onOptionsSelectListener) {
            this.context = context;
            this.optionsSelectListener = onOptionsSelectListener;
        }

        public OptionsPickerView build() {
            return new OptionsPickerView(this);
        }

        public Builder isCenterLabel(boolean bl) {
            this.isCenterLabel = bl;
            return this;
        }

        public Builder isDialog(boolean bl) {
            this.isDialog = bl;
            return this;
        }

        public Builder setBackgroundId(int n) {
            this.backgroundId = n;
            return this;
        }

        public Builder setBgColor(int n) {
            this.Color_Background_Wheel = n;
            return this;
        }

        public Builder setCancelColor(int n) {
            this.Color_Cancel = n;
            return this;
        }

        public Builder setCancelText(String string2) {
            this.Str_Cancel = string2;
            return this;
        }

        public Builder setContentTextSize(int n) {
            this.Size_Content = n;
            return this;
        }

        public Builder setCyclic(boolean bl, boolean bl2, boolean bl3) {
            this.cyclic1 = bl;
            this.cyclic2 = bl2;
            this.cyclic3 = bl3;
            return this;
        }

        public Builder setDecorView(ViewGroup viewGroup) {
            this.decorView = viewGroup;
            return this;
        }

        public Builder setDividerColor(int n) {
            this.dividerColor = n;
            return this;
        }

        public Builder setDividerType(WheelView.DividerType dividerType) {
            this.dividerType = dividerType;
            return this;
        }

        public Builder setLabels(String string2, String string3, String string4) {
            this.label1 = string2;
            this.label2 = string3;
            this.label3 = string4;
            return this;
        }

        public Builder setLayoutRes(int n, CustomListener customListener) {
            this.layoutRes = n;
            this.customListener = customListener;
            return this;
        }

        public Builder setLineSpacingMultiplier(float f) {
            this.lineSpacingMultiplier = f;
            return this;
        }

        @Deprecated
        public Builder setLinkage(boolean bl) {
            this.linkage = bl;
            return this;
        }

        public Builder setOutSideCancelable(boolean bl) {
            this.cancelable = bl;
            return this;
        }

        public Builder setSelectOptions(int n) {
            this.option1 = n;
            return this;
        }

        public Builder setSelectOptions(int n, int n2) {
            this.option1 = n;
            this.option2 = n2;
            return this;
        }

        public Builder setSelectOptions(int n, int n2, int n3) {
            this.option1 = n;
            this.option2 = n2;
            this.option3 = n3;
            return this;
        }

        public Builder setSubCalSize(int n) {
            this.Size_Submit_Cancel = n;
            return this;
        }

        public Builder setSubmitColor(int n) {
            this.Color_Submit = n;
            return this;
        }

        public Builder setSubmitText(String string2) {
            this.Str_Submit = string2;
            return this;
        }

        public Builder setTextColorCenter(int n) {
            this.textColorCenter = n;
            return this;
        }

        public Builder setTextColorOut(int n) {
            this.textColorOut = n;
            return this;
        }

        public Builder setTextXOffset(int n, int n2, int n3) {
            this.xoffset_one = n;
            this.xoffset_two = n2;
            this.xoffset_three = n3;
            return this;
        }

        public Builder setTitleBgColor(int n) {
            this.Color_Background_Title = n;
            return this;
        }

        public Builder setTitleColor(int n) {
            this.Color_Title = n;
            return this;
        }

        public Builder setTitleSize(int n) {
            this.Size_Title = n;
            return this;
        }

        public Builder setTitleText(String string2) {
            this.Str_Title = string2;
            return this;
        }

        public Builder setTypeface(Typeface typeface) {
            this.font = typeface;
            return this;
        }
    }

    public static interface OnOptionsSelectListener {
        public void onOptionsSelect(int var1, int var2, int var3, View var4);
    }
}

