/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.datetimeoptionspicker.lib;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.chivorn.datetimeoptionspicker.R;
import com.chivorn.datetimeoptionspicker.adapter.WheelAdapter;
import com.chivorn.datetimeoptionspicker.lib.InertiaTimerTask;
import com.chivorn.datetimeoptionspicker.lib.LoopViewGestureListener;
import com.chivorn.datetimeoptionspicker.lib.MessageHandler;
import com.chivorn.datetimeoptionspicker.lib.OnItemSelectedRunnable;
import com.chivorn.datetimeoptionspicker.lib.SmoothScrollTimerTask;
import com.chivorn.datetimeoptionspicker.listener.OnItemSelectedListener;
import com.chivorn.datetimeoptionspicker.model.IPickerViewData;
import java.util.Locale;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class WheelView
extends View {
    private static final float SCALECONTENT = 0.8f;
    private static final int VELOCITYFLING = 5;
    private float CENTERCONTENTOFFSET;
    private final float DEFAULT_TEXT_TARGET_SKEWX;
    WheelAdapter adapter;
    float centerY;
    int change;
    Context context;
    int dividerColor = -2763307;
    private DividerType dividerType;
    private int drawCenterContentStart = 0;
    private int drawOutContentStart = 0;
    float firstLineY;
    private GestureDetector gestureDetector;
    int halfCircumference;
    Handler handler;
    int initPosition;
    private boolean isCenterLabel = true;
    boolean isLoop;
    private boolean isOptions = false;
    float itemHeight;
    int itemsVisible = 11;
    private String label;
    float lineSpacingMultiplier = 1.6f;
    ScheduledExecutorService mExecutor = Executors.newSingleThreadScheduledExecutor();
    private ScheduledFuture<?> mFuture;
    private int mGravity = 17;
    private int mOffset = 0;
    int maxTextHeight;
    int maxTextWidth;
    int measuredHeight;
    int measuredWidth;
    OnItemSelectedListener onItemSelectedListener;
    Paint paintCenterText;
    Paint paintIndicator;
    Paint paintOuterText;
    int preCurrentIndex;
    private float previousY = 0.0f;
    int radius;
    float secondLineY;
    private int selectedItem;
    long startTime = 0L;
    int textColorCenter = -14013910;
    int textColorOut = -5723992;
    int textSize;
    private int textXOffset;
    float totalScrollY;
    Typeface typeface = Typeface.MONOSPACE;
    int widthMeasureSpec;

    public WheelView(Context context) {
        this(context, null);
    }

    public WheelView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.DEFAULT_TEXT_TARGET_SKEWX = 0.5f;
        this.textSize = this.getResources().getDimensionPixelSize(R.dimen.datetimeoptionspicker_textsize);
        float f = this.getResources().getDisplayMetrics().density;
        if (f < 1.0f) {
            this.CENTERCONTENTOFFSET = 2.4f;
        } else {
            float f2 = 1.0f - f;
            float f3 = f2 == 0.0f ? 0 : (f2 < 0.0f ? -1 : 1);
            if (f3 <= 0 && f < 2.0f) {
                this.CENTERCONTENTOFFSET = 3.6f;
            } else if (f3 <= 0 && f < 2.0f) {
                this.CENTERCONTENTOFFSET = 4.5f;
            } else if (2.0f <= f && f < 3.0f) {
                this.CENTERCONTENTOFFSET = 6.0f;
            } else if (f >= 3.0f) {
                this.CENTERCONTENTOFFSET = f * 2.5f;
            }
        }
        if (attributeSet != null) {
            attributeSet = context.obtainStyledAttributes(attributeSet, R.styleable.pickerview, 0, 0);
            this.mGravity = attributeSet.getInt(R.styleable.pickerview_pickerview_gravity, 17);
            this.textColorOut = attributeSet.getColor(R.styleable.pickerview_datetimeoptionspicker_textColorOut, this.textColorOut);
            this.textColorCenter = attributeSet.getColor(R.styleable.pickerview_datetimeoptionspicker_textColorCenter, this.textColorCenter);
            this.dividerColor = attributeSet.getColor(R.styleable.pickerview_datetimeoptionspicker_dividerColor, this.dividerColor);
            this.textSize = attributeSet.getDimensionPixelOffset(R.styleable.pickerview_datetimeoptionspicker_textSize, this.textSize);
            this.lineSpacingMultiplier = attributeSet.getFloat(R.styleable.pickerview_datetimeoptionspicker_lineSpacingMultiplier, this.lineSpacingMultiplier);
            attributeSet.recycle();
        }
        this.judgeLineSpace();
        this.initLoopView(context);
    }

    private String getContentText(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof IPickerViewData) {
            return ((IPickerViewData)object).getPickerViewText();
        }
        if (object instanceof Integer) {
            return String.format(Locale.getDefault(), "%02d", (int)((Integer)object));
        }
        return object.toString();
    }

    private int getLoopMappingIndex(int n) {
        int n2;
        if (n < 0) {
            n2 = this.getLoopMappingIndex(n + this.adapter.getItemsCount());
        } else {
            n2 = n;
            if (n > this.adapter.getItemsCount() - 1) {
                n2 = this.getLoopMappingIndex(n - this.adapter.getItemsCount());
            }
        }
        return n2;
    }

    private void initLoopView(Context context) {
        this.context = context;
        this.handler = new MessageHandler(this);
        context = new GestureDetector(context, (GestureDetector.OnGestureListener)new LoopViewGestureListener(this));
        this.gestureDetector = context;
        context.setIsLongpressEnabled(false);
        this.isLoop = true;
        this.totalScrollY = 0.0f;
        this.initPosition = -1;
        this.initPaints();
    }

    private void initPaints() {
        Paint paint;
        this.paintOuterText = paint = new Paint();
        paint.setColor(this.textColorOut);
        this.paintOuterText.setAntiAlias(true);
        this.paintOuterText.setTypeface(this.typeface);
        this.paintOuterText.setTextSize((float)this.textSize);
        this.paintCenterText = paint = new Paint();
        paint.setColor(this.textColorCenter);
        this.paintCenterText.setAntiAlias(true);
        this.paintCenterText.setTextScaleX(1.1f);
        this.paintCenterText.setTypeface(this.typeface);
        this.paintCenterText.setTextSize((float)this.textSize);
        this.paintIndicator = paint = new Paint();
        paint.setColor(this.dividerColor);
        this.paintIndicator.setAntiAlias(true);
        if (Build.VERSION.SDK_INT >= 11) {
            this.setLayerType(1, null);
        }
    }

    private void judgeLineSpace() {
        float f = this.lineSpacingMultiplier;
        if (f < 1.2f) {
            this.lineSpacingMultiplier = 1.2f;
        } else if (f > 2.0f) {
            this.lineSpacingMultiplier = 2.0f;
        }
    }

    private void measureTextWidthHeight() {
        Rect rect = new Rect();
        for (int i = 0; i < this.adapter.getItemsCount(); ++i) {
            String string2 = this.getContentText(this.adapter.getItem(i));
            this.paintCenterText.getTextBounds(string2, 0, string2.length(), rect);
            int n = rect.width();
            if (n > this.maxTextWidth) {
                this.maxTextWidth = n;
            }
            this.paintCenterText.getTextBounds("\u661f\u671f", 0, 2, rect);
            this.maxTextHeight = rect.height() + 2;
        }
        this.itemHeight = this.lineSpacingMultiplier * (float)this.maxTextHeight;
    }

    private void measuredCenterContentStart(String string2) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(string2, 0, string2.length(), rect);
        int n = this.mGravity;
        if (n != 3) {
            if (n != 5) {
                if (n == 17) {
                    this.drawCenterContentStart = !this.isOptions && (string2 = this.label) != null && !string2.equals("") && this.isCenterLabel ? (int)((double)(this.measuredWidth - rect.width()) * 0.25) : (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                }
            } else {
                this.drawCenterContentStart = this.measuredWidth - rect.width() - (int)this.CENTERCONTENTOFFSET;
            }
        } else {
            this.drawCenterContentStart = 0;
        }
    }

    private void measuredOutContentStart(String string2) {
        Rect rect = new Rect();
        this.paintOuterText.getTextBounds(string2, 0, string2.length(), rect);
        int n = this.mGravity;
        if (n != 3) {
            if (n != 5) {
                if (n == 17) {
                    this.drawOutContentStart = !this.isOptions && (string2 = this.label) != null && !string2.equals("") && this.isCenterLabel ? (int)((double)(this.measuredWidth - rect.width()) * 0.25) : (int)((double)(this.measuredWidth - rect.width()) * 0.5);
                }
            } else {
                this.drawOutContentStart = this.measuredWidth - rect.width() - (int)this.CENTERCONTENTOFFSET;
            }
        } else {
            this.drawOutContentStart = 0;
        }
    }

    private void reMeasureTextSize(String string2) {
        Rect rect = new Rect();
        this.paintCenterText.getTextBounds(string2, 0, string2.length(), rect);
        int n = rect.width();
        int n2 = this.textSize;
        while (n > this.measuredWidth) {
            this.paintCenterText.setTextSize((float)(--n2));
            this.paintCenterText.getTextBounds(string2, 0, string2.length(), rect);
            n = rect.width();
        }
        this.paintOuterText.setTextSize((float)n2);
    }

    private void remeasure() {
        int n;
        if (this.adapter == null) {
            return;
        }
        this.measureTextWidthHeight();
        this.halfCircumference = n = (int)(this.itemHeight * (float)(this.itemsVisible - 1));
        this.measuredHeight = (int)((double)(n * 2) / Math.PI);
        this.radius = (int)((double)n / Math.PI);
        this.measuredWidth = View.MeasureSpec.getSize((int)this.widthMeasureSpec);
        n = this.measuredHeight;
        float f = n;
        float f2 = this.itemHeight;
        this.firstLineY = (f - f2) / 2.0f;
        this.secondLineY = f = ((float)n + f2) / 2.0f;
        this.centerY = f - (f2 - (float)this.maxTextHeight) / 2.0f - this.CENTERCONTENTOFFSET;
        if (this.initPosition == -1) {
            this.initPosition = this.isLoop ? (this.adapter.getItemsCount() + 1) / 2 : 0;
        }
        this.preCurrentIndex = this.initPosition;
    }

    public void cancelFuture() {
        ScheduledFuture<?> scheduledFuture = this.mFuture;
        if (scheduledFuture != null && !scheduledFuture.isCancelled()) {
            this.mFuture.cancel(true);
            this.mFuture = null;
        }
    }

    public final WheelAdapter getAdapter() {
        return this.adapter;
    }

    public final int getCurrentItem() {
        return this.selectedItem;
    }

    public int getItemsCount() {
        WheelAdapter wheelAdapter = this.adapter;
        int n = wheelAdapter != null ? wheelAdapter.getItemsCount() : 0;
        return n;
    }

    public int getTextWidth(Paint paint, String string2) {
        int n = 0;
        int n2 = n;
        if (string2 != null) {
            n2 = n;
            if (string2.length() > 0) {
                n = string2.length();
                float[] fArray = new float[n];
                paint.getTextWidths(string2, fArray);
                n2 = 0;
                for (int i = 0; i < n; ++i) {
                    n2 += (int)Math.ceil(fArray[i]);
                }
            }
        }
        return n2;
    }

    public void isCenterLabel(Boolean bl) {
        this.isCenterLabel = bl;
    }

    protected void onDraw(Canvas canvas) {
        float f;
        float f2;
        float f3;
        int n;
        int n2;
        Object object = this.adapter;
        if (object == null) {
            return;
        }
        if (this.initPosition < 0) {
            this.initPosition = 0;
        }
        if (this.initPosition >= object.getItemsCount()) {
            this.initPosition = this.adapter.getItemsCount() - 1;
        }
        Object[] objectArray = new Object[this.itemsVisible];
        this.change = n2 = (int)(this.totalScrollY / this.itemHeight);
        try {
            this.preCurrentIndex = this.initPosition + n2 % this.adapter.getItemsCount();
        }
        catch (ArithmeticException arithmeticException) {
            Log.e((String)"WheelView", (String)"\u51fa\u9519\u4e86\uff01adapter.getItemsCount() == 0\uff0c\u8054\u52a8\u6570\u636e\u4e0d\u5339\u914d");
        }
        if (!this.isLoop) {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = 0;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex = this.adapter.getItemsCount() - 1;
            }
        } else {
            if (this.preCurrentIndex < 0) {
                this.preCurrentIndex = this.adapter.getItemsCount() + this.preCurrentIndex;
            }
            if (this.preCurrentIndex > this.adapter.getItemsCount() - 1) {
                this.preCurrentIndex -= this.adapter.getItemsCount();
            }
        }
        float f4 = this.totalScrollY;
        float f5 = this.itemHeight;
        for (n2 = 0; n2 < (n = this.itemsVisible); ++n2) {
            n = this.preCurrentIndex - (n / 2 - n2);
            if (this.isLoop) {
                n = this.getLoopMappingIndex(n);
                objectArray[n2] = this.adapter.getItem(n);
                continue;
            }
            objectArray[n2] = n < 0 ? "" : (n > this.adapter.getItemsCount() - 1 ? "" : this.adapter.getItem(n));
        }
        if (this.dividerType == DividerType.WRAP) {
            n2 = TextUtils.isEmpty((CharSequence)this.label) ? (this.measuredWidth - this.maxTextWidth) / 2 : (this.measuredWidth - this.maxTextWidth) / 4;
            f3 = n2 - 12;
            if (f3 <= 0.0f) {
                f3 = 10.0f;
            }
            f2 = (float)this.measuredWidth - f3;
            f = this.firstLineY;
            canvas.drawLine(f3, f, f2, f, this.paintIndicator);
            f = this.secondLineY;
            canvas.drawLine(f3, f, f2, f, this.paintIndicator);
        } else {
            f3 = this.firstLineY;
            canvas.drawLine(0.0f, f3, (float)this.measuredWidth, f3, this.paintIndicator);
            f3 = this.secondLineY;
            canvas.drawLine(0.0f, f3, (float)this.measuredWidth, f3, this.paintIndicator);
        }
        if (!TextUtils.isEmpty((CharSequence)this.label) && this.isCenterLabel) {
            n = this.measuredWidth;
            n2 = this.getTextWidth(this.paintCenterText, this.label);
            canvas.drawText(this.label, (float)(n - n2) - this.CENTERCONTENTOFFSET, this.centerY, this.paintCenterText);
        }
        for (n = 0; n < this.itemsVisible; ++n) {
            canvas.save();
            double d = (this.itemHeight * (float)n - f4 % f5) / (float)this.radius;
            f3 = (float)(90.0 - d / Math.PI * 180.0);
            if (!(f3 >= 90.0f) && !(f3 <= -90.0f)) {
                float f6 = (float)Math.pow(Math.abs(f3) / 90.0f, 2.2);
                if (!(this.isCenterLabel || TextUtils.isEmpty((CharSequence)this.label) || TextUtils.isEmpty((CharSequence)this.getContentText(objectArray[n])))) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append(this.getContentText(objectArray[n]));
                    ((StringBuilder)object).append(this.label);
                    object = ((StringBuilder)object).toString();
                } else {
                    object = this.getContentText(objectArray[n]);
                }
                this.reMeasureTextSize((String)object);
                this.measuredCenterContentStart((String)object);
                this.measuredOutContentStart((String)object);
                float f7 = (float)((double)this.radius - Math.cos(d) * (double)this.radius - Math.sin(d) * (double)this.maxTextHeight / 2.0);
                canvas.translate(0.0f, f7);
                f2 = this.firstLineY;
                if (f7 <= f2 && (float)this.maxTextHeight + f7 >= f2) {
                    canvas.save();
                    canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.firstLineY - f7);
                    canvas.scale(1.0f, (float)Math.sin(d) * 0.8f);
                    canvas.drawText((String)object, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                    canvas.restore();
                    canvas.save();
                    canvas.clipRect(0.0f, this.firstLineY - f7, (float)this.measuredWidth, (float)((int)this.itemHeight));
                    canvas.scale(1.0f, (float)Math.sin(d) * 1.0f);
                    canvas.drawText((String)object, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTERCONTENTOFFSET, this.paintCenterText);
                    canvas.restore();
                } else {
                    f = this.secondLineY;
                    if (f7 <= f && (float)this.maxTextHeight + f7 >= f) {
                        canvas.save();
                        canvas.clipRect(0.0f, 0.0f, (float)this.measuredWidth, this.secondLineY - f7);
                        canvas.scale(1.0f, (float)Math.sin(d) * 1.0f);
                        canvas.drawText((String)object, (float)this.drawCenterContentStart, (float)this.maxTextHeight - this.CENTERCONTENTOFFSET, this.paintCenterText);
                        canvas.restore();
                        canvas.save();
                        canvas.clipRect(0.0f, this.secondLineY - f7, (float)this.measuredWidth, (float)((int)this.itemHeight));
                        canvas.scale(1.0f, (float)Math.sin(d) * 0.8f);
                        canvas.drawText((String)object, (float)this.drawOutContentStart, (float)this.maxTextHeight, this.paintOuterText);
                        canvas.restore();
                    } else if (f7 >= f2 && (float)(n2 = this.maxTextHeight) + f7 <= f) {
                        f3 = n2;
                        f2 = this.CENTERCONTENTOFFSET;
                        canvas.drawText((String)object, (float)this.drawCenterContentStart, f3 - f2, this.paintCenterText);
                        this.selectedItem = this.adapter.indexOf(objectArray[n]);
                    } else {
                        canvas.save();
                        canvas.clipRect(0, 0, this.measuredWidth, (int)this.itemHeight);
                        canvas.scale(1.0f, (float)Math.sin(d) * 0.8f);
                        Paint paint = this.paintOuterText;
                        n2 = this.textXOffset;
                        int n3 = -1;
                        n2 = n2 == 0 ? 0 : (n2 > 0 ? 1 : -1);
                        if (!(f3 > 0.0f)) {
                            n3 = 1;
                        }
                        paint.setTextSkewX((float)(n2 * n3) * 0.5f * f6);
                        this.paintOuterText.setAlpha((int)((1.0f - f6) * 255.0f));
                        canvas.drawText((String)object, (float)this.drawOutContentStart + (float)this.textXOffset * f6, (float)this.maxTextHeight, this.paintOuterText);
                        canvas.restore();
                    }
                }
                canvas.restore();
                this.paintCenterText.setTextSize((float)this.textSize);
                continue;
            }
            canvas.restore();
        }
    }

    protected final void onItemSelected() {
        if (this.onItemSelectedListener != null) {
            this.postDelayed(new OnItemSelectedRunnable(this), 200L);
        }
    }

    protected void onMeasure(int n, int n2) {
        this.widthMeasureSpec = n;
        this.remeasure();
        this.setMeasuredDimension(this.measuredWidth, this.measuredHeight);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean bl = this.gestureDetector.onTouchEvent(motionEvent);
        int n = motionEvent.getAction();
        if (n != 0) {
            if (n != 2) {
                if (!bl) {
                    float f = motionEvent.getY();
                    n = this.radius;
                    double d = Math.acos(((float)n - f) / (float)n);
                    double d2 = this.radius;
                    f = this.itemHeight;
                    n = (int)((d * d2 + (double)(f / 2.0f)) / (double)f);
                    float f2 = this.totalScrollY;
                    this.mOffset = (int)((float)(n - this.itemsVisible / 2) * f - (f2 % f + f) % f);
                    if (System.currentTimeMillis() - this.startTime > 120L) {
                        this.smoothScroll(ACTION.DAGGLE);
                    } else {
                        this.smoothScroll(ACTION.CLICK);
                    }
                }
            } else {
                float f = this.previousY - motionEvent.getRawY();
                this.previousY = motionEvent.getRawY();
                this.totalScrollY += f;
                if (!this.isLoop) {
                    float f3;
                    float f4 = (float)(-this.initPosition) * this.itemHeight;
                    float f5 = this.adapter.getItemsCount() - 1 - this.initPosition;
                    float f6 = this.itemHeight;
                    float f7 = f5 * f6;
                    float f8 = this.totalScrollY;
                    if ((double)f8 - (double)f6 * 0.25 < (double)f4) {
                        f3 = f8 - f;
                        f5 = f7;
                    } else {
                        f5 = f7;
                        f3 = f4;
                        if ((double)f8 + (double)f6 * 0.25 > (double)f7) {
                            f5 = f8 - f;
                            f3 = f4;
                        }
                    }
                    if (f8 < f3) {
                        this.totalScrollY = (int)f3;
                    } else if (f8 > f5) {
                        this.totalScrollY = (int)f5;
                    }
                }
            }
        } else {
            this.startTime = System.currentTimeMillis();
            this.cancelFuture();
            this.previousY = motionEvent.getRawY();
        }
        this.invalidate();
        return true;
    }

    protected final void scrollBy(float f) {
        this.cancelFuture();
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new InertiaTimerTask(this, f), 0L, 5L, TimeUnit.MILLISECONDS);
    }

    public final void setAdapter(WheelAdapter wheelAdapter) {
        this.adapter = wheelAdapter;
        this.remeasure();
        this.invalidate();
    }

    public final void setCurrentItem(int n) {
        this.selectedItem = n;
        this.initPosition = n;
        this.totalScrollY = 0.0f;
        this.invalidate();
    }

    public final void setCyclic(boolean bl) {
        this.isLoop = bl;
    }

    public void setDividerColor(int n) {
        if (n != 0) {
            this.dividerColor = n;
            this.paintIndicator.setColor(n);
        }
    }

    public void setDividerType(DividerType dividerType) {
        this.dividerType = dividerType;
    }

    public void setGravity(int n) {
        this.mGravity = n;
    }

    public void setIsOptions(boolean bl) {
        this.isOptions = bl;
    }

    public void setLabel(String string2) {
        this.label = string2;
    }

    public void setLineSpacingMultiplier(float f) {
        if (f != 0.0f) {
            this.lineSpacingMultiplier = f;
            this.judgeLineSpace();
        }
    }

    public final void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        this.onItemSelectedListener = onItemSelectedListener;
    }

    public void setTextColorCenter(int n) {
        if (n != 0) {
            this.textColorCenter = n;
            this.paintCenterText.setColor(n);
        }
    }

    public void setTextColorOut(int n) {
        if (n != 0) {
            this.textColorOut = n;
            this.paintOuterText.setColor(n);
        }
    }

    public final void setTextSize(float f) {
        if (f > 0.0f) {
            int n;
            this.textSize = n = (int)(this.context.getResources().getDisplayMetrics().density * f);
            this.paintOuterText.setTextSize((float)n);
            this.paintCenterText.setTextSize((float)this.textSize);
        }
    }

    public void setTextXOffset(int n) {
        this.textXOffset = n;
        if (n != 0) {
            this.paintCenterText.setTextScaleX(1.0f);
        }
    }

    public final void setTypeface(Typeface typeface) {
        this.typeface = typeface;
        this.paintOuterText.setTypeface(typeface);
        this.paintCenterText.setTypeface(this.typeface);
    }

    void smoothScroll(ACTION aCTION) {
        this.cancelFuture();
        if (aCTION == ACTION.FLING || aCTION == ACTION.DAGGLE) {
            int n;
            float f = this.totalScrollY;
            float f2 = this.itemHeight;
            this.mOffset = n = (int)((f % f2 + f2) % f2);
            this.mOffset = (float)n > f2 / 2.0f ? (int)(f2 - (float)n) : -n;
        }
        this.mFuture = this.mExecutor.scheduleWithFixedDelay(new SmoothScrollTimerTask(this, this.mOffset), 0L, 10L, TimeUnit.MILLISECONDS);
    }

    public static final class ACTION
    extends Enum<ACTION> {
        private static final /* synthetic */ ACTION[] $VALUES;
        public static final /* enum */ ACTION CLICK;
        public static final /* enum */ ACTION DAGGLE;
        public static final /* enum */ ACTION FLING;

        static {
            ACTION aCTION;
            ACTION aCTION2;
            ACTION aCTION3;
            CLICK = aCTION3 = new ACTION();
            FLING = aCTION2 = new ACTION();
            DAGGLE = aCTION = new ACTION();
            $VALUES = new ACTION[]{aCTION3, aCTION2, aCTION};
        }

        public static ACTION valueOf(String string2) {
            return Enum.valueOf(ACTION.class, string2);
        }

        public static ACTION[] values() {
            return (ACTION[])$VALUES.clone();
        }
    }

    public static final class DividerType
    extends Enum<DividerType> {
        private static final /* synthetic */ DividerType[] $VALUES;
        public static final /* enum */ DividerType FILL;
        public static final /* enum */ DividerType WRAP;

        static {
            DividerType dividerType;
            DividerType dividerType2;
            FILL = dividerType2 = new DividerType();
            WRAP = dividerType = new DividerType();
            $VALUES = new DividerType[]{dividerType2, dividerType};
        }

        public static DividerType valueOf(String string2) {
            return Enum.valueOf(DividerType.class, string2);
        }

        public static DividerType[] values() {
            return (DividerType[])$VALUES.clone();
        }
    }
}

