/*
 * Decompiled with CFR 0.152.
 */
package com.chivorn.datetimeoptionspicker.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.chivorn.datetimeoptionspicker.R;
import com.chivorn.datetimeoptionspicker.listener.OnDismissListener;
import com.chivorn.datetimeoptionspicker.utils.DateTimeOptionPickerViewAnimateUtil;

public class BasePickerView {
    protected int bgColor_default = -1;
    private boolean cancelable;
    protected View clickView;
    protected ViewGroup contentContainer;
    private Context context;
    public ViewGroup decorView;
    private ViewGroup dialogView;
    private boolean dismissing;
    private int gravity = 80;
    private Animation inAnim;
    private boolean isAnim = true;
    private boolean isShowing;
    private Dialog mDialog;
    private final View.OnTouchListener onCancelableTouchListener;
    private OnDismissListener onDismissListener;
    private View.OnKeyListener onKeyBackListener;
    private Animation outAnim;
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    protected int pickerview_bg_topbar = -657931;
    protected int pickerview_timebtn_nor = -16417281;
    protected int pickerview_timebtn_pre = -4007179;
    protected int pickerview_topbar_title = -16777216;
    private ViewGroup rootView;

    public BasePickerView(Context context) {
        this.onKeyBackListener = new View.OnKeyListener(){

            public boolean onKey(View view, int n, KeyEvent keyEvent) {
                if (n == 4 && keyEvent.getAction() == 0 && BasePickerView.this.isShowing()) {
                    BasePickerView.this.dismiss();
                    return true;
                }
                return false;
            }
        };
        this.onCancelableTouchListener = new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    BasePickerView.this.dismiss();
                }
                return false;
            }
        };
        this.context = context;
    }

    static /* synthetic */ boolean access$102(BasePickerView basePickerView, boolean bl) {
        basePickerView.isShowing = bl;
        return bl;
    }

    static /* synthetic */ boolean access$202(BasePickerView basePickerView, boolean bl) {
        basePickerView.dismissing = bl;
        return bl;
    }

    private void onAttached(View view) {
        this.decorView.addView(view);
        if (this.isAnim) {
            this.contentContainer.startAnimation(this.inAnim);
        }
    }

    public void createDialog() {
        if (this.dialogView != null) {
            Dialog dialog;
            this.mDialog = dialog = new Dialog(this.context, R.style.custom_dialog2);
            dialog.setCancelable(this.cancelable);
            this.mDialog.setContentView((View)this.dialogView);
            this.mDialog.getWindow().setWindowAnimations(R.style.datetimeoptionspicker_dialogAnim);
            this.mDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                public void onDismiss(DialogInterface dialogInterface) {
                    if (BasePickerView.this.onDismissListener != null) {
                        BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                    }
                }
            });
        }
    }

    public void dismiss() {
        if (this.isDialog()) {
            this.dismissDialog();
        } else {
            if (this.dismissing) {
                return;
            }
            if (this.isAnim) {
                this.outAnim.setAnimationListener(new Animation.AnimationListener(){

                    public void onAnimationEnd(Animation animation) {
                        BasePickerView.this.dismissImmediately();
                    }

                    public void onAnimationRepeat(Animation animation) {
                    }

                    public void onAnimationStart(Animation animation) {
                    }
                });
                this.contentContainer.startAnimation(this.outAnim);
            } else {
                this.dismissImmediately();
            }
            this.dismissing = true;
        }
    }

    public void dismissDialog() {
        Dialog dialog = this.mDialog;
        if (dialog != null) {
            dialog.dismiss();
        }
    }

    public void dismissImmediately() {
        this.decorView.post(new Runnable(){

            @Override
            public void run() {
                BasePickerView.this.decorView.removeView((View)BasePickerView.this.rootView);
                BasePickerView.access$102(BasePickerView.this, false);
                BasePickerView.access$202(BasePickerView.this, false);
                if (BasePickerView.this.onDismissListener != null) {
                    BasePickerView.this.onDismissListener.onDismiss(BasePickerView.this);
                }
            }
        });
    }

    public View findViewById(int n) {
        return this.contentContainer.findViewById(n);
    }

    public Animation getInAnimation() {
        int n = DateTimeOptionPickerViewAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)this.context, (int)n);
    }

    public Animation getOutAnimation() {
        int n = DateTimeOptionPickerViewAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)this.context, (int)n);
    }

    protected void init() {
        this.inAnim = this.getInAnimation();
        this.outAnim = this.getOutAnimation();
    }

    protected void initEvents() {
    }

    protected void initViews(int n) {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        if (this.isDialog()) {
            layoutInflater = (ViewGroup)layoutInflater.inflate(R.layout.layout_base_datetimeoptionspicker, null, false);
            this.dialogView = layoutInflater;
            layoutInflater.setBackgroundColor(0);
            this.contentContainer = (ViewGroup)this.dialogView.findViewById(R.id.content_container);
            this.params.leftMargin = 30;
            this.params.rightMargin = 30;
            this.contentContainer.setLayoutParams((ViewGroup.LayoutParams)this.params);
            this.createDialog();
            this.dialogView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    BasePickerView.this.dismiss();
                }
            });
        } else {
            if (this.decorView == null) {
                this.decorView = (ViewGroup)((Activity)this.context).getWindow().getDecorView().findViewById(0x1020002);
            }
            layoutInflater = (ViewGroup)layoutInflater.inflate(R.layout.layout_base_datetimeoptionspicker, this.decorView, false);
            this.rootView = layoutInflater;
            layoutInflater.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            if (n != 0) {
                this.rootView.setBackgroundColor(n);
            }
            layoutInflater = (ViewGroup)this.rootView.findViewById(R.id.content_container);
            this.contentContainer = layoutInflater;
            layoutInflater.setLayoutParams((ViewGroup.LayoutParams)this.params);
        }
        this.setKeyBackCancelable(true);
    }

    public boolean isDialog() {
        return false;
    }

    public boolean isShowing() {
        boolean bl = this.isDialog();
        boolean bl2 = false;
        if (bl) {
            return false;
        }
        if (this.rootView.getParent() != null || this.isShowing) {
            bl2 = true;
        }
        return bl2;
    }

    public void setDialogOutSideCancelable(boolean bl) {
        this.cancelable = bl;
        Dialog dialog = this.mDialog;
        if (dialog != null) {
            dialog.setCancelable(bl);
        }
    }

    public void setKeyBackCancelable(boolean bl) {
        ViewGroup viewGroup = this.isDialog() ? this.dialogView : this.rootView;
        viewGroup.setFocusable(bl);
        viewGroup.setFocusableInTouchMode(bl);
        if (bl) {
            viewGroup.setOnKeyListener(this.onKeyBackListener);
        } else {
            viewGroup.setOnKeyListener(null);
        }
    }

    public BasePickerView setOnDismissListener(OnDismissListener onDismissListener) {
        this.onDismissListener = onDismissListener;
        return this;
    }

    protected BasePickerView setOutSideCancelable(boolean bl) {
        ViewGroup viewGroup = this.rootView;
        if (viewGroup != null) {
            viewGroup = viewGroup.findViewById(R.id.outmost_container);
            if (bl) {
                viewGroup.setOnTouchListener(this.onCancelableTouchListener);
            } else {
                viewGroup.setOnTouchListener(null);
            }
        }
        return this;
    }

    public void show() {
        if (this.isDialog()) {
            this.showDialog();
        } else {
            if (this.isShowing()) {
                return;
            }
            this.isShowing = true;
            this.onAttached((View)this.rootView);
            this.rootView.requestFocus();
        }
    }

    public void show(View view) {
        this.clickView = view;
        this.show();
    }

    public void show(View view, boolean bl) {
        this.clickView = view;
        this.isAnim = bl;
        this.show();
    }

    public void show(boolean bl) {
        this.isAnim = bl;
        this.show();
    }

    public void showDialog() {
        Dialog dialog = this.mDialog;
        if (dialog != null) {
            dialog.show();
        }
    }
}

