/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class BrytonOverviewMesg
extends Mesg {
    private static final int DISTANCE_FIELD_TYPE = 134;
    private static final double DISTANCE_OFFSET = 0.0;
    private static final Profile.Type DISTANCE_PROFILE_TYPE;
    private static final double DISTANCE_SCALE = 1.0;
    private static final int GAIN_FIELD_TYPE = 132;
    private static final int GAIN_OFFSET = 0;
    private static final Profile.Type GAIN_PROFILE_TYPE;
    private static final int GAIN_SCALE = 1;
    public static final int GainFieldNum = 9;
    private static final int LOSS_FIELD_TYPE = 132;
    private static final int LOSS_OFFSET = 0;
    private static final Profile.Type LOSS_PROFILE_TYPE;
    private static final int LOSS_SCALE = 1;
    public static final int LossFieldNum = 10;
    private static final int MAX_ALTITUDE_FIELD_TYPE = 132;
    private static final int MAX_ALTITUDE_OFFSET = 500;
    private static final Profile.Type MAX_ALTITUDE_PROFILE_TYPE;
    private static final int MAX_ALTITUDE_SCALE = 5;
    private static final int MAX_LATITUDE_FIELD_TYPE = 133;
    private static final int MAX_LATITUDE_OFFSET = 0;
    private static final Profile.Type MAX_LATITUDE_PROFILE_TYPE;
    private static final int MAX_LATITUDE_SCALE = 1000000;
    private static final int MAX_LONGITUDE_FIELD_TYPE = 133;
    private static final int MAX_LONGITUDE_OFFSET = 0;
    private static final Profile.Type MAX_LONGITUDE_PROFILE_TYPE;
    private static final int MAX_LONGITUDE_SCALE = 1000000;
    private static final int MIN_ALTITUDE_FIELD_TYPE = 132;
    private static final int MIN_ALTITUDE_OFFSET = 500;
    private static final Profile.Type MIN_ALTITUDE_PROFILE_TYPE;
    private static final int MIN_ALTITUDE_SCALE = 5;
    private static final int MIN_LATITUDE_FIELD_TYPE = 133;
    private static final int MIN_LATITUDE_OFFSET = 0;
    private static final Profile.Type MIN_LATITUDE_PROFILE_TYPE;
    private static final int MIN_LATITUDE_SCALE = 1000000;
    private static final int MIN_LONGITUDE_FIELD_TYPE = 133;
    private static final int MIN_LONGITUDE_OFFSET = 0;
    private static final Profile.Type MIN_LONGITUDE_PROFILE_TYPE;
    private static final int MIN_LONGITUDE_SCALE = 1000000;
    public static final int MaxAltFieldNum = 7;
    public static final int MaxLatFieldNum = 2;
    public static final int MaxLonFieldNum = 4;
    public static final int MesgID = 65024;
    public static final int MinAltFieldNum = 8;
    public static final int MinLatFieldNum = 3;
    public static final int MinLonFieldNum = 5;
    private static final int RECORD_COUNT_FIELD_TYPE = 132;
    private static final int RECORD_COUNT_OFFSET = 0;
    private static final Profile.Type RECORD_COUNT_PROFILE_TYPE;
    private static final int RECORD_COUNT_SCALE = 1;
    public static final int RecordCountFieldNum = 1;
    public static final int TotalDistanceFieldNum = 6;
    protected static final Mesg overviewMesg;

    static {
        RECORD_COUNT_PROFILE_TYPE = Profile.Type.UINT16;
        MAX_LATITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        MIN_LATITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        MAX_LONGITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        MIN_LONGITUDE_PROFILE_TYPE = Profile.Type.SINT32;
        DISTANCE_PROFILE_TYPE = Profile.Type.UINT32;
        MAX_ALTITUDE_PROFILE_TYPE = Profile.Type.UINT16;
        MIN_ALTITUDE_PROFILE_TYPE = Profile.Type.UINT16;
        GAIN_PROFILE_TYPE = Profile.Type.UINT16;
        LOSS_PROFILE_TYPE = Profile.Type.UINT16;
        overviewMesg = new Mesg("overview", 65024);
    }

    public BrytonOverviewMesg() {
        super(Factory.createMesg(65024));
    }

    public BrytonOverviewMesg(Mesg mesg) {
        super(mesg);
    }

    public void addField() {
        this.fields.add(new Field("record_count", 1, 132, 1.0, 0.0, "", false, RECORD_COUNT_PROFILE_TYPE));
        this.fields.add(new Field("max latitude", 2, 133, 1000000.0, 0.0, "", false, MAX_LATITUDE_PROFILE_TYPE));
        this.fields.add(new Field("min latitude", 3, 133, 1000000.0, 0.0, "", false, MIN_LATITUDE_PROFILE_TYPE));
        this.fields.add(new Field("max longitude", 4, 133, 1000000.0, 0.0, "", false, MAX_LONGITUDE_PROFILE_TYPE));
        this.fields.add(new Field("min longitude", 5, 133, 1000000.0, 0.0, "", false, MIN_LONGITUDE_PROFILE_TYPE));
        this.fields.add(new Field("total distance in meter", 6, 134, 1.0, 0.0, "", false, DISTANCE_PROFILE_TYPE));
        this.fields.add(new Field("max altitude", 7, 132, 5.0, 500.0, "", false, MAX_ALTITUDE_PROFILE_TYPE));
        this.fields.add(new Field("min altitude", 8, 132, 5.0, 500.0, "", false, MIN_ALTITUDE_PROFILE_TYPE));
    }

    public void addField(String string2) {
        string2.hashCode();
        if (!string2.equals("gain")) {
            if (string2.equals("loss")) {
                this.fields.add(new Field("loss", 10, 132, 1.0, 0.0, "", false, LOSS_PROFILE_TYPE));
            }
        } else {
            this.fields.add(new Field("gain", 9, 132, 1.0, 0.0, "", false, GAIN_PROFILE_TYPE));
        }
    }

    public Integer getGain() {
        int n = this.getFieldIntegerValue(9, 0, 65535) != null ? this.getFieldIntegerValue(9, 0, 65535) / 1 - 0 : -1;
        return n;
    }

    public Integer getLoss() {
        int n = 0;
        if (this.getFieldIntegerValue(10, 0, 65535) != null) {
            n = this.getFieldIntegerValue(10, 0, 65535) / 1 + 0;
        }
        return n;
    }

    public Integer getMaxAlt() {
        Integer n = 0;
        if (this.getFieldIntegerValue(7, 0, 65535) != null) {
            n = this.getFieldIntegerValue(7, 0, 65535) / 5 - 500;
        }
        return n;
    }

    public Double getMaxLat() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(2, 0, 65535) != null) {
            d = this.getFieldDoubleValue(2, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public Double getMaxLon() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(4, 0, 65535) != null) {
            d = this.getFieldDoubleValue(4, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public Integer getMinAlt() {
        Integer n = 0;
        if (this.getFieldIntegerValue(8, 0, 65535) != null) {
            n = this.getFieldIntegerValue(8, 0, 65535) / 5 - 500;
        }
        return n;
    }

    public Double getMinLat() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(3, 0, 65535) != null) {
            d = this.getFieldDoubleValue(3, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public Double getMinLon() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(5, 0, 65535) != null) {
            d = this.getFieldDoubleValue(5, 0, 65535) / 1000000.0 - 0.0;
        }
        return d;
    }

    public Integer getRecordCount() {
        int n = Fit.UINT16_INVALID;
        if (this.getFieldIntegerValue(1, 0, 65535) != null) {
            n = this.getFieldIntegerValue(1, 0, 65535) / 1 - 0;
        }
        return n;
    }

    public Double getTotalDistance() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(6, 0, 65535) != null) {
            d = this.getFieldDoubleValue(6, 0, 65535) / 1.0 - 0.0;
        }
        return d;
    }

    public void setGain(Integer n) {
        this.setFieldValue(9, 0, (Object)n, 65535);
    }

    public void setLoss(Integer n) {
        this.setFieldValue(10, 0, (Object)n, 65535);
    }

    public void setMaxAlt(Integer n) {
        this.setFieldValue(7, 0, (Object)n, 65535);
    }

    public void setMaxLat(Double d) {
        this.setFieldValue(2, 0, (Object)d, 65535);
    }

    public void setMaxLon(Double d) {
        this.setFieldValue(4, 0, (Object)d, 65535);
    }

    public void setMinAlt(Integer n) {
        this.setFieldValue(8, 0, (Object)n, 65535);
    }

    public void setMinLat(Double d) {
        this.setFieldValue(3, 0, (Object)d, 65535);
    }

    public void setMinLon(Double d) {
        this.setFieldValue(5, 0, (Object)d, 65535);
    }

    public void setRecordCount(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public void setTotalDistance(Double d) {
        this.setFieldValue(6, 0, (Object)d, 65535);
    }
}

