/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Fit;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class BrytonTurnRecordMesg
extends Mesg {
    private static final int DISTANCE_FIELD_TYPE = 134;
    private static final int DISTANCE_OFFSET = 0;
    private static final Profile.Type DISTANCE_PROFILE_TYPE;
    private static final int DISTANCE_SCALE = 1;
    private static final int DURATION_FIELD_TYPE = 134;
    private static final long DURATION_OFFSET = 0L;
    private static final Profile.Type DURATION_PROFILE_TYPE;
    private static final long DURATION_SCALE = 1L;
    public static final int DistanceFieldNum = 3;
    public static final int DurationFieldNum = 4;
    private static final int INSTRUCTION_FIELD_TYPE = 7;
    private static final float INSTRUCTION_OFFSET = 0.0f;
    private static final Profile.Type INSTRUCTION_PROFILE_TYPE;
    private static final float INSTRUCTION_SCALE = 1.0f;
    public static final int InstructionFieldNum = 5;
    private static final int MANEUVER_FIELD_TYPE = 0;
    private static final int MANEUVER_OFFSET = 0;
    private static final Profile.Type MANEUVER_PROFILE_TYPE;
    private static final int MANEUVER_SCALE = 1;
    public static final int ManeuverFieldNum = 2;
    public static final int MesgID = 64000;
    private static final int TRACK_INDEX_FIELD_TYPE = 132;
    private static final int TRACK_INDEX_OFFSET = 0;
    private static final Profile.Type TRACK_INDEX_PROFILE_TYPE;
    private static final int TRACK_INDEX_SCALE = 1;
    public static final int TrackIndexFieldNum = 1;
    protected static final Mesg turnRecordMesg;

    static {
        TRACK_INDEX_PROFILE_TYPE = Profile.Type.UINT16;
        MANEUVER_PROFILE_TYPE = Profile.Type.ENUM;
        DISTANCE_PROFILE_TYPE = Profile.Type.UINT32;
        DURATION_PROFILE_TYPE = Profile.Type.UINT32;
        INSTRUCTION_PROFILE_TYPE = Profile.Type.STRING;
        turnRecordMesg = new Mesg("turn record", 64000);
    }

    public BrytonTurnRecordMesg() {
        super(Factory.createMesg(64000));
    }

    public BrytonTurnRecordMesg(Mesg mesg) {
        super(mesg);
    }

    public void addField() {
        this.fields.add(new Field("track_index", 1, 132, 1.0, 0.0, "", false, TRACK_INDEX_PROFILE_TYPE));
        this.fields.add(new Field("maneuver", 2, 0, 1.0, 0.0, "", false, MANEUVER_PROFILE_TYPE));
        this.fields.add(new Field("distance in meter", 3, 134, 1.0, 0.0, "", false, DISTANCE_PROFILE_TYPE));
        this.fields.add(new Field("duration in sec", 4, 134, 1.0, 0.0, "", false, DURATION_PROFILE_TYPE));
        this.fields.add(new Field("instruction", 5, 7, 1.0, 0.0, "", false, INSTRUCTION_PROFILE_TYPE));
    }

    public Double getDistance() {
        Double d = 0.0;
        if (this.getFieldDoubleValue(3, 0, 65535) != null) {
            d = this.getFieldDoubleValue(3, 0, 65535) / 1.0 - 0.0;
        }
        return d;
    }

    public Long getDuration() {
        Long l = 0L;
        if (this.getFieldLongValue(4, 0, 65535) != null) {
            l = this.getFieldLongValue(4, 0, 65535) / 1L - 0L;
        }
        return l;
    }

    public String getInstruction() {
        String string2 = this.getFieldStringValue(5, 0, 65535) != null ? this.getFieldStringValue(5, 0, 65535) : "";
        return string2;
    }

    public Integer getManeuver() {
        int n = 0;
        if (this.getFieldIntegerValue(2, 0, 65535) != null) {
            n = this.getFieldIntegerValue(2, 0, 65535) / 1 + 0;
        }
        return n;
    }

    public Integer getTrackIndex() {
        int n = Fit.UINT16_INVALID;
        if (this.getFieldIntegerValue(1, 0, 65535) != null) {
            n = this.getFieldIntegerValue(1, 0, 65535) / 1 - 0;
        }
        return n;
    }

    public void setDistance(Double d) {
        this.setFieldValue(3, 0, (Object)d, 65535);
    }

    public void setDuration(Long l) {
        this.setFieldValue(4, 0, (Object)l, 65535);
    }

    public void setInstruction(String string2) {
        this.setFieldValue(5, 0, (Object)string2, 65535);
    }

    public void setManeuver(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public void setTrackIndex(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }
}

