/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.ProtocolValidator;
import com.garmin.fit.Validator;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.List;

public class BufferEncoder
implements MesgListener,
MesgDefinitionListener {
    private ByteArrayOutputStream byteOutStream;
    private DataOutputStream dataOutStream;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private Validator validator;
    private Fit.ProtocolVersion version;

    @Deprecated
    public BufferEncoder() {
        Fit.ProtocolVersion protocolVersion;
        this.version = protocolVersion = Fit.ProtocolVersion.V1_0;
        this.validator = new ProtocolValidator(protocolVersion);
        this.byteOutStream = new ByteArrayOutputStream();
        this.dataOutStream = new DataOutputStream(this.byteOutStream);
        this.open();
    }

    public BufferEncoder(Fit.ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
        this.validator = new ProtocolValidator(protocolVersion);
        this.byteOutStream = new ByteArrayOutputStream();
        this.dataOutStream = new DataOutputStream(this.byteOutStream);
        this.open();
    }

    private void writeFileHeader() {
        this.byteOutStream.write(14);
        this.byteOutStream.write(this.version.getVersion());
        this.byteOutStream.write(40);
        this.byteOutStream.write(8);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
        this.byteOutStream.write(46);
        this.byteOutStream.write(70);
        this.byteOutStream.write(73);
        this.byteOutStream.write(84);
        this.byteOutStream.write(0);
        this.byteOutStream.write(0);
    }

    public byte[] close() {
        int n;
        Object object = this.byteOutStream;
        int n2 = 0;
        ((ByteArrayOutputStream)object).write(0);
        this.byteOutStream.write(0);
        object = this.byteOutStream.toByteArray();
        long l = ((Object)object).length - 14 - 2;
        object[4] = (byte)(l & 0xFFL);
        object[5] = (byte)(l >> 8 & 0xFFL);
        object[6] = (byte)(l >> 16 & 0xFFL);
        object[7] = (byte)(l >> 24 & 0xFFL);
        int n3 = 0;
        for (n = 0; n < 12; ++n) {
            n3 = CRC.get16(n3, (byte)object[n]);
        }
        object[12] = (byte)(n3 & 0xFF);
        object[13] = (byte)(n3 >> 8 & 0xFF);
        n3 = 0;
        for (n = n2; n < ((Object)object).length - 2; ++n) {
            n3 = CRC.get16(n3, (byte)object[n]);
        }
        object[((Object)object).length - 2] = (byte)(n3 & 0xFF);
        object[((Object)object).length - 1] = (byte)(n3 >> 8 & 0xFF);
        this.open();
        return object;
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void open() {
        this.byteOutStream.reset();
        this.writeFileHeader();
    }

    public void write(Mesg mesg) {
        if (this.validator.validateMesg(mesg)) {
            if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
                this.write(new MesgDefinition(mesg));
            }
            mesg.write(this.dataOutStream, this.lastMesgDefinition[mesg.localNum]);
            return;
        }
        throw new FitRuntimeException("Incompatible Protocol Features");
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.validator.validateMesgDefn(mesgDefinition)) {
            mesgDefinition.write(this.dataOutStream);
            this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
            return;
        }
        throw new FitRuntimeException("Incompatible Protocol Features");
    }

    public void write(List<Mesg> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.write((Mesg)object.next());
        }
    }
}

