/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.Sport;
import com.garmin.fit.SubSport;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DecodeSummary {
    private byte ENDIAN;
    private byte[] SessionData;
    int avgaltitude;
    int avgcadence;
    int avgheartrate;
    int avgpower;
    int avgspeed;
    int avgtemperature;
    private byte[] buffer;
    int bytesRead;
    int datalength;
    int event;
    int eventtype;
    int intensityfactory;
    int leftrightbalance;
    Long lstarttime;
    Long ltimestamp;
    int maxaltitude;
    int maxcadence;
    int maxheartrate;
    int maxpower;
    int maxspeed;
    int maxtemperature;
    int normalizedpower;
    int numlaps;
    SessionMesg smesg;
    int sport;
    int startpositionlat;
    int startpositionlong;
    int starttime;
    int subsport;
    private byte[] temp4;
    int timestamp;
    int totalascent;
    int totalcalories;
    int totalcycle;
    int totaldescent;
    int totaldistance;
    int totalelapsedtime;
    int totalmovingtime;
    int totaltimertime;
    int totalwork;
    int trainingstressscore;

    public DecodeSummary(FileInputStream fileInputStream) {
        int n;
        int n2;
        block5: {
            this.smesg = new SessionMesg();
            n2 = 0;
            this.datalength = n = fileInputStream.available();
            if (n <= 232) break block5;
            try {
                byte[] byArray = new byte[n];
                this.buffer = byArray;
                this.bytesRead = fileInputStream.read(byArray, 0, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        n = this.datalength;
        if (n > 232) {
            this.SessionData = new byte[79];
            this.temp4 = new byte[4];
            this.ENDIAN = this.buffer[n - 232];
            while (n2 < 79) {
                this.SessionData[n2] = this.buffer[this.datalength - 126 + n2];
                ++n2;
            }
            this.setTimeStamp();
            this.setStartTime();
            this.setStartPositionLat();
            this.setStartPositionLong();
            this.setTotalElapsedTime();
            this.setTotalTimerTime();
            this.setTotalDistance();
            this.setTotalCycle();
            this.setTotalMovingTime();
            this.setTotalWork();
            this.setTotalCalories();
            this.setAvgSpeed();
            this.setMaxSpeed();
            this.setTotalAscent();
            this.setTotalDescent();
            this.setNumLaps();
            this.setAvgAltitude();
            this.setMaxAltitude();
            this.setAvgPower();
            this.setMaxPower();
            this.setNormalizedPower();
            this.setTrainingStressScore();
            this.setIntensityFactory();
            this.setLeftRightBalance();
            this.setEvent();
            this.setEventType();
            this.setSport();
            this.setSubSport();
            this.setAvgHeartRate();
            this.setMaxHeartRate();
            this.setAvgCadence();
            this.setMaxCadence();
            this.setAvgTemperature();
            this.setMaxTemperature();
        }
    }

    private void setAvgAltitude() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[57];
            object[1] = byArray[58];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.avgaltitude = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[57];
            byArray[3] = byArray2[58];
            this.avgaltitude = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setAvgCadence() {
        Object object = this.temp4;
        object[0] = this.SessionData[51];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.avgcadence = ((ByteBuffer)object).getInt();
    }

    private void setAvgHeartRate() {
        Object object = this.temp4;
        object[0] = this.SessionData[49];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.avgheartrate = ((ByteBuffer)object).getInt();
    }

    private void setAvgPower() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[63];
            object[1] = byArray[64];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.avgpower = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[63];
            byArray[3] = byArray2[64];
            this.avgpower = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setAvgSpeed() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[35];
            object[1] = byArray[36];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.avgspeed = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[35];
            byArray[3] = byArray2[36];
            this.avgspeed = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setAvgTemperature() {
        Object object = this.temp4;
        object[0] = this.SessionData[61];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.avgtemperature = ((ByteBuffer)object).getInt();
    }

    private void setEvent() {
        Object object = this.temp4;
        object[0] = this.SessionData[45];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.event = ((ByteBuffer)object).getInt();
    }

    private void setEventType() {
        Object object = this.temp4;
        object[0] = this.SessionData[46];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.eventtype = ((ByteBuffer)object).getInt();
    }

    private void setIntensityFactory() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[71];
            byArray[1] = object[72];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.intensityfactory = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[71];
            byArray[3] = byArray2[72];
            this.intensityfactory = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setLeftRightBalance() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[77];
            object[1] = byArray[78];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.leftrightbalance = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[77];
            byArray[3] = byArray2[78];
            this.leftrightbalance = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setMaxAltitude() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[59];
            byArray[1] = object[60];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.maxaltitude = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[59];
            byArray[3] = byArray2[60];
            this.maxaltitude = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setMaxCadence() {
        Object object = this.temp4;
        object[0] = this.SessionData[52];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.maxcadence = ((ByteBuffer)object).getInt();
    }

    private void setMaxHeartRate() {
        Object object = this.temp4;
        object[0] = this.SessionData[50];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.maxheartrate = ((ByteBuffer)object).getInt();
    }

    private void setMaxPower() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[65];
            byArray[1] = object[66];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.maxpower = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[65];
            byArray[3] = byArray2[66];
            this.maxpower = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setMaxSpeed() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[37];
            object[1] = byArray[38];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.maxspeed = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[37];
            byArray[3] = byArray2[38];
            this.maxspeed = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setMaxTemperature() {
        Object object = this.temp4;
        object[0] = this.SessionData[62];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.maxtemperature = ((ByteBuffer)object).getInt();
    }

    private void setNormalizedPower() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[67];
            byArray[1] = object[68];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.normalizedpower = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[67];
            byArray[3] = byArray2[68];
            this.normalizedpower = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setNumLaps() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[43];
            object[1] = byArray[44];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.numlaps = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[43];
            byArray[3] = byArray2[44];
            this.numlaps = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setSport() {
        Object object = this.temp4;
        object[0] = this.SessionData[47];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.sport = ((ByteBuffer)object).getInt();
    }

    private void setStartPositionLat() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[9];
        byArray[1] = object[10];
        byArray[2] = object[11];
        byArray[3] = object[12];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.startpositionlat = ((ByteBuffer)object).getInt();
    }

    private void setStartPositionLong() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[13];
        byArray[1] = object[14];
        byArray[2] = object[15];
        byArray[3] = object[16];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.startpositionlong = ((ByteBuffer)object).getInt();
    }

    private void setStartTime() {
        int n;
        Object object = this.temp4;
        byte[] byArray = this.SessionData;
        object[0] = byArray[5];
        object[1] = byArray[6];
        object[2] = byArray[7];
        object[3] = byArray[8];
        object = ByteBuffer.wrap((byte[])object);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.starttime = n = ((ByteBuffer)object).getInt();
        this.lstarttime = n;
    }

    private void setSubSport() {
        Object object = this.temp4;
        object[0] = this.SessionData[48];
        object[1] = (byte)0;
        object[2] = (byte)0;
        object[3] = (byte)0;
        object = ByteBuffer.wrap((byte[])object);
        ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        this.subsport = ((ByteBuffer)object).getInt();
    }

    private void setTimeStamp() {
        int n;
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[1];
        byArray[1] = object[2];
        byArray[2] = object[3];
        byArray[3] = object[4];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.timestamp = n = ((ByteBuffer)object).getInt();
        this.ltimestamp = n;
    }

    private void setTotalAscent() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[39];
            byArray[1] = object[40];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.totalascent = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[39];
            byArray[3] = byArray2[40];
            this.totalascent = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setTotalCalories() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[33];
            object[1] = byArray[34];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.totalcalories = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[33];
            byArray[3] = byArray2[34];
            this.totalcalories = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setTotalCycle() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[29];
        byArray[1] = object[30];
        byArray[2] = object[31];
        byArray[3] = object[32];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totalcycle = ((ByteBuffer)object).getInt();
    }

    private void setTotalDescent() {
        if (this.ENDIAN == 0) {
            Object object = this.temp4;
            byte[] byArray = this.SessionData;
            object[0] = byArray[41];
            object[1] = byArray[42];
            object[2] = (byte)0;
            object[3] = (byte)0;
            object = ByteBuffer.wrap((byte[])object);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.totaldescent = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[41];
            byArray[3] = byArray2[42];
            this.totaldescent = ByteBuffer.wrap(byArray).getInt();
        }
    }

    private void setTotalDistance() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[25];
        byArray[1] = object[26];
        byArray[2] = object[27];
        byArray[3] = object[28];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totaldistance = ((ByteBuffer)object).getInt();
    }

    private void setTotalElapsedTime() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[17];
        byArray[1] = object[18];
        byArray[2] = object[19];
        byArray[3] = object[20];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totalelapsedtime = ((ByteBuffer)object).getInt();
    }

    private void setTotalMovingTime() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[53];
        byArray[1] = object[54];
        byArray[2] = object[55];
        byArray[3] = object[56];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totalmovingtime = ((ByteBuffer)object).getInt();
    }

    private void setTotalTimerTime() {
        Object object = this.temp4;
        byte[] byArray = this.SessionData;
        object[0] = byArray[21];
        object[1] = byArray[22];
        object[2] = byArray[23];
        object[3] = byArray[24];
        object = ByteBuffer.wrap((byte[])object);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totaltimertime = ((ByteBuffer)object).getInt();
    }

    private void setTotalWork() {
        byte[] byArray = this.temp4;
        Object object = this.SessionData;
        byArray[0] = object[73];
        byArray[1] = object[74];
        byArray[2] = object[75];
        byArray[3] = object[76];
        object = ByteBuffer.wrap(byArray);
        if (this.ENDIAN == 0) {
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
        }
        this.totalwork = ((ByteBuffer)object).getInt();
    }

    private void setTrainingStressScore() {
        if (this.ENDIAN == 0) {
            byte[] byArray = this.temp4;
            Object object = this.SessionData;
            byArray[0] = object[69];
            byArray[1] = object[70];
            byArray[2] = (byte)0;
            byArray[3] = (byte)0;
            object = ByteBuffer.wrap(byArray);
            ((ByteBuffer)object).order(ByteOrder.LITTLE_ENDIAN);
            this.trainingstressscore = ((ByteBuffer)object).getInt();
        } else {
            byte[] byArray = this.temp4;
            byArray[0] = (byte)0;
            byArray[1] = (byte)0;
            byte[] byArray2 = this.SessionData;
            byArray[2] = byArray2[69];
            byArray[3] = byArray2[70];
            this.trainingstressscore = ByteBuffer.wrap(byArray).getInt();
        }
    }

    public Float getAvgAltitude() {
        return Float.valueOf((float)((double)this.avgaltitude / 5.0) - 500.0f);
    }

    public Short getAvgCadence() {
        return (short)this.avgcadence;
    }

    public Short getAvgHeartRate() {
        return (short)this.avgheartrate;
    }

    public Integer getAvgPower() {
        return this.avgpower;
    }

    public Float getAvgSpeed() {
        return Float.valueOf((float)((double)this.avgspeed / 1000.0));
    }

    public Short getAvgTemperature() {
        return (short)this.avgtemperature;
    }

    public byte getEndian() {
        return this.ENDIAN;
    }

    public Event getEvent() {
        return Event.LAP;
    }

    public EventType getEventType() {
        return EventType.STOP;
    }

    public boolean getFileLength() {
        return this.datalength > 232;
    }

    public Float getIntensityFactory() {
        return Float.valueOf((float)((double)this.intensityfactory / 1000.0));
    }

    public Integer getLeftRightBalance() {
        return this.leftrightbalance;
    }

    public Float getMaxAltitude() {
        return Float.valueOf((float)((double)this.maxaltitude / 5.0) - 500.0f);
    }

    public Short getMaxCadence() {
        return (short)this.maxcadence;
    }

    public Short getMaxHeartRate() {
        return (short)this.maxheartrate;
    }

    public Integer getMaxPower() {
        return this.maxpower;
    }

    public Float getMaxSpeed() {
        return Float.valueOf((float)((double)this.maxspeed / 1000.0));
    }

    public Short getMaxTemperature() {
        return (short)this.maxtemperature;
    }

    public Integer getNormalizedPower() {
        return this.normalizedpower;
    }

    public Integer getNumLaps() {
        return this.numlaps;
    }

    public Sport getSport() {
        return Sport.CYCLING;
    }

    public Float getStartPositionLat() {
        return Float.valueOf((float)((double)this.startpositionlat / 1000000.0));
    }

    public Float getStartPositionLong() {
        return Float.valueOf((float)((double)this.startpositionlong / 1000000.0));
    }

    public DateTime getStartTime() {
        return this.smesg.getStartTime_summary(this.lstarttime);
    }

    public SubSport getSubSport() {
        return SubSport.GENERIC;
    }

    public DateTime getTimeStamp() {
        return this.smesg.getTimestamp_summary(this.ltimestamp);
    }

    public Integer getTotalAscent() {
        return this.totalascent;
    }

    public Integer getTotalCalories() {
        return this.totalcalories;
    }

    public Long getTotalCycle() {
        return this.totalcycle;
    }

    public Integer getTotalDescent() {
        return this.totaldescent;
    }

    public Float getTotalDistance() {
        return Float.valueOf((float)((double)this.totaldistance / 100.0));
    }

    public Float getTotalElapsedTime() {
        return Float.valueOf((float)((double)this.totalelapsedtime / 1000.0));
    }

    public Float getTotalMovingTime() {
        return Float.valueOf((float)((double)this.totalmovingtime / 1000.0));
    }

    public Float getTotalTimerTime() {
        return Float.valueOf((float)((double)this.totaltimertime / 1000.0));
    }

    public Long getTotalWork() {
        return this.totalwork;
    }

    public Float getTrainingStressScore() {
        return Float.valueOf((float)((double)this.trainingstressscore / 10.0));
    }
}

