/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperDataIdMesg;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FieldDescriptionMesg;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import java.io.IOException;
import java.io.OutputStream;

public class DeveloperFieldDefinition
extends FieldDefinitionBase {
    private DeveloperDataIdMesg developerDataIdMesg;
    private FieldDescriptionMesg fieldDescriptionMesg;
    private short num;
    private int size;
    private int type;

    public DeveloperFieldDefinition() {
        this.fieldDescriptionMesg = null;
        this.type = 2;
    }

    public DeveloperFieldDefinition(DeveloperField developerField) {
        this(developerField.getFieldDefinition());
        this.size = developerField.getSize();
    }

    public DeveloperFieldDefinition(DeveloperFieldDefinition developerFieldDefinition) {
        this.setFieldDescription(developerFieldDefinition.fieldDescriptionMesg);
        this.developerDataIdMesg = developerFieldDefinition.developerDataIdMesg;
        this.size = developerFieldDefinition.getSize();
    }

    public DeveloperFieldDefinition(FieldDescriptionMesg fieldDescriptionMesg, DeveloperDataIdMesg developerDataIdMesg) {
        this.setFieldDescription(fieldDescriptionMesg);
        this.developerDataIdMesg = developerDataIdMesg;
    }

    public Byte[] getAppId() {
        if (this.isDefined()) {
            return this.developerDataIdMesg.getApplicationId();
        }
        return null;
    }

    public long getAppVersion() {
        Long l = this.isDefined() ? this.developerDataIdMesg.getApplicationVersion() : null;
        if (l == null) {
            return Fit.UINT32_INVALID;
        }
        return l;
    }

    public DeveloperField getDefaultField() {
        return new DeveloperField(this);
    }

    public short getDeveloperDataIndex() {
        Short s = this.isDefined() ? this.fieldDescriptionMesg.getDeveloperDataIndex() : null;
        if (s == null) {
            return Fit.UINT8_INVALID;
        }
        return s;
    }

    public String getFieldName() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getFieldName(0);
        }
        return null;
    }

    public short getNativeOverride() {
        Short s;
        if (this.isDefined() && (s = this.fieldDescriptionMesg.getNativeFieldNum()) != null) {
            return s;
        }
        return Fit.UINT8_INVALID;
    }

    public short getNum() {
        return this.num;
    }

    public short getOffset() {
        if (this.isDefined() && this.fieldDescriptionMesg.getOffset() != null && !this.fieldDescriptionMesg.getOffset().equals(Fit.SINT8_INVALID)) {
            return this.fieldDescriptionMesg.getOffset().byteValue();
        }
        return 0;
    }

    public short getScale() {
        if (this.isDefined() && this.fieldDescriptionMesg.getScale() != null && !this.fieldDescriptionMesg.getScale().equals(Fit.UINT8_INVALID)) {
            return this.fieldDescriptionMesg.getScale();
        }
        return 1;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    public int getType() {
        return this.type;
    }

    public String getUnits() {
        if (this.isDefined()) {
            return this.fieldDescriptionMesg.getUnits(0);
        }
        return null;
    }

    public boolean isDefined() {
        boolean bl = this.fieldDescriptionMesg != null && this.developerDataIdMesg != null;
        return bl;
    }

    void setDeveloperDataIdMesg(DeveloperDataIdMesg developerDataIdMesg) {
        this.developerDataIdMesg = developerDataIdMesg;
    }

    void setFieldDescription(FieldDescriptionMesg fieldDescriptionMesg) {
        this.fieldDescriptionMesg = fieldDescriptionMesg;
        this.num = fieldDescriptionMesg.getFieldDefinitionNumber();
        this.type = this.fieldDescriptionMesg.getFitBaseTypeId().shortValue();
    }

    public void setNum(short s) {
        this.num = s;
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    protected void write(OutputStream outputStream) {
        try {
            outputStream.write(this.fieldDescriptionMesg.getFieldDefinitionNumber().shortValue());
            outputStream.write(this.size);
            outputStream.write(this.fieldDescriptionMesg.getDeveloperDataIndex().shortValue());
            return;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }
}

