/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Bool;
import com.garmin.fit.DiveBacklightMode;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SourceType;
import com.garmin.fit.SubField;
import com.garmin.fit.TissueModelType;
import com.garmin.fit.WaterType;

public class DiveSettingsMesg
extends Mesg {
    public static final int ApneaCountdownEnabledFieldNum = 12;
    public static final int ApneaCountdownTimeFieldNum = 13;
    public static final int BacklightBrightnessFieldNum = 15;
    public static final int BacklightModeFieldNum = 14;
    public static final int BacklightTimeoutFieldNum = 16;
    public static final int BottomDepthFieldNum = 10;
    public static final int BottomTimeFieldNum = 11;
    public static final int GfHighFieldNum = 3;
    public static final int GfLowFieldNum = 2;
    public static final int HeartRateSourceFieldNum = 20;
    public static final int HeartRateSourceTypeFieldNum = 19;
    public static final int MessageIndexFieldNum = 254;
    public static final int ModelFieldNum = 1;
    public static final int NameFieldNum = 0;
    public static final int Po2CriticalFieldNum = 7;
    public static final int Po2DecoFieldNum = 8;
    public static final int Po2WarnFieldNum = 6;
    public static final int RepeatDiveIntervalFieldNum = 17;
    public static final int SafetyStopEnabledFieldNum = 9;
    public static final int SafetyStopTimeFieldNum = 18;
    public static final int WaterDensityFieldNum = 5;
    public static final int WaterTypeFieldNum = 4;
    protected static final Mesg diveSettingsMesg;

    static {
        Mesg mesg;
        diveSettingsMesg = mesg = new Mesg("dive_settings", 258);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("name", 0, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        mesg.addField(new Field("model", 1, 0, 1.0, 0.0, "", false, Profile.Type.TISSUE_MODEL_TYPE));
        mesg.addField(new Field("gf_low", 2, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("gf_high", 3, 2, 1.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("water_type", 4, 0, 1.0, 0.0, "", false, Profile.Type.WATER_TYPE));
        mesg.addField(new Field("water_density", 5, 136, 1.0, 0.0, "kg/m^3", false, Profile.Type.FLOAT32));
        mesg.addField(new Field("po2_warn", 6, 2, 100.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("po2_critical", 7, 2, 100.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("po2_deco", 8, 2, 100.0, 0.0, "percent", false, Profile.Type.UINT8));
        mesg.addField(new Field("safety_stop_enabled", 9, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("bottom_depth", 10, 136, 1.0, 0.0, "", false, Profile.Type.FLOAT32));
        mesg.addField(new Field("bottom_time", 11, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.addField(new Field("apnea_countdown_enabled", 12, 0, 1.0, 0.0, "", false, Profile.Type.BOOL));
        mesg.addField(new Field("apnea_countdown_time", 13, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.addField(new Field("backlight_mode", 14, 0, 1.0, 0.0, "", false, Profile.Type.DIVE_BACKLIGHT_MODE));
        mesg.addField(new Field("backlight_brightness", 15, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("backlight_timeout", 16, 2, 1.0, 0.0, "", false, Profile.Type.BACKLIGHT_TIMEOUT));
        mesg.addField(new Field("repeat_dive_interval", 17, 132, 1.0, 0.0, "s", false, Profile.Type.UINT16));
        mesg.addField(new Field("safety_stop_time", 18, 132, 1.0, 0.0, "s", false, Profile.Type.UINT16));
        mesg.addField(new Field("heart_rate_source_type", 19, 0, 1.0, 0.0, "", false, Profile.Type.SOURCE_TYPE));
        mesg.addField(new Field("heart_rate_source", 20, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.fields.get((int)21).subFields.add(new SubField("heart_rate_antplus_device_type", 2, 1.0, 0.0, ""));
        mesg.fields.get((int)21).subFields.get(0).addMap(19, 1L);
        mesg.fields.get((int)21).subFields.add(new SubField("heart_rate_local_device_type", 2, 1.0, 0.0, ""));
        mesg.fields.get((int)21).subFields.get(1).addMap(19, 5L);
    }

    public DiveSettingsMesg() {
        super(Factory.createMesg(258));
    }

    public DiveSettingsMesg(Mesg mesg) {
        super(mesg);
    }

    public Bool getApneaCountdownEnabled() {
        Short s = this.getFieldShortValue(12, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public Long getApneaCountdownTime() {
        return this.getFieldLongValue(13, 0, 65535);
    }

    public Short getBacklightBrightness() {
        return this.getFieldShortValue(15, 0, 65535);
    }

    public DiveBacklightMode getBacklightMode() {
        Short s = this.getFieldShortValue(14, 0, 65535);
        if (s == null) {
            return null;
        }
        return DiveBacklightMode.getByValue(s);
    }

    public Short getBacklightTimeout() {
        return this.getFieldShortValue(16, 0, 65535);
    }

    public Float getBottomDepth() {
        return this.getFieldFloatValue(10, 0, 65535);
    }

    public Long getBottomTime() {
        return this.getFieldLongValue(11, 0, 65535);
    }

    public Short getGfHigh() {
        return this.getFieldShortValue(3, 0, 65535);
    }

    public Short getGfLow() {
        return this.getFieldShortValue(2, 0, 65535);
    }

    public Short getHeartRateAntplusDeviceType() {
        return this.getFieldShortValue(20, 0, 0);
    }

    public Short getHeartRateLocalDeviceType() {
        return this.getFieldShortValue(20, 0, 1);
    }

    public Short getHeartRateSource() {
        return this.getFieldShortValue(20, 0, 65535);
    }

    public SourceType getHeartRateSourceType() {
        Short s = this.getFieldShortValue(19, 0, 65535);
        if (s == null) {
            return null;
        }
        return SourceType.getByValue(s);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public TissueModelType getModel() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return TissueModelType.getByValue(s);
    }

    @Override
    public String getName() {
        return this.getFieldStringValue(0, 0, 65535);
    }

    public Float getPo2Critical() {
        return this.getFieldFloatValue(7, 0, 65535);
    }

    public Float getPo2Deco() {
        return this.getFieldFloatValue(8, 0, 65535);
    }

    public Float getPo2Warn() {
        return this.getFieldFloatValue(6, 0, 65535);
    }

    public Integer getRepeatDiveInterval() {
        return this.getFieldIntegerValue(17, 0, 65535);
    }

    public Bool getSafetyStopEnabled() {
        Short s = this.getFieldShortValue(9, 0, 65535);
        if (s == null) {
            return null;
        }
        return Bool.getByValue(s);
    }

    public Integer getSafetyStopTime() {
        return this.getFieldIntegerValue(18, 0, 65535);
    }

    public Float getWaterDensity() {
        return this.getFieldFloatValue(5, 0, 65535);
    }

    public WaterType getWaterType() {
        Short s = this.getFieldShortValue(4, 0, 65535);
        if (s == null) {
            return null;
        }
        return WaterType.getByValue(s);
    }

    public void setApneaCountdownEnabled(Bool bool2) {
        this.setFieldValue(12, 0, (Object)bool2.value, 65535);
    }

    public void setApneaCountdownTime(Long l) {
        this.setFieldValue(13, 0, (Object)l, 65535);
    }

    public void setBacklightBrightness(Short s) {
        this.setFieldValue(15, 0, (Object)s, 65535);
    }

    public void setBacklightMode(DiveBacklightMode diveBacklightMode) {
        this.setFieldValue(14, 0, (Object)diveBacklightMode.value, 65535);
    }

    public void setBacklightTimeout(Short s) {
        this.setFieldValue(16, 0, (Object)s, 65535);
    }

    public void setBottomDepth(Float f) {
        this.setFieldValue(10, 0, (Object)f, 65535);
    }

    public void setBottomTime(Long l) {
        this.setFieldValue(11, 0, (Object)l, 65535);
    }

    public void setGfHigh(Short s) {
        this.setFieldValue(3, 0, (Object)s, 65535);
    }

    public void setGfLow(Short s) {
        this.setFieldValue(2, 0, (Object)s, 65535);
    }

    public void setHeartRateAntplusDeviceType(Short s) {
        this.setFieldValue(20, 0, (Object)s, 0);
    }

    public void setHeartRateLocalDeviceType(Short s) {
        this.setFieldValue(20, 0, (Object)s, 1);
    }

    public void setHeartRateSource(Short s) {
        this.setFieldValue(20, 0, (Object)s, 65535);
    }

    public void setHeartRateSourceType(SourceType sourceType) {
        this.setFieldValue(19, 0, (Object)sourceType.value, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setModel(TissueModelType tissueModelType) {
        this.setFieldValue(1, 0, (Object)tissueModelType.value, 65535);
    }

    public void setName(String string2) {
        this.setFieldValue(0, 0, (Object)string2, 65535);
    }

    public void setPo2Critical(Float f) {
        this.setFieldValue(7, 0, (Object)f, 65535);
    }

    public void setPo2Deco(Float f) {
        this.setFieldValue(8, 0, (Object)f, 65535);
    }

    public void setPo2Warn(Float f) {
        this.setFieldValue(6, 0, (Object)f, 65535);
    }

    public void setRepeatDiveInterval(Integer n) {
        this.setFieldValue(17, 0, (Object)n, 65535);
    }

    public void setSafetyStopEnabled(Bool bool2) {
        this.setFieldValue(9, 0, (Object)bool2.value, 65535);
    }

    public void setSafetyStopTime(Integer n) {
        this.setFieldValue(18, 0, (Object)n, 65535);
    }

    public void setWaterDensity(Float f) {
        this.setFieldValue(5, 0, (Object)f, 65535);
    }

    public void setWaterType(WaterType waterType) {
        this.setFieldValue(4, 0, (Object)waterType.value, 65535);
    }
}

