/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Event;
import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FitnessEquipmentState;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.Profile;
import com.garmin.fit.RiderPositionType;
import com.garmin.fit.SubField;
import com.garmin.fit.TimerTrigger;

public class EventMesg
extends Mesg
implements MesgWithEvent {
    public static final int Data16FieldNum = 2;
    public static final int DataFieldNum = 3;
    public static final int DeviceIndexFieldNum = 13;
    public static final int EventFieldNum = 0;
    public static final int EventGroupFieldNum = 4;
    public static final int EventTypeFieldNum = 1;
    public static final int FrontGearFieldNum = 10;
    public static final int FrontGearNumFieldNum = 9;
    public static final int MesgID = 5376;
    public static final int OpponentScoreFieldNum = 8;
    public static final int RearGearFieldNum = 12;
    public static final int RearGearNumFieldNum = 11;
    public static final int ScoreFieldNum = 7;
    public static final int TimestampFieldNum = 253;
    protected static final Mesg eventMesg;

    static {
        Mesg mesg;
        eventMesg = mesg = new Mesg("event", 5376);
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("event", 0, 0, 1.0, 0.0, "", false, Profile.Type.EVENT));
        mesg.addField(new Field("event_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.EVENT_TYPE));
        mesg.addField(new Field("data16", 2, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.fields.get((int)3).components.add(new FieldComponent(3, false, 16, 1.0, 0.0));
        mesg.addField(new Field("data", 3, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)4).subFields.add(new SubField("timer_trigger", 0, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(0).addMap(0, 0L);
        mesg.fields.get((int)4).subFields.add(new SubField("course_point_index", 132, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(1).addMap(0, 10L);
        mesg.fields.get((int)4).subFields.add(new SubField("battery_level", 132, 1000.0, 0.0, "V"));
        mesg.fields.get((int)4).subFields.get(2).addMap(0, 11L);
        mesg.fields.get((int)4).subFields.add(new SubField("virtual_partner_speed", 132, 1000.0, 0.0, "m/s"));
        mesg.fields.get((int)4).subFields.get(3).addMap(0, 12L);
        mesg.fields.get((int)4).subFields.add(new SubField("hr_high_alert", 2, 1.0, 0.0, "bpm"));
        mesg.fields.get((int)4).subFields.get(4).addMap(0, 13L);
        mesg.fields.get((int)4).subFields.add(new SubField("hr_low_alert", 2, 1.0, 0.0, "bpm"));
        mesg.fields.get((int)4).subFields.get(5).addMap(0, 14L);
        mesg.fields.get((int)4).subFields.add(new SubField("speed_high_alert", 134, 1000.0, 0.0, "m/s"));
        mesg.fields.get((int)4).subFields.get(6).addMap(0, 15L);
        mesg.fields.get((int)4).subFields.add(new SubField("speed_low_alert", 134, 1000.0, 0.0, "m/s"));
        mesg.fields.get((int)4).subFields.get(7).addMap(0, 16L);
        mesg.fields.get((int)4).subFields.add(new SubField("cad_high_alert", 132, 1.0, 0.0, "rpm"));
        mesg.fields.get((int)4).subFields.get(8).addMap(0, 17L);
        mesg.fields.get((int)4).subFields.add(new SubField("cad_low_alert", 132, 1.0, 0.0, "rpm"));
        mesg.fields.get((int)4).subFields.get(9).addMap(0, 18L);
        mesg.fields.get((int)4).subFields.add(new SubField("power_high_alert", 132, 1.0, 0.0, "watts"));
        mesg.fields.get((int)4).subFields.get(10).addMap(0, 19L);
        mesg.fields.get((int)4).subFields.add(new SubField("power_low_alert", 132, 1.0, 0.0, "watts"));
        mesg.fields.get((int)4).subFields.get(11).addMap(0, 20L);
        mesg.fields.get((int)4).subFields.add(new SubField("time_duration_alert", 134, 1000.0, 0.0, "s"));
        mesg.fields.get((int)4).subFields.get(12).addMap(0, 23L);
        mesg.fields.get((int)4).subFields.add(new SubField("distance_duration_alert", 134, 100.0, 0.0, "m"));
        mesg.fields.get((int)4).subFields.get(13).addMap(0, 24L);
        mesg.fields.get((int)4).subFields.add(new SubField("calorie_duration_alert", 134, 1.0, 0.0, "calories"));
        mesg.fields.get((int)4).subFields.get(14).addMap(0, 25L);
        mesg.fields.get((int)4).subFields.add(new SubField("fitness_equipment_state", 0, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(15).addMap(0, 27L);
        mesg.fields.get((int)4).subFields.add(new SubField("sport_point", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(16).addMap(0, 33L);
        mesg.fields.get((int)4).subFields.get(16).addComponent(new FieldComponent(7, false, 16, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.get(16).addComponent(new FieldComponent(8, false, 16, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.add(new SubField("gear_change_data", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(17).addMap(0, 42L);
        mesg.fields.get((int)4).subFields.get(17).addMap(0, 43L);
        mesg.fields.get((int)4).subFields.get(17).addComponent(new FieldComponent(11, false, 8, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.get(17).addComponent(new FieldComponent(12, false, 8, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.get(17).addComponent(new FieldComponent(9, false, 8, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.get(17).addComponent(new FieldComponent(10, false, 8, 1.0, 0.0));
        mesg.fields.get((int)4).subFields.add(new SubField("rider_position", 0, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(18).addMap(0, 44L);
        mesg.fields.get((int)4).subFields.add(new SubField("comm_timeout", 132, 1.0, 0.0, ""));
        mesg.fields.get((int)4).subFields.get(19).addMap(0, 47L);
        mesg.addField(new Field("event_group", 4, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("score", 7, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("opponent_score", 8, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("front_gear_num", 9, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        mesg.addField(new Field("front_gear", 10, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        mesg.addField(new Field("rear_gear_num", 11, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        mesg.addField(new Field("rear_gear", 12, 10, 1.0, 0.0, "", false, Profile.Type.UINT8Z));
        mesg.addField(new Field("device_index", 13, 2, 1.0, 0.0, "", false, Profile.Type.DEVICE_INDEX));
    }

    public EventMesg() {
        super(Factory.createMesg(5376));
    }

    public EventMesg(Mesg mesg) {
        super(mesg);
    }

    public Float getBatteryLevel() {
        return this.getFieldFloatValue(3, 0, 2);
    }

    public Integer getCadHighAlert() {
        return this.getFieldIntegerValue(3, 0, 8);
    }

    public Integer getCadLowAlert() {
        return this.getFieldIntegerValue(3, 0, 9);
    }

    public Long getCalorieDurationAlert() {
        return this.getFieldLongValue(3, 0, 14);
    }

    public Integer getCommTimeout() {
        return this.getFieldIntegerValue(3, 0, 19);
    }

    public Integer getCoursePointIndex() {
        return this.getFieldIntegerValue(3, 0, 1);
    }

    public Long getData() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public Integer getData16() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public Short getDeviceIndex() {
        return this.getFieldShortValue(13, 0, 65535);
    }

    public Float getDistanceDurationAlert() {
        return this.getFieldFloatValue(3, 0, 13);
    }

    @Override
    public Event getEvent() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return Event.getByValue(s);
    }

    @Override
    public Short getEventGroup() {
        return this.getFieldShortValue(4, 0, 65535);
    }

    @Override
    public EventType getEventType() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return EventType.getByValue(s);
    }

    public FitnessEquipmentState getFitnessEquipmentState() {
        Short s = this.getFieldShortValue(3, 0, 15);
        if (s == null) {
            return null;
        }
        return FitnessEquipmentState.getByValue(s);
    }

    public Short getFrontGear() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    public Short getFrontGearNum() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public Long getGearChangeData() {
        return this.getFieldLongValue(3, 0, 17);
    }

    public Short getHrHighAlert() {
        return this.getFieldShortValue(3, 0, 4);
    }

    public Short getHrLowAlert() {
        return this.getFieldShortValue(3, 0, 5);
    }

    public Long getLongTimestamp() {
        return this.getFieldLongValue(253, 0, 65535);
    }

    public Integer getOpponentScore() {
        return this.getFieldIntegerValue(8, 0, 65535);
    }

    public Integer getPowerHighAlert() {
        return this.getFieldIntegerValue(3, 0, 10);
    }

    public Integer getPowerLowAlert() {
        return this.getFieldIntegerValue(3, 0, 11);
    }

    public Short getRearGear() {
        return this.getFieldShortValue(12, 0, 65535);
    }

    public Short getRearGearNum() {
        return this.getFieldShortValue(11, 0, 65535);
    }

    public RiderPositionType getRiderPosition() {
        Short s = this.getFieldShortValue(3, 0, 18);
        if (s == null) {
            return null;
        }
        return RiderPositionType.getByValue(s);
    }

    public Integer getScore() {
        return this.getFieldIntegerValue(7, 0, 65535);
    }

    public Float getSpeedHighAlert() {
        return this.getFieldFloatValue(3, 0, 6);
    }

    public Float getSpeedLowAlert() {
        return this.getFieldFloatValue(3, 0, 7);
    }

    public Long getSportPoint() {
        return this.getFieldLongValue(3, 0, 16);
    }

    public Float getTimeDurationAlert() {
        return this.getFieldFloatValue(3, 0, 12);
    }

    public TimerTrigger getTimerTrigger() {
        Short s = this.getFieldShortValue(3, 0, 0);
        if (s == null) {
            return null;
        }
        return TimerTrigger.getByValue(s);
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public Float getVirtualPartnerSpeed() {
        return this.getFieldFloatValue(3, 0, 3);
    }

    public void setBatteryLevel(Float f) {
        this.setFieldValue(3, 0, (Object)f, 2);
    }

    public void setCadHighAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 8);
    }

    public void setCadLowAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 9);
    }

    public void setCalorieDurationAlert(Long l) {
        this.setFieldValue(3, 0, (Object)l, 14);
    }

    public void setCommTimeout(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 19);
    }

    public void setCoursePointIndex(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 1);
    }

    public void setData(Long l) {
        this.setFieldValue(3, 0, (Object)l, 65535);
    }

    public void setData16(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public void setDeviceIndex(Short s) {
        this.setFieldValue(13, 0, (Object)s, 65535);
    }

    public void setDistanceDurationAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 13);
    }

    @Override
    public void setEvent(Event event) {
        this.setFieldValue(0, 0, (Object)event.value, 65535);
    }

    @Override
    public void setEventGroup(Short s) {
        this.setFieldValue(4, 0, (Object)s, 65535);
    }

    @Override
    public void setEventType(EventType eventType) {
        this.setFieldValue(1, 0, (Object)eventType.value, 65535);
    }

    public void setFitnessEquipmentState(FitnessEquipmentState fitnessEquipmentState) {
        this.setFieldValue(3, 0, (Object)fitnessEquipmentState.value, 15);
    }

    public void setFrontGear(Short s) {
        this.setFieldValue(10, 0, (Object)s, 65535);
    }

    public void setFrontGearNum(Short s) {
        this.setFieldValue(9, 0, (Object)s, 65535);
    }

    public void setGearChangeData(Long l) {
        this.setFieldValue(3, 0, (Object)l, 17);
    }

    public void setHrHighAlert(Short s) {
        this.setFieldValue(3, 0, (Object)s, 4);
    }

    public void setHrLowAlert(Short s) {
        this.setFieldValue(3, 0, (Object)s, 5);
    }

    public void setOpponentScore(Integer n) {
        this.setFieldValue(8, 0, (Object)n, 65535);
    }

    public void setPowerHighAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 10);
    }

    public void setPowerLowAlert(Integer n) {
        this.setFieldValue(3, 0, (Object)n, 11);
    }

    public void setRearGear(Short s) {
        this.setFieldValue(12, 0, (Object)s, 65535);
    }

    public void setRearGearNum(Short s) {
        this.setFieldValue(11, 0, (Object)s, 65535);
    }

    public void setRiderPosition(RiderPositionType riderPositionType) {
        this.setFieldValue(3, 0, (Object)riderPositionType.value, 18);
    }

    public void setScore(Integer n) {
        this.setFieldValue(7, 0, (Object)n, 65535);
    }

    public void setSpeedHighAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 6);
    }

    public void setSpeedLowAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 7);
    }

    public void setSportPoint(Long l) {
        this.setFieldValue(3, 0, (Object)l, 16);
    }

    public void setTimeDurationAlert(Float f) {
        this.setFieldValue(3, 0, (Object)f, 12);
    }

    public void setTimerTrigger(TimerTrigger timerTrigger) {
        this.setFieldValue(3, 0, (Object)timerTrigger.value, 0);
    }

    @Override
    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setVirtualPartnerSpeed(Float f) {
        this.setFieldValue(3, 0, (Object)f, 3);
    }
}

