/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC16;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import com.garmin.fit.ProtocolValidator;
import com.garmin.fit.Validator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.zip.CheckedOutputStream;

public class FileEncoder
implements MesgListener,
MesgDefinitionListener {
    private CRC16 crc16;
    private File file;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private CheckedOutputStream out;
    private Validator validator;
    private Fit.ProtocolVersion version;
    private int workoutMesgTempLocalNum = -1;
    private Mesg workoutTempMesg = null;

    public FileEncoder() {
    }

    @Deprecated
    public FileEncoder(File file) {
        Fit.ProtocolVersion protocolVersion;
        this.version = protocolVersion = Fit.ProtocolVersion.V1_0;
        this.validator = new ProtocolValidator(protocolVersion);
        this.open(file);
    }

    public FileEncoder(File file, Fit.ProtocolVersion protocolVersion) {
        this.version = protocolVersion;
        this.validator = new ProtocolValidator(protocolVersion);
        this.open(file);
    }

    private void writeFileHeader() {
        if (this.file != null) {
            long l;
            RandomAccessFile randomAccessFile;
            CRC16 cRC16;
            block6: {
                try {
                    long l2;
                    cRC16 = new CRC16();
                    randomAccessFile = new RandomAccessFile(this.file, "rw");
                    l = l2 = this.file.length() - 14L;
                    if (l2 >= 0L) break block6;
                    l = 0L;
                }
                catch (IOException iOException) {
                    throw new FitRuntimeException(iOException);
                }
            }
            byte[] byArray = new byte[12];
            byArray[0] = (byte)14;
            byArray[1] = (byte)this.version.getVersion();
            byArray[2] = (byte)40;
            byArray[3] = (byte)8;
            byArray[4] = (byte)(l & 0xFFL);
            byArray[5] = (byte)(l >> 8 & 0xFFL);
            byArray[6] = (byte)(l >> 16 & 0xFFL);
            byArray[7] = (byte)(l >> 24 & 0xFFL);
            byArray[8] = (byte)46;
            byArray[9] = (byte)70;
            byArray[10] = (byte)73;
            byArray[11] = (byte)84;
            randomAccessFile.write(byArray);
            cRC16.update(byArray, 0, 12);
            l = cRC16.getValue();
            randomAccessFile.write((byte)(l & 0xFFL));
            randomAccessFile.write((byte)(l >> 8 & 0xFFL));
            randomAccessFile.close();
            return;
        }
        throw new FitRuntimeException("File not open.");
    }

    public void close() {
        if (this.file != null) {
            try {
                this.writeFileHeader();
                long l = this.out.getChecksum().getValue();
                this.out.write((int)(l & 0xFFL));
                this.out.write((int)(l >> 8 & 0xFFL));
                this.out.close();
                this.file = null;
                return;
            }
            catch (IOException iOException) {
                throw new FitRuntimeException(iOException);
            }
        }
        throw new FitRuntimeException("File not open.");
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void open(File object) {
        ((File)object).delete();
        this.crc16 = new CRC16();
        this.file = object;
        this.writeFileHeader();
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.file, true);
            this.out = object = new CheckedOutputStream(fileOutputStream, this.crc16);
            return;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    public void write(Mesg mesg) {
        if (this.file != null) {
            if (this.validator.validateMesg(mesg)) {
                if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports(mesg)) {
                    this.write(new MesgDefinition(mesg));
                }
                mesg.write(this.out, this.lastMesgDefinition[mesg.localNum]);
                return;
            }
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        throw new FitRuntimeException("File not open.");
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.file != null) {
            if (this.validator.validateMesgDefn(mesgDefinition)) {
                mesgDefinition.write(this.out);
                this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
                return;
            }
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        throw new FitRuntimeException("File not open.");
    }

    public void write(List<Mesg> object) {
        object = object.iterator();
        while (object.hasNext()) {
            this.write((Mesg)object.next());
        }
    }

    public void writeForWorkout(Mesg mesg) {
        Object object = new MesgDefinition(mesg);
        if (this.file != null) {
            if (this.validator.validateMesg(mesg)) {
                if (this.lastMesgDefinition[mesg.localNum] == null || !this.lastMesgDefinition[mesg.localNum].supports((MesgDefinition)object)) {
                    this.write((MesgDefinition)object);
                }
                if (mesg.name.equals("workout")) {
                    this.workoutMesgTempLocalNum = ((MesgDefinition)object).getLocalNum();
                    this.workoutTempMesg = mesg;
                } else {
                    int n;
                    if (mesg.name.equals("workout_step") && (n = this.workoutMesgTempLocalNum) != -1 && (object = this.workoutTempMesg) != null) {
                        ((Mesg)object).write(this.out, this.lastMesgDefinition[n]);
                        this.workoutMesgTempLocalNum = -1;
                        this.workoutTempMesg = null;
                    }
                    mesg.write(this.out, this.lastMesgDefinition[mesg.localNum]);
                }
                return;
            }
            throw new FitRuntimeException("Incompatible Protocol Features");
        }
        throw new FitRuntimeException("File not open.");
    }
}

