/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class LittleEndianOutputStream
extends FilterOutputStream {
    protected int written;

    public LittleEndianOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public int size() {
        return this.written;
    }

    @Override
    public void write(int n) throws IOException {
        synchronized (this) {
            this.out.write(n);
            ++this.written;
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        synchronized (this) {
            this.out.write(byArray, n, n2);
            this.written += n2;
            return;
        }
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int n) throws IOException {
        this.out.write(n);
        ++this.written;
    }

    public void writeBytes(String string2) throws IOException {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            this.out.write((byte)string2.charAt(i));
        }
        this.written += n;
    }

    public void writeChar(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeChars(String string2) throws IOException {
        int n = string2.length();
        for (int i = 0; i < n; ++i) {
            char c = string2.charAt(i);
            this.out.write(c & 0xFF);
            this.out.write(c >>> 8 & 0xFF);
        }
        this.written += n * 2;
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public void writeInt(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.out.write(n >>> 16 & 0xFF);
        this.out.write(n >>> 24 & 0xFF);
        this.written += 4;
    }

    public void writeLong(long l) throws IOException {
        this.out.write((int)l & 0xFF);
        this.out.write((int)(l >>> 8) & 0xFF);
        this.out.write((int)(l >>> 16) & 0xFF);
        this.out.write((int)(l >>> 24) & 0xFF);
        this.out.write((int)(l >>> 32) & 0xFF);
        this.out.write((int)(l >>> 40) & 0xFF);
        this.out.write((int)(l >>> 48) & 0xFF);
        this.out.write((int)(l >>> 56) & 0xFF);
        this.written += 8;
    }

    public void writeShort(int n) throws IOException {
        this.out.write(n & 0xFF);
        this.out.write(n >>> 8 & 0xFF);
        this.written += 2;
    }

    public void writeUTF(String string2) throws IOException {
        int n;
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            char c = string2.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n4;
                continue;
            }
            if (c > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 <= 65535) {
            this.out.write(n4 >>> 8 & 0xFF);
            this.out.write(n4 & 0xFF);
            for (n4 = n3; n4 < n2; ++n4) {
                n = string2.charAt(n4);
                if (n >= 1 && n <= 127) {
                    this.out.write(n);
                    continue;
                }
                if (n > 2047) {
                    this.out.write(n >> 12 & 0xF | 0xE0);
                    this.out.write(n >> 6 & 0x3F | 0x80);
                    this.out.write(n & 0x3F | 0x80);
                    this.written += 2;
                    continue;
                }
                this.out.write(n >> 6 & 0x1F | 0xC0);
                this.out.write(n & 0x3F | 0x80);
                ++this.written;
            }
            this.written += n2 + 2;
            return;
        }
        throw new UTFDataFormatException();
    }
}

