/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgNum;
import com.garmin.fit.SubField;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public class Mesg {
    protected ArrayList<DeveloperField> developerFields;
    protected ArrayList<Field> fields;
    protected int localNum;
    protected String name;
    protected int num;
    protected long systemTimeOffset;

    public Mesg(Mesg object3) {
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        if (object3 == null) {
            this.name = "unknown";
            this.num = MesgNum.INVALID;
            this.systemTimeOffset = 0L;
            return;
        }
        this.name = ((Mesg)object3).name;
        this.num = ((Mesg)object3).num;
        this.localNum = ((Mesg)object3).localNum;
        this.systemTimeOffset = ((Mesg)object3).systemTimeOffset;
        for (Field field : ((Mesg)object3).fields) {
            if (field.getNumValues() <= 0) continue;
            this.fields.add(new Field(field));
        }
        for (DeveloperField developerField : ((Mesg)object3).developerFields) {
            if (developerField.getNumValues() <= 0) continue;
            this.developerFields.add(new DeveloperField(developerField));
        }
    }

    protected Mesg(String string2, int n) {
        this.name = new String(string2);
        this.num = n;
        this.localNum = 0;
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
        this.systemTimeOffset = 0L;
    }

    private DeveloperField getDeveloperField(short s, int n) {
        for (DeveloperField developerField : this.developerFields) {
            if (developerField.getDeveloperDataIndex() != s || developerField.getNum() != n) continue;
            return developerField;
        }
        return null;
    }

    public void addDeveloperField(DeveloperField developerField) {
        for (int i = 0; i < this.developerFields.size(); ++i) {
            DeveloperField developerField2 = this.developerFields.get(i);
            if (developerField2.getNum() != developerField.getNum() || developerField2.getDeveloperDataIndex() != developerField.getDeveloperDataIndex()) continue;
            this.developerFields.set(i, developerField);
            return;
        }
        this.developerFields.add(developerField);
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public int getActiveSubFieldIndex(int n) {
        Field field = Factory.createField(this.num, n);
        if (field == null) {
            return 65535;
        }
        for (n = 0; n < field.subFields.size(); ++n) {
            if (!field.subFields.get(n).canMesgSupport(this)) continue;
            return n;
        }
        return 65535;
    }

    public String getActiveSubFieldName(int n) {
        Field field = Factory.createField(this.num, n);
        if (field == null) {
            return Fit.SUBFIELD_NAME_MAIN_FIELD;
        }
        for (n = 0; n < field.subFields.size(); ++n) {
            if (!field.subFields.get(n).canMesgSupport(this)) continue;
            return field.subFields.get(n).getName();
        }
        return Fit.SUBFIELD_NAME_MAIN_FIELD;
    }

    public Iterable<DeveloperField> getDeveloperFields() {
        return this.developerFields;
    }

    public Field getField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public Field getField(String string2) {
        return this.getField(string2, true);
    }

    public Field getField(String string2, boolean bl) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).name.equals(string2)) {
                return this.fields.get(i);
            }
            for (int j = 0; j < this.fields.get((int)i).subFields.size(); ++j) {
                if (!this.fields.get((int)i).subFields.get((int)j).name.equals(string2) || bl && !this.fields.get((int)i).subFields.get(j).canMesgSupport(this)) continue;
                return this.fields.get(i);
            }
        }
        return null;
    }

    public BigInteger getFieldBigIntegerValue(int n) {
        return this.getFieldBigIntegerValue(n, 0, 65534);
    }

    public BigInteger getFieldBigIntegerValue(int n, int n2) {
        return this.getFieldBigIntegerValue(n, n2, 65534);
    }

    public BigInteger getFieldBigIntegerValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getBigIntegerValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getBigIntegerValue(n2, n3);
    }

    public BigInteger getFieldBigIntegerValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getBigIntegerValue(n2, string2);
    }

    public BigInteger getFieldBigIntegerValue(String string2) {
        return this.getFieldBigIntegerValue(string2, 0);
    }

    public BigInteger getFieldBigIntegerValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getBigIntegerValue(n, string2);
    }

    public BigInteger[] getFieldBigIntegerValues(int n) {
        return this.getFieldBigIntegerValues(n, 65534);
    }

    public BigInteger[] getFieldBigIntegerValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getBigIntegerValues(n2);
    }

    public BigInteger[] getFieldBigIntegerValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getBigIntegerValues(string2);
    }

    public Long getFieldBitsValue(int n, int n2, int n3, boolean bl) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        return field.getBitsValue(n2, n3, bl);
    }

    public Long getFieldBitsValue(String object, int n, int n2, boolean bl) {
        Field field = this.getField((String)object, false);
        if (field == null) {
            return null;
        }
        if ((object = field.getSubField((String)object)) != null && !((SubField)object).canMesgSupport(this)) {
            return null;
        }
        return field.getBitsValue(n, n2, bl);
    }

    public Byte getFieldByteValue(int n) {
        return this.getFieldByteValue(n, 0, 65534);
    }

    public Byte getFieldByteValue(int n, int n2) {
        return this.getFieldByteValue(n, n2, 65534);
    }

    public Byte getFieldByteValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getByteValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getByteValue(n2, n3);
    }

    public Byte getFieldByteValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getByteValue(n2, string2);
    }

    public Byte getFieldByteValue(String string2) {
        return this.getFieldByteValue(string2, 0);
    }

    public Byte getFieldByteValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getByteValue(n, string2);
    }

    public Byte[] getFieldByteValues(int n) {
        return this.getFieldByteValues(n, 65534);
    }

    public Byte[] getFieldByteValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getByteValues(n2);
    }

    public Byte[] getFieldByteValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getByteValues(string2);
    }

    public Double getFieldDoubleValue(int n) {
        return this.getFieldDoubleValue(n, 0, 65534);
    }

    public Double getFieldDoubleValue(int n, int n2) {
        return this.getFieldDoubleValue(n, n2, 65534);
    }

    public Double getFieldDoubleValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getDoubleValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getDoubleValue(n2, n3);
    }

    public Double getFieldDoubleValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getDoubleValue(n2, string2);
    }

    public Double getFieldDoubleValue(String string2) {
        return this.getFieldDoubleValue(string2, 0);
    }

    public Double getFieldDoubleValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getDoubleValue(n, string2);
    }

    public Double[] getFieldDoubleValues(int n) {
        return this.getFieldDoubleValues(n, 65534);
    }

    public Double[] getFieldDoubleValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getDoubleValues(n2);
    }

    public Double[] getFieldDoubleValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getDoubleValues(string2);
    }

    public Float getFieldFloatValue(int n) {
        return this.getFieldFloatValue(n, 0, 65534);
    }

    public Float getFieldFloatValue(int n, int n2) {
        return this.getFieldFloatValue(n, n2, 65534);
    }

    public Float getFieldFloatValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getFloatValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getFloatValue(n2, n3);
    }

    public Float getFieldFloatValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getFloatValue(n2, string2);
    }

    public Float getFieldFloatValue(String string2) {
        return this.getFieldFloatValue(string2, 0);
    }

    public Float getFieldFloatValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getFloatValue(n, string2);
    }

    public Float[] getFieldFloatValues(int n) {
        return this.getFieldFloatValues(n, 65534);
    }

    public Float[] getFieldFloatValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getFloatValues(n2);
    }

    public Float[] getFieldFloatValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getFloatValues(string2);
    }

    public Integer getFieldIntegerValue(int n) {
        return this.getFieldIntegerValue(n, 0, 65534);
    }

    public Integer getFieldIntegerValue(int n, int n2) {
        return this.getFieldIntegerValue(n, n2, 65534);
    }

    public Integer getFieldIntegerValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getIntegerValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getIntegerValue(n2, n3);
    }

    public Integer getFieldIntegerValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getIntegerValue(n2, string2);
    }

    public Integer getFieldIntegerValue(String string2) {
        return this.getFieldIntegerValue(string2, 0);
    }

    public Integer getFieldIntegerValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getIntegerValue(n, string2);
    }

    public Integer[] getFieldIntegerValues(int n) {
        return this.getFieldIntegerValues(n, 65534);
    }

    public Integer[] getFieldIntegerValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getIntegerValues(n2);
    }

    public Integer[] getFieldIntegerValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getIntegerValues(string2);
    }

    public Long getFieldLongValue(int n) {
        return this.getFieldLongValue(n, 0, 65534);
    }

    public Long getFieldLongValue(int n, int n2) {
        return this.getFieldLongValue(n, n2, 65534);
    }

    public Long getFieldLongValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getLongValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getLongValue(n2, n3);
    }

    public Long getFieldLongValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getLongValue(n2, string2);
    }

    public Long getFieldLongValue(String string2) {
        return this.getFieldLongValue(string2, 0);
    }

    public Long getFieldLongValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getLongValue(n, string2);
    }

    public Long[] getFieldLongValues(int n) {
        return this.getFieldLongValues(n, 65534);
    }

    public Long[] getFieldLongValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getLongValues(n2);
    }

    public Long[] getFieldLongValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getLongValues(string2);
    }

    public Short getFieldShortValue(int n) {
        return this.getFieldShortValue(n, 0, 65534);
    }

    public Short getFieldShortValue(int n, int n2) {
        return this.getFieldShortValue(n, n2, 65534);
    }

    public Short getFieldShortValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getShortValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getShortValue(n2, n3);
    }

    public Short getFieldShortValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getShortValue(n2, string2);
    }

    public Short getFieldShortValue(String string2) {
        return this.getFieldShortValue(string2, 0);
    }

    public Short getFieldShortValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getShortValue(n, string2);
    }

    public Short[] getFieldShortValues(int n) {
        return this.getFieldShortValues(n, 65534);
    }

    public Short[] getFieldShortValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getShortValues(n2);
    }

    public Short[] getFieldShortValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getShortValues(string2);
    }

    public String getFieldStringValue(int n) {
        return this.getFieldStringValue(n, 0, 65534);
    }

    public String getFieldStringValue(int n, int n2) {
        return this.getFieldStringValue(n, n2, 65534);
    }

    public String getFieldStringValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getStringValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getStringValue(n2, n3);
    }

    public String getFieldStringValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getStringValue(n2, string2);
    }

    public String getFieldStringValue(String string2) {
        return this.getFieldStringValue(string2, 0);
    }

    public String getFieldStringValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getStringValue(n, string2);
    }

    public String[] getFieldStringValues(int n) {
        return this.getFieldStringValues(n, 65534);
    }

    public String[] getFieldStringValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getStringValues(n2);
    }

    public String[] getFieldStringValues(int n, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getStringValues(string2);
    }

    public Object getFieldValue(int n) {
        return this.getFieldValue(n, 0, 65534);
    }

    public Object getFieldValue(int n, int n2) {
        return this.getFieldValue(n, n2, 65534);
    }

    public Object getFieldValue(int n, int n2, int n3) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        if (n3 == 65534) {
            return field.getValue(n2, this.getActiveSubFieldIndex(n));
        }
        SubField subField = field.getSubField(n3);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getValue(n2, n3);
    }

    public Object getFieldValue(int n, int n2, String string2) {
        Field field = this.getField(n);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getValue(n2, string2);
    }

    public Object getFieldValue(String string2) {
        return this.getFieldValue(string2, 0);
    }

    public Object getFieldValue(String string2, int n) {
        Field field = this.getField(string2, false);
        if (field == null) {
            return null;
        }
        SubField subField = field.getSubField(string2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return null;
        }
        return field.getValue(n, string2);
    }

    public Collection<Field> getFields() {
        return Collections.unmodifiableCollection(this.fields);
    }

    public boolean getIsFieldAccumulated(int n) {
        Field field = this.getField(n);
        if (field != null) {
            return field.getIsAccumulated();
        }
        return false;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public String getName() {
        return this.name;
    }

    public int getNum() {
        return this.num;
    }

    public int getNumFieldValues(int n) {
        return this.getNumFieldValues(n, 65534);
    }

    public int getNumFieldValues(int n, int n2) {
        Field field = this.getField(n);
        if (field == null) {
            return 0;
        }
        if (n2 == 65534) {
            return field.getNumValues();
        }
        SubField subField = field.getSubField(n2);
        if (subField != null && !subField.canMesgSupport(this)) {
            return 0;
        }
        return field.getNumValues();
    }

    public int getNumFieldValues(int n, String object) {
        Field field = this.getField(n);
        if (field == null) {
            return 0;
        }
        if ((object = field.getSubField((String)object)) != null && !((SubField)object).canMesgSupport(this)) {
            return 0;
        }
        return field.getNumValues();
    }

    public int getNumFieldValues(String object) {
        Field field = this.getField((String)object, false);
        if (field == null) {
            return 0;
        }
        if ((object = field.getSubField((String)object)) != null && !((SubField)object).canMesgSupport(this)) {
            return 0;
        }
        return field.getNumValues();
    }

    public int getNumFields() {
        return this.fields.size();
    }

    public Iterable<FieldBase> getOverrideField(short s) {
        LinkedList<FieldBase> linkedList = new LinkedList<FieldBase>();
        Field field = this.getField(s);
        if (field != null) {
            linkedList.add(field);
        }
        for (DeveloperField developerField : this.developerFields) {
            if (developerField.getNativeOverride() != s) continue;
            linkedList.add(developerField);
        }
        return linkedList;
    }

    public boolean hasField(int n) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != n) continue;
            return true;
        }
        return false;
    }

    public void removeExpandedFields() {
        ArrayList<Field> arrayList = new ArrayList<Field>();
        for (Field field : this.fields) {
            if (!field.getIsExpanded()) continue;
            arrayList.add(field);
        }
        this.fields.removeAll(arrayList);
    }

    public boolean removeField(Field field) {
        boolean bl;
        if (this.fields.contains(field)) {
            this.fields.remove(field);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void setField(Field field) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get((int)i).num != field.num) continue;
            this.fields.set(i, field);
            return;
        }
        this.fields.add(field);
    }

    public void setFieldValue(int n, int n2, Object object) {
        this.setFieldValue(n, n2, object, 65535);
    }

    public void setFieldValue(int n, int n2, Object object, int n3) {
        Field field;
        int n4 = n3;
        if (n3 == 65534) {
            n4 = this.getActiveSubFieldIndex(n);
        }
        Field field2 = field = this.getField(n);
        if (field == null) {
            field2 = Factory.createField(this.num, n);
            this.addField(field2);
        }
        field2.setValue(n2, object, n4);
    }

    public void setFieldValue(int n, int n2, Object object, String string2) {
        Field field;
        Field field2 = field = this.getField(n);
        if (field == null) {
            field2 = Factory.createField(this.num, n);
            this.addField(field2);
        }
        field2.setValue(n2, object, string2);
    }

    public void setFieldValue(int n, Object object) {
        this.setFieldValue(n, 0, object, 65535);
    }

    public void setFieldValue(String string2, int n, Object object) {
        Field field;
        Field field2 = field = this.getField(string2, false);
        if (field == null) {
            field2 = Factory.createField(this.num, string2);
            this.addField(field2);
        }
        field2.setValue(n, object, string2);
    }

    public void setFieldValue(String string2, Object object) {
        this.setFieldValue(string2, 0, object);
    }

    public void setFields(Mesg object) {
        if (((Mesg)object).num != this.num) {
            return;
        }
        object = ((Mesg)object).fields.iterator();
        while (object.hasNext()) {
            this.setField((Field)object.next());
        }
    }

    public void setLocalNum(int n) {
        if (n < 16) {
            this.localNum = n;
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Invalid local message number ");
        stringBuilder.append(n);
        stringBuilder.append(".  Local message number must be < ");
        stringBuilder.append(16);
        stringBuilder.append(".");
        throw new FitRuntimeException(stringBuilder.toString());
    }

    public DateTime timestampToDateTime(Long object) {
        if (object == null) {
            return null;
        }
        object = new DateTime((Long)object);
        ((DateTime)object).convertSystemTimeToUTC(this.systemTimeOffset);
        return object;
    }

    public void write(OutputStream outputStream) {
        this.write(outputStream, null);
    }

    public void write(OutputStream outputStream, MesgDefinition object) {
        Object object2;
        try {
            int n = this.localNum;
            object2 = new DataOutputStream(outputStream);
            ((DataOutputStream)object2).writeByte(n & 0xF);
            object2 = object;
            if (object == null) {
                object2 = new MesgDefinition(this);
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        for (FieldDefinition object3 : ((MesgDefinition)object2).fields) {
            Field field = this.getField(object3.num);
            object = field;
            if (field == null) {
                object = Factory.createField(this.num, object3.num);
            }
            ((FieldBase)object).write(outputStream, object3);
        }
        for (DeveloperFieldDefinition developerFieldDefinition : ((MesgDefinition)object2).developerFields) {
            object = object2 = this.getDeveloperField(developerFieldDefinition.getDeveloperDataIndex(), developerFieldDefinition.getNum());
            if (object2 == null) {
                object = developerFieldDefinition.getDefaultField();
            }
            ((FieldBase)object).write(outputStream, developerFieldDefinition);
        }
        return;
    }
}

