/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DeveloperField;
import com.garmin.fit.DeveloperFieldDefinition;
import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FieldDefinitionBase;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgNum;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class MesgDefinition {
    protected int arch;
    protected ArrayList<DeveloperFieldDefinition> developerFields;
    protected ArrayList<FieldDefinition> fields;
    protected int localNum;
    protected int num;

    protected MesgDefinition() {
        this.num = MesgNum.INVALID;
        this.localNum = 0;
        this.arch = 0;
        this.fields = new ArrayList();
        this.developerFields = new ArrayList();
    }

    public MesgDefinition(Mesg iterator2) {
        int n;
        this.num = ((Mesg)((Object)iterator2)).num;
        this.localNum = n = ((Mesg)((Object)iterator2)).localNum;
        this.arch = 0;
        if (n < 16) {
            this.fields = new ArrayList();
            this.developerFields = new ArrayList();
            for (Field field : ((Mesg)((Object)iterator2)).fields) {
                this.fields.add(new FieldDefinition(field));
            }
            for (DeveloperField developerField : ((Mesg)((Object)iterator2)).developerFields) {
                this.developerFields.add(new DeveloperFieldDefinition(developerField));
            }
            return;
        }
        iterator2 = new StringBuilder();
        ((StringBuilder)((Object)iterator2)).append("Invalid local message number ");
        ((StringBuilder)((Object)iterator2)).append(this.localNum);
        ((StringBuilder)((Object)iterator2)).append(".  Local message number must be < ");
        ((StringBuilder)((Object)iterator2)).append(16);
        ((StringBuilder)((Object)iterator2)).append(".");
        throw new FitRuntimeException(((StringBuilder)((Object)iterator2)).toString());
    }

    private DeveloperFieldDefinition getDeveloperField(short s, int n) {
        for (DeveloperFieldDefinition developerFieldDefinition : this.developerFields) {
            if (developerFieldDefinition.getNum() != n || developerFieldDefinition.getDeveloperDataIndex() != s) continue;
            return developerFieldDefinition;
        }
        return null;
    }

    public void addDeveloperField(DeveloperFieldDefinition developerFieldDefinition) {
        this.developerFields.add(developerFieldDefinition);
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.fields.add(fieldDefinition);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MesgDefinition)) {
            return false;
        }
        object = (MesgDefinition)object;
        if (this.num != ((MesgDefinition)object).num) {
            return false;
        }
        if (this.localNum != ((MesgDefinition)object).localNum) {
            return false;
        }
        if (this.fields.size() != ((MesgDefinition)object).fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            if (this.fields.get(i).equals(((MesgDefinition)object).fields.get(i))) continue;
            return false;
        }
        return true;
    }

    public int getArch() {
        return this.arch;
    }

    public int getDeveloperFieldTotalSize() {
        Iterator<DeveloperFieldDefinition> iterator2 = this.developerFields.iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            n += iterator2.next().getSize();
        }
        return n;
    }

    public Iterable<DeveloperFieldDefinition> getDeveloperFields() {
        return this.developerFields;
    }

    public FieldDefinition getField(int n) {
        for (FieldDefinition fieldDefinition : this.fields) {
            if (fieldDefinition.num != n) continue;
            return fieldDefinition;
        }
        return null;
    }

    public ArrayList<FieldDefinition> getFields() {
        return this.fields;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public int getNum() {
        return this.num;
    }

    public int hashCode() {
        return ((31 + new Integer(this.num).hashCode()) * 47 + new Integer(this.localNum).hashCode()) * 19 + this.fields.hashCode();
    }

    public boolean supports(Mesg mesg) {
        return this.supports(new MesgDefinition(mesg));
    }

    public boolean supports(MesgDefinition object2) {
        if (object2 == null) {
            return false;
        }
        if (this.num != ((MesgDefinition)object2).num) {
            return false;
        }
        if (this.localNum != ((MesgDefinition)object2).localNum) {
            return false;
        }
        for (FieldDefinition fieldDefinition : ((MesgDefinition)object2).fields) {
            FieldDefinition fieldDefinition2 = this.getField(fieldDefinition.num);
            if (fieldDefinition2 == null) {
                return false;
            }
            if (fieldDefinition.size <= fieldDefinition2.size) continue;
            return false;
        }
        for (DeveloperFieldDefinition developerFieldDefinition : ((MesgDefinition)object2).developerFields) {
            DeveloperFieldDefinition developerFieldDefinition2 = this.getDeveloperField(developerFieldDefinition.getDeveloperDataIndex(), developerFieldDefinition.getNum());
            if (developerFieldDefinition2 == null) {
                return false;
            }
            if (developerFieldDefinition.getSize() <= developerFieldDefinition2.getSize()) continue;
            return false;
        }
        return true;
    }

    public void write(OutputStream outputStream) {
        int n;
        block7: {
            int n2;
            n = n2 = this.localNum & 0xF | 0x40;
            if (this.developerFields.isEmpty()) break block7;
            n = n2 | 0x20;
        }
        try {
            outputStream.write(n);
            outputStream.write(0);
            outputStream.write(0);
            outputStream.write(this.num >> 8);
            outputStream.write(this.num);
            outputStream.write(this.fields.size());
            Iterator<FieldDefinitionBase> iterator2 = this.fields.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().write(outputStream);
            }
            if (!this.developerFields.isEmpty()) {
                outputStream.write(this.developerFields.size());
                iterator2 = this.developerFields.iterator();
                while (iterator2.hasNext()) {
                    ((DeveloperFieldDefinition)iterator2.next()).write(outputStream);
                }
            }
            return;
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }
}

