/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityType;
import com.garmin.fit.DateTime;
import com.garmin.fit.DeviceSettingsMesg;
import com.garmin.fit.DeviceSettingsMesgListener;
import com.garmin.fit.Field;
import com.garmin.fit.FieldBase;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.LocalDateTime;
import com.garmin.fit.Mesg;
import com.garmin.fit.MonitoringInfoMesg;
import com.garmin.fit.MonitoringInfoMesgListener;
import com.garmin.fit.MonitoringMesg;
import com.garmin.fit.MonitoringMesgListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class MonitoringReader
implements MonitoringInfoMesgListener,
MonitoringMesgListener,
DeviceSettingsMesgListener {
    public static final String ACTIVE_CAL_STRING = "active_calories";
    public static final String ACTIVE_TIME_STRING = "active_time";
    public static final String ASCENT_STRING = "ascent";
    public static final String CALORIE_STRING = "calories";
    public static final String CYCLES_STRING = "cycles";
    public static final int DAILY_INTERVAL = 86400;
    public static final String DESCENT_STRING = "descent";
    public static final String DISTANCE_STRING = "distance";
    public static final String HR_STRING = "heart_rate";
    public static final String INTENSITY_STRING = "intensity";
    public static final String MOD_ACTIVITY_MIN_STRING = "moderate_activity_minutes";
    public static final String TEMPERATURE_STRING = "temperature";
    public static final String VIG_ACTIVITY_MIN_STRING = "vigorous_activity_minutes";
    private final String[] accumulatedFieldNames = new String[]{"cycles", "distance", "active_calories", "calories", "active_time"};
    private long endTimestamp;
    private TreeMap<ActivityType, ExtractState> extractStates;
    private HashMap<String, Boolean> includedFields;
    private MonitoringInfoMesg infoMesg;
    private final String[] instantaneousFieldNames = new String[]{"intensity", "heart_rate", "temperature"};
    private int interval;
    private TreeMap<ActivityType, ArrayList<MonitoringMesg>> intervalMesgs;
    private MonitoringMesg lastAccumMesg;
    private TreeMap<ActivityType, MonitoringMesg> lastMesgs;
    private MonitoringMesg lastSummedInstMesg;
    private long lastTimestamp;
    private ArrayList<MonitoringMesgListener> listeners;
    private long localTimeOffset;
    private long mesgTimestamp;
    private boolean outputDailyTotals;
    private long startTimestamp;
    private final String[] summedInstantaneousFieldNames = new String[]{"ascent", "descent", "moderate_activity_minutes", "vigorous_activity_minutes"};
    private HashSet<String> summedInstantaneousFields;
    private long systemToLocalTimestampOffset;
    private long systemToUtcTimestampOffset;

    public MonitoringReader(int n) {
        if (n >= 0 && n <= 86400) {
            String[] stringArray;
            this.listeners = new ArrayList();
            this.interval = n;
            this.outputDailyTotals = false;
            this.intervalMesgs = new TreeMap();
            this.lastMesgs = new TreeMap();
            this.localTimeOffset = 0L;
            this.systemToUtcTimestampOffset = 0L;
            this.systemToLocalTimestampOffset = 0L;
            this.extractStates = new TreeMap();
            this.includedFields = new HashMap();
            this.summedInstantaneousFields = new HashSet();
            for (n = 0; n < (stringArray = this.summedInstantaneousFieldNames).length; ++n) {
                this.summedInstantaneousFields.add(stringArray[n]);
            }
            this.includedFields.put(CYCLES_STRING, true);
            this.includedFields.put(DISTANCE_STRING, true);
            this.includedFields.put(ACTIVE_CAL_STRING, true);
            this.includedFields.put(CALORIE_STRING, true);
            this.includedFields.put(ACTIVE_TIME_STRING, true);
            this.includedFields.put(INTENSITY_STRING, true);
            this.includedFields.put(HR_STRING, true);
            this.includedFields.put(TEMPERATURE_STRING, true);
            this.includedFields.put(ASCENT_STRING, true);
            this.includedFields.put(DESCENT_STRING, true);
            this.includedFields.put(MOD_ACTIVITY_MIN_STRING, true);
            this.includedFields.put(VIG_ACTIVITY_MIN_STRING, true);
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(n);
        stringBuilder.append("s is invalid.  Output interval duration must be between 1s and 86400s (1 day).");
        throw new FitRuntimeException(stringBuilder.toString());
    }

    private void broadcastCompleteIntervals() {
        while (this.broadcastInterval(true)) {
        }
    }

    private boolean broadcastInterval(boolean bl) {
        Iterator<MonitoringMesgListener> iterator22;
        Object object4;
        long l;
        long l2;
        Object object2 = this.intervalMesgs.keySet().iterator();
        TreeMap<ActivityType, MonitoringMesg> treeMap = new TreeMap<ActivityType, MonitoringMesg>();
        if (this.endTimestamp == this.lastTimestamp) {
            return false;
        }
        if (this.outputDailyTotals) {
            this.startTimestamp = this.modTimestampToLocalInterval(this.startTimestamp);
        }
        if ((l2 = this.endTimestamp) < (l = this.startTimestamp)) {
            this.endTimestamp = this.modTimestampToLocalInterval(l);
        }
        if (bl && this.endTimestamp + (long)this.interval > this.lastTimestamp) {
            return false;
        }
        this.endTimestamp = l2 = this.endTimestamp + (long)this.interval;
        l = this.lastTimestamp;
        if (l2 > l) {
            this.endTimestamp = l;
        }
        Object object3 = null;
        block0: while (object2.hasNext()) {
            int n;
            ActivityType object4 = object2.next();
            String[] stringArray = this.intervalMesgs.get((Object)object4);
            object4 = this.computeInterval(object4, (ArrayList<MonitoringMesg>)stringArray);
            iterator22 = object3;
            if (object4 != null) {
                treeMap.put(object4, (MonitoringMesg)object4);
                iterator22 = object3;
                if (((MonitoringMesg)object4).getActivityType() == ActivityType.ALL) {
                    iterator22 = object4;
                }
            }
            for (n = 0; n < stringArray.size() && stringArray.get(n).getTimestamp().getTimestamp() <= this.endTimestamp; ++n) {
            }
            --n;
            while (true) {
                object3 = iterator22;
                if (n <= 0) continue block0;
                stringArray.remove(--n);
            }
        }
        if (treeMap.size() > 0) {
            object4 = (MonitoringMesg)treeMap.values().iterator().next();
            iterator22 = new MonitoringMesg();
            ((MonitoringMesg)((Object)iterator22)).setTimestamp(((MonitoringMesg)object4).getTimestamp());
            ((MonitoringMesg)((Object)iterator22)).setLocalTimestamp(((MonitoringMesg)object4).getLocalTimestamp());
            ((MonitoringMesg)((Object)iterator22)).setActivityType(ActivityType.ALL);
            ((MonitoringMesg)((Object)iterator22)).setDuration(((MonitoringMesg)object4).getDuration());
            object4 = treeMap.keySet().iterator();
            while (object4.hasNext()) {
                object2 = (MonitoringMesg)treeMap.get((Object)((ActivityType)((Object)object4.next())));
                if (((MonitoringMesg)object2).getActivityType() == ActivityType.ALL) continue;
                for (String string2 : this.accumulatedFieldNames) {
                    if (((Mesg)object2).getFieldDoubleValue(string2) == null) continue;
                    if (((Mesg)((Object)iterator22)).getFieldDoubleValue(string2) == null) {
                        ((Mesg)((Object)iterator22)).setFieldValue(string2, Float.valueOf(0.0f));
                    }
                    ((Mesg)((Object)iterator22)).setFieldValue(string2, ((Mesg)((Object)iterator22)).getFieldDoubleValue(string2) + ((Mesg)object2).getFieldDoubleValue(string2));
                }
                for (String string3 : this.summedInstantaneousFieldNames) {
                    if (((Mesg)object2).getFieldDoubleValue(string3) == null) continue;
                    if (((Mesg)((Object)iterator22)).getFieldDoubleValue(string3) == null) {
                        ((Mesg)((Object)iterator22)).setFieldValue(string3, Float.valueOf(0.0f));
                    }
                    ((Mesg)((Object)iterator22)).setFieldValue(string3, ((Mesg)((Object)iterator22)).getFieldDoubleValue(string3) + ((Mesg)object2).getFieldDoubleValue(string3));
                }
            }
            if (((MonitoringMesg)((Object)iterator22)).getCalories() == null && this.infoMesg.getRestingMetabolicRate() != null) {
                ((MonitoringMesg)((Object)iterator22)).setCalories((int)(((MonitoringMesg)((Object)iterator22)).getDuration() * (long)this.infoMesg.getRestingMetabolicRate().intValue() / 86400L));
                if (((MonitoringMesg)((Object)iterator22)).getActiveCalories() != null) {
                    ((MonitoringMesg)((Object)iterator22)).setCalories(((MonitoringMesg)((Object)iterator22)).getCalories() + ((MonitoringMesg)((Object)iterator22)).getActiveCalories());
                }
            }
            if (object3 != null) {
                for (Iterator<MonitoringMesgListener> iterator22 : ((MonitoringMesg)((Object)iterator22)).fields) {
                    if (((Mesg)object3).getField(((Field)((Object)iterator22)).num) != null) continue;
                    ((Mesg)object3).setField((Field)((Object)iterator22));
                }
            } else {
                treeMap.put(ActivityType.ALL, (MonitoringMesg)((Object)iterator22));
            }
            for (Object object4 : treeMap.keySet()) {
                iterator22 = this.listeners.iterator();
                while (iterator22.hasNext()) {
                    iterator22.next().onMesg((MonitoringMesg)treeMap.get(object4));
                }
            }
            this.startTimestamp = this.endTimestamp;
        }
        return true;
    }

    private MonitoringMesg computeInterval(ActivityType object, ArrayList<MonitoringMesg> object2) {
        Object object3;
        int n;
        MonitoringMesg monitoringMesg = new MonitoringMesg();
        ArrayList<Field> arrayList = new ArrayList<Field>();
        if (((ArrayList)((Object)object2)).size() == 0) {
            return null;
        }
        monitoringMesg.setTimestamp(new DateTime(this.endTimestamp));
        monitoringMesg.setLocalTimestamp(this.endTimestamp + this.localTimeOffset);
        monitoringMesg.setActivityType((ActivityType)((Object)object));
        monitoringMesg.setDuration(this.endTimestamp - this.startTimestamp);
        object = this.accumulatedFieldNames;
        int n2 = ((Object)object).length;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            Object object42 = object[n];
            arrayList.add(new AccumField(MonitoringMesg.monitoringMesg.getField((String)object42)));
        }
        for (String string2 : this.instantaneousFieldNames) {
            arrayList.add(new InstField(MonitoringMesg.monitoringMesg.getField(string2)));
        }
        for (String string3 : this.summedInstantaneousFieldNames) {
            arrayList.add(new SummedInstField(MonitoringMesg.monitoringMesg.getField(string3)));
        }
        object = ((ArrayList)((Object)object2)).iterator();
        block3: while (true) {
            boolean bl = object.hasNext();
            n2 = 1;
            if (!bl) break;
            object3 = (MonitoringMesg)object.next();
            n = 0;
            while (true) {
                String[] stringArray;
                if (n >= (stringArray = this.summedInstantaneousFieldNames).length) continue block3;
                if (((Mesg)object3).getField(stringArray[n]) != null) {
                    this.lastSummedInstMesg = object3;
                    n2 = 0;
                }
                if (n2 != 0) {
                    this.lastAccumMesg = object3;
                }
                ++n;
            }
            break;
        }
        object2 = ((ArrayList)((Object)object2)).iterator();
        n = 0;
        block5: while (object2.hasNext()) {
            MonitoringMesg monitoringMesg2 = (MonitoringMesg)object2.next();
            long l = monitoringMesg2.getTimestamp().getTimestamp();
            n2 = n;
            if (l > this.startTimestamp) {
                n2 = n;
                if (l < this.endTimestamp + (long)this.interval) {
                    n2 = 1;
                }
            }
            object3 = arrayList.iterator();
            while (true) {
                n = n2;
                if (!object3.hasNext()) continue block5;
                object = (ReaderField)object3.next();
                if (this.summedInstantaneousFields.contains(object.getName())) {
                    if (l <= this.startTimestamp || l > this.endTimestamp) continue;
                    object.onMesg(monitoringMesg2);
                    continue;
                }
                object.onMesg(monitoringMesg2);
            }
        }
        if (n == 0) {
            return null;
        }
        object = arrayList.iterator();
        n = n3;
        while (object.hasNext()) {
            if (!((ReaderField)object.next()).setMesg(monitoringMesg)) continue;
            n = 1;
        }
        if (n == 0) {
            return null;
        }
        return monitoringMesg;
    }

    private MonitoringMesg extract(MonitoringMesg monitoringMesg) {
        int n;
        long l;
        MonitoringMesg monitoringMesg2 = new MonitoringMesg();
        if (monitoringMesg.getTimestamp() != null) {
            this.mesgTimestamp = monitoringMesg.getTimestamp().getTimestamp();
        } else if (monitoringMesg.getTimestamp16() != null) {
            this.mesgTimestamp += (long)monitoringMesg.getTimestamp16().intValue() - (this.mesgTimestamp & 0xFFFFL) & 0xFFFFL;
        } else if (monitoringMesg.getTimestampMin8() != null) {
            this.mesgTimestamp = l = this.mesgTimestamp / 60L;
            this.mesgTimestamp = l += (long)monitoringMesg.getTimestampMin8().shortValue() - (this.mesgTimestamp & 0xFFL) & 0xFFL;
            this.mesgTimestamp = l * 60L;
        }
        DateTime dateTime = new DateTime(this.mesgTimestamp);
        dateTime.convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        monitoringMesg2.setTimestamp(dateTime);
        if (monitoringMesg.getLocalTimestamp() != null) {
            monitoringMesg2.setLocalTimestamp(monitoringMesg.getLocalTimestamp());
        } else {
            monitoringMesg2.setLocalTimestamp(dateTime.getTimestamp() + this.localTimeOffset);
        }
        if (monitoringMesg.getActivityType() != null) {
            monitoringMesg2.setActivityType(monitoringMesg.getActivityType());
        }
        ActivityType activityType = monitoringMesg2.getActivityType();
        Object object = null;
        Object object2 = activityType != null ? this.extractStates.get((Object)activityType) : null;
        ExtractState extractState = object2;
        if (object2 == null) {
            object2 = new ExtractState();
            extractState = object2;
            if (activityType != null) {
                this.extractStates.put(activityType, (ExtractState)object2);
                extractState = object2;
            }
        }
        int n2 = this.infoMesg.getNumActivityType();
        int n3 = n = Integer.MAX_VALUE;
        if (n2 > 0) {
            n2 = 0;
            while (true) {
                n3 = n;
                if (n2 >= this.infoMesg.getNumActivityType()) break;
                if (this.infoMesg.getActivityType(n2) == monitoringMesg2.getActivityType()) {
                    n = n2;
                }
                ++n2;
            }
        }
        activityType = monitoringMesg.getActivityType();
        object2 = object;
        if (activityType != null) {
            object2 = this.lastMesgs.get((Object)activityType);
        }
        object = object2;
        if (object2 == null) {
            object = new MonitoringMesg();
        }
        if (monitoringMesg.getDuration() != null) {
            monitoringMesg2.setDuration(monitoringMesg.getDuration());
        } else if (monitoringMesg.getDurationMin() != null) {
            monitoringMesg2.setDuration((long)monitoringMesg.getDurationMin().intValue() * 60L);
        }
        if (monitoringMesg.getActiveTime() != null) {
            monitoringMesg2.setActiveTime(monitoringMesg.getActiveTime());
        } else if (monitoringMesg.getActiveTime16() != null) {
            l = ((MonitoringMesg)object).getActiveTime() != null ? (long)((double)((MonitoringMesg)object).getActiveTime().floatValue() + 0.5) : 0L;
            monitoringMesg2.setActiveTime(Float.valueOf(l + ((long)monitoringMesg.getActiveTime16().intValue() - (l & 0xFFFFL) & 0xFFFFL)));
        } else if (monitoringMesg.getCurrentActivityTypeIntensity() != null) {
            l = ((MonitoringMesg)object).getActiveTime() != null ? (long)((double)((MonitoringMesg)object).getActiveTime().floatValue() + 0.5) : 0L;
            monitoringMesg2.setActiveTime(Float.valueOf(l + (dateTime.getTimestamp() - this.lastTimestamp)));
        }
        if (monitoringMesg.getCycles() != null) {
            monitoringMesg2.setCycles(monitoringMesg.getCycles());
        } else if (monitoringMesg.getCycles16() != null) {
            l = ((MonitoringMesg)object).getCycles() != null ? (long)(((MonitoringMesg)object).getCycles().floatValue() * 2.0f) : 0L;
            monitoringMesg2.setCycles(Float.valueOf((float)(l + ((long)monitoringMesg.getCycles16().intValue() - (l & 0xFFFFL) & 0xFFFFL)) / 2.0f));
        }
        if (monitoringMesg.getDistance() != null) {
            monitoringMesg2.setDistance(monitoringMesg.getDistance());
        } else if (monitoringMesg.getDistance16() != null) {
            l = ((MonitoringMesg)object).getDistance() != null ? (long)(((MonitoringMesg)object).getDistance().floatValue() * 100.0f) : 0L;
            monitoringMesg2.setDistance(Float.valueOf((float)(l + ((long)monitoringMesg.getDistance16().intValue() - (l & 0xFFFFL) & 0xFFFFL)) / 100.0f));
        }
        if (monitoringMesg.getActiveCalories() != null) {
            monitoringMesg2.setActiveCalories(monitoringMesg.getActiveCalories());
        }
        if (monitoringMesg.getCalories() != null) {
            monitoringMesg2.setCalories(monitoringMesg.getCalories());
        }
        if (monitoringMesg.getIntensity() != null) {
            monitoringMesg2.setIntensity(monitoringMesg.getIntensity());
        }
        if (monitoringMesg.getHeartRate() != null) {
            monitoringMesg2.setHeartRate(monitoringMesg.getHeartRate());
        }
        if (monitoringMesg.getTemperature() != null) {
            monitoringMesg2.setTemperature(monitoringMesg.getTemperature());
        }
        if (monitoringMesg.getAscent() != null) {
            monitoringMesg2.setAscent(monitoringMesg.getAscent());
        }
        if (monitoringMesg.getDescent() != null) {
            monitoringMesg2.setDescent(monitoringMesg.getDescent());
        }
        if (monitoringMesg.getModerateActivityMinutes() != null) {
            monitoringMesg2.setModerateActivityMinutes(monitoringMesg.getModerateActivityMinutes());
        }
        if (monitoringMesg.getVigorousActivityMinutes() != null) {
            monitoringMesg2.setVigorousActivityMinutes(monitoringMesg.getVigorousActivityMinutes());
        }
        if (monitoringMesg2.getDistance() != null) {
            extractState.cyclesToDistanceStartDist = monitoringMesg2.getDistance().floatValue();
            extractState.cyclesToDistanceStartCycles = monitoringMesg2.getCycles().floatValue();
        } else if (n3 < this.infoMesg.getNumCyclesToDistance() && monitoringMesg2.getCycles() != null) {
            monitoringMesg2.setDistance(Float.valueOf(extractState.cyclesToDistanceStartDist + (monitoringMesg2.getCycles().floatValue() - extractState.cyclesToDistanceStartCycles) * this.infoMesg.getCyclesToDistance(n3).floatValue()));
        }
        if (monitoringMesg2.getActiveCalories() != null) {
            extractState.cyclesToCaloriesStartCal = monitoringMesg2.getActiveCalories();
            extractState.cyclesToCaloriesStartCycles = monitoringMesg2.getCycles().floatValue();
        } else if (n3 < this.infoMesg.getNumCyclesToCalories() && monitoringMesg2.getCycles() != null) {
            monitoringMesg2.setActiveCalories((int)((float)extractState.cyclesToCaloriesStartCal + (monitoringMesg2.getCycles().floatValue() - extractState.cyclesToCaloriesStartCycles) * this.infoMesg.getCyclesToCalories(n3).floatValue()));
        }
        return monitoringMesg2;
    }

    private long modTimestampToLocalInterval(long l) {
        long l2 = this.localTimeOffset;
        return (l += l2) - l % (long)this.interval - l2;
    }

    private void setFieldsFromMesg(MonitoringMesg monitoringMesg, MonitoringMesg object) {
        object = ((MonitoringMesg)object).fields.iterator();
        while (object.hasNext()) {
            monitoringMesg.setField(new Field((Field)object.next()));
        }
    }

    public void addListener(MonitoringMesgListener monitoringMesgListener) {
        this.listeners.add(monitoringMesgListener);
    }

    public void broadcast() {
        while (this.broadcastInterval(false)) {
        }
    }

    public void excludeAllFields() {
        for (Map.Entry<String, Boolean> entry : this.includedFields.entrySet()) {
            this.includedFields.put(entry.getKey(), false);
        }
    }

    public HashMap<String, Boolean> getFieldStates() {
        return new HashMap<String, Boolean>(this.includedFields);
    }

    public void includeAllFields() {
        for (Map.Entry<String, Boolean> entry : this.includedFields.entrySet()) {
            this.includedFields.put(entry.getKey(), true);
        }
    }

    @Override
    public void onMesg(DeviceSettingsMesg deviceSettingsMesg) {
        if (deviceSettingsMesg.getUtcOffset() != null) {
            short s = 0;
            long l = deviceSettingsMesg.getUtcOffset();
            this.setSystemToUtcTimestampOffset(l);
            if (deviceSettingsMesg.getActiveTimeZone() != null) {
                s = deviceSettingsMesg.getActiveTimeZone();
            }
            long l2 = l;
            if (deviceSettingsMesg.getTimeZoneOffset(s) != null) {
                l2 = (long)((double)l + (double)deviceSettingsMesg.getTimeZoneOffset(s).floatValue() * 3600.0);
            }
            this.setSystemToLocalTimestampOffset(l2);
        }
    }

    @Override
    public void onMesg(MonitoringInfoMesg object) {
        this.infoMesg = object;
        object = ((MonitoringInfoMesg)object).getTimestamp();
        this.mesgTimestamp = ((DateTime)object).getTimestamp();
        ((DateTime)object).convertSystemTimeToUTC(this.systemToUtcTimestampOffset);
        this.infoMesg.setTimestamp((DateTime)object);
        this.lastTimestamp = ((DateTime)object).getTimestamp();
        if (this.infoMesg.getLocalTimestamp() != null) {
            object = new LocalDateTime(this.infoMesg.getLocalTimestamp());
            ((LocalDateTime)object).convertSystemTimeToLocal(this.systemToLocalTimestampOffset);
            this.localTimeOffset = ((LocalDateTime)object).getTimestamp() - this.lastTimestamp;
        } else {
            this.localTimeOffset = this.systemToLocalTimestampOffset - this.systemToUtcTimestampOffset;
        }
        this.startTimestamp = this.lastTimestamp;
    }

    @Override
    public void onMesg(MonitoringMesg stringArray) {
        Object object;
        Object object2;
        if (this.infoMesg == null) {
            return;
        }
        MonitoringMesg monitoringMesg = this.extract((MonitoringMesg)stringArray);
        if (monitoringMesg.getActivityType() == null) {
            monitoringMesg.setActivityType(ActivityType.ALL);
        }
        if (monitoringMesg.getTimestamp() == null) {
            return;
        }
        if (this.lastTimestamp != monitoringMesg.getTimestamp().getTimestamp() && this.lastTimestamp - this.modTimestampToLocalInterval(this.startTimestamp) >= (long)this.interval) {
            this.broadcastCompleteIntervals();
        }
        if (stringArray.getCurrentActivityTypeIntensity() != null) {
            if (this.lastMesgs.get((Object)monitoringMesg.getActivityType()) == null) {
                stringArray = new ArrayList();
                object2 = new MonitoringMesg();
                ((MonitoringMesg)object2).setActivityType(monitoringMesg.getActivityType());
                ((MonitoringMesg)object2).setTimestamp(new DateTime(monitoringMesg.getTimestamp().getTimestamp() - monitoringMesg.getActiveTime().longValue()));
                stringArray.add(object2);
                this.intervalMesgs.put(((MonitoringMesg)object2).getActivityType(), (ArrayList<MonitoringMesg>)stringArray);
            }
            for (MonitoringMesg monitoringMesg2 : this.lastMesgs.values()) {
                if (monitoringMesg2.getActivityType() == monitoringMesg.getActivityType()) continue;
                object = new MonitoringMesg();
                ((MonitoringMesg)object).setTimestamp(monitoringMesg.getTimestamp());
                ((MonitoringMesg)object).setActivityType(monitoringMesg2.getActivityType());
                for (String string2 : this.accumulatedFieldNames) {
                    if (monitoringMesg2.getField(string2) == null) continue;
                    ((Mesg)object).setField(monitoringMesg2.getField(string2));
                }
                this.intervalMesgs.get((Object)((MonitoringMesg)object).getActivityType()).add((MonitoringMesg)object);
            }
        }
        this.lastTimestamp = monitoringMesg.getTimestamp().getTimestamp();
        object2 = this.lastMesgs.get((Object)monitoringMesg.getActivityType());
        stringArray = object2;
        if (object2 == null) {
            stringArray = new MonitoringMesg();
            this.lastMesgs.put(monitoringMesg.getActivityType(), (MonitoringMesg)stringArray);
        }
        this.setFieldsFromMesg((MonitoringMesg)stringArray, monitoringMesg);
        object = this.intervalMesgs.get((Object)monitoringMesg.getActivityType());
        object2 = null;
        stringArray = object;
        if (object == null) {
            stringArray = new ArrayList();
            this.intervalMesgs.put(monitoringMesg.getActivityType(), (ArrayList<MonitoringMesg>)stringArray);
        }
        if (stringArray.size() > 0) {
            object2 = (MonitoringMesg)stringArray.get(stringArray.size() - 1);
        }
        if (object2 != null && monitoringMesg.getTimestamp().equals(((MonitoringMesg)object2).getTimestamp())) {
            this.setFieldsFromMesg((MonitoringMesg)object2, monitoringMesg);
        } else {
            stringArray.add(monitoringMesg);
        }
    }

    public void outputDailyTotals() {
        if (this.interval == 86400) {
            this.outputDailyTotals = true;
            return;
        }
        throw new FitRuntimeException("Interval must be 86400s to output daily totals");
    }

    public void setFieldIncluded(String string2, boolean bl) {
        this.includedFields.put(string2, bl);
    }

    public void setSystemToLocalTimestampOffset(long l) {
        this.systemToLocalTimestampOffset = l;
    }

    public void setSystemToUtcTimestampOffset(long l) {
        this.systemToUtcTimestampOffset = l;
    }

    private class AccumField
    extends Field
    implements ReaderField {
        private Double endValue;
        private long endValueTimestamp;
        private Double startValue;
        private long startValueTimestamp;

        public AccumField(Field field) {
            long l;
            super(field);
            this.startValue = new Double(0.0);
            this.startValueTimestamp = l = MonitoringReader.this.startTimestamp + MonitoringReader.this.localTimeOffset;
            l -= l % 86400L;
            this.startValueTimestamp = l;
            this.startValueTimestamp = l - MonitoringReader.this.localTimeOffset;
            this.endValue = null;
            this.endValueTimestamp = 0L;
        }

        @Override
        public double getVal() {
            return -1.0;
        }

        @Override
        public void onMesg(MonitoringMesg object) {
            Object object2 = ((Mesg)object).getField(this.num);
            long l = ((MonitoringMesg)object).getTimestamp().getTimestamp();
            if (!((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                return;
            }
            object = object2 != null ? ((FieldBase)object2).getDoubleValue() : null;
            if (l <= MonitoringReader.this.startTimestamp) {
                if (object != null) {
                    this.startValue = object;
                }
                this.startValueTimestamp = l;
            } else {
                double d;
                double d2;
                double d3;
                long l2;
                long l3 = l2 = 0L;
                if (MonitoringReader.this.lastAccumMesg != null) {
                    l3 = l2;
                    if (MonitoringReader.this.lastAccumMesg.getTimestamp() != null) {
                        l3 = MonitoringReader.this.lastAccumMesg.getTimestamp().getTimestamp();
                    }
                }
                if (this.startValueTimestamp < MonitoringReader.this.startTimestamp && (MonitoringReader.this.startTimestamp >= l3 || MonitoringReader.this.lastSummedInstMesg == null || MonitoringReader.this.lastSummedInstMesg.getTimestamp().getTimestamp() < this.startValueTimestamp)) {
                    if (object != null) {
                        l3 = this.startValueTimestamp;
                        if (l3 == l) {
                            this.startValueTimestamp = l3 - (MonitoringReader.this.startTimestamp - this.startValueTimestamp);
                        }
                        d3 = this.startValue;
                        d2 = (Double)object;
                        d = this.startValue;
                        l3 = MonitoringReader.this.startTimestamp;
                        l2 = this.startValueTimestamp;
                        this.startValue = d3 + (d2 - d) * (double)(l3 - l2) / (double)(l - l2);
                    }
                    this.startValueTimestamp = MonitoringReader.this.startTimestamp;
                }
                object2 = object;
                if (l > MonitoringReader.this.endTimestamp) {
                    object2 = object;
                    if (object != null) {
                        if (this.endValue == null) {
                            this.endValue = this.startValue;
                            this.endValueTimestamp = this.startValueTimestamp;
                        }
                        if ((l3 = this.endValueTimestamp) == l) {
                            this.endValueTimestamp = l3 - (l - MonitoringReader.this.endTimestamp);
                        }
                        d = this.endValue;
                        d3 = (Double)object;
                        d2 = this.endValue;
                        l3 = MonitoringReader.this.endTimestamp;
                        l2 = this.endValueTimestamp;
                        object2 = d + (d3 - d2) * (double)(l3 - l2) / (double)(l - l2);
                    }
                }
                this.endValueTimestamp = l;
                if (object2 != null) {
                    this.endValue = object2;
                }
            }
        }

        @Override
        public boolean setMesg(MonitoringMesg monitoringMesg) {
            double d;
            Double d2 = this.endValue;
            boolean bl = false;
            if (d2 == null) {
                return false;
            }
            double d3 = d = d2 - this.startValue;
            if (d < 0.0) {
                d3 = 0.0;
            }
            monitoringMesg.setFieldValue(this.num, 0, (Object)d3);
            if (d3 != 0.0) {
                bl = true;
            }
            return bl;
        }
    }

    private class ExtractState {
        public int cyclesToCaloriesStartCal = 0;
        public float cyclesToCaloriesStartCycles = 0.0f;
        public float cyclesToDistanceStartCycles = 0.0f;
        public float cyclesToDistanceStartDist = 0.0f;

        private ExtractState() {
        }
    }

    private class InstField
    extends Field
    implements ReaderField {
        private double sum;
        private double sumDuration;
        private long sumEndTimestamp;

        public InstField(Field field) {
            super(field);
            this.sum = 0.0;
            this.sumDuration = 0.0;
            this.sumEndTimestamp = MonitoringReader.this.startTimestamp;
        }

        @Override
        public double getVal() {
            return this.sum / this.sumDuration;
        }

        @Override
        public void onMesg(MonitoringMesg object) {
            Field field = ((Mesg)object).getField(this.num);
            if (!MonitoringReader.this.outputDailyTotals && ((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                long l;
                long l2 = l = ((MonitoringMesg)object).getTimestamp().getTimestamp().longValue();
                if (l > MonitoringReader.this.endTimestamp) {
                    l2 = MonitoringReader.this.endTimestamp;
                }
                if ((l = this.sumEndTimestamp) >= l2) {
                    return;
                }
                double d = l2 - l;
                this.sumEndTimestamp = l2;
                if (field == null) {
                    return;
                }
                object = field.getDoubleValue();
                if (object == null) {
                    return;
                }
                this.sumDuration += d;
                this.sum += (Double)object * d;
            }
        }

        @Override
        public boolean setMesg(MonitoringMesg monitoringMesg) {
            if (this.sumDuration == 0.0) {
                return false;
            }
            monitoringMesg.setFieldValue(this.num, 0, (Object)(this.sum / this.sumDuration));
            return true;
        }
    }

    private static interface ReaderField
    extends MonitoringMesgListener {
        public String getName();

        public double getVal();

        public boolean setMesg(MonitoringMesg var1);
    }

    private class SummedInstField
    extends Field
    implements ReaderField {
        private double sum;

        public SummedInstField(Field field) {
            super(field);
            this.sum = 0.0;
        }

        @Override
        public double getVal() {
            return this.sum;
        }

        @Override
        public void onMesg(MonitoringMesg object) {
            Field field = ((Mesg)object).getField(this.num);
            if (!((Boolean)MonitoringReader.this.includedFields.get(this.name)).booleanValue()) {
                return;
            }
            if (((MonitoringMesg)object).getTimestamp().getTimestamp() > MonitoringReader.this.endTimestamp) {
                MonitoringReader.this.endTimestamp;
            }
            if (field == null) {
                return;
            }
            object = field.getDoubleValue();
            if (object == null) {
                return;
            }
            this.sum += ((Double)object).doubleValue();
        }

        @Override
        public boolean setMesg(MonitoringMesg monitoringMesg) {
            if (this.sum == 0.0) {
                return false;
            }
            monitoringMesg.setFieldValue(this.num, 0, (Object)this.sum);
            return true;
        }
    }
}

