/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class SegmentPointMesg
extends Mesg {
    public static final int AltitudeFieldNum = 4;
    public static final int DistanceFieldNum = 3;
    public static final int LeaderTimeFieldNum = 5;
    public static final int MessageIndexFieldNum = 254;
    public static final int PositionLatFieldNum = 1;
    public static final int PositionLongFieldNum = 2;
    protected static final Mesg segmentPointMesg;

    static {
        Mesg mesg;
        segmentPointMesg = mesg = new Mesg("segment_point", 150);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("position_lat", 1, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("position_long", 2, 133, 1.0, 0.0, "semicircles", false, Profile.Type.SINT32));
        mesg.addField(new Field("distance", 3, 134, 100.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("altitude", 4, 132, 5.0, 500.0, "m", false, Profile.Type.UINT16));
        mesg.addField(new Field("leader_time", 5, 134, 1000.0, 0.0, "s", false, Profile.Type.UINT32));
    }

    public SegmentPointMesg() {
        super(Factory.createMesg(150));
    }

    public SegmentPointMesg(Mesg mesg) {
        super(mesg);
    }

    public Float getAltitude() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public Float getDistance() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public Float getLeaderTime(int n) {
        return this.getFieldFloatValue(5, n, 65535);
    }

    public Float[] getLeaderTime() {
        return this.getFieldFloatValues(5, 65535);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public int getNumLeaderTime() {
        return this.getNumFieldValues(5, 65535);
    }

    public Integer getPositionLat() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public Integer getPositionLong() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public void setAltitude(Float f) {
        this.setFieldValue(4, 0, (Object)f, 65535);
    }

    public void setDistance(Float f) {
        this.setFieldValue(3, 0, (Object)f, 65535);
    }

    public void setLeaderTime(int n, Float f) {
        this.setFieldValue(5, n, (Object)f, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setPositionLat(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public void setPositionLong(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }
}

