/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SensorType;
import com.garmin.fit.SubField;

public class ThreeDSensorCalibrationMesg
extends Mesg {
    public static final int CalibrationDivisorFieldNum = 2;
    public static final int CalibrationFactorFieldNum = 1;
    public static final int LevelShiftFieldNum = 3;
    public static final int OffsetCalFieldNum = 4;
    public static final int OrientationMatrixFieldNum = 5;
    public static final int SensorTypeFieldNum = 0;
    public static final int TimestampFieldNum = 253;
    protected static final Mesg threeDSensorCalibrationMesg;

    static {
        Mesg mesg;
        threeDSensorCalibrationMesg = mesg = new Mesg("three_d_sensor_calibration", 167);
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("sensor_type", 0, 0, 1.0, 0.0, "", false, Profile.Type.SENSOR_TYPE));
        mesg.addField(new Field("calibration_factor", 1, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)2).subFields.add(new SubField("accel_cal_factor", 134, 1.0, 0.0, "g"));
        mesg.fields.get((int)2).subFields.get(0).addMap(0, 0L);
        mesg.fields.get((int)2).subFields.add(new SubField("gyro_cal_factor", 134, 1.0, 0.0, "deg/s"));
        mesg.fields.get((int)2).subFields.get(1).addMap(0, 1L);
        mesg.addField(new Field("calibration_divisor", 2, 134, 1.0, 0.0, "counts", false, Profile.Type.UINT32));
        mesg.addField(new Field("level_shift", 3, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.addField(new Field("offset_cal", 4, 133, 1.0, 0.0, "", false, Profile.Type.SINT32));
        mesg.addField(new Field("orientation_matrix", 5, 133, 65535.0, 0.0, "", false, Profile.Type.SINT32));
    }

    public ThreeDSensorCalibrationMesg() {
        super(Factory.createMesg(167));
    }

    public ThreeDSensorCalibrationMesg(Mesg mesg) {
        super(mesg);
    }

    public Long getAccelCalFactor() {
        return this.getFieldLongValue(1, 0, 0);
    }

    public Long getCalibrationDivisor() {
        return this.getFieldLongValue(2, 0, 65535);
    }

    public Long getCalibrationFactor() {
        return this.getFieldLongValue(1, 0, 65535);
    }

    public Long getGyroCalFactor() {
        return this.getFieldLongValue(1, 0, 1);
    }

    public Long getLevelShift() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public int getNumOffsetCal() {
        return this.getNumFieldValues(4, 65535);
    }

    public int getNumOrientationMatrix() {
        return this.getNumFieldValues(5, 65535);
    }

    public Integer getOffsetCal(int n) {
        return this.getFieldIntegerValue(4, n, 65535);
    }

    public Integer[] getOffsetCal() {
        return this.getFieldIntegerValues(4, 65535);
    }

    public Float getOrientationMatrix(int n) {
        return this.getFieldFloatValue(5, n, 65535);
    }

    public Float[] getOrientationMatrix() {
        return this.getFieldFloatValues(5, 65535);
    }

    public SensorType getSensorType() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return SensorType.getByValue(s);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setAccelCalFactor(Long l) {
        this.setFieldValue(1, 0, (Object)l, 0);
    }

    public void setCalibrationDivisor(Long l) {
        this.setFieldValue(2, 0, (Object)l, 65535);
    }

    public void setCalibrationFactor(Long l) {
        this.setFieldValue(1, 0, (Object)l, 65535);
    }

    public void setGyroCalFactor(Long l) {
        this.setFieldValue(1, 0, (Object)l, 1);
    }

    public void setLevelShift(Long l) {
        this.setFieldValue(3, 0, (Object)l, 65535);
    }

    public void setOffsetCal(int n, Integer n2) {
        this.setFieldValue(4, n, (Object)n2, 65535);
    }

    public void setOrientationMatrix(int n, Float f) {
        this.setFieldValue(5, n, (Object)f, 65535);
    }

    public void setSensorType(SensorType sensorType) {
        this.setFieldValue(0, 0, (Object)sensorType.value, 65535);
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }
}

