/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.Sport;

public class TotalsMesg
extends Mesg {
    public static final int ActiveTimeFieldNum = 6;
    public static final int CaloriesFieldNum = 2;
    public static final int DistanceFieldNum = 1;
    public static final int ElapsedTimeFieldNum = 4;
    public static final int MessageIndexFieldNum = 254;
    public static final int SessionsFieldNum = 5;
    public static final int SportFieldNum = 3;
    public static final int SportIndexFieldNum = 9;
    public static final int TimerTimeFieldNum = 0;
    public static final int TimestampFieldNum = 253;
    protected static final Mesg totalsMesg;

    static {
        Mesg mesg;
        totalsMesg = mesg = new Mesg("totals", 33);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("timer_time", 0, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("distance", 1, 134, 1.0, 0.0, "m", false, Profile.Type.UINT32));
        mesg.addField(new Field("calories", 2, 134, 1.0, 0.0, "kcal", false, Profile.Type.UINT32));
        mesg.addField(new Field("sport", 3, 0, 1.0, 0.0, "", false, Profile.Type.SPORT));
        mesg.addField(new Field("elapsed_time", 4, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("sessions", 5, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("active_time", 6, 134, 1.0, 0.0, "s", false, Profile.Type.UINT32));
        mesg.addField(new Field("sport_index", 9, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
    }

    public TotalsMesg() {
        super(Factory.createMesg(33));
    }

    public TotalsMesg(Mesg mesg) {
        super(mesg);
    }

    public Long getActiveTime() {
        return this.getFieldLongValue(6, 0, 65535);
    }

    public Long getCalories() {
        return this.getFieldLongValue(2, 0, 65535);
    }

    public Long getDistance() {
        return this.getFieldLongValue(1, 0, 65535);
    }

    public Long getElapsedTime() {
        return this.getFieldLongValue(4, 0, 65535);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public Integer getSessions() {
        return this.getFieldIntegerValue(5, 0, 65535);
    }

    public Sport getSport() {
        Short s = this.getFieldShortValue(3, 0, 65535);
        if (s == null) {
            return null;
        }
        return Sport.getByValue(s);
    }

    public Short getSportIndex() {
        return this.getFieldShortValue(9, 0, 65535);
    }

    public Long getTimerTime() {
        return this.getFieldLongValue(0, 0, 65535);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public void setActiveTime(Long l) {
        this.setFieldValue(6, 0, (Object)l, 65535);
    }

    public void setCalories(Long l) {
        this.setFieldValue(2, 0, (Object)l, 65535);
    }

    public void setDistance(Long l) {
        this.setFieldValue(1, 0, (Object)l, 65535);
    }

    public void setElapsedTime(Long l) {
        this.setFieldValue(4, 0, (Object)l, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setSessions(Integer n) {
        this.setFieldValue(5, 0, (Object)n, 65535);
    }

    public void setSport(Sport sport) {
        this.setFieldValue(3, 0, (Object)sport.value, 65535);
    }

    public void setSportIndex(Short s) {
        this.setFieldValue(9, 0, (Object)s, 65535);
    }

    public void setTimerTime(Long l) {
        this.setFieldValue(0, 0, (Object)l, 65535);
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }
}

