/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.File;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;

public class TrainingFileMesg
extends Mesg {
    public static final int ManufacturerFieldNum = 1;
    public static final int ProductFieldNum = 2;
    public static final int SerialNumberFieldNum = 3;
    public static final int TimeCreatedFieldNum = 4;
    public static final int TimestampFieldNum = 253;
    public static final int TypeFieldNum = 0;
    protected static final Mesg trainingFileMesg;

    static {
        Mesg mesg;
        trainingFileMesg = mesg = new Mesg("training_file", 72);
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("type", 0, 0, 1.0, 0.0, "", false, Profile.Type.FILE));
        mesg.addField(new Field("manufacturer", 1, 132, 1.0, 0.0, "", false, Profile.Type.MANUFACTURER));
        mesg.addField(new Field("product", 2, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.fields.get((int)3).subFields.add(new SubField("favero_product", 132, 1.0, 0.0, ""));
        mesg.fields.get((int)3).subFields.get(0).addMap(1, 263L);
        mesg.fields.get((int)3).subFields.add(new SubField("garmin_product", 132, 1.0, 0.0, ""));
        mesg.fields.get((int)3).subFields.get(1).addMap(1, 1L);
        mesg.fields.get((int)3).subFields.get(1).addMap(1, 15L);
        mesg.fields.get((int)3).subFields.get(1).addMap(1, 13L);
        mesg.addField(new Field("serial_number", 3, 140, 1.0, 0.0, "", false, Profile.Type.UINT32Z));
        mesg.addField(new Field("time_created", 4, 134, 1.0, 0.0, "", false, Profile.Type.DATE_TIME));
    }

    public TrainingFileMesg() {
        super(Factory.createMesg(72));
    }

    public TrainingFileMesg(Mesg mesg) {
        super(mesg);
    }

    public Integer getFaveroProduct() {
        return this.getFieldIntegerValue(2, 0, 0);
    }

    public Integer getGarminProduct() {
        return this.getFieldIntegerValue(2, 0, 1);
    }

    public Integer getManufacturer() {
        return this.getFieldIntegerValue(1, 0, 65535);
    }

    public Integer getProduct() {
        return this.getFieldIntegerValue(2, 0, 65535);
    }

    public Long getSerialNumber() {
        return this.getFieldLongValue(3, 0, 65535);
    }

    public DateTime getTimeCreated() {
        return this.timestampToDateTime(this.getFieldLongValue(4, 0, 65535));
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public File getType() {
        Short s = this.getFieldShortValue(0, 0, 65535);
        if (s == null) {
            return null;
        }
        return File.getByValue(s);
    }

    public void setFaveroProduct(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 0);
    }

    public void setGarminProduct(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 1);
    }

    public void setManufacturer(Integer n) {
        this.setFieldValue(1, 0, (Object)n, 65535);
    }

    public void setProduct(Integer n) {
        this.setFieldValue(2, 0, (Object)n, 65535);
    }

    public void setSerialNumber(Long l) {
        this.setFieldValue(3, 0, (Object)l, 65535);
    }

    public void setTimeCreated(DateTime dateTime) {
        this.setFieldValue(4, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setType(File file) {
        this.setFieldValue(0, 0, (Object)file.value, 65535);
    }
}

