/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DateTime;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;

public class WeightScaleMesg
extends Mesg {
    public static final int ActiveMetFieldNum = 9;
    public static final int BasalMetFieldNum = 7;
    public static final int BoneMassFieldNum = 4;
    public static final int MetabolicAgeFieldNum = 10;
    public static final int MuscleMassFieldNum = 5;
    public static final int PercentFatFieldNum = 1;
    public static final int PercentHydrationFieldNum = 2;
    public static final int PhysiqueRatingFieldNum = 8;
    public static final int TimestampFieldNum = 253;
    public static final int UserProfileIndexFieldNum = 12;
    public static final int VisceralFatMassFieldNum = 3;
    public static final int VisceralFatRatingFieldNum = 11;
    public static final int WeightFieldNum = 0;
    protected static final Mesg weightScaleMesg;

    static {
        Mesg mesg;
        weightScaleMesg = mesg = new Mesg("weight_scale", 30);
        mesg.addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s", false, Profile.Type.DATE_TIME));
        mesg.addField(new Field("weight", 0, 132, 100.0, 0.0, "kg", false, Profile.Type.WEIGHT));
        mesg.addField(new Field("percent_fat", 1, 132, 100.0, 0.0, "%", false, Profile.Type.UINT16));
        mesg.addField(new Field("percent_hydration", 2, 132, 100.0, 0.0, "%", false, Profile.Type.UINT16));
        mesg.addField(new Field("visceral_fat_mass", 3, 132, 100.0, 0.0, "kg", false, Profile.Type.UINT16));
        mesg.addField(new Field("bone_mass", 4, 132, 100.0, 0.0, "kg", false, Profile.Type.UINT16));
        mesg.addField(new Field("muscle_mass", 5, 132, 100.0, 0.0, "kg", false, Profile.Type.UINT16));
        mesg.addField(new Field("basal_met", 7, 132, 4.0, 0.0, "kcal/day", false, Profile.Type.UINT16));
        mesg.addField(new Field("physique_rating", 8, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("active_met", 9, 132, 4.0, 0.0, "kcal/day", false, Profile.Type.UINT16));
        mesg.addField(new Field("metabolic_age", 10, 2, 1.0, 0.0, "years", false, Profile.Type.UINT8));
        mesg.addField(new Field("visceral_fat_rating", 11, 2, 1.0, 0.0, "", false, Profile.Type.UINT8));
        mesg.addField(new Field("user_profile_index", 12, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
    }

    public WeightScaleMesg() {
        super(Factory.createMesg(30));
    }

    public WeightScaleMesg(Mesg mesg) {
        super(mesg);
    }

    public Float getActiveMet() {
        return this.getFieldFloatValue(9, 0, 65535);
    }

    public Float getBasalMet() {
        return this.getFieldFloatValue(7, 0, 65535);
    }

    public Float getBoneMass() {
        return this.getFieldFloatValue(4, 0, 65535);
    }

    public Short getMetabolicAge() {
        return this.getFieldShortValue(10, 0, 65535);
    }

    public Float getMuscleMass() {
        return this.getFieldFloatValue(5, 0, 65535);
    }

    public Float getPercentFat() {
        return this.getFieldFloatValue(1, 0, 65535);
    }

    public Float getPercentHydration() {
        return this.getFieldFloatValue(2, 0, 65535);
    }

    public Short getPhysiqueRating() {
        return this.getFieldShortValue(8, 0, 65535);
    }

    public DateTime getTimestamp() {
        return this.timestampToDateTime(this.getFieldLongValue(253, 0, 65535));
    }

    public Integer getUserProfileIndex() {
        return this.getFieldIntegerValue(12, 0, 65535);
    }

    public Float getVisceralFatMass() {
        return this.getFieldFloatValue(3, 0, 65535);
    }

    public Short getVisceralFatRating() {
        return this.getFieldShortValue(11, 0, 65535);
    }

    public Float getWeight() {
        return this.getFieldFloatValue(0, 0, 65535);
    }

    public void setActiveMet(Float f) {
        this.setFieldValue(9, 0, (Object)f, 65535);
    }

    public void setBasalMet(Float f) {
        this.setFieldValue(7, 0, (Object)f, 65535);
    }

    public void setBoneMass(Float f) {
        this.setFieldValue(4, 0, (Object)f, 65535);
    }

    public void setMetabolicAge(Short s) {
        this.setFieldValue(10, 0, (Object)s, 65535);
    }

    public void setMuscleMass(Float f) {
        this.setFieldValue(5, 0, (Object)f, 65535);
    }

    public void setPercentFat(Float f) {
        this.setFieldValue(1, 0, (Object)f, 65535);
    }

    public void setPercentHydration(Float f) {
        this.setFieldValue(2, 0, (Object)f, 65535);
    }

    public void setPhysiqueRating(Short s) {
        this.setFieldValue(8, 0, (Object)s, 65535);
    }

    public void setTimestamp(DateTime dateTime) {
        this.setFieldValue(253, 0, (Object)dateTime.getTimestamp(), 65535);
    }

    public void setUserProfileIndex(Integer n) {
        this.setFieldValue(12, 0, (Object)n, 65535);
    }

    public void setVisceralFatMass(Float f) {
        this.setFieldValue(3, 0, (Object)f, 65535);
    }

    public void setVisceralFatRating(Short s) {
        this.setFieldValue(11, 0, (Object)s, 65535);
    }

    public void setWeight(Float f) {
        this.setFieldValue(0, 0, (Object)f, 65535);
    }
}

