/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.DisplayMeasure;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.Sport;
import com.garmin.fit.SubSport;

public class WorkoutMesg
extends Mesg {
    public static final int CapabilitiesFieldNum = 5;
    public static final int MesgID = 6656;
    public static final int NumValidStepsFieldNum = 6;
    public static final int PoolLengthFieldNum = 14;
    public static final int PoolLengthUnitFieldNum = 15;
    public static final int SportFieldNum = 4;
    public static final int SubSportFieldNum = 11;
    public static final int WktNameFieldNum = 8;
    protected static final Mesg workoutMesg;

    static {
        Mesg mesg;
        workoutMesg = mesg = new Mesg("workout", 6656);
        mesg.addField(new Field("sport", 4, 0, 1.0, 0.0, "", false, Profile.Type.SPORT));
        mesg.addField(new Field("capabilities", 5, 140, 1.0, 0.0, "", false, Profile.Type.WORKOUT_CAPABILITIES));
        mesg.addField(new Field("num_valid_steps", 6, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("wkt_name", 8, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        mesg.addField(new Field("sub_sport", 11, 0, 1.0, 0.0, "", false, Profile.Type.SUB_SPORT));
        mesg.addField(new Field("pool_length", 14, 132, 100.0, 0.0, "m", false, Profile.Type.UINT16));
        mesg.addField(new Field("pool_length_unit", 15, 0, 1.0, 0.0, "", false, Profile.Type.DISPLAY_MEASURE));
    }

    public WorkoutMesg() {
        super(Factory.createMesg(6656));
    }

    public WorkoutMesg(Mesg mesg) {
        super(mesg);
    }

    public Long getCapabilities() {
        return this.getFieldLongValue(5, 0, 65535);
    }

    public Integer getNumValidSteps() {
        return this.getFieldIntegerValue(6, 0, 65535);
    }

    public Float getPoolLength() {
        return this.getFieldFloatValue(14, 0, 65535);
    }

    public DisplayMeasure getPoolLengthUnit() {
        Short s = this.getFieldShortValue(15, 0, 65535);
        if (s == null) {
            return null;
        }
        return DisplayMeasure.getByValue(s);
    }

    public Sport getSport() {
        Short s = this.getFieldShortValue(4, 0, 65535);
        if (s == null) {
            return null;
        }
        return Sport.getByValue(s);
    }

    public SubSport getSubSport() {
        Short s = this.getFieldShortValue(11, 0, 65535);
        if (s == null) {
            return null;
        }
        return SubSport.getByValue(s);
    }

    public String getWktName() {
        return this.getFieldStringValue(8, 0, 65535);
    }

    public void setCapabilities(Long l) {
        this.setFieldValue(5, 0, (Object)l, 65535);
    }

    public void setNumValidSteps(Integer n) {
        this.setFieldValue(6, 0, (Object)n, 65535);
    }

    public void setPoolLength(Float f) {
        this.setFieldValue(14, 0, (Object)f, 65535);
    }

    public void setPoolLengthUnit(DisplayMeasure displayMeasure) {
        this.setFieldValue(15, 0, (Object)displayMeasure.value, 65535);
    }

    public void setSport(Sport sport) {
        this.setFieldValue(4, 0, (Object)sport.value, 65535);
    }

    public void setSubSport(SubSport subSport) {
        this.setFieldValue(11, 0, (Object)subSport.value, 65535);
    }

    public void setWktName(String string2) {
        this.setFieldValue(8, 0, (Object)string2, 65535);
    }
}

