/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.Intensity;
import com.garmin.fit.Mesg;
import com.garmin.fit.Profile;
import com.garmin.fit.SubField;
import com.garmin.fit.SwimStroke;
import com.garmin.fit.WktStepDuration;
import com.garmin.fit.WktStepTarget;
import com.garmin.fit.WorkoutEquipment;

public class WorkoutStepMesg
extends Mesg {
    public static final int CustomTargetValueHighFieldNum = 6;
    public static final int CustomTargetValueLowFieldNum = 5;
    public static final int DurationTypeFieldNum = 1;
    public static final int DurationValueFieldNum = 2;
    public static final int EquipmentFieldNum = 9;
    public static final int ExerciseCategoryFieldNum = 10;
    public static final int ExerciseNameFieldNum = 11;
    public static final int ExerciseWeightFieldNum = 12;
    public static final int IntensityFieldNum = 7;
    public static final int MesgID = 6912;
    public static final int MessageIndexFieldNum = 254;
    public static final int NotesFieldNum = 8;
    public static final int TargetTypeFieldNum = 3;
    public static final int TargetValueFieldNum = 4;
    public static final int WeightDisplayUnitFieldNum = 13;
    public static final int WktStepNameFieldNum = 0;
    protected static final Mesg workoutStepMesg;

    static {
        Mesg mesg;
        workoutStepMesg = mesg = new Mesg("workout_step", 6912);
        mesg.addField(new Field("message_index", 254, 132, 1.0, 0.0, "", false, Profile.Type.MESSAGE_INDEX));
        mesg.addField(new Field("wkt_step_name", 0, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        mesg.addField(new Field("duration_type", 1, 0, 1.0, 0.0, "", false, Profile.Type.WKT_STEP_DURATION));
        mesg.addField(new Field("duration_value", 2, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)3).subFields.add(new SubField("duration_time", 134, 1.0, 0.0, "s"));
        mesg.fields.get((int)3).subFields.get(0).addMap(1, 0L);
        mesg.fields.get((int)3).subFields.get(0).addMap(1, 28L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_distance", 134, 100.0, 0.0, "m"));
        mesg.fields.get((int)3).subFields.get(1).addMap(1, 1L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_hr", 134, 1.0, 0.0, "% or bpm"));
        mesg.fields.get((int)3).subFields.get(2).addMap(1, 2L);
        mesg.fields.get((int)3).subFields.get(2).addMap(1, 3L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_calories", 134, 1.0, 0.0, "calories"));
        mesg.fields.get((int)3).subFields.get(3).addMap(1, 4L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_step", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 6L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 7L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 8L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 9L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 10L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 11L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 12L);
        mesg.fields.get((int)3).subFields.get(4).addMap(1, 13L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_power", 134, 1.0, 0.0, "% or watts"));
        mesg.fields.get((int)3).subFields.get(5).addMap(1, 14L);
        mesg.fields.get((int)3).subFields.get(5).addMap(1, 15L);
        mesg.fields.get((int)3).subFields.add(new SubField("duration_reps", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)3).subFields.get(6).addMap(1, 29L);
        mesg.addField(new Field("target_type", 3, 0, 1.0, 0.0, "", false, Profile.Type.WKT_STEP_TARGET));
        mesg.addField(new Field("target_value", 4, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)5).subFields.add(new SubField("target_speed_zone", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(0).addMap(3, 0L);
        mesg.fields.get((int)5).subFields.add(new SubField("target_hr_zone", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(1).addMap(3, 1L);
        mesg.fields.get((int)5).subFields.add(new SubField("target_cadence_zone", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(2).addMap(3, 3L);
        mesg.fields.get((int)5).subFields.add(new SubField("target_power_zone", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(3).addMap(3, 4L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_steps", 134, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(4).addMap(1, 6L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_time", 134, 1000.0, 0.0, "s"));
        mesg.fields.get((int)5).subFields.get(5).addMap(1, 7L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_distance", 134, 100.0, 0.0, "m"));
        mesg.fields.get((int)5).subFields.get(6).addMap(1, 8L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_calories", 134, 1.0, 0.0, "calories"));
        mesg.fields.get((int)5).subFields.get(7).addMap(1, 9L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_hr", 134, 1.0, 0.0, "% or bpm"));
        mesg.fields.get((int)5).subFields.get(8).addMap(1, 10L);
        mesg.fields.get((int)5).subFields.get(8).addMap(1, 11L);
        mesg.fields.get((int)5).subFields.add(new SubField("repeat_power", 134, 1.0, 0.0, "% or watts"));
        mesg.fields.get((int)5).subFields.get(9).addMap(1, 12L);
        mesg.fields.get((int)5).subFields.get(9).addMap(1, 13L);
        mesg.fields.get((int)5).subFields.add(new SubField("target_stroke_type", 0, 1.0, 0.0, ""));
        mesg.fields.get((int)5).subFields.get(10).addMap(3, 11L);
        mesg.addField(new Field("custom_target_value_low", 5, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)6).subFields.add(new SubField("custom_target_speed_low", 134, 1000.0, 0.0, "m/s"));
        mesg.fields.get((int)6).subFields.get(0).addMap(3, 0L);
        mesg.fields.get((int)6).subFields.add(new SubField("custom_target_heart_rate_low", 134, 1.0, 0.0, "% or bpm"));
        mesg.fields.get((int)6).subFields.get(1).addMap(3, 1L);
        mesg.fields.get((int)6).subFields.add(new SubField("custom_target_cadence_low", 134, 1.0, 0.0, "rpm"));
        mesg.fields.get((int)6).subFields.get(2).addMap(3, 3L);
        mesg.fields.get((int)6).subFields.add(new SubField("custom_target_power_low", 134, 1.0, 0.0, "% or watts"));
        mesg.fields.get((int)6).subFields.get(3).addMap(3, 4L);
        mesg.addField(new Field("custom_target_value_high", 6, 134, 1.0, 0.0, "", false, Profile.Type.UINT32));
        mesg.fields.get((int)7).subFields.add(new SubField("custom_target_speed_high", 134, 1000.0, 0.0, "m/s"));
        mesg.fields.get((int)7).subFields.get(0).addMap(3, 0L);
        mesg.fields.get((int)7).subFields.add(new SubField("custom_target_heart_rate_high", 134, 1.0, 0.0, "% or bpm"));
        mesg.fields.get((int)7).subFields.get(1).addMap(3, 1L);
        mesg.fields.get((int)7).subFields.add(new SubField("custom_target_cadence_high", 134, 1.0, 0.0, "rpm"));
        mesg.fields.get((int)7).subFields.get(2).addMap(3, 3L);
        mesg.fields.get((int)7).subFields.add(new SubField("custom_target_power_high", 134, 1.0, 0.0, "% or watts"));
        mesg.fields.get((int)7).subFields.get(3).addMap(3, 4L);
        mesg.addField(new Field("intensity", 7, 0, 1.0, 0.0, "", false, Profile.Type.INTENSITY));
        mesg.addField(new Field("notes", 8, 7, 1.0, 0.0, "", false, Profile.Type.STRING));
        mesg.addField(new Field("equipment", 9, 0, 1.0, 0.0, "", false, Profile.Type.WORKOUT_EQUIPMENT));
        mesg.addField(new Field("exercise_category", 10, 132, 1.0, 0.0, "", false, Profile.Type.EXERCISE_CATEGORY));
        mesg.addField(new Field("exercise_name", 11, 132, 1.0, 0.0, "", false, Profile.Type.UINT16));
        mesg.addField(new Field("exercise_weight", 12, 132, 100.0, 0.0, "kg", false, Profile.Type.UINT16));
        mesg.addField(new Field("weight_display_unit", 13, 132, 1.0, 0.0, "", false, Profile.Type.FIT_BASE_UNIT));
    }

    public WorkoutStepMesg() {
        super(Factory.createMesg(6912));
    }

    public WorkoutStepMesg(Mesg mesg) {
        super(mesg);
    }

    public Long getCustomTargetCadenceHigh() {
        return this.getFieldLongValue(6, 0, 2);
    }

    public Long getCustomTargetCadenceLow() {
        return this.getFieldLongValue(5, 0, 2);
    }

    public Long getCustomTargetHeartRateHigh() {
        return this.getFieldLongValue(6, 0, 1);
    }

    public Long getCustomTargetHeartRateLow() {
        return this.getFieldLongValue(5, 0, 1);
    }

    public Long getCustomTargetPowerHigh() {
        return this.getFieldLongValue(6, 0, 3);
    }

    public Long getCustomTargetPowerLow() {
        return this.getFieldLongValue(5, 0, 3);
    }

    public Float getCustomTargetSpeedHigh() {
        return this.getFieldFloatValue(6, 0, 0);
    }

    public Float getCustomTargetSpeedLow() {
        return this.getFieldFloatValue(5, 0, 0);
    }

    public Long getCustomTargetValueHigh() {
        return this.getFieldLongValue(6, 0, 65535);
    }

    public Long getCustomTargetValueLow() {
        return this.getFieldLongValue(5, 0, 65535);
    }

    public Long getDurationCalories() {
        return this.getFieldLongValue(2, 0, 3);
    }

    public Float getDurationDistance() {
        return this.getFieldFloatValue(2, 0, 1);
    }

    public Long getDurationHr() {
        return this.getFieldLongValue(2, 0, 2);
    }

    public Long getDurationPower() {
        return this.getFieldLongValue(2, 0, 5);
    }

    public Long getDurationReps() {
        return this.getFieldLongValue(2, 0, 6);
    }

    public Long getDurationStep() {
        return this.getFieldLongValue(2, 0, 4);
    }

    public Float getDurationTime() {
        return this.getFieldFloatValue(2, 0, 0);
    }

    public WktStepDuration getDurationType() {
        Short s = this.getFieldShortValue(1, 0, 65535);
        if (s == null) {
            return null;
        }
        return WktStepDuration.getByValue(s);
    }

    public Long getDurationValue() {
        return this.getFieldLongValue(2, 0, 65535);
    }

    public WorkoutEquipment getEquipment() {
        Short s = this.getFieldShortValue(9, 0, 65535);
        if (s == null) {
            return null;
        }
        return WorkoutEquipment.getByValue(s);
    }

    public Integer getExerciseCategory() {
        return this.getFieldIntegerValue(10, 0, 65535);
    }

    public Integer getExerciseName() {
        return this.getFieldIntegerValue(11, 0, 65535);
    }

    public Float getExerciseWeight() {
        return this.getFieldFloatValue(12, 0, 65535);
    }

    public Intensity getIntensity() {
        Short s = this.getFieldShortValue(7, 0, 65535);
        if (s == null) {
            return null;
        }
        return Intensity.getByValue(s);
    }

    public Integer getMessageIndex() {
        return this.getFieldIntegerValue(254, 0, 65535);
    }

    public String getNotes() {
        return this.getFieldStringValue(8, 0, 65535);
    }

    public Long getRepeatCalories() {
        return this.getFieldLongValue(4, 0, 7);
    }

    public Float getRepeatDistance() {
        return this.getFieldFloatValue(4, 0, 6);
    }

    public Long getRepeatHr() {
        return this.getFieldLongValue(4, 0, 8);
    }

    public Long getRepeatPower() {
        return this.getFieldLongValue(4, 0, 9);
    }

    public Long getRepeatSteps() {
        return this.getFieldLongValue(4, 0, 4);
    }

    public Float getRepeatTime() {
        return this.getFieldFloatValue(4, 0, 5);
    }

    public Long getTargetCadenceZone() {
        return this.getFieldLongValue(4, 0, 2);
    }

    public Long getTargetHrZone() {
        return this.getFieldLongValue(4, 0, 1);
    }

    public Long getTargetPowerZone() {
        return this.getFieldLongValue(4, 0, 3);
    }

    public Long getTargetSpeedZone() {
        return this.getFieldLongValue(4, 0, 0);
    }

    public SwimStroke getTargetStrokeType() {
        Short s = this.getFieldShortValue(4, 0, 10);
        if (s == null) {
            return null;
        }
        return SwimStroke.getByValue(s);
    }

    public WktStepTarget getTargetType() {
        Short s = this.getFieldShortValue(3, 0, 65535);
        if (s == null) {
            return null;
        }
        return WktStepTarget.getByValue(s);
    }

    public Long getTargetValue() {
        return this.getFieldLongValue(4, 0, 65535);
    }

    public Integer getWeightDisplayUnit() {
        return this.getFieldIntegerValue(13, 0, 65535);
    }

    public String getWktStepName() {
        return this.getFieldStringValue(0, 0, 65535);
    }

    public void setCustomTargetCadenceHigh(Long l) {
        this.setFieldValue(6, 0, (Object)l, 2);
    }

    public void setCustomTargetCadenceLow(Long l) {
        this.setFieldValue(5, 0, (Object)l, 2);
    }

    public void setCustomTargetHeartRateHigh(Long l) {
        this.setFieldValue(6, 0, (Object)l, 1);
    }

    public void setCustomTargetHeartRateLow(Long l) {
        this.setFieldValue(5, 0, (Object)l, 1);
    }

    public void setCustomTargetPowerHigh(Long l) {
        this.setFieldValue(6, 0, (Object)l, 3);
    }

    public void setCustomTargetPowerLow(Long l) {
        this.setFieldValue(5, 0, (Object)l, 3);
    }

    public void setCustomTargetSpeedHigh(Float f) {
        this.setFieldValue(6, 0, (Object)f, 0);
    }

    public void setCustomTargetSpeedLow(Float f) {
        this.setFieldValue(5, 0, (Object)f, 0);
    }

    public void setCustomTargetValueHigh(Long l) {
        this.setFieldValue(6, 0, (Object)l, 65535);
    }

    public void setCustomTargetValueLow(Long l) {
        this.setFieldValue(5, 0, (Object)l, 65535);
    }

    public void setDurationCalories(Long l) {
        this.setFieldValue(2, 0, (Object)l, 3);
    }

    public void setDurationDistance(Float f) {
        this.setFieldValue(2, 0, (Object)f, 1);
    }

    public void setDurationHr(Long l) {
        this.setFieldValue(2, 0, (Object)l, 2);
    }

    public void setDurationPower(Long l) {
        this.setFieldValue(2, 0, (Object)l, 5);
    }

    public void setDurationReps(Long l) {
        this.setFieldValue(2, 0, (Object)l, 6);
    }

    public void setDurationStep(Long l) {
        this.setFieldValue(2, 0, (Object)l, 4);
    }

    public void setDurationTime(Float f) {
        this.setFieldValue(2, 0, (Object)f, 0);
    }

    public void setDurationType(WktStepDuration wktStepDuration) {
        this.setFieldValue(1, 0, (Object)wktStepDuration.value, 65535);
    }

    public void setDurationValue(Long l) {
        this.setFieldValue(2, 0, (Object)l, 65535);
    }

    public void setEquipment(WorkoutEquipment workoutEquipment) {
        this.setFieldValue(9, 0, (Object)workoutEquipment.value, 65535);
    }

    public void setExerciseCategory(Integer n) {
        this.setFieldValue(10, 0, (Object)n, 65535);
    }

    public void setExerciseName(Integer n) {
        this.setFieldValue(11, 0, (Object)n, 65535);
    }

    public void setExerciseWeight(Float f) {
        this.setFieldValue(12, 0, (Object)f, 65535);
    }

    public void setIntensity(Intensity intensity) {
        this.setFieldValue(7, 0, (Object)intensity.value, 65535);
    }

    public void setMessageIndex(Integer n) {
        this.setFieldValue(254, 0, (Object)n, 65535);
    }

    public void setNotes(String string2) {
        this.setFieldValue(8, 0, (Object)string2, 65535);
    }

    public void setRepeatCalories(Long l) {
        this.setFieldValue(4, 0, (Object)l, 7);
    }

    public void setRepeatDistance(Float f) {
        this.setFieldValue(4, 0, (Object)f, 6);
    }

    public void setRepeatHr(Long l) {
        this.setFieldValue(4, 0, (Object)l, 8);
    }

    public void setRepeatPower(Long l) {
        this.setFieldValue(4, 0, (Object)l, 9);
    }

    public void setRepeatSteps(Long l) {
        this.setFieldValue(4, 0, (Object)l, 4);
    }

    public void setRepeatTime(Float f) {
        this.setFieldValue(4, 0, (Object)f, 5);
    }

    public void setTargetCadenceZone(Long l) {
        this.setFieldValue(4, 0, (Object)l, 2);
    }

    public void setTargetHrZone(Long l) {
        this.setFieldValue(4, 0, (Object)l, 1);
    }

    public void setTargetPowerZone(Long l) {
        this.setFieldValue(4, 0, (Object)l, 3);
    }

    public void setTargetSpeedZone(Long l) {
        this.setFieldValue(4, 0, (Object)l, 0);
    }

    public void setTargetStrokeType(SwimStroke swimStroke) {
        this.setFieldValue(4, 0, (Object)swimStroke.value, 10);
    }

    public void setTargetType(WktStepTarget wktStepTarget) {
        this.setFieldValue(3, 0, (Object)wktStepTarget.value, 65535);
    }

    public void setTargetValue(Long l) {
        this.setFieldValue(4, 0, (Object)l, 65535);
    }

    public void setWeightDisplayUnit(Integer n) {
        this.setFieldValue(13, 0, (Object)n, 65535);
    }

    public void setWktStepName(String string2) {
        this.setFieldValue(0, 0, (Object)string2, 65535);
    }
}

