/*
 * Decompiled with CFR 0.152.
 */
package com.github.clans.fab;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.ImageView;
import com.github.clans.fab.FloatingActionButton;
import com.github.clans.fab.Label;
import com.github.clans.fab.R;
import com.github.clans.fab.Util;
import java.util.ArrayList;

public class FloatingActionMenu
extends ViewGroup {
    private static final int ANIMATION_DURATION = 300;
    private static final float CLOSED_PLUS_ROTATION = 0.0f;
    private static final int LABELS_POSITION_LEFT = 0;
    private static final int LABELS_POSITION_RIGHT = 1;
    private static final float OPENED_PLUS_ROTATION_LEFT = -135.0f;
    private static final float OPENED_PLUS_ROTATION_RIGHT = 135.0f;
    private static final int OPEN_DOWN = 1;
    private static final int OPEN_UP = 0;
    private int mAnimationDelayPerItem;
    private int mBackgroundColor;
    private int mButtonSpacing;
    private int mButtonsCount;
    private AnimatorSet mCloseAnimatorSet;
    private Interpolator mCloseInterpolator;
    private Typeface mCustomTypefaceFromFont;
    private ValueAnimator mHideBackgroundAnimator;
    private Drawable mIcon;
    private boolean mIconAnimated = true;
    private AnimatorSet mIconToggleSet;
    private ImageView mImageToggle;
    private Animation mImageToggleHideAnimation;
    private Animation mImageToggleShowAnimation;
    private boolean mIsAnimated = true;
    private boolean mIsMenuButtonAnimationRunning;
    private boolean mIsMenuOpening;
    private boolean mIsSetClosedOnTouchOutside;
    private int mLabelsColorNormal;
    private int mLabelsColorPressed;
    private int mLabelsColorRipple;
    private Context mLabelsContext;
    private int mLabelsCornerRadius;
    private int mLabelsEllipsize;
    private int mLabelsHideAnimation;
    private int mLabelsMargin;
    private int mLabelsMaxLines;
    private int mLabelsPaddingBottom;
    private int mLabelsPaddingLeft;
    private int mLabelsPaddingRight;
    private int mLabelsPaddingTop;
    private int mLabelsPosition;
    private int mLabelsShowAnimation;
    private boolean mLabelsShowShadow;
    private boolean mLabelsSingleLine;
    private int mLabelsStyle;
    private ColorStateList mLabelsTextColor;
    private float mLabelsTextSize;
    private int mLabelsVerticalOffset;
    private int mMaxButtonWidth;
    private FloatingActionButton mMenuButton;
    private Animation mMenuButtonHideAnimation;
    private Animation mMenuButtonShowAnimation;
    private int mMenuColorNormal;
    private int mMenuColorPressed;
    private int mMenuColorRipple;
    private int mMenuFabSize;
    private String mMenuLabelText;
    private boolean mMenuOpened;
    private int mMenuShadowColor;
    private float mMenuShadowRadius = 4.0f;
    private float mMenuShadowXOffset = 1.0f;
    private float mMenuShadowYOffset = 3.0f;
    private boolean mMenuShowShadow;
    private AnimatorSet mOpenAnimatorSet = new AnimatorSet();
    private int mOpenDirection;
    private Interpolator mOpenInterpolator;
    private ValueAnimator mShowBackgroundAnimator;
    private OnMenuToggleListener mToggleListener;
    private Handler mUiHandler;
    private boolean mUsingMenuLabel;

    public FloatingActionMenu(Context context) {
        this(context, null);
    }

    public FloatingActionMenu(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public FloatingActionMenu(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mCloseAnimatorSet = new AnimatorSet();
        this.mButtonSpacing = Util.dpToPx(this.getContext(), 0.0f);
        this.mLabelsMargin = Util.dpToPx(this.getContext(), 0.0f);
        this.mLabelsVerticalOffset = Util.dpToPx(this.getContext(), 0.0f);
        this.mUiHandler = new Handler();
        this.mLabelsPaddingTop = Util.dpToPx(this.getContext(), 4.0f);
        this.mLabelsPaddingRight = Util.dpToPx(this.getContext(), 8.0f);
        this.mLabelsPaddingBottom = Util.dpToPx(this.getContext(), 4.0f);
        this.mLabelsPaddingLeft = Util.dpToPx(this.getContext(), 8.0f);
        this.mLabelsCornerRadius = Util.dpToPx(this.getContext(), 3.0f);
        this.init(context, attributeSet);
    }

    static /* synthetic */ boolean access$202(FloatingActionMenu floatingActionMenu, boolean bl) {
        floatingActionMenu.mMenuOpened = bl;
        return bl;
    }

    static /* synthetic */ boolean access$502(FloatingActionMenu floatingActionMenu, boolean bl) {
        floatingActionMenu.mIsMenuButtonAnimationRunning = bl;
        return bl;
    }

    private void addLabel(FloatingActionButton floatingActionButton) {
        String string2 = floatingActionButton.getLabelText();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        Label label = new Label(this.mLabelsContext);
        label.setClickable(true);
        label.setFab(floatingActionButton);
        label.setShowAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsShowAnimation));
        label.setHideAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)this.mLabelsHideAnimation));
        if (this.mLabelsStyle > 0) {
            label.setTextAppearance(this.getContext(), this.mLabelsStyle);
            label.setShowShadow(false);
            label.setUsingStyle(true);
        } else {
            label.setColors(this.mLabelsColorNormal, this.mLabelsColorPressed, this.mLabelsColorRipple);
            label.setShowShadow(this.mLabelsShowShadow);
            label.setCornerRadius(this.mLabelsCornerRadius);
            if (this.mLabelsEllipsize > 0) {
                this.setLabelEllipsize(label);
            }
            label.setMaxLines(this.mLabelsMaxLines);
            label.updateBackground();
            label.setTextSize(0, this.mLabelsTextSize);
            label.setTextColor(this.mLabelsTextColor);
            int n = this.mLabelsPaddingLeft;
            int n2 = this.mLabelsPaddingTop;
            int n3 = n;
            int n4 = n2;
            if (this.mLabelsShowShadow) {
                n3 = n + (floatingActionButton.getShadowRadius() + Math.abs(floatingActionButton.getShadowXOffset()));
                n4 = n2 + (floatingActionButton.getShadowRadius() + Math.abs(floatingActionButton.getShadowYOffset()));
            }
            label.setPadding(n3, n4, this.mLabelsPaddingLeft, this.mLabelsPaddingTop);
            if (this.mLabelsMaxLines < 0 || this.mLabelsSingleLine) {
                label.setSingleLine(this.mLabelsSingleLine);
            }
        }
        Typeface typeface = this.mCustomTypefaceFromFont;
        if (typeface != null) {
            label.setTypeface(typeface);
        }
        label.setText(string2);
        label.setOnClickListener(floatingActionButton.getOnClickListener());
        this.addView((View)label);
        floatingActionButton.setTag(R.id.fab_label, (Object)label);
    }

    private int adjustForOvershoot(int n) {
        double d = n;
        return (int)(0.03 * d + d);
    }

    /*
     * Unable to fully structure code
     */
    private void createDefaultIconAnimation() {
        var1_1 = this.mOpenDirection;
        var2_2 = 135.0f;
        if (var1_1 == 0) {
            var1_1 = this.mLabelsPosition;
            var3_3 = var1_1 == 0 ? -135.0f : 135.0f;
            var4_5 = var3_3;
            if (var1_1 == 0) {
                var4_5 = var3_3;
                while (true) {
                    var2_2 = -135.0f;
                    break;
                }
            }
        } else {
            var1_1 = this.mLabelsPosition;
            var3_4 = var1_1 == 0 ? 135.0f : -135.0f;
            var4_5 = var3_4;
            if (var1_1 != 0) ** continue;
            var4_5 = var3_4;
        }
        var5_6 = ObjectAnimator.ofFloat((Object)this.mImageToggle, (String)"rotation", (float[])new float[]{var4_5, 0.0f});
        var6_7 = ObjectAnimator.ofFloat((Object)this.mImageToggle, (String)"rotation", (float[])new float[]{0.0f, var2_2});
        this.mOpenAnimatorSet.play((Animator)var6_7);
        this.mCloseAnimatorSet.play((Animator)var5_6);
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)this.mOpenInterpolator);
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)this.mCloseInterpolator);
        this.mOpenAnimatorSet.setDuration(300L);
        this.mCloseAnimatorSet.setDuration(300L);
    }

    private void createLabels() {
        for (int i = 0; i < this.mButtonsCount; ++i) {
            FloatingActionButton floatingActionButton;
            if (this.getChildAt(i) == this.mImageToggle || (floatingActionButton = (FloatingActionButton)this.getChildAt(i)).getTag(R.id.fab_label) != null) continue;
            this.addLabel(floatingActionButton);
            FloatingActionButton floatingActionButton2 = this.mMenuButton;
            if (floatingActionButton != floatingActionButton2) continue;
            floatingActionButton2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View object) {
                    object = FloatingActionMenu.this;
                    ((FloatingActionMenu)((Object)object)).toggle(((FloatingActionMenu)((Object)object)).mIsAnimated);
                }
            });
        }
    }

    private void createMenuButton() {
        FloatingActionButton floatingActionButton;
        this.mMenuButton = floatingActionButton = new FloatingActionButton(this.getContext());
        floatingActionButton.mShowShadow = this.mMenuShowShadow;
        if (this.mMenuShowShadow) {
            this.mMenuButton.mShadowRadius = Util.dpToPx(this.getContext(), this.mMenuShadowRadius);
            this.mMenuButton.mShadowXOffset = Util.dpToPx(this.getContext(), this.mMenuShadowXOffset);
            this.mMenuButton.mShadowYOffset = Util.dpToPx(this.getContext(), this.mMenuShadowYOffset);
        }
        this.mMenuButton.setColors(this.mMenuColorNormal, this.mMenuColorPressed, this.mMenuColorRipple);
        this.mMenuButton.mShadowColor = this.mMenuShadowColor;
        this.mMenuButton.mFabSize = this.mMenuFabSize;
        this.mMenuButton.updateBackground();
        this.mMenuButton.setLabelText(this.mMenuLabelText);
        floatingActionButton = new ImageView(this.getContext());
        this.mImageToggle = floatingActionButton;
        floatingActionButton.setImageDrawable(this.mIcon);
        this.addView((View)this.mMenuButton, super.generateDefaultLayoutParams());
        this.addView((View)this.mImageToggle);
        this.createDefaultIconAnimation();
    }

    private void hideMenuButtonWithImage(boolean bl) {
        if (!this.isMenuButtonHidden()) {
            this.mMenuButton.hide(bl);
            if (bl) {
                this.mImageToggle.startAnimation(this.mImageToggleHideAnimation);
            }
            this.mImageToggle.setVisibility(4);
            this.mIsMenuButtonAnimationRunning = false;
        }
    }

    private void init(Context object, AttributeSet object2) {
        block6: {
            object2 = object.obtainStyledAttributes((AttributeSet)object2, R.styleable.FloatingActionMenu, 0, 0);
            this.mButtonSpacing = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_buttonSpacing, this.mButtonSpacing);
            this.mLabelsMargin = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_margin, this.mLabelsMargin);
            this.mLabelsPosition = object2.getInt(R.styleable.FloatingActionMenu_menu_labels_position, 0);
            int n = R.styleable.FloatingActionMenu_menu_labels_showAnimation;
            int n2 = this.mLabelsPosition == 0 ? R.anim.fab_slide_in_from_right : R.anim.fab_slide_in_from_left;
            this.mLabelsShowAnimation = object2.getResourceId(n, n2);
            n = R.styleable.FloatingActionMenu_menu_labels_hideAnimation;
            n2 = this.mLabelsPosition == 0 ? R.anim.fab_slide_out_to_right : R.anim.fab_slide_out_to_left;
            this.mLabelsHideAnimation = object2.getResourceId(n, n2);
            this.mLabelsPaddingTop = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingTop, this.mLabelsPaddingTop);
            this.mLabelsPaddingRight = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingRight, this.mLabelsPaddingRight);
            this.mLabelsPaddingBottom = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingBottom, this.mLabelsPaddingBottom);
            this.mLabelsPaddingLeft = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_paddingLeft, this.mLabelsPaddingLeft);
            object = object2.getColorStateList(R.styleable.FloatingActionMenu_menu_labels_textColor);
            this.mLabelsTextColor = object;
            if (object == null) {
                this.mLabelsTextColor = ColorStateList.valueOf((int)-1);
            }
            this.mLabelsTextSize = object2.getDimension(R.styleable.FloatingActionMenu_menu_labels_textSize, this.getResources().getDimension(R.dimen.labels_text_size));
            this.mLabelsCornerRadius = object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_cornerRadius, this.mLabelsCornerRadius);
            this.mLabelsShowShadow = object2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_showShadow, true);
            this.mLabelsColorNormal = object2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorNormal, -13421773);
            this.mLabelsColorPressed = object2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorPressed, -12303292);
            this.mLabelsColorRipple = object2.getColor(R.styleable.FloatingActionMenu_menu_labels_colorRipple, 0x66FFFFFF);
            this.mMenuShowShadow = object2.getBoolean(R.styleable.FloatingActionMenu_menu_showShadow, true);
            this.mMenuShadowColor = object2.getColor(R.styleable.FloatingActionMenu_menu_shadowColor, 0x66000000);
            this.mMenuShadowRadius = object2.getDimension(R.styleable.FloatingActionMenu_menu_shadowRadius, this.mMenuShadowRadius);
            this.mMenuShadowXOffset = object2.getDimension(R.styleable.FloatingActionMenu_menu_shadowXOffset, this.mMenuShadowXOffset);
            this.mMenuShadowYOffset = object2.getDimension(R.styleable.FloatingActionMenu_menu_shadowYOffset, this.mMenuShadowYOffset);
            this.mMenuColorNormal = object2.getColor(R.styleable.FloatingActionMenu_menu_colorNormal, -2473162);
            this.mMenuColorPressed = object2.getColor(R.styleable.FloatingActionMenu_menu_colorPressed, -1617853);
            this.mMenuColorRipple = object2.getColor(R.styleable.FloatingActionMenu_menu_colorRipple, -1711276033);
            this.mAnimationDelayPerItem = object2.getInt(R.styleable.FloatingActionMenu_menu_animationDelayPerItem, 50);
            object = object2.getDrawable(R.styleable.FloatingActionMenu_menu_icon);
            this.mIcon = object;
            if (object == null) {
                this.mIcon = this.getResources().getDrawable(R.drawable.fab_add);
            }
            this.mLabelsSingleLine = object2.getBoolean(R.styleable.FloatingActionMenu_menu_labels_singleLine, false);
            this.mLabelsEllipsize = object2.getInt(R.styleable.FloatingActionMenu_menu_labels_ellipsize, 0);
            this.mLabelsMaxLines = object2.getInt(R.styleable.FloatingActionMenu_menu_labels_maxLines, -1);
            this.mMenuFabSize = object2.getInt(R.styleable.FloatingActionMenu_menu_fab_size, 0);
            this.mLabelsStyle = object2.getResourceId(R.styleable.FloatingActionMenu_menu_labels_style, 0);
            object = object2.getString(R.styleable.FloatingActionMenu_menu_labels_customFont);
            try {
                if (TextUtils.isEmpty((CharSequence)object)) break block6;
                this.mCustomTypefaceFromFont = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)object);
            }
            catch (RuntimeException runtimeException) {
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("Unable to load specified custom font: ");
                ((StringBuilder)object2).append((String)object);
                throw new IllegalArgumentException(((StringBuilder)object2).toString(), runtimeException);
            }
        }
        this.mOpenDirection = object2.getInt(R.styleable.FloatingActionMenu_menu_openDirection, 0);
        this.mBackgroundColor = object2.getColor(R.styleable.FloatingActionMenu_menu_backgroundColor, 0);
        if (object2.hasValue(R.styleable.FloatingActionMenu_menu_fab_label)) {
            this.mUsingMenuLabel = true;
            this.mMenuLabelText = object2.getString(R.styleable.FloatingActionMenu_menu_fab_label);
        }
        if (object2.hasValue(R.styleable.FloatingActionMenu_menu_labels_padding)) {
            this.initPadding(object2.getDimensionPixelSize(R.styleable.FloatingActionMenu_menu_labels_padding, 0));
        }
        this.mOpenInterpolator = new OvershootInterpolator();
        this.mCloseInterpolator = new AnticipateInterpolator();
        this.mLabelsContext = new ContextThemeWrapper(this.getContext(), this.mLabelsStyle);
        this.initBackgroundDimAnimation();
        this.createMenuButton();
        this.initMenuButtonAnimations((TypedArray)object2);
        object2.recycle();
    }

    private void initBackgroundDimAnimation() {
        ValueAnimator valueAnimator;
        int n = Color.alpha((int)this.mBackgroundColor);
        final int n2 = Color.red((int)this.mBackgroundColor);
        final int n3 = Color.green((int)this.mBackgroundColor);
        final int n4 = Color.blue((int)this.mBackgroundColor);
        this.mShowBackgroundAnimator = valueAnimator = ValueAnimator.ofInt((int[])new int[]{0, n});
        valueAnimator.setDuration(300L);
        this.mShowBackgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator object) {
                object = (Integer)object.getAnimatedValue();
                FloatingActionMenu.this.setBackgroundColor(Color.argb((int)((Integer)object), (int)n2, (int)n3, (int)n4));
            }
        });
        this.mHideBackgroundAnimator = valueAnimator = ValueAnimator.ofInt((int[])new int[]{n, 0});
        valueAnimator.setDuration(300L);
        this.mHideBackgroundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator object) {
                object = (Integer)object.getAnimatedValue();
                FloatingActionMenu.this.setBackgroundColor(Color.argb((int)((Integer)object), (int)n2, (int)n3, (int)n4));
            }
        });
    }

    private void initMenuButtonAnimations(TypedArray typedArray) {
        int n = typedArray.getResourceId(R.styleable.FloatingActionMenu_menu_fab_show_animation, R.anim.fab_scale_up);
        this.setMenuButtonShowAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)n));
        this.mImageToggleShowAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)n);
        n = typedArray.getResourceId(R.styleable.FloatingActionMenu_menu_fab_hide_animation, R.anim.fab_scale_down);
        this.setMenuButtonHideAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)n));
        this.mImageToggleHideAnimation = AnimationUtils.loadAnimation((Context)this.getContext(), (int)n);
    }

    private void initPadding(int n) {
        this.mLabelsPaddingTop = n;
        this.mLabelsPaddingRight = n;
        this.mLabelsPaddingBottom = n;
        this.mLabelsPaddingLeft = n;
    }

    private boolean isBackgroundEnabled() {
        boolean bl = this.mBackgroundColor != 0;
        return bl;
    }

    private void setLabelEllipsize(Label label) {
        int n = this.mLabelsEllipsize;
        if (n != 1) {
            if (n != 2) {
                if (n != 3) {
                    if (n == 4) {
                        label.setEllipsize(TextUtils.TruncateAt.MARQUEE);
                    }
                } else {
                    label.setEllipsize(TextUtils.TruncateAt.END);
                }
            } else {
                label.setEllipsize(TextUtils.TruncateAt.MIDDLE);
            }
        } else {
            label.setEllipsize(TextUtils.TruncateAt.START);
        }
    }

    private void showMenuButtonWithImage(boolean bl) {
        if (this.isMenuButtonHidden()) {
            this.mMenuButton.show(bl);
            if (bl) {
                this.mImageToggle.startAnimation(this.mImageToggleShowAnimation);
            }
            this.mImageToggle.setVisibility(0);
        }
    }

    public void addMenuButton(FloatingActionButton floatingActionButton) {
        this.addView((View)floatingActionButton, this.mButtonsCount - 2);
        ++this.mButtonsCount;
        this.addLabel(floatingActionButton);
    }

    public void addMenuButton(FloatingActionButton floatingActionButton, int n) {
        int n2;
        int n3 = this.mButtonsCount - 2;
        if (n < 0) {
            n2 = 0;
        } else {
            n2 = n;
            if (n > n3) {
                n2 = n3;
            }
        }
        this.addView((View)floatingActionButton, n2);
        ++this.mButtonsCount;
        this.addLabel(floatingActionButton);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams;
    }

    public void close(boolean bl) {
        if (this.isOpened()) {
            Object object;
            if (this.isBackgroundEnabled()) {
                this.mHideBackgroundAnimator.start();
            }
            if (this.mIconAnimated) {
                object = this.mIconToggleSet;
                if (object != null) {
                    object.start();
                } else {
                    this.mCloseAnimatorSet.start();
                    this.mOpenAnimatorSet.cancel();
                }
            }
            this.mIsMenuOpening = false;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < this.getChildCount(); ++i) {
                object = this.getChildAt(i);
                int n3 = n;
                int n4 = n2;
                if (object instanceof FloatingActionButton) {
                    n3 = n;
                    n4 = n2;
                    if (object.getVisibility() != 8) {
                        n3 = n + 1;
                        object = (FloatingActionButton)((Object)object);
                        this.mUiHandler.postDelayed(new Runnable((FloatingActionButton)((Object)object), bl){
                            final /* synthetic */ boolean val$animate;
                            final /* synthetic */ FloatingActionButton val$fab;
                            {
                                this.val$fab = floatingActionButton;
                                this.val$animate = bl;
                            }

                            @Override
                            public void run() {
                                Label label;
                                if (!FloatingActionMenu.this.isOpened()) {
                                    return;
                                }
                                if (this.val$fab != FloatingActionMenu.this.mMenuButton) {
                                    this.val$fab.hide(this.val$animate);
                                }
                                if ((label = (Label)((Object)this.val$fab.getTag(R.id.fab_label))) != null && label.isHandleVisibilityChanges()) {
                                    label.hide(this.val$animate);
                                }
                            }
                        }, (long)n2);
                        n4 = n2 + this.mAnimationDelayPerItem;
                    }
                }
                n = n3;
                n2 = n4;
            }
            this.mUiHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FloatingActionMenu.access$202(FloatingActionMenu.this, false);
                    if (FloatingActionMenu.this.mToggleListener != null) {
                        FloatingActionMenu.this.mToggleListener.onMenuToggle(false);
                    }
                }
            }, (long)((n + 1) * this.mAnimationDelayPerItem));
        }
    }

    protected ViewGroup.MarginLayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.MarginLayoutParams(-2, -2);
    }

    public ViewGroup.MarginLayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new ViewGroup.MarginLayoutParams(this.getContext(), attributeSet);
    }

    protected ViewGroup.MarginLayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new ViewGroup.MarginLayoutParams(layoutParams);
    }

    public int getAnimationDelayPerItem() {
        return this.mAnimationDelayPerItem;
    }

    public AnimatorSet getIconToggleAnimatorSet() {
        return this.mIconToggleSet;
    }

    public int getMenuButtonColorNormal() {
        return this.mMenuColorNormal;
    }

    public int getMenuButtonColorPressed() {
        return this.mMenuColorPressed;
    }

    public int getMenuButtonColorRipple() {
        return this.mMenuColorRipple;
    }

    public String getMenuButtonLabelText() {
        return this.mMenuLabelText;
    }

    public ImageView getMenuIconView() {
        return this.mImageToggle;
    }

    public void hideMenu(final boolean bl) {
        if (!this.isMenuHidden() && !this.mIsMenuButtonAnimationRunning) {
            this.mIsMenuButtonAnimationRunning = true;
            if (this.isOpened()) {
                this.close(bl);
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            FloatingActionMenu floatingActionMenu = FloatingActionMenu.this;
                            floatingActionMenu.startAnimation(floatingActionMenu.mMenuButtonHideAnimation);
                        }
                        FloatingActionMenu.this.setVisibility(4);
                        FloatingActionMenu.access$502(FloatingActionMenu.this, false);
                    }
                }, (long)(this.mAnimationDelayPerItem * this.mButtonsCount));
            } else {
                if (bl) {
                    this.startAnimation(this.mMenuButtonHideAnimation);
                }
                this.setVisibility(4);
                this.mIsMenuButtonAnimationRunning = false;
            }
        }
    }

    public void hideMenuButton(final boolean bl) {
        if (!this.isMenuButtonHidden() && !this.mIsMenuButtonAnimationRunning) {
            this.mIsMenuButtonAnimationRunning = true;
            if (this.isOpened()) {
                this.close(bl);
                this.mUiHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        FloatingActionMenu.this.hideMenuButtonWithImage(bl);
                    }
                }, (long)(this.mAnimationDelayPerItem * this.mButtonsCount));
            } else {
                this.hideMenuButtonWithImage(bl);
            }
        }
    }

    public boolean isAnimated() {
        return this.mIsAnimated;
    }

    public boolean isIconAnimated() {
        return this.mIconAnimated;
    }

    public boolean isMenuButtonHidden() {
        return this.mMenuButton.isHidden();
    }

    public boolean isMenuHidden() {
        boolean bl = this.getVisibility() == 4;
        return bl;
    }

    public boolean isOpened() {
        return this.mMenuOpened;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bringChildToFront((View)this.mMenuButton);
        this.bringChildToFront((View)this.mImageToggle);
        this.mButtonsCount = this.getChildCount();
        this.createLabels();
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        n3 = this.mLabelsPosition == 0 ? n3 - n - this.mMaxButtonWidth / 2 - this.getPaddingRight() : this.mMaxButtonWidth / 2 + this.getPaddingLeft();
        boolean bl2 = this.mOpenDirection == 0;
        n = bl2 ? n4 - n2 - this.mMenuButton.getMeasuredHeight() - this.getPaddingBottom() : this.getPaddingTop();
        n2 = n3 - this.mMenuButton.getMeasuredWidth() / 2;
        FloatingActionButton floatingActionButton = this.mMenuButton;
        floatingActionButton.layout(n2, n, floatingActionButton.getMeasuredWidth() + n2, this.mMenuButton.getMeasuredHeight() + n);
        n4 = n3 - this.mImageToggle.getMeasuredWidth() / 2;
        n2 = this.mMenuButton.getMeasuredHeight() / 2 + n - this.mImageToggle.getMeasuredHeight() / 2;
        floatingActionButton = this.mImageToggle;
        floatingActionButton.layout(n4, n2, floatingActionButton.getMeasuredWidth() + n4, this.mImageToggle.getMeasuredHeight() + n2);
        n2 = n;
        if (bl2) {
            n2 = n + this.mMenuButton.getMeasuredHeight() + this.mButtonSpacing;
        }
        n = n2;
        for (n4 = this.mButtonsCount - 1; n4 >= 0; --n4) {
            View view;
            View view2 = this.getChildAt(n4);
            if (view2 == this.mImageToggle || (floatingActionButton = (FloatingActionButton)view2).getVisibility() == 8) continue;
            n2 = n3 - floatingActionButton.getMeasuredWidth() / 2;
            int n5 = n;
            if (bl2) {
                n5 = n - floatingActionButton.getMeasuredHeight() - this.mButtonSpacing;
            }
            if (floatingActionButton != this.mMenuButton) {
                floatingActionButton.layout(n2, n5, floatingActionButton.getMeasuredWidth() + n2, floatingActionButton.getMeasuredHeight() + n5);
                if (!this.mIsMenuOpening) {
                    floatingActionButton.hide(false);
                }
            }
            if ((view = (View)floatingActionButton.getTag(R.id.fab_label)) != null) {
                n = this.mUsingMenuLabel ? this.mMaxButtonWidth : floatingActionButton.getMeasuredWidth();
                n = n / 2 + this.mLabelsMargin;
                n2 = this.mLabelsPosition;
                n = n2 == 0 ? n3 - n : (n += n3);
                n2 = n2 == 0 ? n - view.getMeasuredWidth() : view.getMeasuredWidth() + n;
                int n6 = this.mLabelsPosition;
                int n7 = n6 == 0 ? n2 : n;
                if (n6 != 0) {
                    n = n2;
                }
                n2 = n5 - this.mLabelsVerticalOffset + (floatingActionButton.getMeasuredHeight() - view.getMeasuredHeight()) / 2;
                view.layout(n7, n2, n, view.getMeasuredHeight() + n2);
                if (!this.mIsMenuOpening) {
                    view.setVisibility(4);
                }
            }
            n = bl2 ? n5 - this.mButtonSpacing : n5 + view2.getMeasuredHeight() + this.mButtonSpacing;
        }
    }

    protected void onMeasure(int n, int n2) {
        int n3;
        View view;
        int n4;
        this.mMaxButtonWidth = 0;
        this.measureChildWithMargins((View)this.mImageToggle, n, 0, n2, 0);
        for (n4 = 0; n4 < this.mButtonsCount; ++n4) {
            view = this.getChildAt(n4);
            if (view.getVisibility() == 8 || view == this.mImageToggle) continue;
            this.measureChildWithMargins(view, n, 0, n2, 0);
            this.mMaxButtonWidth = Math.max(this.mMaxButtonWidth, view.getMeasuredWidth());
        }
        int n5 = 0;
        int n6 = 0;
        n4 = 0;
        while (true) {
            n3 = this.mButtonsCount;
            int n7 = 1;
            if (n6 >= n3) break;
            view = this.getChildAt(n6);
            int n8 = n5;
            n3 = n4;
            if (view.getVisibility() != 8) {
                if (view == this.mImageToggle) {
                    n8 = n5;
                    n3 = n4;
                } else {
                    int n9 = view.getMeasuredWidth();
                    n8 = view.getMeasuredHeight();
                    Label label = (Label)((Object)view.getTag(R.id.fab_label));
                    n3 = n4;
                    if (label != null) {
                        int n10 = this.mMaxButtonWidth;
                        int n11 = view.getMeasuredWidth();
                        n3 = this.mUsingMenuLabel ? n7 : 2;
                        n3 = (n10 - n11) / n3;
                        this.measureChildWithMargins((View)label, n, view.getMeasuredWidth() + label.calculateShadowWidth() + this.mLabelsMargin + n3, n2, 0);
                        n3 = Math.max(n4, n9 + 0 + label.getMeasuredWidth() + n3);
                    }
                    n8 = n5 + n8;
                }
            }
            ++n6;
            n5 = n8;
            n4 = n3;
        }
        n4 = Math.max(this.mMaxButtonWidth, n4 + this.mLabelsMargin) + this.getPaddingLeft() + this.getPaddingRight();
        n3 = this.adjustForOvershoot(n5 + (this.mButtonSpacing * (this.mButtonsCount - 1) + this.getPaddingTop() + this.getPaddingBottom()));
        if (this.getLayoutParams().width == -1) {
            n4 = FloatingActionMenu.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)n);
        }
        n = n3;
        if (this.getLayoutParams().height == -1) {
            n = FloatingActionMenu.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)n2);
        }
        this.setMeasuredDimension(n4, n);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.mIsSetClosedOnTouchOutside) {
            boolean bl = false;
            int n = motionEvent.getAction();
            if (n != 0) {
                if (n == 1) {
                    this.close(this.mIsAnimated);
                    bl = true;
                }
            } else {
                bl = this.isOpened();
            }
            return bl;
        }
        return super.onTouchEvent(motionEvent);
    }

    public void open(boolean bl) {
        if (!this.isOpened()) {
            Object object;
            if (this.isBackgroundEnabled()) {
                this.mShowBackgroundAnimator.start();
            }
            if (this.mIconAnimated) {
                object = this.mIconToggleSet;
                if (object != null) {
                    object.start();
                } else {
                    this.mCloseAnimatorSet.cancel();
                    this.mOpenAnimatorSet.start();
                }
            }
            this.mIsMenuOpening = true;
            int n = 0;
            int n2 = 0;
            for (int i = this.getChildCount() - 1; i >= 0; --i) {
                object = this.getChildAt(i);
                int n3 = n;
                int n4 = n2;
                if (object instanceof FloatingActionButton) {
                    n3 = n;
                    n4 = n2;
                    if (object.getVisibility() != 8) {
                        n3 = n + 1;
                        object = (FloatingActionButton)((Object)object);
                        this.mUiHandler.postDelayed(new Runnable((FloatingActionButton)((Object)object), bl){
                            final /* synthetic */ boolean val$animate;
                            final /* synthetic */ FloatingActionButton val$fab;
                            {
                                this.val$fab = floatingActionButton;
                                this.val$animate = bl;
                            }

                            @Override
                            public void run() {
                                Label label;
                                if (FloatingActionMenu.this.isOpened()) {
                                    return;
                                }
                                if (this.val$fab != FloatingActionMenu.this.mMenuButton) {
                                    this.val$fab.show(this.val$animate);
                                }
                                if ((label = (Label)((Object)this.val$fab.getTag(R.id.fab_label))) != null && label.isHandleVisibilityChanges()) {
                                    label.show(this.val$animate);
                                }
                            }
                        }, (long)n2);
                        n4 = n2 + this.mAnimationDelayPerItem;
                    }
                }
                n = n3;
                n2 = n4;
            }
            this.mUiHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    FloatingActionMenu.access$202(FloatingActionMenu.this, true);
                    if (FloatingActionMenu.this.mToggleListener != null) {
                        FloatingActionMenu.this.mToggleListener.onMenuToggle(true);
                    }
                }
            }, (long)((n + 1) * this.mAnimationDelayPerItem));
        }
    }

    public void removeAllMenuButtons() {
        View view;
        this.close(true);
        ArrayList<FloatingActionButton> arrayList = new ArrayList<FloatingActionButton>();
        for (int i = 0; i < this.getChildCount(); ++i) {
            view = this.getChildAt(i);
            if (view == this.mMenuButton || view == this.mImageToggle || !(view instanceof FloatingActionButton)) continue;
            arrayList.add((FloatingActionButton)view);
        }
        view = arrayList.iterator();
        while (view.hasNext()) {
            this.removeMenuButton((FloatingActionButton)((Object)view.next()));
        }
    }

    public void removeMenuButton(FloatingActionButton floatingActionButton) {
        this.removeView((View)floatingActionButton.getLabelView());
        this.removeView((View)floatingActionButton);
        --this.mButtonsCount;
    }

    public void setAnimated(boolean bl) {
        this.mIsAnimated = bl;
        AnimatorSet animatorSet = this.mOpenAnimatorSet;
        long l = 300L;
        long l2 = bl ? 300L : 0L;
        animatorSet.setDuration(l2);
        animatorSet = this.mCloseAnimatorSet;
        l2 = bl ? l : 0L;
        animatorSet.setDuration(l2);
    }

    public void setAnimationDelayPerItem(int n) {
        this.mAnimationDelayPerItem = n;
    }

    public void setClosedOnTouchOutside(boolean bl) {
        this.mIsSetClosedOnTouchOutside = bl;
    }

    public void setIconAnimated(boolean bl) {
        this.mIconAnimated = bl;
    }

    public void setIconAnimationCloseInterpolator(Interpolator interpolator2) {
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)interpolator2);
    }

    public void setIconAnimationInterpolator(Interpolator interpolator2) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)interpolator2);
        this.mCloseAnimatorSet.setInterpolator((TimeInterpolator)interpolator2);
    }

    public void setIconAnimationOpenInterpolator(Interpolator interpolator2) {
        this.mOpenAnimatorSet.setInterpolator((TimeInterpolator)interpolator2);
    }

    public void setIconToggleAnimatorSet(AnimatorSet animatorSet) {
        this.mIconToggleSet = animatorSet;
    }

    public void setMenuButtonColorNormal(int n) {
        this.mMenuColorNormal = n;
        this.mMenuButton.setColorNormal(n);
    }

    public void setMenuButtonColorNormalResId(int n) {
        this.mMenuColorNormal = this.getResources().getColor(n);
        this.mMenuButton.setColorNormalResId(n);
    }

    public void setMenuButtonColorPressed(int n) {
        this.mMenuColorPressed = n;
        this.mMenuButton.setColorPressed(n);
    }

    public void setMenuButtonColorPressedResId(int n) {
        this.mMenuColorPressed = this.getResources().getColor(n);
        this.mMenuButton.setColorPressedResId(n);
    }

    public void setMenuButtonColorRipple(int n) {
        this.mMenuColorRipple = n;
        this.mMenuButton.setColorRipple(n);
    }

    public void setMenuButtonColorRippleResId(int n) {
        this.mMenuColorRipple = this.getResources().getColor(n);
        this.mMenuButton.setColorRippleResId(n);
    }

    public void setMenuButtonHideAnimation(Animation animation) {
        this.mMenuButtonHideAnimation = animation;
        this.mMenuButton.setHideAnimation(animation);
    }

    public void setMenuButtonLabelText(String string2) {
        this.mMenuButton.setLabelText(string2);
    }

    public void setMenuButtonShowAnimation(Animation animation) {
        this.mMenuButtonShowAnimation = animation;
        this.mMenuButton.setShowAnimation(animation);
    }

    public void setOnMenuButtonClickListener(View.OnClickListener onClickListener) {
        this.mMenuButton.setOnClickListener(onClickListener);
    }

    public void setOnMenuButtonLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mMenuButton.setOnLongClickListener(onLongClickListener);
    }

    public void setOnMenuToggleListener(OnMenuToggleListener onMenuToggleListener) {
        this.mToggleListener = onMenuToggleListener;
    }

    public void showMenu(boolean bl) {
        if (this.isMenuHidden()) {
            if (bl) {
                this.startAnimation(this.mMenuButtonShowAnimation);
            }
            this.setVisibility(0);
        }
    }

    public void showMenuButton(boolean bl) {
        if (this.isMenuButtonHidden()) {
            this.showMenuButtonWithImage(bl);
        }
    }

    public void toggle(boolean bl) {
        if (this.isOpened()) {
            this.close(bl);
        } else {
            this.open(bl);
        }
    }

    public void toggleMenu(boolean bl) {
        if (this.isMenuHidden()) {
            this.showMenu(bl);
        } else {
            this.hideMenu(bl);
        }
    }

    public void toggleMenuButton(boolean bl) {
        if (this.isMenuButtonHidden()) {
            this.showMenuButton(bl);
        } else {
            this.hideMenuButton(bl);
        }
    }

    public static interface OnMenuToggleListener {
        public void onMenuToggle(boolean var1);
    }
}

