/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.charts;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.util.Log;
import com.github.mikephil.charting.charts.BarLineChartBase;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.CombinedHighlighter;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.dataprovider.CombinedDataProvider;
import com.github.mikephil.charting.renderer.CombinedChartRenderer;

public class CombinedChart
extends BarLineChartBase<CombinedData>
implements CombinedDataProvider {
    private boolean mDrawBarShadow = false;
    protected DrawOrder[] mDrawOrder;
    private boolean mDrawValueAboveBar = true;
    protected boolean mHighlightFullBarEnabled = false;

    public CombinedChart(Context context) {
        super(context);
    }

    public CombinedChart(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public CombinedChart(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
    }

    @Override
    protected void drawMarkers(Canvas canvas) {
        if (this.mMarker != null && this.isDrawMarkersEnabled() && this.valuesToHighlight()) {
            for (int i = 0; i < this.mIndicesToHighlight.length; ++i) {
                Highlight highlight = this.mIndicesToHighlight[i];
                Object object = ((CombinedData)this.mData).getDataSetByHighlight(highlight);
                Entry entry = ((CombinedData)this.mData).getEntryForHighlight(highlight);
                if (entry == null || (float)object.getEntryIndex((Entry)entry) > (float)object.getEntryCount() * this.mAnimator.getPhaseX() || !this.mViewPortHandler.isInBounds((float)(object = (Object)this.getMarkerPosition(highlight))[0], (float)object[1])) continue;
                this.mMarker.refreshContent(entry, highlight);
                this.mMarker.draw(canvas, (float)object[0], (float)object[1]);
            }
        }
    }

    @Override
    public BarData getBarData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBarData();
    }

    @Override
    public BubbleData getBubbleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getBubbleData();
    }

    @Override
    public CandleData getCandleData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getCandleData();
    }

    @Override
    public CombinedData getCombinedData() {
        return (CombinedData)this.mData;
    }

    public DrawOrder[] getDrawOrder() {
        return this.mDrawOrder;
    }

    @Override
    public Highlight getHighlightByTouchPoint(float f, float f2) {
        if (this.mData == null) {
            Log.e((String)"MPAndroidChart", (String)"Can't select by touch. No data set.");
            return null;
        }
        Highlight highlight = this.getHighlighter().getHighlight(f, f2);
        if (highlight != null && this.isHighlightFullBarEnabled()) {
            return new Highlight(highlight.getX(), highlight.getY(), highlight.getXPx(), highlight.getYPx(), highlight.getDataSetIndex(), -1, highlight.getAxis());
        }
        return highlight;
    }

    @Override
    public LineData getLineData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getLineData();
    }

    @Override
    public ScatterData getScatterData() {
        if (this.mData == null) {
            return null;
        }
        return ((CombinedData)this.mData).getScatterData();
    }

    @Override
    protected void init() {
        super.init();
        this.mDrawOrder = new DrawOrder[]{DrawOrder.BAR, DrawOrder.BUBBLE, DrawOrder.LINE, DrawOrder.CANDLE, DrawOrder.SCATTER};
        this.setHighlighter(new CombinedHighlighter(this, this));
        this.setHighlightFullBarEnabled(true);
        this.mRenderer = new CombinedChartRenderer(this, this.mAnimator, this.mViewPortHandler);
    }

    @Override
    public boolean isDrawBarShadowEnabled() {
        return this.mDrawBarShadow;
    }

    @Override
    public boolean isDrawValueAboveBarEnabled() {
        return this.mDrawValueAboveBar;
    }

    @Override
    public boolean isHighlightFullBarEnabled() {
        return this.mHighlightFullBarEnabled;
    }

    @Override
    public void setData(CombinedData combinedData) {
        super.setData(combinedData);
        this.setHighlighter(new CombinedHighlighter(this, this));
        ((CombinedChartRenderer)this.mRenderer).createRenderers();
        this.mRenderer.initBuffers();
    }

    public void setDrawBarShadow(boolean bl) {
        this.mDrawBarShadow = bl;
    }

    public void setDrawOrder(DrawOrder[] drawOrderArray) {
        if (drawOrderArray != null && drawOrderArray.length > 0) {
            this.mDrawOrder = drawOrderArray;
        }
    }

    public void setDrawValueAboveBar(boolean bl) {
        this.mDrawValueAboveBar = bl;
    }

    public void setHighlightFullBarEnabled(boolean bl) {
        this.mHighlightFullBarEnabled = bl;
    }

    public static final class DrawOrder
    extends Enum<DrawOrder> {
        private static final /* synthetic */ DrawOrder[] $VALUES;
        public static final /* enum */ DrawOrder BAR;
        public static final /* enum */ DrawOrder BUBBLE;
        public static final /* enum */ DrawOrder CANDLE;
        public static final /* enum */ DrawOrder LINE;
        public static final /* enum */ DrawOrder SCATTER;

        static {
            DrawOrder drawOrder;
            DrawOrder drawOrder2;
            DrawOrder drawOrder3;
            DrawOrder drawOrder4;
            DrawOrder drawOrder5;
            BAR = drawOrder5 = new DrawOrder();
            BUBBLE = drawOrder4 = new DrawOrder();
            LINE = drawOrder3 = new DrawOrder();
            CANDLE = drawOrder2 = new DrawOrder();
            SCATTER = drawOrder = new DrawOrder();
            $VALUES = new DrawOrder[]{drawOrder5, drawOrder4, drawOrder3, drawOrder2, drawOrder};
        }

        public static DrawOrder valueOf(String string2) {
            return Enum.valueOf(DrawOrder.class, string2);
        }

        public static DrawOrder[] values() {
            return (DrawOrder[])$VALUES.clone();
        }
    }
}

