/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.graphics.Color;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleDataSet;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.interfaces.datasets.IBarDataSet;
import com.github.mikephil.charting.utils.Fill;
import java.util.ArrayList;
import java.util.List;

public class BarDataSet
extends BarLineScatterCandleBubbleDataSet<BarEntry>
implements IBarDataSet {
    private int mBarBorderColor = -16777216;
    private float mBarBorderWidth = 0.0f;
    private int mBarShadowColor = Color.rgb((int)215, (int)215, (int)215);
    private int mEntryCountStacks = 0;
    protected List<Fill> mFills = null;
    private int mHighLightAlpha = 120;
    private String[] mStackLabels = new String[0];
    private int mStackSize = 1;

    public BarDataSet(List<BarEntry> list, String string2) {
        super(list, string2);
        this.mHighLightColor = Color.rgb((int)0, (int)0, (int)0);
        this.calcStackSize(list);
        this.calcEntryCountIncludingStacks(list);
    }

    private void calcEntryCountIncludingStacks(List<BarEntry> list) {
        this.mEntryCountStacks = 0;
        for (int i = 0; i < list.size(); ++i) {
            float[] fArray = list.get(i).getYVals();
            if (fArray == null) {
                ++this.mEntryCountStacks;
                continue;
            }
            this.mEntryCountStacks += fArray.length;
        }
    }

    private void calcStackSize(List<BarEntry> list) {
        for (int i = 0; i < list.size(); ++i) {
            float[] fArray = list.get(i).getYVals();
            if (fArray == null || fArray.length <= this.mStackSize) continue;
            this.mStackSize = fArray.length;
        }
    }

    @Override
    protected void calcMinMax(BarEntry barEntry) {
        if (barEntry != null && !Float.isNaN(barEntry.getY())) {
            if (barEntry.getYVals() == null) {
                if (barEntry.getY() < this.mYMin) {
                    this.mYMin = barEntry.getY();
                }
                if (barEntry.getY() > this.mYMax) {
                    this.mYMax = barEntry.getY();
                }
            } else {
                if (-barEntry.getNegativeSum() < this.mYMin) {
                    this.mYMin = -barEntry.getNegativeSum();
                }
                if (barEntry.getPositiveSum() > this.mYMax) {
                    this.mYMax = barEntry.getPositiveSum();
                }
            }
            this.calcMinMaxX(barEntry);
        }
    }

    @Override
    public DataSet<BarEntry> copy() {
        Object object = new ArrayList<BarEntry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            object.add((BarEntry)((BarEntry)this.mEntries.get(i)).copy());
        }
        object = new BarDataSet((List<BarEntry>)object, this.getLabel());
        this.copy((BarDataSet)object);
        return object;
    }

    protected void copy(BarDataSet barDataSet) {
        super.copy(barDataSet);
        barDataSet.mStackSize = this.mStackSize;
        barDataSet.mBarShadowColor = this.mBarShadowColor;
        barDataSet.mBarBorderWidth = this.mBarBorderWidth;
        barDataSet.mStackLabels = this.mStackLabels;
        barDataSet.mHighLightAlpha = this.mHighLightAlpha;
    }

    @Override
    public int getBarBorderColor() {
        return this.mBarBorderColor;
    }

    @Override
    public float getBarBorderWidth() {
        return this.mBarBorderWidth;
    }

    @Override
    public int getBarShadowColor() {
        return this.mBarShadowColor;
    }

    public int getEntryCountStacks() {
        return this.mEntryCountStacks;
    }

    @Override
    public Fill getFill(int n) {
        List<Fill> list = this.mFills;
        return list.get(n % list.size());
    }

    @Override
    public List<Fill> getFills() {
        return this.mFills;
    }

    @Deprecated
    public Fill getGradient(int n) {
        return this.getFill(n);
    }

    @Deprecated
    public List<Fill> getGradients() {
        return this.mFills;
    }

    @Override
    public int getHighLightAlpha() {
        return this.mHighLightAlpha;
    }

    @Override
    public String[] getStackLabels() {
        return this.mStackLabels;
    }

    @Override
    public int getStackSize() {
        return this.mStackSize;
    }

    @Override
    public boolean isStacked() {
        int n = this.mStackSize;
        boolean bl = true;
        if (n <= 1) {
            bl = false;
        }
        return bl;
    }

    public void setBarBorderColor(int n) {
        this.mBarBorderColor = n;
    }

    public void setBarBorderWidth(float f) {
        this.mBarBorderWidth = f;
    }

    public void setBarShadowColor(int n) {
        this.mBarShadowColor = n;
    }

    public void setFills(List<Fill> list) {
        this.mFills = list;
    }

    public void setGradientColor(int n, int n2) {
        this.mFills.clear();
        this.mFills.add(new Fill(n, n2));
    }

    @Deprecated
    public void setGradientColors(List<Fill> list) {
        this.mFills = list;
    }

    public void setHighLightAlpha(int n) {
        this.mHighLightAlpha = n;
    }

    public void setStackLabels(String[] stringArray) {
        this.mStackLabels = stringArray;
    }
}

