/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.util.Log;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarLineScatterCandleBubbleData;
import com.github.mikephil.charting.data.BubbleData;
import com.github.mikephil.charting.data.CandleData;
import com.github.mikephil.charting.data.ChartData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.highlight.Highlight;
import com.github.mikephil.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CombinedData
extends BarLineScatterCandleBubbleData<IBarLineScatterCandleBubbleDataSet<? extends Entry>> {
    private BarData mBarData;
    private BubbleData mBubbleData;
    private CandleData mCandleData;
    private LineData mLineData;
    private ScatterData mScatterData;

    @Override
    public void calcMinMax() {
        if (this.mDataSets == null) {
            this.mDataSets = new ArrayList();
        }
        this.mDataSets.clear();
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        for (ChartData chartData : this.getAllData()) {
            chartData.calcMinMax();
            Object object = chartData.getDataSets();
            this.mDataSets.addAll(object);
            if (chartData.getYMax() > this.mYMax) {
                this.mYMax = chartData.getYMax();
            }
            if (chartData.getYMin() < this.mYMin) {
                this.mYMin = chartData.getYMin();
            }
            if (chartData.getXMax() > this.mXMax) {
                this.mXMax = chartData.getXMax();
            }
            if (chartData.getXMin() < this.mXMin) {
                this.mXMin = chartData.getXMin();
            }
            Iterator object2 = object.iterator();
            while (object2.hasNext()) {
                object = (IBarLineScatterCandleBubbleDataSet)object2.next();
                if (object.getAxisDependency() == YAxis.AxisDependency.LEFT) {
                    if (object.getYMax() > this.mLeftAxisMax) {
                        this.mLeftAxisMax = object.getYMax();
                    }
                    if (!(object.getYMin() < this.mLeftAxisMin)) continue;
                    this.mLeftAxisMin = object.getYMin();
                    continue;
                }
                if (object.getYMax() > this.mRightAxisMax) {
                    this.mRightAxisMax = object.getYMax();
                }
                if (!(object.getYMin() < this.mRightAxisMin)) continue;
                this.mRightAxisMin = object.getYMin();
            }
        }
    }

    public List<BarLineScatterCandleBubbleData> getAllData() {
        ArrayList<BarLineScatterCandleBubbleData> arrayList = new ArrayList<BarLineScatterCandleBubbleData>();
        BarLineScatterCandleBubbleData barLineScatterCandleBubbleData = this.mLineData;
        if (barLineScatterCandleBubbleData != null) {
            arrayList.add(barLineScatterCandleBubbleData);
        }
        if ((barLineScatterCandleBubbleData = this.mBarData) != null) {
            arrayList.add(barLineScatterCandleBubbleData);
        }
        if ((barLineScatterCandleBubbleData = this.mScatterData) != null) {
            arrayList.add(barLineScatterCandleBubbleData);
        }
        if ((barLineScatterCandleBubbleData = this.mCandleData) != null) {
            arrayList.add(barLineScatterCandleBubbleData);
        }
        if ((barLineScatterCandleBubbleData = this.mBubbleData) != null) {
            arrayList.add(barLineScatterCandleBubbleData);
        }
        return arrayList;
    }

    public BarData getBarData() {
        return this.mBarData;
    }

    public BubbleData getBubbleData() {
        return this.mBubbleData;
    }

    public CandleData getCandleData() {
        return this.mCandleData;
    }

    public BarLineScatterCandleBubbleData getDataByIndex(int n) {
        return this.getAllData().get(n);
    }

    public int getDataIndex(ChartData chartData) {
        return this.getAllData().indexOf(chartData);
    }

    public IBarLineScatterCandleBubbleDataSet<? extends Entry> getDataSetByHighlight(Highlight highlight) {
        if (highlight.getDataIndex() >= this.getAllData().size()) {
            return null;
        }
        BarLineScatterCandleBubbleData barLineScatterCandleBubbleData = this.getDataByIndex(highlight.getDataIndex());
        if (highlight.getDataSetIndex() >= barLineScatterCandleBubbleData.getDataSetCount()) {
            return null;
        }
        return (IBarLineScatterCandleBubbleDataSet)barLineScatterCandleBubbleData.getDataSets().get(highlight.getDataSetIndex());
    }

    @Override
    public Entry getEntryForHighlight(Highlight highlight) {
        if (highlight.getDataIndex() >= this.getAllData().size()) {
            return null;
        }
        BarLineScatterCandleBubbleData barLineScatterCandleBubbleData = this.getDataByIndex(highlight.getDataIndex());
        if (highlight.getDataSetIndex() >= barLineScatterCandleBubbleData.getDataSetCount()) {
            return null;
        }
        for (Entry entry : barLineScatterCandleBubbleData.getDataSetByIndex(highlight.getDataSetIndex()).getEntriesForXValue(highlight.getX())) {
            if (entry.getY() != highlight.getY() && !Float.isNaN(highlight.getY())) continue;
            return entry;
        }
        return null;
    }

    public LineData getLineData() {
        return this.mLineData;
    }

    public ScatterData getScatterData() {
        return this.mScatterData;
    }

    @Override
    public void notifyDataChanged() {
        BarLineScatterCandleBubbleData barLineScatterCandleBubbleData = this.mLineData;
        if (barLineScatterCandleBubbleData != null) {
            barLineScatterCandleBubbleData.notifyDataChanged();
        }
        if ((barLineScatterCandleBubbleData = this.mBarData) != null) {
            barLineScatterCandleBubbleData.notifyDataChanged();
        }
        if ((barLineScatterCandleBubbleData = this.mCandleData) != null) {
            barLineScatterCandleBubbleData.notifyDataChanged();
        }
        if ((barLineScatterCandleBubbleData = this.mScatterData) != null) {
            barLineScatterCandleBubbleData.notifyDataChanged();
        }
        if ((barLineScatterCandleBubbleData = this.mBubbleData) != null) {
            barLineScatterCandleBubbleData.notifyDataChanged();
        }
        this.calcMinMax();
    }

    @Override
    @Deprecated
    public boolean removeDataSet(int n) {
        Log.e((String)"MPAndroidChart", (String)"removeDataSet(int index) not supported for CombinedData");
        return false;
    }

    @Override
    public boolean removeDataSet(IBarLineScatterCandleBubbleDataSet<? extends Entry> iBarLineScatterCandleBubbleDataSet) {
        Iterator<BarLineScatterCandleBubbleData> iterator2 = this.getAllData().iterator();
        boolean bl = false;
        while (iterator2.hasNext()) {
            boolean bl2;
            bl = bl2 = ((ChartData)iterator2.next()).removeDataSet(iBarLineScatterCandleBubbleDataSet);
            if (!bl2) continue;
            bl = bl2;
            break;
        }
        return bl;
    }

    @Override
    @Deprecated
    public boolean removeEntry(float f, int n) {
        Log.e((String)"MPAndroidChart", (String)"removeEntry(...) not supported for CombinedData");
        return false;
    }

    @Override
    @Deprecated
    public boolean removeEntry(Entry entry, int n) {
        Log.e((String)"MPAndroidChart", (String)"removeEntry(...) not supported for CombinedData");
        return false;
    }

    public void setData(BarData barData) {
        this.mBarData = barData;
        this.notifyDataChanged();
    }

    public void setData(BubbleData bubbleData) {
        this.mBubbleData = bubbleData;
        this.notifyDataChanged();
    }

    public void setData(CandleData candleData) {
        this.mCandleData = candleData;
        this.notifyDataChanged();
    }

    public void setData(LineData lineData) {
        this.mLineData = lineData;
        this.notifyDataChanged();
    }

    public void setData(ScatterData scatterData) {
        this.mScatterData = scatterData;
        this.notifyDataChanged();
    }
}

