/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import com.github.mikephil.charting.data.BaseDataSet;
import com.github.mikephil.charting.data.BaseEntry;
import com.github.mikephil.charting.data.Entry;
import java.util.ArrayList;
import java.util.List;

public abstract class DataSet<T extends Entry>
extends BaseDataSet<T> {
    protected List<T> mEntries;
    protected float mXMax = -3.4028235E38f;
    protected float mXMin;
    protected float mYMax = -3.4028235E38f;
    protected float mYMin = Float.MAX_VALUE;

    public DataSet(List<T> list, String string2) {
        super(string2);
        this.mXMin = Float.MAX_VALUE;
        this.mEntries = list;
        if (list == null) {
            this.mEntries = new ArrayList<T>();
        }
        this.calcMinMax();
    }

    @Override
    public boolean addEntry(T t) {
        List<T> list;
        if (t == null) {
            return false;
        }
        List<T> list2 = list = this.getEntries();
        if (list == null) {
            list2 = new ArrayList<T>();
        }
        this.calcMinMax(t);
        return list2.add(t);
    }

    @Override
    public void addEntryOrdered(T t) {
        List<T> list;
        if (t == null) {
            return;
        }
        if (this.mEntries == null) {
            this.mEntries = new ArrayList<T>();
        }
        this.calcMinMax(t);
        if (this.mEntries.size() > 0 && ((Entry)(list = this.mEntries).get(list.size() - 1)).getX() > ((Entry)t).getX()) {
            int n = this.getEntryIndex(((Entry)t).getX(), ((BaseEntry)t).getY(), Rounding.UP);
            this.mEntries.add(n, t);
        } else {
            this.mEntries.add(t);
        }
    }

    @Override
    public void calcMinMax() {
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        this.mXMax = -3.4028235E38f;
        this.mXMin = Float.MAX_VALUE;
        List<T> list = this.mEntries;
        if (list != null && !list.isEmpty()) {
            list = this.mEntries.iterator();
            while (list.hasNext()) {
                this.calcMinMax((Entry)list.next());
            }
        }
    }

    protected void calcMinMax(T t) {
        if (t == null) {
            return;
        }
        this.calcMinMaxX(t);
        this.calcMinMaxY(t);
    }

    protected void calcMinMaxX(T t) {
        if (((Entry)t).getX() < this.mXMin) {
            this.mXMin = ((Entry)t).getX();
        }
        if (((Entry)t).getX() > this.mXMax) {
            this.mXMax = ((Entry)t).getX();
        }
    }

    @Override
    public void calcMinMaxY(float f, float f2) {
        this.mYMax = -3.4028235E38f;
        this.mYMin = Float.MAX_VALUE;
        List<T> list = this.mEntries;
        if (list != null && !list.isEmpty()) {
            int n = this.getEntryIndex(f, Float.NaN, Rounding.DOWN);
            int n2 = this.getEntryIndex(f2, Float.NaN, Rounding.UP);
            if (n2 < n) {
                return;
            }
            for (int i = n; i <= n2; ++i) {
                this.calcMinMaxY((Entry)this.mEntries.get(i));
            }
        }
    }

    protected void calcMinMaxY(T t) {
        if (((BaseEntry)t).getY() < this.mYMin) {
            this.mYMin = ((BaseEntry)t).getY();
        }
        if (((BaseEntry)t).getY() > this.mYMax) {
            this.mYMax = ((BaseEntry)t).getY();
        }
    }

    @Override
    public void clear() {
        this.mEntries.clear();
        this.notifyDataSetChanged();
    }

    public abstract DataSet<T> copy();

    protected void copy(DataSet dataSet) {
        super.copy(dataSet);
    }

    public List<T> getEntries() {
        return this.mEntries;
    }

    @Override
    public List<T> getEntriesForXValue(float f) {
        ArrayList<Entry> arrayList = new ArrayList<Entry>();
        int n = this.mEntries.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = (n + n2) / 2;
            Entry entry = (Entry)this.mEntries.get(n3);
            if (f == entry.getX()) {
                for (n2 = n3; n2 > 0 && ((Entry)this.mEntries.get(n2 - 1)).getX() == f; --n2) {
                }
                n = this.mEntries.size();
                while (n2 < n && (entry = (Entry)this.mEntries.get(n2)).getX() == f) {
                    arrayList.add(entry);
                    ++n2;
                }
                break;
            }
            if (f > entry.getX()) {
                n2 = n3 + 1;
                continue;
            }
            n = n3 - 1;
        }
        return arrayList;
    }

    @Override
    public int getEntryCount() {
        return this.mEntries.size();
    }

    @Override
    public T getEntryForIndex(int n) {
        return (T)((Entry)this.mEntries.get(n));
    }

    @Override
    public T getEntryForXValue(float f, float f2) {
        return this.getEntryForXValue(f, f2, Rounding.CLOSEST);
    }

    @Override
    public T getEntryForXValue(float f, float f2, Rounding rounding) {
        int n = this.getEntryIndex(f, f2, rounding);
        if (n > -1) {
            return (T)((Entry)this.mEntries.get(n));
        }
        return null;
    }

    @Override
    public int getEntryIndex(float f, float f2, Rounding rounding) {
        throw new RuntimeException("d2j fail translate: java.lang.RuntimeException: fail exe a35 = a12\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.exec(BaseAnalyze.java:92)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.exec(BaseAnalyze.java:31)\r\n\tat com.googlecode.dex2jar.ir.ts.Cfg.dfs(Cfg.java:255)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.analyze0(BaseAnalyze.java:75)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.analyze(BaseAnalyze.java:69)\r\n\tat com.googlecode.dex2jar.ir.ts.Ir2JRegAssignTransformer.transform(Ir2JRegAssignTransformer.java:182)\r\n\tat com.googlecode.d2j.dex.Dex2jar$2.optimize(Dex2jar.java:167)\r\n\tat com.googlecode.d2j.dex.Dex2Asm.convertCode(Dex2Asm.java:442)\r\n\tat com.googlecode.d2j.dex.ExDex2Asm.convertCode(ExDex2Asm.java:40)\r\n\tat com.googlecode.d2j.dex.Dex2jar$2.convertCode(Dex2jar.java:132)\r\n\tat com.googlecode.d2j.dex.Dex2Asm.convertMethod(Dex2Asm.java:575)\r\n\tat com.googlecode.d2j.dex.Dex2Asm.convertClass(Dex2Asm.java:434)\r\n\tat com.googlecode.d2j.dex.Dex2Asm.convertDex(Dex2Asm.java:450)\r\n\tat com.googlecode.d2j.dex.Dex2jar.doTranslate(Dex2jar.java:175)\r\n\tat com.googlecode.d2j.dex.Dex2jar.to(Dex2jar.java:275)\r\n\tat com.googlecode.dex2jar.tools.Dex2jarCmd.doCommandLine(Dex2jarCmd.java:112)\r\n\tat com.googlecode.dex2jar.tools.BaseCmd.doMain(BaseCmd.java:290)\r\n\tat com.googlecode.dex2jar.tools.Dex2jarCmd.main(Dex2jarCmd.java:33)\r\nCaused by: java.lang.NullPointerException\r\n\tat com.googlecode.dex2jar.ir.ts.an.SimpleLiveAnalyze.onUseLocal(SimpleLiveAnalyze.java:89)\r\n\tat com.googlecode.dex2jar.ir.ts.an.SimpleLiveAnalyze.onUseLocal(SimpleLiveAnalyze.java:27)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.onUse(BaseAnalyze.java:166)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.onUse(BaseAnalyze.java:31)\r\n\tat com.googlecode.dex2jar.ir.ts.Cfg.travel(Cfg.java:331)\r\n\tat com.googlecode.dex2jar.ir.ts.Cfg.travel(Cfg.java:387)\r\n\tat com.googlecode.dex2jar.ir.ts.an.BaseAnalyze.exec(BaseAnalyze.java:90)\r\n\t... 17 more\r\n");
    }

    @Override
    public int getEntryIndex(Entry entry) {
        return this.mEntries.indexOf(entry);
    }

    @Deprecated
    public List<T> getValues() {
        return this.mEntries;
    }

    @Override
    public float getXMax() {
        return this.mXMax;
    }

    @Override
    public float getXMin() {
        return this.mXMin;
    }

    @Override
    public float getYMax() {
        return this.mYMax;
    }

    @Override
    public float getYMin() {
        return this.mYMin;
    }

    @Override
    public boolean removeEntry(T t) {
        if (t == null) {
            return false;
        }
        List<T> list = this.mEntries;
        if (list == null) {
            return false;
        }
        boolean bl = list.remove(t);
        if (bl) {
            this.calcMinMax();
        }
        return bl;
    }

    public void setEntries(List<T> list) {
        this.mEntries = list;
        this.notifyDataSetChanged();
    }

    @Deprecated
    public void setValues(List<T> list) {
        this.setEntries(list);
    }

    public String toSimpleString() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataSet, label: ");
        String string2 = this.getLabel() == null ? "" : this.getLabel();
        stringBuilder.append(string2);
        stringBuilder.append(", entries: ");
        stringBuilder.append(this.mEntries.size());
        stringBuilder.append("\n");
        stringBuffer.append(stringBuilder.toString());
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toSimpleString());
        for (int i = 0; i < this.mEntries.size(); ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(((Entry)this.mEntries.get(i)).toString());
            stringBuilder.append(" ");
            stringBuffer.append(stringBuilder.toString());
        }
        return stringBuffer.toString();
    }

    public static final class Rounding
    extends Enum<Rounding> {
        private static final /* synthetic */ Rounding[] $VALUES;
        public static final /* enum */ Rounding CLOSEST;
        public static final /* enum */ Rounding DOWN;
        public static final /* enum */ Rounding UP;

        static {
            Rounding rounding;
            Rounding rounding2;
            Rounding rounding3;
            UP = rounding3 = new Rounding();
            DOWN = rounding2 = new Rounding();
            CLOSEST = rounding = new Rounding();
            $VALUES = new Rounding[]{rounding3, rounding2, rounding};
        }

        public static Rounding valueOf(String string2) {
            return Enum.valueOf(Rounding.class, string2);
        }

        public static Rounding[] values() {
            return (Rounding[])$VALUES.clone();
        }
    }
}

