/*
 * Decompiled with CFR 0.152.
 */
package com.github.mikephil.charting.data;

import android.content.Context;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.util.Log;
import com.github.mikephil.charting.data.DataSet;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineRadarDataSet;
import com.github.mikephil.charting.formatter.DefaultFillFormatter;
import com.github.mikephil.charting.formatter.IFillFormatter;
import com.github.mikephil.charting.interfaces.datasets.ILineDataSet;
import com.github.mikephil.charting.utils.ColorTemplate;
import com.github.mikephil.charting.utils.Utils;
import java.util.ArrayList;
import java.util.List;

public class LineDataSet
extends LineRadarDataSet<Entry>
implements ILineDataSet {
    private List<Integer> mCircleColors = null;
    private int mCircleHoleColor = -1;
    private float mCircleHoleRadius = 4.0f;
    private float mCircleRadius = 8.0f;
    private float mCubicIntensity = 0.2f;
    private DashPathEffect mDashPathEffect = null;
    private boolean mDrawCircleHole = true;
    private boolean mDrawCircles = true;
    private IFillFormatter mFillFormatter;
    private Mode mMode = Mode.LINEAR;

    public LineDataSet(List<Entry> list, String string2) {
        super(list, string2);
        this.mFillFormatter = new DefaultFillFormatter();
        if (this.mCircleColors == null) {
            this.mCircleColors = new ArrayList<Integer>();
        }
        this.mCircleColors.clear();
        this.mCircleColors.add(Color.rgb((int)140, (int)234, (int)255));
    }

    @Override
    public DataSet<Entry> copy() {
        Object object = new ArrayList<Entry>();
        for (int i = 0; i < this.mEntries.size(); ++i) {
            object.add((Entry)((Entry)this.mEntries.get(i)).copy());
        }
        object = new LineDataSet((List<Entry>)object, this.getLabel());
        this.copy((LineDataSet)object);
        return object;
    }

    protected void copy(LineDataSet lineDataSet) {
        super.copy(lineDataSet);
        lineDataSet.mCircleColors = this.mCircleColors;
        lineDataSet.mCircleHoleColor = this.mCircleHoleColor;
        lineDataSet.mCircleHoleRadius = this.mCircleHoleRadius;
        lineDataSet.mCircleRadius = this.mCircleRadius;
        lineDataSet.mCubicIntensity = this.mCubicIntensity;
        lineDataSet.mDashPathEffect = this.mDashPathEffect;
        lineDataSet.mDrawCircleHole = this.mDrawCircleHole;
        lineDataSet.mDrawCircles = this.mDrawCircleHole;
        lineDataSet.mFillFormatter = this.mFillFormatter;
        lineDataSet.mMode = this.mMode;
    }

    public void disableDashedLine() {
        this.mDashPathEffect = null;
    }

    public void enableDashedLine(float f, float f2, float f3) {
        this.mDashPathEffect = new DashPathEffect(new float[]{f, f2}, f3);
    }

    @Override
    public int getCircleColor(int n) {
        return this.mCircleColors.get(n);
    }

    @Override
    public int getCircleColorCount() {
        return this.mCircleColors.size();
    }

    public List<Integer> getCircleColors() {
        return this.mCircleColors;
    }

    @Override
    public int getCircleHoleColor() {
        return this.mCircleHoleColor;
    }

    @Override
    public float getCircleHoleRadius() {
        return this.mCircleHoleRadius;
    }

    @Override
    public float getCircleRadius() {
        return this.mCircleRadius;
    }

    @Deprecated
    public float getCircleSize() {
        return this.getCircleRadius();
    }

    @Override
    public float getCubicIntensity() {
        return this.mCubicIntensity;
    }

    @Override
    public DashPathEffect getDashPathEffect() {
        return this.mDashPathEffect;
    }

    @Override
    public IFillFormatter getFillFormatter() {
        return this.mFillFormatter;
    }

    @Override
    public Mode getMode() {
        return this.mMode;
    }

    @Override
    public boolean isDashedLineEnabled() {
        boolean bl = this.mDashPathEffect != null;
        return bl;
    }

    @Override
    public boolean isDrawCircleHoleEnabled() {
        return this.mDrawCircleHole;
    }

    @Override
    public boolean isDrawCirclesEnabled() {
        return this.mDrawCircles;
    }

    @Override
    @Deprecated
    public boolean isDrawCubicEnabled() {
        boolean bl = this.mMode == Mode.CUBIC_BEZIER;
        return bl;
    }

    @Override
    @Deprecated
    public boolean isDrawSteppedEnabled() {
        boolean bl = this.mMode == Mode.STEPPED;
        return bl;
    }

    public void resetCircleColors() {
        if (this.mCircleColors == null) {
            this.mCircleColors = new ArrayList<Integer>();
        }
        this.mCircleColors.clear();
    }

    public void setCircleColor(int n) {
        this.resetCircleColors();
        this.mCircleColors.add(n);
    }

    public void setCircleColors(List<Integer> list) {
        this.mCircleColors = list;
    }

    public void setCircleColors(int ... nArray) {
        this.mCircleColors = ColorTemplate.createColors(nArray);
    }

    public void setCircleColors(int[] nArray, Context context) {
        List<Integer> list;
        List<Integer> list2 = list = this.mCircleColors;
        if (list == null) {
            list2 = new ArrayList<Integer>();
        }
        list2.clear();
        for (int n : nArray) {
            list2.add(context.getResources().getColor(n));
        }
        this.mCircleColors = list2;
    }

    public void setCircleHoleColor(int n) {
        this.mCircleHoleColor = n;
    }

    public void setCircleHoleRadius(float f) {
        if (f >= 0.5f) {
            this.mCircleHoleRadius = Utils.convertDpToPixel(f);
        } else {
            Log.e((String)"LineDataSet", (String)"Circle radius cannot be < 0.5");
        }
    }

    public void setCircleRadius(float f) {
        if (f >= 1.0f) {
            this.mCircleRadius = Utils.convertDpToPixel(f);
        } else {
            Log.e((String)"LineDataSet", (String)"Circle radius cannot be < 1");
        }
    }

    @Deprecated
    public void setCircleSize(float f) {
        this.setCircleRadius(f);
    }

    public void setCubicIntensity(float f) {
        float f2 = f;
        if (f > 1.0f) {
            f2 = 1.0f;
        }
        f = f2;
        if (f2 < 0.05f) {
            f = 0.05f;
        }
        this.mCubicIntensity = f;
    }

    public void setDrawCircleHole(boolean bl) {
        this.mDrawCircleHole = bl;
    }

    public void setDrawCircles(boolean bl) {
        this.mDrawCircles = bl;
    }

    public void setFillFormatter(IFillFormatter iFillFormatter) {
        this.mFillFormatter = iFillFormatter == null ? new DefaultFillFormatter() : iFillFormatter;
    }

    public void setMode(Mode mode) {
        this.mMode = mode;
    }

    public static final class Mode
    extends Enum<Mode> {
        private static final /* synthetic */ Mode[] $VALUES;
        public static final /* enum */ Mode CUBIC_BEZIER;
        public static final /* enum */ Mode HORIZONTAL_BEZIER;
        public static final /* enum */ Mode LINEAR;
        public static final /* enum */ Mode STEPPED;

        static {
            Mode mode;
            Mode mode2;
            Mode mode3;
            Mode mode4;
            LINEAR = mode4 = new Mode();
            STEPPED = mode3 = new Mode();
            CUBIC_BEZIER = mode2 = new Mode();
            HORIZONTAL_BEZIER = mode = new Mode();
            $VALUES = new Mode[]{mode4, mode3, mode2, mode};
        }

        public static Mode valueOf(String string2) {
            return Enum.valueOf(Mode.class, string2);
        }

        public static Mode[] values() {
            return (Mode[])$VALUES.clone();
        }
    }
}

